/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.RangeBOp;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.RangeNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTStaticJoinOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.util.concurrent.ExecutionExceptions;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ASTRangeCountOptimizer
extends AbstractJoinGroupOptimizer
implements IASTOptimizer {
    private static final transient Logger log = Logger.getLogger(ASTRangeCountOptimizer.class);

    @Override
    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode group) {
        List<StatementPatternNode> spNodes = group.getStatementPatterns();
        if (!spNodes.isEmpty()) {
            this.attachRangeCounts(ctx, spNodes, ASTRangeCountOptimizer.getExogenousBindings(bSets));
        }
    }

    private final void attachRangeCounts(AST2BOpContext ctx, List<StatementPatternNode> spNodes, IBindingSet exogenousBindings) {
        List futures;
        AbstractTripleStore db = ctx.getAbstractTripleStore();
        LinkedList<RangeCountTask> tasks = new LinkedList<RangeCountTask>();
        for (StatementPatternNode sp : spNodes) {
            if (sp.getProperty(ASTStaticJoinOptimizer.Annotations.ESTIMATED_CARDINALITY) != null) continue;
            tasks.add(new RangeCountTask(sp, db, exogenousBindings));
        }
        try {
            futures = db.getExecutorService().invokeAll(tasks);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        LinkedList<Exception> causes = new LinkedList<Exception>();
        for (Future f : futures) {
            try {
                f.get();
            }
            catch (InterruptedException e) {
                log.error((Object)e);
                causes.add(e);
            }
            catch (ExecutionException e) {
                log.error((Object)e);
                causes.add(e);
            }
        }
        if (!causes.isEmpty()) {
            if (causes.size() == 1) {
                throw new RuntimeException((Throwable)causes.get(0));
            }
            throw new RuntimeException("nerrors=" + causes.size(), new ExecutionExceptions(causes));
        }
    }

    protected void estimateCardinality(StatementPatternNode sp, AbstractTripleStore db, IBindingSet exogenousBindings) {
        IV s = this.getIV(sp.s(), exogenousBindings);
        IV p = this.getIV(sp.p(), exogenousBindings);
        IV o = this.getIV(sp.o(), exogenousBindings);
        IV c = this.getIV(sp.c(), exogenousBindings);
        this.estimateCardinalities(sp, s, p, o, c, db);
    }

    protected void estimateCardinalities(StatementPatternNode sp, IV<?, ?> s, IV<?, ?> p, IV<?, ?> o, IV<?, ?> c, AbstractTripleStore db) {
        RangeNode rangeNode = sp.getRange();
        RangeBOp range = rangeNode != null ? rangeNode.getRangeBOp() : null;
        IAccessPath<ISPO> ap = db.getAccessPath(s, p, o, c, range);
        long cardinality = ap.rangeCount(false);
        sp.setProperty(ASTStaticJoinOptimizer.Annotations.ESTIMATED_CARDINALITY, cardinality);
        sp.setProperty(ASTStaticJoinOptimizer.Annotations.ORIGINAL_INDEX, ap.getKeyOrder());
    }

    private final IV getIV(TermNode term, IBindingSet exogenousBindings) {
        IConstant c;
        if (term != null && term.isVariable() && exogenousBindings != null && (c = exogenousBindings.get((IVariable)term.getValueExpression())) != null) {
            return (IV)c.get();
        }
        if (term != null && term.isConstant()) {
            IV iv = (IV)((IConstant)term.getValueExpression()).get();
            if (iv == null) {
                throw new AssertionError((Object)"this optimizer cannot run with unknown IVs in statement patterns");
            }
            return iv;
        }
        return null;
    }

    private static IBindingSet getExogenousBindings(IBindingSet[] bindingSets) {
        if (bindingSets == null || bindingSets.length == 0) {
            return null;
        }
        return bindingSets[0];
    }

    private class RangeCountTask
    implements Callable<Void> {
        private final StatementPatternNode sp;
        private final AbstractTripleStore db;
        private final IBindingSet exogenousBindings;

        public RangeCountTask(StatementPatternNode sp, AbstractTripleStore db, IBindingSet exogenousBindings) {
            this.sp = sp;
            this.db = db;
            this.exogenousBindings = exogenousBindings;
        }

        @Override
        public Void call() throws Exception {
            ASTRangeCountOptimizer.this.estimateCardinality(this.sp, this.db, this.exogenousBindings);
            return null;
        }
    }
}

