/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.sparql.ast.ASTBase;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;

public class ASTRunFirstRunLastOptimizer
implements IASTOptimizer {
    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        if (!(queryNode instanceof QueryRoot)) {
            return queryNode;
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        GraphPatternGroup whereClause = queryRoot.getWhereClause();
        if (whereClause != null) {
            this.optimize((IEvaluationContext)context, sa, whereClause);
        }
        if (queryRoot.getNamedSubqueries() != null) {
            NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
            for (NamedSubqueryRoot namedSubquery : namedSubqueries) {
                GraphPatternGroup whereClause2 = namedSubquery.getWhereClause();
                if (whereClause2 == null) continue;
                this.optimize((IEvaluationContext)context, sa, whereClause2);
            }
        }
        return queryNode;
    }

    private void optimize(IEvaluationContext ctx, StaticAnalysis sa, GraphPatternGroup<?> op) {
        if (op instanceof JoinGroupNode) {
            JoinGroupNode joinGroup = (JoinGroupNode)op;
            IGroupMemberNode first = null;
            IGroupMemberNode last = null;
            for (IGroupMemberNode child : joinGroup) {
                if (!(child instanceof IJoinNode)) continue;
                ASTBase join = (ASTBase)((Object)child);
                if (join.getProperty("runFirst", false).booleanValue()) {
                    if (first != null) {
                        throw new RuntimeException("there can be only one \"run first\" join in any group");
                    }
                    if (((IJoinNode)((Object)join)).isOptional()) {
                        throw new RuntimeException("\"run first\" cannot be attached to optional joins");
                    }
                    first = child;
                }
                if (!join.getProperty("runLast", false).booleanValue()) continue;
                if (last != null) {
                    throw new RuntimeException("there can be only one \"run last\" join in any group");
                }
                last = child;
            }
            if (first != null) {
                int firstJoinIndex = 0;
                for (int i = 0; i < joinGroup.arity(); ++i) {
                    if (!(joinGroup.get(i) instanceof IJoinNode)) continue;
                    firstJoinIndex = i;
                    break;
                }
                joinGroup.removeChild(first);
                joinGroup.addArg(firstJoinIndex, first);
            }
            if (last != null) {
                int lastJoinIndex = 0;
                for (int i = joinGroup.size() - 1; i >= 0; --i) {
                    if (!(joinGroup.get(i) instanceof IJoinNode)) continue;
                    lastJoinIndex = i;
                    break;
                }
                joinGroup.removeChild(last);
                joinGroup.addArg(lastJoinIndex, last);
            }
        }
        for (int i = 0; i < op.arity(); ++i) {
            BOp child = op.get(i);
            if (child instanceof GraphPatternGroup) {
                GraphPatternGroup childGroup = (GraphPatternGroup)child;
                this.optimize(ctx, sa, childGroup);
                continue;
            }
            if (!(child instanceof QueryBase)) continue;
            QueryBase subquery = (QueryBase)child;
            GraphPatternGroup childGroup = subquery.getWhereClause();
            this.optimize(ctx, sa, childGroup);
        }
    }
}

