/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.HashMap;
import java.util.HashSet;

public class ASTSimpleBindingsOptimizer
implements IASTOptimizer {
    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        if (bindingSets == null) {
            return queryNode;
        }
        if (!(queryNode instanceof QueryRoot)) {
            return queryNode;
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        if (queryRoot.getBindingsClause() != null) {
            return queryNode;
        }
        GraphPatternGroup whereClause = queryRoot.getWhereClause();
        if (whereClause != null) {
            this.doOptimize(whereClause, bindingSets);
        }
        return queryNode;
    }

    private void doOptimize(GroupNodeBase<IGroupMemberNode> whereClause, IBindingSet[] bindingSets) {
        HashMap bindings = new HashMap();
        HashSet<AssignmentNode> simpleAssignmentNodes = new HashSet<AssignmentNode>();
        for (int i = whereClause.arity() - 1; i >= 0; --i) {
            AssignmentNode an;
            IValueExpression<? extends IV> ve;
            BOp op = whereClause.get(i);
            if (!(op instanceof AssignmentNode) || !((ve = (an = (AssignmentNode)op).getValueExpression()) instanceof IConstant)) continue;
            simpleAssignmentNodes.add(an);
        }
        for (AssignmentNode simpleAssignmentNode : simpleAssignmentNodes) {
            while (whereClause.removeArg(simpleAssignmentNode)) {
            }
        }
        for (int i = 0; i < bindingSets.length; ++i) {
            for (AssignmentNode simpleAssignmentNode : simpleAssignmentNodes) {
                IBindingSet bs = bindingSets[i];
                IConstant bindingValue = (IConstant)simpleAssignmentNode.getValueExpression();
                bs.set(simpleAssignmentNode.getVar(), bindingValue);
            }
        }
    }
}

