/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.TrueBOp;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.sparql.ast.ComputedMaterializationRequirement;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupMemberNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceCallUtility;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.BDS;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ASTSimpleOptionalOptimizer
implements IASTOptimizer {
    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        if (!(queryNode instanceof QueryRoot)) {
            return queryNode;
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        LinkedList<JoinGroupNode> optionalGroups = new LinkedList<JoinGroupNode>();
        if (queryRoot.getNamedSubqueries() != null) {
            for (NamedSubqueryRoot namedSubquery : queryRoot.getNamedSubqueries()) {
                this.collectOptionalGroups(namedSubquery.getWhereClause(), optionalGroups);
            }
        }
        this.collectOptionalGroups(queryRoot.getWhereClause(), optionalGroups);
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        for (JoinGroupNode group : optionalGroups) {
            this.liftOptionalGroup(sa, group);
        }
        return queryNode;
    }

    private void collectOptionalGroups(GraphPatternGroup<IGroupMemberNode> group, Collection<JoinGroupNode> optionalGroups) {
        if (group instanceof JoinGroupNode && group.isOptional() && group.getParent() != null) {
            optionalGroups.add((JoinGroupNode)group);
        }
        for (IGroupMemberNode child : group) {
            if (child instanceof ServiceNode) {
                BigdataURI serviceURI;
                ServiceNode serviceNode = (ServiceNode)child;
                IValueExpression serviceRef = serviceNode.getServiceRef().getValueExpression();
                if (serviceRef.isVar() || !BDS.SEARCH.equals((Object)(serviceURI = ServiceCallUtility.getConstantServiceURI(serviceRef)))) continue;
                GraphPatternGroup<IGroupMemberNode> graphPattern = serviceNode.getGraphPattern();
                this.collectOptionalGroups(graphPattern, optionalGroups);
            }
            if (!(child instanceof GraphPatternGroup)) continue;
            this.collectOptionalGroups((GraphPatternGroup)child, optionalGroups);
        }
    }

    private void liftOptionalGroup(StaticAnalysis sa, JoinGroupNode group) {
        JoinGroupNode p = group.getParentJoinGroup();
        if (p == null) {
            return;
        }
        if (!ASTSimpleOptionalOptimizer.isSimpleOptional(sa, p, group)) {
            return;
        }
        LinkedList<FilterNode> filters = new LinkedList<FilterNode>();
        LinkedList<MockFilterNode> mockFilters = new LinkedList<MockFilterNode>();
        StatementPatternNode tmp = null;
        for (IGroupMemberNode child : group) {
            if (child instanceof StatementPatternNode) {
                tmp = (StatementPatternNode)child;
                continue;
            }
            if (child instanceof FilterNode) {
                FilterNode filter = (FilterNode)child;
                filters.add(filter);
                ComputedMaterializationRequirement req = filter.getMaterializationRequirement();
                if (req.getRequirement() == INeedsMaterialization.Requirement.NEVER || !(req instanceof ComputedMaterializationRequirement)) continue;
                IValueExpressionNode ven = BOpUtility.deepCopy((ValueExpressionNode)filter.getValueExpressionNode());
                ven.setValueExpression(TrueBOp.INSTANCE);
                ComputedMaterializationRequirement mockReq = new ComputedMaterializationRequirement(INeedsMaterialization.Requirement.ALWAYS, req.getVarsToMaterialize());
                MockFilterNode mockFilter = new MockFilterNode(ven, mockReq);
                mockFilters.add(mockFilter);
                continue;
            }
            throw new AssertionError((Object)("Unexpected child for simple optional: group=" + group + ", child=" + child));
        }
        assert (tmp != null);
        StatementPatternNode sp = tmp;
        sp.setOptional(true);
        if (!filters.isEmpty()) {
            sp.setAttachedJoinFilters(filters);
        }
        p.replaceWith(group, sp);
        for (FilterNode filterNode : mockFilters) {
            p.addChild(filterNode);
        }
    }

    private static boolean isSimpleOptional(StaticAnalysis sa, JoinGroupNode p, JoinGroupNode group) {
        if (!group.isOptional()) {
            return false;
        }
        StatementPatternNode sp = null;
        for (IQueryNode node : group) {
            if (node instanceof StatementPatternNode) {
                if (sp != null) {
                    return false;
                }
                sp = (StatementPatternNode)node;
                continue;
            }
            if (node instanceof FilterNode) {
                FilterNode filter = (FilterNode)node;
                ComputedMaterializationRequirement req = filter.getMaterializationRequirement();
                if (req.getRequirement() == INeedsMaterialization.Requirement.NEVER) continue;
                return false;
            }
            return false;
        }
        return sp != null;
    }

    static final class MockFilterNode
    extends FilterNode {
        private static final long serialVersionUID = 1L;

        public MockFilterNode(BOp[] args, Map<String, Object> anns) {
            super(args, anns);
        }

        public MockFilterNode(MockFilterNode op) {
            super(op);
        }

        public MockFilterNode(IValueExpressionNode ve, ComputedMaterializationRequirement req) {
            super(ve);
            this.setProperty("requirement", req);
        }

        @Override
        public Set<IVariable<?>> getConsumedVars() {
            return this.getMaterializationRequirement().getVarsToMaterialize();
        }

        @Override
        public final ComputedMaterializationRequirement getMaterializationRequirement() {
            return (ComputedMaterializationRequirement)this.getRequiredProperty("requirement");
        }

        @Override
        public String toString(int indent) {
            return super.toString(indent) + " [mockFilter]";
        }

        static interface Annotations
        extends GroupMemberNodeBase.Annotations {
            public static final String REQUIREMENT = "requirement";
        }
    }
}

