/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ASTSubGroupJoinVarOptimizer
implements IASTOptimizer {
    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        QueryRoot queryRoot = (QueryRoot)queryNode;
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
        if (namedSubqueries != null) {
            for (NamedSubqueryRoot namedSubquery : namedSubqueries) {
                this.assignJoinVars(sa, namedSubquery.getWhereClause());
            }
        }
        this.assignJoinVars(sa, queryRoot.getWhereClause());
        return queryRoot;
    }

    private void assignJoinVars(StaticAnalysis sa, GraphPatternGroup<IGroupMemberNode> group) {
        if (group.getParentGraphPatternGroup() != null) {
            JoinGroupNode jgn;
            Set<IVariable<IVariable<?>>> boundByGroup = sa.getDefinitelyProducedBindings(group, new LinkedHashSet(), true);
            Set<IVariable<?>> incomingBindings = sa.getDefinitelyIncomingBindings(group, new LinkedHashSet());
            boundByGroup.retainAll(incomingBindings);
            IVariable[] joinVars = boundByGroup.toArray(new IVariable[0]);
            group.setJoinVars(joinVars);
            Set<IVariable<IVariable<?>>> definitelyBoundInGroup = sa.getDefinitelyProducedBindings(group, new LinkedHashSet(), true);
            Set<IVariable<?>> maybeIncomingBindings = sa.getMaybeIncomingBindings(group, new LinkedHashSet());
            definitelyBoundInGroup.retainAll(maybeIncomingBindings);
            if (group instanceof JoinGroupNode && (jgn = (JoinGroupNode)group).isOptional()) {
                LinkedHashSet<FilterNode> filters = new LinkedHashSet<FilterNode>();
                for (BOp node : jgn.args()) {
                    Iterator<BOp> it = BOpUtility.preOrderIterator(node);
                    while (it.hasNext()) {
                        BOp bop = it.next();
                        if (bop instanceof FilterNode) {
                            filters.add((FilterNode)bop);
                            continue;
                        }
                        if (!(node instanceof StatementPatternNode)) continue;
                        StatementPatternNode nodeAsSP = (StatementPatternNode)node;
                        List<FilterNode> attachedFilters = nodeAsSP.getAttachedJoinFilters();
                        for (FilterNode filter : attachedFilters) {
                            filters.add(filter);
                        }
                    }
                }
                for (FilterNode fn : filters) {
                    definitelyBoundInGroup.addAll(sa.getSpannedVariables(fn, true, new LinkedHashSet()));
                }
            }
            IVariable[] projectInVars = definitelyBoundInGroup.toArray(new IVariable[0]);
            group.setProjectInVars(projectInVars);
        }
        for (IGroupMemberNode child : group) {
            if (child instanceof GraphPatternGroup) {
                GraphPatternGroup subGroup = (GraphPatternGroup)child;
                this.assignJoinVars(sa, subGroup);
                continue;
            }
            if (!(child instanceof QueryBase)) continue;
            QueryBase subquery = (QueryBase)((Object)child);
            GraphPatternGroup subGroup = subquery.getWhereClause();
            this.assignJoinVars(sa, subGroup);
        }
    }
}

