/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.LinkedList;

public class ASTUnionFiltersOptimizer
implements IASTOptimizer {
    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        if (!(queryNode instanceof QueryRoot)) {
            return queryNode;
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        GraphPatternGroup whereClause = queryRoot.getWhereClause();
        if (whereClause != null) {
            this.optimize((IEvaluationContext)context, sa, whereClause);
        }
        if (queryRoot.getNamedSubqueries() != null) {
            NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
            for (NamedSubqueryRoot namedSubquery : namedSubqueries) {
                GraphPatternGroup whereClause2 = namedSubquery.getWhereClause();
                if (whereClause2 == null) continue;
                this.optimize((IEvaluationContext)context, sa, whereClause2);
            }
        }
        return queryNode;
    }

    private void optimize(IEvaluationContext ctx, StaticAnalysis sa, GraphPatternGroup<?> op) {
        if (op instanceof JoinGroupNode) {
            JoinGroupNode joinGroup = (JoinGroupNode)op;
            GroupNodeBase union = null;
            LinkedList<FilterNode> filters = null;
            boolean canOptimize = false;
            for (IGroupMemberNode child : joinGroup) {
                if (child instanceof UnionNode) {
                    if (union != null) {
                        canOptimize = false;
                        break;
                    }
                    union = (UnionNode)child;
                    canOptimize = true;
                    continue;
                }
                if (child instanceof FilterNode) {
                    if (filters == null) {
                        filters = new LinkedList<FilterNode>();
                    }
                    filters.add((FilterNode)child);
                    continue;
                }
                canOptimize = false;
                break;
            }
            if (canOptimize && filters != null) {
                for (IGroupMemberNode child : union) {
                    for (FilterNode filter : filters) {
                        ((GroupNodeBase)child).addChild((IGroupMemberNode)BOpUtility.deepCopy(filter));
                    }
                }
                for (FilterNode filter : filters) {
                    joinGroup.removeChild(filter);
                }
            }
        }
        for (int i = 0; i < op.arity(); ++i) {
            BOp child = op.get(i);
            if (child instanceof GraphPatternGroup) {
                GraphPatternGroup childGroup = (GraphPatternGroup)child;
                this.optimize(ctx, sa, childGroup);
                continue;
            }
            if (!(child instanceof QueryBase)) continue;
            QueryBase subquery = (QueryBase)child;
            GraphPatternGroup childGroup = subquery.getWhereClause();
            this.optimize(ctx, sa, childGroup);
        }
    }
}

