/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Striterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class ASTWildcardProjectionOptimizer
implements IASTOptimizer {
    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        if (!(queryNode instanceof QueryRoot)) {
            return queryNode;
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        if (queryRoot.getNamedSubqueries() != null) {
            for (NamedSubqueryRoot subqueryRoot : queryRoot.getNamedSubqueries()) {
                this.rewriteProjection(sa, subqueryRoot);
            }
        }
        if (queryRoot.getWhereClause() != null) {
            IStriterator itr = new Striterator(BOpUtility.postOrderIterator(queryRoot.getWhereClause())).addTypeFilter(QueryBase.class);
            while (itr.hasNext()) {
                QueryBase queryBase = (QueryBase)itr.next();
                this.rewriteProjection(sa, queryBase);
            }
        }
        this.rewriteProjection(sa, queryRoot);
        return queryRoot;
    }

    private void rewriteProjection(StaticAnalysis sa, QueryBase queryBase) {
        ProjectionNode projection = queryBase.getProjection();
        if (projection != null && projection.isWildcard()) {
            GraphPatternGroup whereClause = queryBase.getWhereClause();
            ProjectionNode p2 = new ProjectionNode();
            queryBase.setProjection(p2);
            if (projection.isDistinct()) {
                p2.setDistinct(true);
            }
            if (projection.isReduced()) {
                p2.setReduced(true);
            }
            Set<IVariable<?>> varSet = sa.getSpannedVariables(whereClause, new LinkedHashSet());
            for (IVariable<?> var : varSet) {
                if (((Var)var).isAnonymous()) continue;
                p2.addProjectionVar(new VarNode(var.getName()));
            }
        }
    }
}

