/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.service;

import com.bigdata.rdf.sparql.ast.service.IRemoteSparqlQueryBuilder;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.RemoteSparql10QueryBuilder;
import com.bigdata.rdf.sparql.ast.service.RemoteSparql11QueryBuilder;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.HashSet;
import org.openrdf.model.BNode;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;

public class RemoteSparqlBuilderFactory {
    public static IRemoteSparqlQueryBuilder get(IServiceOptions serviceOptions, ServiceNode serviceNode, BindingSet[] bindingSets) {
        boolean singleEmptyBindingSet;
        if (serviceOptions == null) {
            throw new IllegalArgumentException();
        }
        if (serviceNode == null) {
            throw new IllegalArgumentException();
        }
        if (!serviceOptions.isSparql11()) {
            return new RemoteSparql10QueryBuilder(serviceNode);
        }
        boolean bl = singleEmptyBindingSet = bindingSets.length == 0 || bindingSets.length == 1 && bindingSets[0].size() == 0;
        if (!singleEmptyBindingSet && RemoteSparqlBuilderFactory.hasCorrelatedBlankNodeBindings(bindingSets)) {
            return new RemoteSparql10QueryBuilder(serviceNode);
        }
        return new RemoteSparql11QueryBuilder(serviceNode);
    }

    private static boolean hasCorrelatedBlankNodeBindings(BindingSet[] bindingSets) {
        if (bindingSets.length <= 1) {
            return false;
        }
        for (BindingSet bindingSet : bindingSets) {
            HashSet<BNode> bnodes = null;
            for (Binding b : bindingSet) {
                BNode t;
                Value v = b.getValue();
                if (!(v instanceof BNode)) continue;
                if (bnodes == null) {
                    bnodes = new HashSet<BNode>();
                }
                if (!bnodes.add(t = (BNode)v)) continue;
                return true;
            }
        }
        return false;
    }
}

