/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.BigdataStatics;
import com.bigdata.btree.BTree;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPORelation;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;

public class DistinctSPOIterator
implements ICloseableIterator<ISPO> {
    private SPORelation spoRelation;
    private ICloseableIterator<ISPO> src;
    private Set<ISPO> hashSet;
    private BTree btreeSet;
    private KeyBuilder keyBuilder;
    private ISPO next = null;
    private boolean exhausted = false;
    private boolean closed = false;
    private int ndistinct = 0;
    private int nscanned = 0;
    static final int MAX_HASH_SET_CAPACITY = Integer.MAX_VALUE;

    public DistinctSPOIterator(SPORelation spoRelation, ICloseableIterator<ISPO> src) {
        if (spoRelation == null) {
            throw new IllegalArgumentException();
        }
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.spoRelation = spoRelation;
        this.src = src;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.src.close();
        if (this.btreeSet != null) {
            this.btreeSet.close();
        }
        this.spoRelation = null;
        this.src = null;
        this.hashSet = null;
        this.btreeSet = null;
        this.keyBuilder = null;
    }

    @Override
    public boolean hasNext() {
        if (this.exhausted || this.closed) {
            return false;
        }
        if (this.next != null) {
            return true;
        }
        if (this.hashSet == null) {
            this.hashSet = new LinkedHashSet<ISPO>();
        } else if (this.btreeSet == null && this.ndistinct >= Integer.MAX_VALUE) {
            if (BigdataStatics.debug) {
                System.err.println("Distinct SPO iterator overflow");
            }
            this.keyBuilder = new KeyBuilder(24);
            this.btreeSet = this.spoRelation.getSPOOnlyBTree(true);
        }
        return this._hasNext();
    }

    private boolean _hasNext() {
        while (this.next == null && this.src.hasNext()) {
            ISPO tmp = (ISPO)this.src.next();
            ++this.nscanned;
            tmp = new SPO(tmp.s(), tmp.p(), tmp.o(), (IV)null);
            if (this.btreeSet == null) {
                if (!this.hashSet.add(tmp)) {
                    continue;
                }
            } else {
                byte[] key;
                if (this.hashSet.contains(tmp) || this.btreeSet.contains(key = SPOKeyOrder.SPO.encodeKey(this.keyBuilder, tmp))) continue;
                this.btreeSet.insert(key, null);
            }
            this.next = tmp;
            ++this.ndistinct;
        }
        if (this.next == null) {
            this.exhausted = true;
            return false;
        }
        return true;
    }

    @Override
    public ISPO next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        assert (this.next != null);
        ISPO tmp = this.next;
        this.next = null;
        return tmp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

