/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.codec.AbstractCodedRaba;
import com.bigdata.btree.raba.codec.ICodedRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.rdf.spo.RDFValueFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class FastRDFValueCoder2
implements Externalizable,
IRabaCoder {
    protected static final Logger log = Logger.getLogger(FastRDFValueCoder2.class);
    private static final long serialVersionUID = 1933430721504168533L;
    private static final transient byte VERSION0 = 0;
    private static final transient int O_values = 5;

    @Override
    public final boolean isKeyCoder() {
        return false;
    }

    @Override
    public final boolean isValueCoder() {
        return true;
    }

    @Override
    public boolean isDuplicateKeys() {
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public AbstractFixedByteArrayBuffer encode(IRaba raba, DataOutputBuffer buf) {
        return this.encodeLive(raba, buf).data();
    }

    @Override
    public ICodedRaba encodeLive(IRaba raba, DataOutputBuffer buf) {
        if (raba == null) {
            throw new UnsupportedOperationException();
        }
        if (buf == null) {
            throw new UnsupportedOperationException();
        }
        int n = raba.size();
        int initialCapacity = 5 + BytesUtil.bitFlagByteLength(4 * n);
        buf.ensureCapacity(initialCapacity);
        int O_origin = buf.pos();
        int size = raba.size();
        buf.putByte((byte)0);
        buf.putInt(size);
        for (int i = 0; i < size; i += 2) {
            int lowNibble;
            int n2 = lowNibble = raba.isNull(i) ? 7 : raba.get(i)[0];
            int highNibble = i + 1 == size ? 0 : (raba.isNull(i + 1) ? 7 : raba.get(i + 1)[0]);
            byte b = (byte)(0xFF & (highNibble << 4 | lowNibble));
            buf.putByte(b);
        }
        AbstractFixedByteArrayBuffer slice = buf.slice(O_origin, buf.pos() - O_origin);
        return new CodedRabaImpl(slice, size);
    }

    @Override
    public ICodedRaba decode(AbstractFixedByteArrayBuffer data) {
        return new CodedRabaImpl(data);
    }

    private static class CodedRabaImpl
    extends AbstractCodedRaba {
        private final AbstractFixedByteArrayBuffer data;
        private final int size;

        @Override
        public final AbstractFixedByteArrayBuffer data() {
            return this.data;
        }

        @Override
        public final boolean isKeys() {
            return false;
        }

        @Override
        public final int size() {
            return this.size;
        }

        @Override
        public final int capacity() {
            return this.size;
        }

        @Override
        public final boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public final boolean isFull() {
            return true;
        }

        public CodedRabaImpl(AbstractFixedByteArrayBuffer data, int size) {
            this.data = data;
            this.size = size;
        }

        public CodedRabaImpl(AbstractFixedByteArrayBuffer data) {
            if (data == null) {
                throw new IllegalArgumentException();
            }
            this.data = data;
            byte version = data.getByte(0);
            if (version != 0) {
                throw new RuntimeException("Unknown version=" + version);
            }
            this.size = data.getInt(1);
        }

        protected final byte getBits(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            byte b = this.data.getByte(5 + index / 2);
            int t = index % 2 == 0 ? b & 0xF : b >> 4;
            return (byte)(0xFF & t);
        }

        @Override
        public final int copy(int index, OutputStream os) {
            byte bits = this.getBits(index);
            if (bits == 7) {
                throw new NullPointerException();
            }
            try {
                os.write(bits);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return 1;
        }

        @Override
        public final byte[] get(int index) {
            byte bits = this.getBits(index);
            if (bits == 7) {
                return null;
            }
            return RDFValueFactory.getValue(bits);
        }

        @Override
        public final boolean isNull(int index) {
            return this.getBits(index) == 7;
        }

        @Override
        public final int length(int index) {
            if (this.isNull(index)) {
                throw new NullPointerException();
            }
            return 1;
        }

        @Override
        public final int search(byte[] searchKey) {
            throw new UnsupportedOperationException();
        }
    }
}

