/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOFilter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashSet;
import org.openrdf.model.URI;

public final class InGraphBinarySearchFilter<E extends ISPO>
extends SPOFilter<E>
implements Externalizable {
    private static final long serialVersionUID = -3566012247356882422L;
    private IV[] a;
    private static final transient short VERSION0 = 0;
    private static final transient short VERSION = 0;

    public InGraphBinarySearchFilter() {
    }

    public InGraphBinarySearchFilter(Iterable<? extends URI> graphs) {
        HashSet<IV> contextSet = new HashSet<IV>();
        for (URI uRI : graphs) {
            IV termId = ((BigdataURI)uRI).getIV();
            if (termId == null) continue;
            contextSet.add(termId);
        }
        this.a = contextSet.toArray(new IV[0]);
        Arrays.sort(this.a);
    }

    @Override
    public boolean isValid(Object o) {
        if (!this.canAccept(o)) {
            return true;
        }
        return this.accept((ISPO)o);
    }

    private boolean accept(ISPO o) {
        ISPO spo = o;
        return Arrays.binarySearch(this.a, spo.c()) >= 0;
    }

    public String toString() {
        return this.getClass().getName() + "{size=" + this.a.length + "}";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown version: " + version);
            }
        }
        int size = in.readInt();
        this.a = new IV[size];
        for (int i = 0; i < size; ++i) {
            this.a[i] = (IV)in.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(0);
        out.writeInt(this.a.length);
        for (IV iv : this.a) {
            out.writeObject(iv);
        }
    }
}

