/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOFilter;
import java.util.HashSet;

public final class InGraphHashSetFilter<E extends ISPO>
extends SPOFilter<E> {
    private static final long serialVersionUID = -6059009162692785772L;
    private final HashSet<IV> contextSet;

    public InGraphHashSetFilter(int initialCapacity, Iterable<IV> graphs) {
        this.contextSet = new HashSet(initialCapacity);
        for (IV termId : graphs) {
            if (termId == null) continue;
            this.contextSet.add(termId);
        }
    }

    @Override
    public boolean isValid(Object o) {
        if (!this.canAccept(o)) {
            return true;
        }
        return this.accept((ISPO)o);
    }

    private boolean accept(ISPO o) {
        ISPO spo = o;
        return this.contextSet.contains(spo.c());
    }

    public String toString() {
        return this.getClass().getName() + "{size=" + this.contextSet.size() + "}";
    }
}

