/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.bop.IConstant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.ModifiedEnum;
import com.bigdata.rdf.store.IRawTripleStore;
import com.bigdata.util.Bits;
import java.io.Serializable;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class SPO
implements ISPO,
Serializable {
    private static final long serialVersionUID = 1L;
    public final IV s;
    public final IV p;
    public final IV o;
    private final IV c;
    private IV sid = null;
    private byte flags = 0;
    private static int TYPE_BIT = 0;
    private static int MODIFIED_BIT = 2;
    private static int USERFLAG_BIT = 4;
    private static int OVERRIDE_BIT = 5;
    private int hashCode = 0;

    @Override
    public final IV get(int index) {
        switch (index) {
            case 0: {
                return this.s;
            }
            case 1: {
                return this.p;
            }
            case 2: {
                return this.o;
            }
            case 3: {
                return this.c;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final IV s() {
        return this.s;
    }

    @Override
    public final IV p() {
        return this.p;
    }

    @Override
    public final IV o() {
        return this.o;
    }

    @Override
    public final IV c() {
        return this.c;
    }

    @Override
    public final IV getStatementIdentifier() {
        if (this.sid == null && this.type() == StatementEnum.Explicit) {
            this.sid = new SidIV(this);
        }
        return this.sid;
    }

    @Override
    public final boolean hasStatementIdentifier() {
        return this.type() == StatementEnum.Explicit;
    }

    @Override
    public void setOverride(boolean override) {
        this.override(override);
    }

    @Override
    public boolean isOverride() {
        return this.override();
    }

    public SPO(IV s, IV p, IV o) {
        this.s = s;
        this.p = p;
        this.o = o;
        this.c = null;
        this.type(null);
    }

    public SPO(IV s, IV p, IV o, IV c) {
        this.s = s;
        this.p = p;
        this.o = o;
        this.c = c;
        this.type(null);
    }

    public SPO(IV s, IV p, IV o, StatementEnum type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.s = s;
        this.p = p;
        this.o = o;
        this.c = null;
        this.type(type);
    }

    public SPO(IV s, IV p, IV o, IV c, StatementEnum type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.s = s;
        this.p = p;
        this.o = o;
        this.c = c;
        this.type(type);
    }

    public SPO(IConstant<IV> s, IConstant<IV> p, IConstant<IV> o, StatementEnum type) {
        this((IV)s.get(), (IV)p.get(), (IV)o.get(), type);
    }

    public SPO(IPredicate<ISPO> predicate) {
        IVariableOrConstant t = predicate.get(0);
        this.s = t.isVar() ? null : (IV)t.get();
        t = predicate.get(1);
        this.p = t.isVar() ? null : (IV)t.get();
        t = predicate.get(2);
        IV iV = this.o = t.isVar() ? null : (IV)t.get();
        this.c = predicate.arity() >= 4 ? ((t = predicate.get(3)).isVar() ? null : (IV)t.get()) : null;
    }

    public SPO(BigdataResource s, BigdataURI p, BigdataValue o, StatementEnum type) {
        this(s.getIV(), p.getIV(), o.getIV(), type);
    }

    public SPO(BigdataStatement stmt) {
        this(stmt.s(), stmt.p(), stmt.o(), stmt.c(), stmt.getStatementType());
    }

    @Override
    public final boolean isExplicit() {
        return this.type() == StatementEnum.Explicit;
    }

    @Override
    public final boolean isInferred() {
        return this.type() == StatementEnum.Inferred;
    }

    @Override
    public final boolean isAxiom() {
        return this.type() == StatementEnum.Axiom;
    }

    @Override
    public final boolean getUserFlag() {
        return this.userFlag();
    }

    @Override
    public final void setUserFlag(boolean userFlag) {
        this.userFlag(userFlag);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int s = this.s.hashCode();
            int p = this.p.hashCode();
            int o = this.o.hashCode();
            this.hashCode = 961 * s + 31 * p + o;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return this.equals((ISPO)o);
    }

    public boolean equals(ISPO stmt2) {
        if (stmt2 == this) {
            return true;
        }
        return IVUtility.equals(this.s, stmt2.s()) && IVUtility.equals(this.p, stmt2.p()) && IVUtility.equals(this.o, stmt2.o()) && this.type() == stmt2.getStatementType();
    }

    public String toString() {
        return "< " + SPO.toString(this.s) + ", " + SPO.toString(this.p) + ", " + SPO.toString(this.o) + (this.c == null ? "" : ", " + SPO.toString(this.c)) + (this.type() == null ? "" : " : " + (Object)((Object)this.type()) + (this.override() ? ", override" : "")) + (this.isModified() ? ", modified (" + (Object)((Object)this.modified()) + ")" : "") + " >";
    }

    public static String toString(IV iv) {
        if (iv == null) {
            return "NULL";
        }
        return iv.toString();
    }

    @Override
    public String toString(IRawTripleStore store) {
        block5: {
            String t;
            block7: {
                block6: {
                    if (store == null) break block5;
                    t = null;
                    if (this.type() == null) break block6;
                    switch (this.type()) {
                        case Explicit: {
                            t = "Explicit    ";
                            break block7;
                        }
                        case Inferred: {
                            t = "Inferred    ";
                            break block7;
                        }
                        case Axiom: {
                            t = "Axiom       ";
                            break block7;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                t = "Unknown     ";
            }
            return t + (this.isModified() ? "(*)" : "") + " : " + store.toString(this.s, this.p, this.o, this.c);
        }
        return this.toString();
    }

    @Override
    public final boolean isFullyBound() {
        return this.s != null && this.p != null && this.o != null;
    }

    @Override
    public final StatementEnum getStatementType() {
        return this.type();
    }

    @Override
    public final void setStatementType(StatementEnum type) {
        if (this.type() != null && this.type() != type) {
            throw new IllegalStateException("newValue=" + (Object)((Object)type) + ", spo=" + this);
        }
        this.type(type);
    }

    @Override
    public final boolean hasStatementType() {
        return this.type() != null;
    }

    @Override
    public boolean isModified() {
        return this.modified() != ModifiedEnum.NONE;
    }

    @Override
    public void setModified(ModifiedEnum modified) {
        this.modified(modified);
    }

    @Override
    public ModifiedEnum getModified() {
        return this.modified();
    }

    private StatementEnum type() {
        int b = 0;
        b = (byte)(b | 1 << TYPE_BIT);
        b = (byte)(b | 1 << TYPE_BIT + 1);
        b = (byte)(b & this.flags);
        switch (b) {
            case 0: {
                return null;
            }
            case 1: {
                return StatementEnum.Explicit;
            }
            case 2: {
                return StatementEnum.Axiom;
            }
            case 3: {
                return StatementEnum.Inferred;
            }
        }
        throw new IllegalStateException();
    }

    private void type(StatementEnum type) {
        byte b = this.flags;
        if (type == null) {
            b = Bits.set(Bits.set(b, TYPE_BIT, false), TYPE_BIT + 1, false);
        } else {
            switch (type) {
                case Explicit: {
                    b = Bits.set(Bits.set(b, TYPE_BIT, true), TYPE_BIT + 1, false);
                    break;
                }
                case Axiom: {
                    b = Bits.set(Bits.set(b, TYPE_BIT, false), TYPE_BIT + 1, true);
                    break;
                }
                case Inferred: {
                    b = Bits.set(Bits.set(b, TYPE_BIT, true), TYPE_BIT + 1, true);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        this.flags = b;
    }

    private ModifiedEnum modified() {
        int b = 0;
        b = (byte)(b | 1 << MODIFIED_BIT);
        b = (byte)(b | 1 << MODIFIED_BIT + 1);
        b = (byte)(b & this.flags);
        switch (b) {
            case 0: {
                return ModifiedEnum.NONE;
            }
            case 4: {
                return ModifiedEnum.INSERTED;
            }
            case 8: {
                return ModifiedEnum.REMOVED;
            }
            case 12: {
                return ModifiedEnum.UPDATED;
            }
        }
        throw new IllegalStateException();
    }

    private void modified(ModifiedEnum modified) {
        byte b = this.flags;
        if (modified == null) {
            throw new IllegalArgumentException();
        }
        switch (modified) {
            case NONE: {
                b = Bits.set(Bits.set(b, MODIFIED_BIT, false), MODIFIED_BIT + 1, false);
                break;
            }
            case INSERTED: {
                b = Bits.set(Bits.set(b, MODIFIED_BIT, true), MODIFIED_BIT + 1, false);
                break;
            }
            case REMOVED: {
                b = Bits.set(Bits.set(b, MODIFIED_BIT, false), MODIFIED_BIT + 1, true);
                break;
            }
            case UPDATED: {
                b = Bits.set(Bits.set(b, MODIFIED_BIT, true), MODIFIED_BIT + 1, true);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.flags = b;
    }

    private boolean userFlag() {
        return Bits.get(this.flags, USERFLAG_BIT);
    }

    private void userFlag(boolean userFlag) {
        this.flags = Bits.set(this.flags, USERFLAG_BIT, userFlag);
    }

    private boolean override() {
        return Bits.get(this.flags, OVERRIDE_BIT);
    }

    private void override(boolean override) {
        this.flags = Bits.set(this.flags, OVERRIDE_BIT, override);
    }

    public Resource getContext() {
        return (Resource)this.c();
    }

    public Value getObject() {
        return this.o();
    }

    public URI getPredicate() {
        return (URI)this.p();
    }

    public Resource getSubject() {
        return (Resource)this.s();
    }
}

