/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.striterator.AbstractChunkedResolverator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class BigdataSolutionResolverator
extends AbstractChunkedResolverator<ISolution, IBindingSet, AbstractTripleStore> {
    private static final Logger log = Logger.getLogger(BigdataSolutionResolverator.class);

    public BigdataSolutionResolverator(AbstractTripleStore db, IChunkedOrderedIterator<ISolution> src) {
        super(db, src, new BlockingBuffer<F[]>(db.getChunkOfChunksCapacity(), db.getChunkCapacity(), db.getChunkTimeout(), TimeUnit.MILLISECONDS));
    }

    public BigdataSolutionResolverator start(ExecutorService service) {
        return (BigdataSolutionResolverator)super.start(service);
    }

    protected IBindingSet[] resolveChunk(ISolution[] chunk) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Fetched chunk: size=" + chunk.length));
        }
        HashSet ids = new HashSet(chunk.length * ((AbstractTripleStore)this.state).getSPOKeyArity());
        for (ISolution solution : chunk) {
            IBindingSet bindingSet = solution.getBindingSet();
            assert (bindingSet != null);
            Iterator<Map.Entry<IVariable, IConstant>> itr = bindingSet.iterator();
            while (itr.hasNext()) {
                Map.Entry<IVariable, IConstant> entry = itr.next();
                IV iv = (IV)entry.getValue().get();
                if (iv == null) {
                    throw new RuntimeException("NULL? : var=" + entry.getKey() + ", " + bindingSet);
                }
                ids.add(iv);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Resolving " + ids.size() + " term identifiers"));
        }
        Map<IV<?, ?>, BigdataValue> terms = ((AbstractTripleStore)this.state).getLexiconRelation().getTerms(ids);
        IBindingSet[] chunk2 = new IBindingSet[chunk.length];
        int i = 0;
        for (ISolution e : chunk) {
            IBindingSet f = this.getBindingSet(e, terms);
            chunk2[i++] = f;
        }
        return chunk2;
    }

    private IBindingSet getBindingSet(ISolution solution, Map<IV<?, ?>, BigdataValue> terms) {
        if (solution == null) {
            throw new IllegalArgumentException();
        }
        if (terms == null) {
            throw new IllegalArgumentException();
        }
        IBindingSet bindingSet = solution.getBindingSet();
        if (bindingSet == null) {
            throw new IllegalStateException("BindingSet was not materialized");
        }
        Iterator<Map.Entry<IVariable, IConstant>> itr = bindingSet.iterator();
        while (itr.hasNext()) {
            Map.Entry<IVariable, IConstant> entry = itr.next();
            Object boundValue = entry.getValue().get();
            if (!(boundValue instanceof IV)) continue;
            IV iv = (IV)boundValue;
            BigdataValue value = terms.get(iv);
            if (value == null) {
                throw new RuntimeException("Could not resolve termId=" + iv);
            }
            bindingSet.set(entry.getKey(), new Constant<BigdataValue>(value));
        }
        return bindingSet;
    }
}

