/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BigdataValueIterator;
import com.bigdata.striterator.IChunkedIterator;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class BigdataValueIteratorImpl
implements BigdataValueIterator {
    private static final Logger log = Logger.getLogger(BigdataValueIteratorImpl.class);
    private final AbstractTripleStore db;
    private final IChunkedIterator<IV> src;
    private int lastIndex = -1;
    private IV<?, ?>[] chunk = null;
    private Map<IV<?, ?>, BigdataValue> terms = null;

    public BigdataValueIteratorImpl(AbstractTripleStore db, IChunkedIterator<IV> src) {
        if (db == null) {
            throw new IllegalArgumentException();
        }
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.db = db;
        this.src = src;
    }

    @Override
    public boolean hasNext() {
        if (this.lastIndex != -1 && this.lastIndex + 1 < this.chunk.length) {
            return true;
        }
        log.debug((Object)"Testing source iterator.");
        return this.src.hasNext();
    }

    @Override
    public BigdataValue next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.lastIndex == -1 || this.lastIndex + 1 == this.chunk.length) {
            log.info((Object)"Fetching next chunk");
            this.chunk = this.src.nextChunk();
            if (log.isInfoEnabled()) {
                log.info((Object)("Fetched chunk: size=" + this.chunk.length));
            }
            HashSet ivs = new HashSet(this.chunk.length);
            for (IV<?, ?> id : this.chunk) {
                ivs.add(id);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Resolving " + ivs.size() + " term identifiers"));
            }
            this.terms = this.db.getLexiconRelation().getTerms(ivs);
            this.lastIndex = 0;
        } else {
            ++this.lastIndex;
        }
        IV<?, ?> iv = this.chunk[this.lastIndex];
        BigdataValue val = this.terms.get(iv);
        if (val == null) {
            throw new RuntimeException("No value for term identifier: id=" + iv);
        }
        return val;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.src.close();
        this.chunk = null;
        this.terms = null;
    }
}

