/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.journal.RWStrategy;
import com.bigdata.rdf.ServiceProviderHook;
import com.bigdata.rdf.inf.ClosureStats;
import com.bigdata.rdf.inf.TruthMaintenance;
import com.bigdata.rdf.rio.LoadStats;
import com.bigdata.rdf.rio.PresortRioLoader;
import com.bigdata.rdf.rio.RDFParserOptions;
import com.bigdata.rdf.rio.RioLoaderEvent;
import com.bigdata.rdf.rio.RioLoaderListener;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.InferenceEngine;
import com.bigdata.rdf.store.AbstractLocalTripleStore;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.LocalTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.openrdf.rio.RDFFormat;

public class DataLoader {
    protected static final transient Logger log = Logger.getLogger(DataLoader.class);
    private final RDFParserOptions parserOptions;
    private final int bufferCapacity;
    private final AbstractTripleStore database;
    private final InferenceEngine inferenceEngine;
    private final TruthMaintenance tm;
    private StatementBuffer<?> buffer;
    private final CommitEnum commitEnum;
    private final ClosureEnum closureEnum;
    private final boolean flush;
    private static final FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            boolean isRDF;
            if (new File(dir, name).isDirectory()) {
                return !dir.isHidden();
            }
            boolean bl = isRDF = RDFFormat.forFileName((String)name) != null || name.endsWith(".zip") && RDFFormat.forFileName((String)name.substring(0, name.length() - 4)) != null || name.endsWith(".gz") && RDFFormat.forFileName((String)name.substring(0, name.length() - 3)) != null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("dir=" + dir + ", name=" + name + " : isRDF=" + isRDF));
            }
            return isRDF;
        }
    };

    public AbstractTripleStore getDatabase() {
        return this.database;
    }

    public InferenceEngine getInferenceEngine() {
        return this.inferenceEngine;
    }

    protected synchronized StatementBuffer<?> getAssertionBuffer() {
        if (this.buffer == null) {
            this.buffer = this.tm != null ? new StatementBuffer(this.tm.newTempTripleStore(), this.database, this.bufferCapacity) : new StatementBuffer(this.database, this.bufferCapacity);
        }
        return this.buffer;
    }

    public boolean getFlush() {
        return this.flush;
    }

    public void endSource() {
        if (this.buffer != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Flushing the buffer.");
            }
            this.buffer.flush();
        }
    }

    public ClosureEnum getClosureEnum() {
        return this.closureEnum;
    }

    public CommitEnum getCommitEnum() {
        return this.commitEnum;
    }

    public DataLoader(AbstractTripleStore database) {
        this(database.getProperties(), database);
    }

    public DataLoader(Properties properties, AbstractTripleStore database) {
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        if (database == null) {
            throw new IllegalArgumentException();
        }
        this.parserOptions = new RDFParserOptions(properties);
        if (properties.getProperty(Options.PRESERVE_BNODE_IDS) == null && database.getLexiconRelation().isStoreBlankNodes()) {
            this.parserOptions.setPreserveBNodeIDs(true);
        }
        this.commitEnum = CommitEnum.valueOf(properties.getProperty(Options.COMMIT, Options.DEFAULT_COMMIT));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.COMMIT + "=" + (Object)((Object)this.commitEnum)));
        }
        ClosureEnum closureEnum = this.closureEnum = database.getAxioms().isNone() ? ClosureEnum.None : ClosureEnum.valueOf(properties.getProperty(Options.CLOSURE, Options.DEFAULT_CLOSURE));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.CLOSURE + "=" + (Object)((Object)this.closureEnum)));
        }
        this.bufferCapacity = Integer.parseInt(properties.getProperty(Options.BUFFER_CAPACITY, "100000"));
        this.database = database;
        this.inferenceEngine = database.getInferenceEngine();
        this.tm = this.closureEnum != ClosureEnum.None ? new TruthMaintenance(this.inferenceEngine) : null;
        this.flush = Boolean.parseBoolean(properties.getProperty(Options.FLUSH, "true"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.FLUSH + "=" + this.flush));
        }
    }

    public final LoadStats loadData(String resource, String baseURL, RDFFormat rdfFormat) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        if (baseURL == null) {
            throw new IllegalArgumentException();
        }
        if (rdfFormat == null) {
            throw new IllegalArgumentException();
        }
        return this.loadData(new String[]{resource}, new String[]{baseURL}, new RDFFormat[]{rdfFormat});
    }

    public final LoadStats loadData(String[] resource, String[] baseURL, RDFFormat[] rdfFormat) throws IOException {
        if (resource.length != baseURL.length) {
            throw new IllegalArgumentException();
        }
        if (resource.length != rdfFormat.length) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("commit=" + (Object)((Object)this.commitEnum) + ", closure=" + (Object)((Object)this.closureEnum) + ", resource=" + Arrays.toString(resource)));
        }
        LoadStats totals = new LoadStats();
        for (int i = 0; i < resource.length; ++i) {
            boolean endOfBatch = i + 1 == resource.length;
            this.loadData2(totals, resource[i], baseURL[i], rdfFormat[i], endOfBatch);
        }
        if (this.flush && this.buffer != null) {
            this.buffer.flush();
        }
        if (this.commitEnum == CommitEnum.Batch) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Commit after batch of " + resource.length + " resources"));
            }
            long beginCommit = System.currentTimeMillis();
            this.database.commit();
            totals.commitTime.add(System.currentTimeMillis() - beginCommit);
            if (log.isInfoEnabled()) {
                log.info((Object)("commit: latency=" + totals.commitTime + "ms"));
            }
            if (log.isInfoEnabled()) {
                // empty if block
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded " + resource.length + " resources: " + totals));
        }
        return totals;
    }

    public LoadStats loadData(Reader reader, String baseURL, RDFFormat rdfFormat) throws IOException {
        LoadStats totals = new LoadStats();
        this.loadData3(totals, reader, baseURL, rdfFormat, null, true);
        return totals;
    }

    public LoadStats loadData(InputStream is, String baseURL, RDFFormat rdfFormat) throws IOException {
        LoadStats totals = new LoadStats();
        this.loadData3(totals, is, baseURL, rdfFormat, null, true);
        return totals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadStats loadData(URL url, String baseURL, RDFFormat rdfFormat) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("loading: " + url));
        }
        try (InputStream is = url.openStream();){
            LoadStats totals = new LoadStats();
            this.loadData3(totals, is, baseURL, rdfFormat, url.toString(), true);
            LoadStats loadStats = totals;
            return loadStats;
        }
    }

    protected void loadData2(LoadStats totals, String resource, String baseURL, RDFFormat rdfFormat, boolean endOfBatch) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("loading: " + resource));
        }
        String defaultGraph = null;
        InputStream rdfStream = this.getClass().getResourceAsStream(resource);
        if (rdfStream != null) {
            defaultGraph = this.getClass().getResource(resource).toString();
        }
        if (rdfStream == null) {
            File file;
            rdfStream = this.getClass().getClassLoader().getResourceAsStream(resource);
            if (rdfStream != null) {
                defaultGraph = this.getClass().getClassLoader().getResource(resource).toString();
            }
            if (rdfStream == null && (file = new File(resource)).exists()) {
                defaultGraph = file.toURI().toString();
                this.loadFiles(totals, 0, file, baseURL, rdfFormat, defaultGraph, filter, endOfBatch);
                return;
            }
        }
        if (rdfStream == null) {
            throw new IOException("Could not locate resource: " + resource);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(rdfStream));
        try {
            this.loadData3(totals, reader, baseURL, rdfFormat, defaultGraph, endOfBatch);
        }
        catch (Exception ex) {
            throw new RuntimeException("While loading: " + resource, ex);
        }
        finally {
            ((Reader)reader).close();
            rdfStream.close();
        }
    }

    public LoadStats loadFiles(File file, String baseURI, RDFFormat rdfFormat, String defaultGraph, FilenameFilter filter) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        LoadStats totals = new LoadStats();
        this.loadFiles(totals, 0, file, baseURI, rdfFormat, defaultGraph, filter, true);
        return totals;
    }

    /*
     * Loose catch block
     */
    protected void loadFiles(LoadStats totals, int depth, File file, String baseURI, RDFFormat rdfFormat, String defaultGraph, FilenameFilter filter, boolean endOfBatch) throws IOException {
        if (file.isDirectory()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("loading directory: " + file));
            }
            File[] files = filter != null ? file.listFiles(filter) : file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                this.loadFiles(totals, depth + 1, f, baseURI, rdfFormat, defaultGraph, filter, depth == 0 && i < files.length - 1 ? false : endOfBatch);
            }
            return;
        }
        String n = file.getName();
        RDFFormat fmt = RDFFormat.forFileName((String)n);
        if (fmt == null && n.endsWith(".zip")) {
            fmt = RDFFormat.forFileName((String)n.substring(0, n.length() - 4));
        }
        if (fmt == null && n.endsWith(".gz")) {
            fmt = RDFFormat.forFileName((String)n.substring(0, n.length() - 3));
        }
        if (fmt == null) {
            fmt = rdfFormat;
        }
        try (InputStream is = null;){
            is = new FileInputStream(file);
            if (n.endsWith(".gz")) {
                is = new GZIPInputStream(is);
            } else if (n.endsWith(".zip")) {
                is = new ZipInputStream(is);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String s = baseURI != null ? baseURI : file.toURI().toString();
                this.loadData3(totals, reader, s, fmt, defaultGraph, endOfBatch);
                return;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public void loadData3(final LoadStats totals, Object source, final String baseURL, RDFFormat rdfFormat, String defaultGraph, boolean endOfBatch) throws IOException {
        long begin = System.currentTimeMillis();
        LoadStats stats = new LoadStats();
        this.getAssertionBuffer();
        if (!this.buffer.isEmpty()) {
            this.buffer.reset();
        }
        PresortRioLoader loader = new PresortRioLoader(this.buffer);
        loader.addRioLoaderListener(new RioLoaderListener(){

            @Override
            public void processingNotification(RioLoaderEvent e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)(e.getStatementsProcessed() + " stmts buffered in " + (double)e.getTimeElapsed() / 1000.0 + " secs, rate= " + e.getInsertRate() + (baseURL != null ? ", baseURL=" + baseURL : "") + ", totalStatementsSoFar=" + (e.getStatementsProcessed() + totals.toldTriples.get())));
                }
            }
        });
        try {
            if (source instanceof Reader) {
                loader.loadRdf((Reader)source, baseURL, rdfFormat, defaultGraph, this.parserOptions);
            } else if (source instanceof InputStream) {
                loader.loadRdf((InputStream)source, baseURL, rdfFormat, defaultGraph, this.parserOptions);
            } else {
                throw new AssertionError();
            }
            long nstmts = loader.getStatementsAdded();
            stats.toldTriples.set(nstmts);
            stats.loadTime.set(System.currentTimeMillis() - begin);
            if (this.closureEnum == ClosureEnum.Incremental || endOfBatch && this.closureEnum == ClosureEnum.Batch) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Computing closure.");
                }
                stats.closureStats.add(this.doClosure());
            }
            if (this.commitEnum == CommitEnum.Incremental) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Commit after each resource");
                }
                long beginCommit = System.currentTimeMillis();
                this.database.commit();
                stats.commitTime.set(System.currentTimeMillis() - beginCommit);
                if (log.isInfoEnabled()) {
                    log.info((Object)("commit: latency=" + stats.commitTime + "ms"));
                }
                if (log.isInfoEnabled()) {
                    // empty if block
                }
            }
            stats.totalTime.set(System.currentTimeMillis() - begin);
            totals.add(stats);
            if (log.isInfoEnabled()) {
                log.info((Object)("file:: " + stats + "; totals:: " + totals + (baseURL != null ? "; baseURL=" + baseURL : "")));
                if (this.buffer != null && this.buffer.getDatabase() instanceof AbstractLocalTripleStore && log.isDebugEnabled()) {
                    log.debug((Object)((AbstractLocalTripleStore)this.buffer.getDatabase()).getLocalBTreeBytesWritten(new StringBuilder()).toString());
                }
            }
            return;
        }
        catch (Exception ex) {
            totals.add(stats);
            if (this.buffer != null) {
                this.buffer.reset();
                if (this.tm != null) {
                    this.buffer.getStatementStore().close();
                }
                this.buffer = null;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            IOException ex2 = new IOException("Problem loading data?");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    private void logCounters(AbstractTripleStore database) {
        if (!log.isInfoEnabled()) {
            return;
        }
        IIndexManager store = database.getIndexManager();
        if (!(store instanceof Journal)) {
            return;
        }
        if (!(((Journal)store).getBufferStrategy() instanceof RWStrategy)) {
            return;
        }
        StringBuilder sb = new StringBuilder("\n");
        ((RWStrategy)((Journal)store).getBufferStrategy()).getStore().showAllocators(sb);
        log.info((Object)sb.toString());
        long extent = ((Journal)store).getBufferStrategy().getExtent();
        long stmts = database.getStatementCount();
        long bytesPerStmt = stmts == 0L ? 0L : extent / stmts;
        log.info((Object)("extent=" + extent + ", stmts=" + stmts + ", bytes/stat=" + bytesPerStmt));
    }

    public ClosureStats doClosure() {
        ClosureStats stats;
        switch (this.closureEnum) {
            case Incremental: 
            case Batch: {
                if (this.buffer == null) {
                    throw new IllegalStateException();
                }
                this.buffer.flush();
                stats = new TruthMaintenance(this.inferenceEngine).assertAll((TempTripleStore)this.buffer.getStatementStore());
                this.buffer = null;
                break;
            }
            case None: {
                stats = this.inferenceEngine.computeClosure(null);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String[] overrides;
        File propertyFile;
        String arg;
        int i;
        String namespace = "kb";
        boolean doClosure = false;
        boolean verbose = false;
        boolean quiet = false;
        RDFFormat rdfFormat = null;
        String defaultGraph = null;
        String baseURI = null;
        for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if (arg.equals("-namespace")) {
                namespace = args[++i];
                continue;
            }
            if (arg.equals("-format")) {
                rdfFormat = RDFFormat.valueOf((String)args[++i]);
                continue;
            }
            if (arg.equals("-baseURI")) {
                baseURI = args[++i];
                continue;
            }
            if (arg.equals("-defaultGraph")) {
                if ((defaultGraph = args[++i]).length() != 0) continue;
                defaultGraph = null;
                continue;
            }
            if (arg.equals("-closure")) {
                doClosure = true;
                continue;
            }
            if (arg.equals("-verbose")) {
                verbose = true;
                quiet = false;
                continue;
            }
            if (arg.equals("-quiet")) {
                quiet = true;
                verbose = false;
                continue;
            }
            System.err.println("Unknown argument: " + arg);
            DataLoader.usage();
        }
        int remaining = args.length - i;
        if (remaining < 1) {
            System.err.println("Not enough arguments.");
            DataLoader.usage();
        }
        if (!(propertyFile = new File(args[i++])).exists()) {
            throw new FileNotFoundException(propertyFile.toString());
        }
        Properties properties = new Properties();
        if (!quiet) {
            System.out.println("Reading properties: " + propertyFile);
        }
        try (FileInputStream is = new FileInputStream(propertyFile);){
            properties.load(is);
        }
        for (String s : overrides = new String[]{com.bigdata.journal.Options.FILE, RDFParserOptions.Options.DATATYPE_HANDLING, RDFParserOptions.Options.PRESERVE_BNODE_IDS, RDFParserOptions.Options.STOP_AT_FIRST_ERROR, RDFParserOptions.Options.VERIFY_DATA, Options.BUFFER_CAPACITY, Options.CLOSURE, Options.COMMIT, Options.FLUSH}) {
            if (System.getProperty(s) == null) continue;
            String v = System.getProperty(s);
            if (!quiet) {
                System.out.println("Using: " + s + "=" + v);
            }
            properties.setProperty(s, v);
        }
        LinkedList<File> files = new LinkedList<File>();
        while (i < args.length) {
            File fileOrDir;
            if (!(fileOrDir = new File(args[i++])).exists()) {
                throw new FileNotFoundException(fileOrDir.toString());
            }
            files.add(fileOrDir);
            if (quiet) continue;
            System.out.println("Will load from: " + fileOrDir);
        }
        try (AbstractJournal jnl = null;){
            AbstractTripleStore kb;
            long begin = System.currentTimeMillis();
            jnl = new Journal(properties);
            long userData0 = jnl.getBufferStrategy().size();
            if (!quiet) {
                System.out.println("Journal file: " + jnl.getFile());
            }
            if ((kb = (AbstractTripleStore)((Journal)jnl).getResourceLocator().locate(namespace, 0L)) == null) {
                kb = new LocalTripleStore(jnl, namespace, 0L, properties);
                kb.create();
            }
            LoadStats totals = new LoadStats();
            DataLoader dataLoader = new DataLoader(properties, kb);
            for (File fileOrDir : files) {
                dataLoader.loadFiles(totals, 0, fileOrDir, baseURI, rdfFormat, defaultGraph, filter, true);
            }
            dataLoader.endSource();
            if (!quiet) {
                System.out.println("Load: " + totals);
            }
            if (dataLoader.closureEnum == ClosureEnum.None && doClosure) {
                if (verbose) {
                    System.out.println(((Journal)jnl).getCounters().toString());
                    System.out.println(((AbstractLocalTripleStore)dataLoader.database).getLocalBTreeBytesWritten(new StringBuilder()).toString());
                }
                if (!quiet) {
                    System.out.println("Computing closure.");
                }
                log.info((Object)"Computing closure.");
                ClosureStats stats = dataLoader.doClosure();
                if (!quiet) {
                    System.out.println("Closure: " + stats.toString());
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Closure: " + stats.toString()));
                }
            }
            jnl.commit();
            if (verbose) {
                System.out.println(((Journal)jnl).getCounters().toString());
                System.out.println(((AbstractLocalTripleStore)dataLoader.database).getLocalBTreeBytesWritten(new StringBuilder()).toString());
                if (log.isInfoEnabled()) {
                    dataLoader.logCounters(dataLoader.database);
                }
            }
            long userData1 = jnl.getBufferStrategy().size();
            long bytesWritten = userData1 - userData0;
            if (!quiet) {
                System.out.println("Wrote: " + bytesWritten + " bytes.");
            }
            long elapsedTotal = System.currentTimeMillis() - begin;
            if (!quiet) {
                System.out.println("Total elapsed=" + elapsedTotal + "ms");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Total elapsed=" + elapsedTotal + "ms"));
            }
        }
    }

    private static void usage() {
        System.err.println("usage: [-closure][-verbose][-namespace namespace] propertyFile (fileOrDir)+");
        System.exit(1);
    }

    static {
        ServiceProviderHook.forceLoad();
    }

    public static interface Options
    extends RDFParserOptions.Options {
        public static final String COMMIT = DataLoader.class.getName() + ".commit";
        public static final String DEFAULT_COMMIT = CommitEnum.Batch.toString();
        public static final String BUFFER_CAPACITY = DataLoader.class.getName() + ".bufferCapacity";
        public static final String DEFAULT_BUFFER_CAPACITY = "100000";
        public static final String CLOSURE = DataLoader.class.getName() + ".closure";
        public static final String DEFAULT_CLOSURE = ClosureEnum.Batch.toString();
        public static final String FLUSH = DataLoader.class.getName() + ".flush";
        public static final String DEFAULT_FLUSH = "true";
    }

    public static enum ClosureEnum {
        Incremental,
        Batch,
        None;

    }

    public static enum CommitEnum {
        Incremental,
        Batch,
        None;

    }
}

