/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class DumpStore {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String[] overrides;
        File propertyFile;
        String arg;
        int i;
        String namespace = "kb";
        boolean explicit = false;
        boolean inferred = false;
        boolean axioms = false;
        boolean justifications = false;
        for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if (arg.equals("-namespace")) {
                namespace = args[++i];
                continue;
            }
            if (arg.equals("-explicit")) {
                explicit = true;
                continue;
            }
            if (arg.equals("-inferred")) {
                inferred = true;
                continue;
            }
            if (arg.equals("-axioms")) {
                axioms = true;
                continue;
            }
            if (!arg.equals("-justifications")) continue;
            justifications = true;
        }
        if (!(propertyFile = new File(args[i++])).exists()) {
            throw new FileNotFoundException(propertyFile.toString());
        }
        Properties properties = new Properties();
        System.out.println("Reading properties: " + propertyFile);
        try (FileInputStream is = new FileInputStream(propertyFile);){
            properties.load(is);
        }
        for (String s : overrides = new String[]{Options.FILE}) {
            if (System.getProperty(s) == null) continue;
            String v = System.getProperty(s);
            System.out.println("Using: " + s + "=" + v);
            properties.setProperty(s, v);
        }
        try (Journal jnl = null;){
            jnl = new Journal(properties);
            System.out.println("Journal file: " + jnl.getFile());
            AbstractTripleStore kb = (AbstractTripleStore)jnl.getResourceLocator().locate(namespace, 0L);
            if (kb == null) {
                throw new RuntimeException("No such namespace: " + namespace);
            }
            System.out.println(kb.dumpStore(kb, explicit, inferred, axioms, justifications));
        }
    }
}

