/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.task;

import com.bigdata.journal.ConcurrencyManager;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IReadOnly;
import com.bigdata.journal.Journal;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.webapp.DatasetNotFoundException;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.task.ApiTaskForIndexManager;
import com.bigdata.rdf.task.ApiTaskForJournal;
import com.bigdata.rdf.task.IApiTask;
import com.bigdata.service.IBigdataFederation;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import org.openrdf.repository.RepositoryException;
import org.openrdf.sail.SailException;

public abstract class AbstractApiTask<T>
implements IApiTask<T>,
IReadOnly {
    private final AtomicReference<IIndexManager> indexManagerRef = new AtomicReference();
    protected final String namespace;
    protected final long timestamp;
    private final boolean isGRSRequired;

    @Override
    public abstract boolean isReadOnly();

    @Override
    public final String getNamespace() {
        return this.namespace;
    }

    @Override
    public final long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean isGRSRequired() {
        return this.isGRSRequired;
    }

    public String toString() {
        return this.getClass().getName() + "{namespace=" + this.getNamespace() + ",timestamp=" + this.getTimestamp() + ", isGRSRequired=" + this.isGRSRequired + "}";
    }

    protected AbstractApiTask(String namespace, long timestamp) {
        this(namespace, timestamp, false);
    }

    protected AbstractApiTask(String namespace, long timestamp, boolean isGRSRequired) {
        this.namespace = namespace;
        this.timestamp = timestamp;
        this.isGRSRequired = isGRSRequired;
    }

    @Override
    public void setIndexManager(IIndexManager indexManager) {
        this.indexManagerRef.set(indexManager);
    }

    @Override
    public IIndexManager getIndexManager() {
        IIndexManager tmp = this.indexManagerRef.get();
        if (tmp == null) {
            throw new IllegalStateException();
        }
        return tmp;
    }

    protected AbstractTripleStore getTripleStore() {
        return this.getTripleStore(this.namespace, this.timestamp);
    }

    protected AbstractTripleStore getTripleStore(String namespace, long timestamp) {
        AbstractTripleStore tripleStore = (AbstractTripleStore)this.getIndexManager().getResourceLocator().locate(namespace, timestamp);
        return tripleStore;
    }

    protected BigdataSailRepositoryConnection getQueryConnection() throws RepositoryException {
        return this.getQueryConnection(this.namespace, this.timestamp);
    }

    protected BigdataSailRepositoryConnection getQueryConnection(String namespace, long timestamp) throws RepositoryException {
        AbstractTripleStore tripleStore = this.getTripleStore(namespace, timestamp);
        if (tripleStore == null) {
            throw new DatasetNotFoundException("Not found: namespace=" + namespace + ", timestamp=" + TimestampUtility.toString(timestamp));
        }
        BigdataSail sail = new BigdataSail(tripleStore);
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        repo.initialize();
        if (TimestampUtility.isReadOnly(timestamp)) {
            return repo.getReadOnlyConnection(timestamp);
        }
        BigdataSailRepositoryConnection conn = repo.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    protected BigdataSailRepositoryConnection getUnisolatedConnection() throws SailException, RepositoryException {
        AbstractTripleStore tripleStore = (AbstractTripleStore)this.getIndexManager().getResourceLocator().locate(this.namespace, 0L);
        if (tripleStore == null) {
            throw new DatasetNotFoundException("Not found: namespace=" + this.namespace);
        }
        BigdataSail sail = new BigdataSail(tripleStore);
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        repo.initialize();
        BigdataSailRepositoryConnection conn = repo.getUnisolatedConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    public static <T> FutureTask<T> submitApiTask(IIndexManager indexManager, IApiTask<T> task) {
        String namespace = task.getNamespace();
        long timestamp = task.getTimestamp();
        if (!indexManager.isGroupCommit() || indexManager instanceof IBigdataFederation || TimestampUtility.isReadOnly(timestamp)) {
            FutureTask<T> ft = new FutureTask<T>(new ApiTaskForIndexManager<T>(indexManager, task));
            ft.run();
            return ft;
        }
        String[] locks = AbstractApiTask.getLocksForKB((Journal)indexManager, namespace, task.isGRSRequired());
        ConcurrencyManager cc = ((Journal)indexManager).getConcurrencyManager();
        FutureTask<T> ft = cc.submit(new ApiTaskForJournal<T>(cc, task.getTimestamp(), locks, task));
        return ft;
    }

    private static String[] getLocksForKB(Journal indexManager, String namespace, boolean requiresGRS) {
        if (requiresGRS) {
            return new String[]{"__globalRowStore", namespace};
        }
        return new String[]{namespace};
    }
}

