/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.accesspath;

import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BufferAnnotations;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.ap.filter.SameVariableConstraint;
import com.bigdata.bop.cost.BTreeCostModel;
import com.bigdata.bop.cost.DiskCostModel;
import com.bigdata.bop.cost.IndexSegmentCostModel;
import com.bigdata.bop.cost.ScanCostReport;
import com.bigdata.bop.join.BaseJoinStats;
import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BTree;
import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.IBTreeStatistics;
import com.bigdata.btree.IBloomFilter;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.Tuple;
import com.bigdata.btree.UnisolatedReadWriteIndex;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.proc.ISimpleIndexProcedure;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.NoSuchIndexException;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.IMetadataIndex;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.relation.accesspath.ChunkConsumerIterator;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.accesspath.IBindingSetAccessPath;
import com.bigdata.relation.accesspath.SameVariableConstraintTupleFilter;
import com.bigdata.relation.accesspath.TupleObjectResolver;
import com.bigdata.service.AbstractClient;
import com.bigdata.service.DataService;
import com.bigdata.service.IBigdataClient;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.ndx.IScaleOutClientIndex;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.ChunkedWrappedIterator;
import com.bigdata.striterator.EmptyChunkedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.NOPFilter;
import cutthecrap.utils.striterators.Striterator;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

public class AccessPath<R>
implements IAccessPath<R>,
IBindingSetAccessPath<R> {
    protected static final Logger log = Logger.getLogger(IAccessPath.class);
    private final IRelation<R> relation;
    protected final IIndexManager indexManager;
    protected final long timestamp;
    protected final IPredicate<R> predicate;
    final LocalPartitionMetadata pmd;
    protected final IKeyOrder<R> keyOrder;
    protected final IIndex ndx;
    protected final int flags;
    protected final int chunkOfChunksCapacity;
    protected final int chunkCapacity;
    protected final int fullyBufferedReadThreshold;
    private final boolean isFullyBoundForKey;
    private final boolean hasFilter;
    protected static final int MAX_FULLY_BUFFERED_READ_LIMIT = 10000000;
    private final boolean historicalRead;
    private long rangeCount = -1L;
    protected final IFilter indexLocalFilter;
    protected final IFilter accessPathFilter;
    private boolean didInit = false;
    private final byte[] fromKey;
    private final byte[] toKey;
    private static final DiskCostModel diskCostModel = DiskCostModel.DEFAULT;

    public final boolean hasFilter() {
        return this.hasFilter;
    }

    public boolean isFullyBoundForKey() {
        return this.isFullyBoundForKey;
    }

    public int getChunkCapacity() {
        return this.chunkCapacity;
    }

    public int getChunkOfChunksCapacity() {
        return this.chunkOfChunksCapacity;
    }

    public final byte[] getFromKey() {
        return this.fromKey;
    }

    public final byte[] getToKey() {
        return this.toKey;
    }

    @Override
    public final IKeyOrder<R> getKeyOrder() {
        return this.keyOrder;
    }

    public AccessPath(IRelation<R> relation, IIndexManager localIndexManager, IPredicate<R> predicate, IKeyOrder<R> keyOrder) {
        IIndex ndx;
        int flags;
        if (relation == null) {
            throw new IllegalArgumentException();
        }
        if (predicate == null) {
            throw new IllegalArgumentException();
        }
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        this.relation = relation;
        int partitionId = predicate.getPartitionId();
        boolean remoteAccessPath = predicate.getProperty(IPredicate.Annotations.REMOTE_ACCESS_PATH, partitionId == -1);
        if (!(relation.getIndexManager() instanceof IBigdataFederation)) {
            this.indexManager = relation.getIndexManager();
        } else if (remoteAccessPath) {
            this.indexManager = relation.getIndexManager();
        } else {
            if (localIndexManager == null) {
                throw new RuntimeException("Local index manager not given but access path specifies local index: pred=" + predicate);
            }
            this.indexManager = localIndexManager;
        }
        this.predicate = predicate;
        this.keyOrder = keyOrder;
        this.flags = flags = predicate.getProperty(IPredicate.Annotations.FLAGS, 3).intValue();
        long timestamp = relation.getTimestamp();
        this.timestamp = timestamp = timestamp == 0L && (flags & 8) != 0 ? -1L : timestamp;
        this.historicalRead = TimestampUtility.isReadOnly(this.timestamp);
        if (partitionId != -1) {
            if (remoteAccessPath) {
                throw new RuntimeException("Annotations are not compatible: " + IPredicate.Annotations.REMOTE_ACCESS_PATH + "=" + remoteAccessPath + ", but " + IPredicate.Annotations.PARTITION_ID + "=" + partitionId + " for " + predicate);
            }
            String namespace = relation.getNamespace();
            String name = DataService.getIndexPartitionName(namespace + "." + keyOrder.getIndexName(), partitionId);
            try {
                ndx = (ILocalBTreeView)this.indexManager.getIndex(name, this.timestamp);
            }
            catch (Throwable t) {
                throw new RuntimeException(predicate.toString(), t);
            }
            if (ndx == null) {
                throw new RuntimeException("No such index: relation=" + relation.getNamespace() + ", timestamp=" + this.timestamp + ", keyOrder=" + keyOrder + ", pred=" + predicate + ", indexManager=" + this.indexManager);
            }
            this.pmd = ndx.getIndexMetadata().getPartitionMetadata();
            if (this.pmd == null) {
                throw new RuntimeException("Not an index partition");
            }
            if (this.pmd.getPartitionId() != partitionId) {
                throw new RuntimeException("Expecting partitionId=" + partitionId + ", but have " + this.pmd.getPartitionId());
            }
        } else {
            this.pmd = null;
            ndx = relation.getIndex(keyOrder);
            if (ndx == null) {
                throw new RuntimeException("No such index: relation=" + relation.getNamespace() + ", timestamp=" + this.timestamp + ", keyOrder=" + keyOrder + ", pred=" + predicate + ", indexManager=" + this.indexManager);
            }
        }
        this.ndx = ndx;
        int chunkOfChunksCapacity = predicate.getProperty(BufferAnnotations.CHUNK_OF_CHUNKS_CAPACITY, 5);
        int chunkCapacity = predicate.getProperty(BufferAnnotations.CHUNK_CAPACITY, 100);
        int fullyBufferedReadThreshold = predicate.getProperty(IPredicate.Annotations.FULLY_BUFFERED_READ_THRESHOLD, 100);
        this.chunkOfChunksCapacity = chunkOfChunksCapacity;
        this.chunkCapacity = chunkCapacity;
        this.fullyBufferedReadThreshold = fullyBufferedReadThreshold;
        this.isFullyBoundForKey = predicate.isFullyBound(keyOrder);
        IFilter indexLocalFilter = predicate.getIndexLocalFilter();
        SameVariableConstraint<R> sameVarConstraint = SameVariableConstraint.newInstance(predicate);
        if (sameVarConstraint != null) {
            NOPFilter tmp = new NOPFilter();
            if (indexLocalFilter != null) {
                tmp.addFilter(indexLocalFilter);
            }
            tmp.addFilter(new SameVariableConstraintTupleFilter<R>(sameVarConstraint));
            this.indexLocalFilter = tmp;
        } else {
            this.indexLocalFilter = indexLocalFilter;
        }
        this.accessPathFilter = predicate.getAccessPathFilter();
        this.hasFilter = this.indexLocalFilter != null || this.accessPathFilter != null;
        IKeyBuilder keyBuilder = ndx.getIndexMetadata().getTupleSerializer().getKeyBuilder();
        this.fromKey = keyOrder.getFromKey(keyBuilder, predicate);
        this.toKey = keyOrder.getToKey(keyBuilder, predicate);
    }

    public String toString() {
        return this.getClass().getName() + "{predicate=" + this.predicate + ", keyOrder=" + this.keyOrder + ", flags=" + Tuple.flagString(this.flags) + ", fromKey=" + (this.fromKey == null ? "n/a" : BytesUtil.toString(this.fromKey)) + ", toKey=" + (this.toKey == null ? "n/a" : BytesUtil.toString(this.toKey)) + ", hasFilter=" + this.hasFilter + ", indexLocalFilter=" + (this.indexLocalFilter == null ? "n/a" : this.indexLocalFilter) + ", accessPathFilter=" + (this.accessPathFilter == null ? "n/a" : this.accessPathFilter) + ", indexManager=" + this.indexManager + "}";
    }

    protected final void assertInitialized() {
        if (!this.didInit) {
            throw new IllegalStateException();
        }
    }

    public AccessPath<R> init() {
        if (this.didInit) {
            throw new IllegalStateException();
        }
        this.didInit = true;
        if (log.isDebugEnabled()) {
            if (this.fromKey != null && this.toKey != null && BytesUtil.compareBytes(this.fromKey, this.toKey) >= 0) {
                throw new AssertionError((Object)("keys are out of order: " + this.toString()));
            }
            log.debug((Object)this.toString());
        }
        return this;
    }

    public IRelation<R> getRelation() {
        return this.relation;
    }

    public IIndexManager getIndexManager() {
        return this.indexManager;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public IPredicate<R> getPredicate() {
        return this.predicate;
    }

    @Override
    public IIndex getIndex() {
        return this.ndx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.assertInitialized();
        if (this.historicalRead && this.rangeCount != -1L) {
            return this.rangeCount == 0L;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this.toString());
        }
        try (IChunkedOrderedIterator<R> itr = this.iterator(0L, 1L, 1);){
            boolean empty;
            boolean bl = empty = !itr.hasNext();
            if (empty && this.historicalRead) {
                this.rangeCount = 0L;
            }
            boolean bl2 = empty;
            return bl2;
        }
    }

    @Override
    public ICloseableIterator<IBindingSet[]> solutions(long limit, BaseJoinStats stats) {
        return BOpContext.solutions(this.iterator(0L, limit, 0), this.predicate, stats);
    }

    @Override
    public final IChunkedOrderedIterator<R> iterator() {
        return this.iterator(0L, 0L, 0);
    }

    @Override
    public final IChunkedOrderedIterator<R> iterator(long offset, long limit, int capacity) {
        boolean fullyBufferedRead;
        if (offset < 0L) {
            throw new IllegalArgumentException();
        }
        if (limit < 0L) {
            throw new IllegalArgumentException();
        }
        if (limit == Long.MAX_VALUE) {
            limit = 0L;
        }
        if (limit > 10000000L) {
            throw new UnsupportedOperationException("limit=" + limit + " exceeds maximum fully buffered read limit: " + 10000000);
        }
        if (this.historicalRead && this.rangeCount >= 0L && this.rangeCount - offset <= 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Proven empty by historical range count");
            }
            return new EmptyChunkedIterator<R>(this.keyOrder);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("offset=" + offset + ", limit=" + limit + ", capacity=" + capacity + ", accessPath=" + this));
        }
        boolean bloomHit = false;
        if (this.isFullyBoundForKey) {
            IBloomFilter filter;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Predicate is fully bound for the key.");
            }
            if (offset > 0L) {
                return new EmptyChunkedIterator<R>(this.keyOrder);
            }
            capacity = 1;
            limit = 1L;
            fullyBufferedRead = true;
            if (this.ndx instanceof ILocalBTreeView && (filter = ((ILocalBTreeView)this.ndx).getBloomFilter()) != null) {
                if (!filter.contains(this.fromKey)) {
                    return new EmptyChunkedIterator<R>(this.keyOrder);
                }
                bloomHit = true;
            }
        } else if (limit > 0L) {
            capacity = (int)limit;
            fullyBufferedRead = true;
        } else {
            long rangeCountRemaining = this.rangeCount(false) - offset;
            if (log.isDebugEnabled()) {
                log.debug((Object)("offset=" + offset + ", limit=" + limit + ", rangeCountRemaining=" + rangeCountRemaining + ", fullyBufferedReadThreashold=" + this.fullyBufferedReadThreshold));
            }
            if (rangeCountRemaining <= 0L) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No elements based on range count.");
                }
                return new EmptyChunkedIterator<R>(this.keyOrder);
            }
            if (rangeCountRemaining < (long)this.fullyBufferedReadThreshold) {
                limit = limit == 0L ? rangeCountRemaining : Math.min(limit, rangeCountRemaining);
                capacity = (int)Math.min(10000000L, limit);
                fullyBufferedRead = true;
            } else {
                fullyBufferedRead = false;
            }
        }
        ITupleIterator<R> tupleItr = this.rangeIterator(capacity, this.flags, this.indexLocalFilter);
        IStriterator src = new Striterator(tupleItr).addFilter(new TupleObjectResolver());
        if (this.accessPathFilter != null) {
            ((Striterator)src).addFilter(this.accessPathFilter);
        }
        if (fullyBufferedRead) {
            IChunkedOrderedIterator<R> tmp = this.synchronousIterator(offset, limit, src);
            if (bloomHit && !tmp.hasNext()) {
                ((ILocalBTreeView)this.ndx).getBloomFilter().falsePos();
            }
            return tmp;
        }
        assert (offset == 0L) : "offset=" + limit;
        assert (limit == 0L) : "limit=" + limit;
        return this.asynchronousIterator(src);
    }

    protected final IChunkedOrderedIterator<R> synchronousIterator(long offset, long limit, Iterator<R> src) {
        if (offset < 0L) {
            throw new IllegalArgumentException();
        }
        if (limit <= 0L) {
            throw new IllegalArgumentException();
        }
        assert (limit < 10000000L) : "limit=" + limit + ", max=" + 10000000;
        if (log.isDebugEnabled()) {
            log.debug((Object)("offset=" + offset + ", limit=" + limit));
        }
        int nread = 0;
        int nused = 0;
        while ((long)nread < offset && src.hasNext()) {
            src.next();
            ++nread;
        }
        Object[] buffer = null;
        while ((long)nused < limit && src.hasNext()) {
            R e = src.next();
            if (buffer == null) {
                buffer = (Object[])Array.newInstance(e.getClass(), (int)limit);
            }
            buffer[nused] = e;
            ++nused;
            ++nread;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fully buffered: read=" + nread + ", used=" + nused + ", offset=" + offset + ", limit=" + limit));
        }
        if (nread == 0) {
            return new EmptyChunkedIterator<R>(this.keyOrder);
        }
        return new ChunkedArrayIterator<R>(nused, buffer, this.keyOrder);
    }

    protected final IChunkedOrderedIterator<R> asynchronousIterator(Iterator<R> src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"");
        }
        BlockingBuffer<R[]> buffer = new BlockingBuffer<R[]>(this.chunkOfChunksCapacity);
        FutureTask<Void> ft = new FutureTask<Void>(new ChunkConsumerTask<R>(this, src, buffer));
        buffer.setFuture(ft);
        this.indexManager.getExecutorService().submit(ft);
        return new ChunkConsumerIterator<R>(buffer.iterator(), this.keyOrder);
    }

    @Override
    public final long rangeCount(boolean exact) {
        this.assertInitialized();
        long n = 0L;
        if (exact) {
            if (this.hasFilter) {
                IChunkedOrderedIterator<R> itr = this.iterator();
                while (itr.hasNext()) {
                    itr.next();
                    ++n;
                }
            } else {
                n = this.ndx.rangeCountExact(this.fromKey, this.toKey);
            }
        } else {
            n = this.historicalRead ? this.historicalRangeCount(this.fromKey, this.toKey) : this.ndx.rangeCount(this.fromKey, this.toKey);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("exact=" + exact + ", filter=" + this.hasFilter + ", n=" + n + " : " + this.toString()));
        }
        return n;
    }

    private final long historicalRangeCount(byte[] fromKey, byte[] toKey) {
        if (this.rangeCount == -1L) {
            this.rangeCount = this.ndx.rangeCount(fromKey, toKey);
            return this.rangeCount;
        }
        return this.rangeCount;
    }

    protected ITupleIterator<R> rangeIterator(int capacity, int flags, IFilter filter) {
        this.assertInitialized();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " : capacity=" + capacity + ", flags=" + flags + ", filter=" + filter));
        }
        return this.ndx.rangeIterator(this.fromKey, this.toKey, capacity, flags, filter);
    }

    @Override
    public long removeAll() {
        this.assertInitialized();
        if (log.isDebugEnabled()) {
            log.debug((Object)this.toString());
        }
        ITupleIterator<R> itr = this.rangeIterator(0, 16, this.indexLocalFilter);
        long n = 0L;
        while (itr.hasNext()) {
            itr.next();
            ++n;
        }
        return n;
    }

    public ScanCostReport estimateCost() {
        if (this.ndx instanceof UnisolatedReadWriteIndex) {
            return ((UnisolatedReadWriteIndex)this.ndx).estimateCost(diskCostModel, this.rangeCount(false));
        }
        if (this.ndx instanceof BTree) {
            long rangeCount = this.rangeCount(false);
            return this.estimateCost(diskCostModel, (BTree)this.ndx, rangeCount);
        }
        if (this.ndx instanceof ILocalBTreeView) {
            long rangeCount = this.rangeCount(false);
            return AccessPath.estimateCost((ILocalBTreeView)this.ndx, rangeCount, this.fromKey, this.toKey);
        }
        if (this.ndx instanceof IScaleOutClientIndex) {
            return this.estimateCost((IScaleOutClientIndex)this.ndx);
        }
        throw new UnsupportedOperationException("index=" + this.ndx);
    }

    private ScanCostReport estimateCost(DiskCostModel diskCostModel, BTree btree, long rangeCount) {
        BTree stats = btree;
        double cost = new BTreeCostModel(diskCostModel).rangeScan(rangeCount, stats.getBranchingFactor(), stats.getHeight(), stats.getUtilization().getLeafUtilization());
        return new ScanCostReport(rangeCount, cost);
    }

    private static ScanCostReport estimateCost(ILocalBTreeView view, long rangeCount, byte[] fromKey, byte[] toKey) {
        AbstractBTree[] sources;
        double cost = 0.0;
        for (AbstractBTree source : sources = view.getSources()) {
            IBTreeStatistics stats = source.getStatistics();
            long sourceRangeCount = source.rangeCount(fromKey, toKey);
            if (source instanceof IndexSegment) {
                IndexSegment seg = (IndexSegment)source;
                long extentLeaves = seg.getStore().getCheckpoint().extentLeaves;
                long leafCount = stats.getLeafCount();
                int bytesPerLeaf = (int)Math.ceil((double)extentLeaves / (double)leafCount);
                cost += new IndexSegmentCostModel(diskCostModel).rangeScan((int)sourceRangeCount, stats.getBranchingFactor(), bytesPerLeaf, DirectBufferPool.INSTANCE.getBufferCapacity());
                continue;
            }
            cost += new BTreeCostModel(diskCostModel).rangeScan(sourceRangeCount, stats.getBranchingFactor(), stats.getHeight(), stats.getUtilization().getLeafUtilization());
        }
        return new ScanCostReport(rangeCount, cost);
    }

    private ScanCostReport estimateCost(IScaleOutClientIndex ndx) {
        String name = ndx.getIndexMetadata().getName();
        IBigdataClient client = ndx.getFederation().getClient();
        int maxParallel = ((AbstractClient)client).getMaxParallelTasksPerRequest();
        IMetadataIndex mdi = ndx.getFederation().getMetadataIndex(name, this.timestamp);
        if (mdi == null) {
            throw new NoSuchIndexException("name=" + name + "@" + TimestampUtility.toString(this.timestamp));
        }
        long partitionCount = mdi.rangeCount(this.fromKey, this.toKey);
        if (partitionCount == 0L) {
            return new ScanCostReport(0L, partitionCount, 100.0);
        }
        long rangeCount = this.rangeCount(false);
        if (partitionCount == 1L) {
            return (ScanCostReport)ndx.submit(this.fromKey == null ? BytesUtil.EMPTY : this.fromKey, new EstimateShardScanCost(rangeCount, this.fromKey, this.toKey));
        }
        boolean njournals = true;
        int nsegments = 2;
        long rangeCountOnJournal = rangeCount / (partitionCount * 3L);
        double costPerJournal = new BTreeCostModel(diskCostModel).rangeScan(rangeCountOnJournal, mdi.getIndexMetadata().getBranchingFactor(), 5, 70);
        double costPerSegment = AccessPath.diskCostModel.seekTime + 1.048576E8;
        double costPerShard = costPerJournal + 2.0 * costPerSegment;
        double cost = costPerShard * (double)partitionCount;
        return new ScanCostReport(rangeCount, partitionCount, cost);
    }

    private static final class EstimateShardScanCost
    implements ISimpleIndexProcedure {
        private static final long serialVersionUID = 1L;
        private final long rangeCount;
        private final byte[] fromKey;
        private final byte[] toKey;

        public EstimateShardScanCost(long rangeCount, byte[] fromKey, byte[] toKey) {
            this.rangeCount = rangeCount;
            this.fromKey = fromKey;
            this.toKey = toKey;
        }

        @Override
        public Object apply(IIndex ndx) {
            ScanCostReport scanCostReport = AccessPath.estimateCost((ILocalBTreeView)ndx, this.rangeCount, this.fromKey, this.toKey);
            return scanCostReport;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }

    private static class ChunkConsumerTask<R>
    implements Callable<Void> {
        protected static final Logger log = Logger.getLogger(ChunkConsumerTask.class);
        private final AccessPath<R> accessPath;
        private final Iterator<R> src;
        private final BlockingBuffer<R[]> buffer;

        public ChunkConsumerTask(AccessPath<R> accessPath, Iterator<R> src, BlockingBuffer<R[]> buffer) {
            if (accessPath == null) {
                throw new IllegalArgumentException();
            }
            if (src == null) {
                throw new IllegalArgumentException();
            }
            if (buffer == null) {
                throw new IllegalArgumentException();
            }
            this.accessPath = accessPath;
            this.src = src;
            this.buffer = buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            ChunkedWrappedIterator<R> itr = new ChunkedWrappedIterator<R>(this.src, this.accessPath.chunkCapacity, this.accessPath.keyOrder, null);
            long nchunks = 0L;
            long nelements = 0L;
            try {
                while (this.src.hasNext()) {
                    E[] chunk = itr.nextChunk();
                    ++nchunks;
                    nelements += (long)chunk.length;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("#chunks=" + nchunks + ", chunkSize=" + chunk.length + ", nelements=" + nelements));
                    }
                    this.buffer.add(chunk);
                }
            }
            finally {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Closing buffer: #chunks=" + nchunks + ", #elements=" + nelements + ", accessPath=" + this.accessPath));
                }
                this.buffer.close();
                itr.close();
            }
            return null;
        }
    }
}

