/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.accesspath;

import com.bigdata.btree.ITuple;
import com.bigdata.btree.filter.TupleFilter;
import com.bigdata.relation.accesspath.IElementFilter;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.IFilterTest;

public class ElementFilter<R>
extends TupleFilter<R> {
    private static final long serialVersionUID = 1L;
    private final IElementFilter<R> test;

    public static <R> IFilter newInstance(IElementFilter<R> test) {
        if (test == null) {
            return null;
        }
        return new ElementFilter<R>(test);
    }

    public static <R> IFilter newInstance(IFilterTest test) {
        if (test == null) {
            return null;
        }
        return new ElementFilter<R>(test);
    }

    public ElementFilter(IElementFilter<R> test) {
        if (test == null) {
            throw new IllegalArgumentException();
        }
        this.test = test;
    }

    public ElementFilter(IFilterTest test) {
        if (test == null) {
            throw new IllegalArgumentException();
        }
        this.test = new FilterTestWrapper(test);
    }

    @Override
    public boolean isValid(ITuple<R> tuple) {
        R obj = tuple.getObject();
        return this.test.isValid(obj);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("{test=" + this.test);
        sb.append("}");
        return sb.toString();
    }

    private static class FilterTestWrapper
    implements IElementFilter {
        private static final long serialVersionUID = 1L;
        private final IFilterTest test;

        private FilterTestWrapper(IFilterTest test) {
            this.test = test;
        }

        @Override
        public boolean isValid(Object e) {
            return this.test.isValid(e);
        }

        @Override
        public boolean canAccept(Object o) {
            return true;
        }
    }
}

