/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.accesspath;

import com.bigdata.relation.accesspath.IBuffer;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public abstract class ThreadLocalBufferFactory<T extends IBuffer<E>, E> {
    private static final Logger log = Logger.getLogger(ThreadLocalBufferFactory.class);
    private final ConcurrentHashMap<Thread, T> map;
    private final LinkedList<T> list = new LinkedList();

    protected ThreadLocalBufferFactory() {
        this(16, 0.75f, 16);
    }

    protected ThreadLocalBufferFactory(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.map = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    public final int size() {
        return this.map.size();
    }

    public void add(E e) {
        this.get().add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get() {
        Thread t = Thread.currentThread();
        IBuffer<Object> tmp = (IBuffer)this.map.get(t);
        if (tmp == null) {
            tmp = this.initialValue();
            if (this.map.put(t, tmp) != null) {
                throw new AssertionError();
            }
            LinkedList<T> linkedList = this.list;
            synchronized (linkedList) {
                this.list.add(tmp);
            }
        }
        this.halted();
        return (T)tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        LinkedList<T> linkedList = this.list;
        synchronized (linkedList) {
            int n = 0;
            long m = 0L;
            for (IBuffer b : this.list) {
                this.halted();
                int size = b.size();
                long counter = b.flush();
                m += counter;
                ++n;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Flushed buffer: size=" + size + ", counter=" + counter));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Flushed " + n + " unsynchronized buffers totalling " + m + " elements"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        LinkedList<T> linkedList = this.list;
        synchronized (linkedList) {
            int n = 0;
            for (IBuffer b : this.list) {
                int size = b.size();
                b.reset();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Reset buffer: size=" + size));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Reset " + n + " unsynchronized buffers"));
            }
        }
    }

    protected abstract T initialValue();

    protected abstract void halted();
}

