/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.accesspath;

import com.bigdata.relation.accesspath.AbstractUnsynchronizedArrayBuffer;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.striterator.EmptyChunkedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class UnsynchronizedUnboundedChunkBuffer<E>
extends AbstractUnsynchronizedArrayBuffer<E> {
    private final Queue<E[]> queue;
    private final IKeyOrder<E> keyOrder;
    private Class<E[]> chunkClass = null;

    public UnsynchronizedUnboundedChunkBuffer(int capacity, Class<? extends E> cls) {
        this(capacity, cls, null, null);
    }

    public UnsynchronizedUnboundedChunkBuffer(int capacity, Class<? extends E> cls, IElementFilter<E> filter, IKeyOrder<E> keyOrder) {
        super(capacity, cls, filter);
        this.keyOrder = keyOrder;
        this.queue = new LinkedBlockingQueue<E[]>();
    }

    @Override
    protected final void handleChunk(E[] chunk) {
        if (this.chunkClass == null) {
            this.chunkClass = chunk.getClass();
        }
        this.queue.add(chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChunkedOrderedIterator<E> iterator() {
        this.overflow();
        Queue<E[]> queue = this.queue;
        synchronized (queue) {
            if (this.queue.isEmpty()) {
                return new EmptyChunkedIterator<E>(this.keyOrder);
            }
            assert (this.chunkClass != null);
            Iterator<E[]> src = Arrays.asList((Object[][])this.queue.toArray((T[])((Object[][])Array.newInstance(this.chunkClass, 0)))).iterator();
            return new ListOfChunksIterator<E>(src, this.keyOrder);
        }
    }

    private static class ListOfChunksIterator<E>
    implements IChunkedOrderedIterator<E> {
        private final Iterator<E[]> src;
        private final IKeyOrder<E> keyOrder;
        private boolean open = true;
        private int i = 0;
        private E[] chunk;

        public ListOfChunksIterator(Iterator<E[]> src, IKeyOrder<E> keyOrder) {
            this.src = src;
            this.keyOrder = keyOrder;
        }

        @Override
        public boolean hasNext() {
            if (!this.open) {
                return false;
            }
            do {
                if (this.chunk != null && this.i >= this.chunk.length) {
                    this.chunk = null;
                    this.i = 0;
                }
                if (this.chunk != null) continue;
                if (!this.src.hasNext()) {
                    return false;
                }
                this.chunk = this.src.next();
                this.i = 0;
            } while (this.chunk.length == 0);
            return true;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.chunk[this.i++];
        }

        @Override
        public E[] nextChunk() {
            Object[] ret;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.i == 0) {
                ret = this.chunk;
            } else {
                int remaining = this.chunk.length - this.i;
                ret = (Object[])Array.newInstance(this.chunk.getClass().getComponentType(), remaining);
                System.arraycopy(this.chunk, this.i, ret, 0, remaining);
            }
            this.chunk = null;
            this.i = 0;
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            this.open = false;
        }

        @Override
        public IKeyOrder<E> getKeyOrder() {
            return this.keyOrder;
        }

        @Override
        public E[] nextChunk(IKeyOrder<E> keyOrder) {
            if (keyOrder == null) {
                throw new IllegalArgumentException();
            }
            E[] chunk = this.nextChunk();
            if (!keyOrder.equals(this.getKeyOrder())) {
                Arrays.sort((Object[])chunk.clone(), 0, chunk.length, keyOrder.getComparator());
            }
            return chunk;
        }
    }
}

