/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.ISolution;
import java.io.Serializable;

public class Solution<E>
implements ISolution<E>,
Serializable {
    private static final long serialVersionUID = 5477431033714540993L;
    private final E e;
    private final IRule<E> rule;
    private final IBindingSet bindingSet;

    public Solution(IJoinNexus joinNexus, IRule<E> rule, IBindingSet bindingSet) {
        if (joinNexus == null) {
            throw new IllegalArgumentException();
        }
        if (rule == null) {
            throw new IllegalArgumentException();
        }
        if (bindingSet == null) {
            throw new IllegalArgumentException();
        }
        int flags = joinNexus.solutionFlags();
        if ((flags & 1) != 0) {
            IPredicate head = rule.getHead();
            IRelation relation = joinNexus.getHeadRelationView(head);
            this.e = relation.newElement(head.args(), bindingSet);
        } else {
            this.e = null;
        }
        this.bindingSet = (flags & 2) != 0 ? bindingSet.clone() : null;
        this.rule = (flags & 4) != 0 ? rule : null;
    }

    @Override
    public E get() {
        return this.e;
    }

    @Override
    public IRule<E> getRule() {
        return this.rule;
    }

    @Override
    public IBindingSet getBindingSet() {
        return this.bindingSet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Solution");
        sb.append("{ element=" + this.e);
        sb.append(", rule=" + this.rule);
        sb.append(", bindingSet=" + this.bindingSet);
        sb.append("}");
        return sb.toString();
    }
}

