/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.LRUNexus;
import com.bigdata.bfs.BigdataFileSystem;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexSegmentStore;
import com.bigdata.cache.ConcurrentWeakValueCacheWithTimeout;
import com.bigdata.concurrent.NamedLock;
import com.bigdata.io.SerializerUtil;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.AbstractLocalTransactionManager;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.CommitRecordIndex;
import com.bigdata.journal.DiskOnlyStrategy;
import com.bigdata.journal.ICommitRecord;
import com.bigdata.journal.IConcurrencyManager;
import com.bigdata.journal.ILocalTransactionManager;
import com.bigdata.journal.IResourceLockService;
import com.bigdata.journal.IResourceManager;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.ITransactionService;
import com.bigdata.journal.Name2Addr;
import com.bigdata.journal.TemporaryStore;
import com.bigdata.journal.WORMStrategy;
import com.bigdata.journal.WriteExecutorService;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.IndexPartitionCause;
import com.bigdata.mdi.JournalMetadata;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.mdi.SegmentMetadata;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.relation.locator.DefaultResourceLocator;
import com.bigdata.resources.IndexSegmentIndex;
import com.bigdata.resources.JournalIndex;
import com.bigdata.resources.NoSuchStoreException;
import com.bigdata.resources.PurgeResult;
import com.bigdata.resources.ResourceEvents;
import com.bigdata.resources.ResourceFileFilter;
import com.bigdata.resources.ResourceManager;
import com.bigdata.service.Event;
import com.bigdata.service.EventResource;
import com.bigdata.service.EventType;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.ManagedResourceService;
import com.bigdata.sparse.SparseRowStore;
import com.bigdata.util.concurrent.DaemonThreadFactory;
import com.bigdata.util.config.NicUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public abstract class StoreManager
extends ResourceEvents
implements IResourceManager {
    private static final Logger log = Logger.getLogger(StoreManager.class);
    protected final File dataDir;
    protected final File journalsDir;
    protected final File segmentsDir;
    protected final File tmpDir;
    private final WORMStrategy.StoreCounters storeCounters = new WORMStrategy.StoreCounters();
    private final JournalIndex journalIndex;
    private final IndexSegmentIndex segmentIndex;
    private final Set<UUID> retentionSet = new HashSet<UUID>();
    protected final ConcurrentWeakValueCacheWithTimeout<UUID, IRawStore> storeCache;
    private final transient NamedLock<UUID> namedLock = new NamedLock();
    private final boolean isTransient;
    protected final AtomicReference<ManagedJournal> liveJournalRef = new AtomicReference<Object>(null);
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final AtomicBoolean starting = new AtomicBoolean(true);
    private ManagedResourceService resourceService;
    private final boolean ignoreBadFiles;
    private final boolean purgeOldResourcesDuringStartup;
    protected final long accelerateOverflowThreshold;
    private final ExecutorService startupService = Executors.newSingleThreadExecutor(new DaemonThreadFactory(this.getClass().getName() + ".startupService"));
    private final Map<UUID, File> resourceFiles = new HashMap<UUID, File>();
    private final Properties properties;
    private long releaseTime = 0L;
    protected long purgeResourcesMillis = 0L;
    protected long lastCommitTimePreserved = 0L;
    protected long lastOverflowTime = 0L;
    protected long maximumJournalSizeAtOverflow = 0L;
    protected final AtomicLong journalReopenCount = new AtomicLong();
    protected final AtomicLong segmentStoreReopenCount = new AtomicLong();
    protected final AtomicLong journalDeleteCount = new AtomicLong();
    protected final AtomicLong segmentStoreDeleteCount = new AtomicLong();
    protected final AtomicLong bytesUnderManagement = new AtomicLong();
    protected final AtomicLong journalBytesUnderManagement = new AtomicLong();
    protected final AtomicLong segmentBytesUnderManagement = new AtomicLong();
    protected final AtomicLong bytesDeleted = new AtomicLong();
    protected final ReentrantReadWriteLock indexCacheLock = new ReentrantReadWriteLock();

    public final WORMStrategy.StoreCounters getStoreCounters() {
        return this.storeCounters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retentionSetAdd(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        Set<UUID> set = this.retentionSet;
        synchronized (set) {
            if (!this.retentionSet.add(uuid)) {
                throw new IllegalStateException("Already in set: " + uuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retentionSetRemove(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        Set<UUID> set = this.retentionSet;
        synchronized (set) {
            if (!this.retentionSet.remove(uuid)) {
                log.warn((Object)("Not in retentionSet: " + uuid));
            }
        }
    }

    public int getStoreCacheSize() {
        return this.storeCache.size();
    }

    public ManagedResourceService getResourceService() {
        this.assertRunning();
        return this.resourceService;
    }

    protected void assertRunning() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Not open");
        }
        if (this.isStarting()) {
            throw new IllegalStateException("Starting up");
        }
    }

    public boolean isRunning() {
        return this.isOpen() && !this.isStarting();
    }

    protected void assertOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
    }

    protected void assertNotOpen() {
        if (this.isOpen()) {
            throw new IllegalStateException();
        }
    }

    public boolean awaitRunning() {
        while (this.isOpen() && this.isStarting()) {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Waiting on startup : " + this.dataDir + " ..."));
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted awaiting startup: " + ex);
            }
        }
        return this.isRunning();
    }

    public long getBytesUnderManagement() {
        this.assertRunning();
        return this.bytesUnderManagement.get() + this.getLiveJournal().getBufferStrategy().getExtent();
    }

    public long getJournalBytesUnderManagement() {
        this.assertRunning();
        return this.journalBytesUnderManagement.get() + this.getLiveJournal().getBufferStrategy().getExtent();
    }

    public long getSegmentBytesUnderManagement() {
        this.assertRunning();
        return this.segmentBytesUnderManagement.get();
    }

    public long getDataDirFreeSpace() {
        return this.getFreeSpace(this.dataDir);
    }

    public long getTempDirFreeSpace() {
        return this.getFreeSpace(this.tmpDir);
    }

    private long getFreeSpace(File dir) {
        try {
            if (!dir.exists()) {
                return -1L;
            }
            return dir.getUsableSpace();
        }
        catch (Throwable t) {
            log.error((Object)("Could not get free space: dir=" + dir + " : " + t), t);
            return -1L;
        }
    }

    public Properties getProperties() {
        return new Properties(this.properties);
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    protected StoreManager(Properties properties) {
        File tmpDir;
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        this.properties = properties;
        this.ignoreBadFiles = Boolean.parseBoolean(properties.getProperty(Options.IGNORE_BAD_FILES, "false"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.IGNORE_BAD_FILES + "=" + this.ignoreBadFiles));
        }
        this.purgeOldResourcesDuringStartup = Boolean.parseBoolean(properties.getProperty(Options.PURGE_OLD_RESOURCES_DURING_STARTUP, "true"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.PURGE_OLD_RESOURCES_DURING_STARTUP + "=" + this.purgeOldResourcesDuringStartup));
        }
        this.accelerateOverflowThreshold = Long.parseLong(properties.getProperty(Options.ACCELERATE_OVERFLOW_THRESHOLD, "1073741824"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.ACCELERATE_OVERFLOW_THRESHOLD + "=" + this.accelerateOverflowThreshold));
        }
        if (this.accelerateOverflowThreshold < 0L) {
            throw new RuntimeException(Options.ACCELERATE_OVERFLOW_THRESHOLD + " must be non-negative");
        }
        int storeCacheCapacity = Integer.parseInt(properties.getProperty(Options.STORE_CACHE_CAPACITY, "20"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.STORE_CACHE_CAPACITY + "=" + storeCacheCapacity));
        }
        if (storeCacheCapacity <= 0) {
            throw new RuntimeException(Options.STORE_CACHE_CAPACITY + " must be positive");
        }
        long storeCacheTimeout = Long.parseLong(properties.getProperty(Options.STORE_CACHE_TIMEOUT, "60000"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.STORE_CACHE_TIMEOUT + "=" + storeCacheTimeout));
        }
        if (storeCacheTimeout < 0L) {
            throw new RuntimeException(Options.STORE_CACHE_TIMEOUT + " must be non-negative");
        }
        this.storeCache = new ConcurrentWeakValueCacheWithTimeout(storeCacheCapacity, TimeUnit.MILLISECONDS.toNanos(storeCacheTimeout));
        this.journalIndex = JournalIndex.createTransient();
        this.segmentIndex = IndexSegmentIndex.createTransient();
        if (log.isInfoEnabled()) {
            log.info((Object)("Current working directory: " + new File(".").getAbsolutePath()));
        }
        boolean bl = this.isTransient = BufferMode.valueOf(properties.getProperty(Options.BUFFER_MODE, Options.DEFAULT_BUFFER_MODE.toString())) == BufferMode.Transient;
        if (this.isTransient) {
            this.dataDir = null;
            this.journalsDir = null;
            this.segmentsDir = null;
        } else {
            File dataDir;
            try {
                String val = properties.getProperty(Options.DATA_DIR);
                if (val == null) {
                    throw new RuntimeException("Required property: " + Options.DATA_DIR);
                }
                dataDir = new File(val).getCanonicalFile();
                if (log.isInfoEnabled()) {
                    log.info((Object)(Options.DATA_DIR + "=" + dataDir));
                }
                this.journalsDir = new File(dataDir, "journals").getCanonicalFile();
                this.segmentsDir = new File(dataDir, "segments").getCanonicalFile();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            if (!dataDir.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Creating: " + dataDir));
                }
                if (!dataDir.mkdirs()) {
                    throw new RuntimeException("Could not create directory: " + dataDir.getAbsolutePath());
                }
            }
            if (!this.journalsDir.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Creating: " + this.journalsDir));
                }
                if (!this.journalsDir.mkdirs()) {
                    throw new RuntimeException("Could not create directory: " + this.journalsDir.getAbsolutePath());
                }
            }
            if (!this.segmentsDir.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Creating: " + this.segmentsDir));
                }
                if (!this.segmentsDir.mkdirs()) {
                    throw new RuntimeException("Could not create directory: " + this.segmentsDir.getAbsolutePath());
                }
            }
            if (!dataDir.isDirectory()) {
                throw new RuntimeException("Not a directory: " + dataDir.getAbsolutePath());
            }
            if (!this.journalsDir.isDirectory()) {
                throw new RuntimeException("Not a directory: " + this.journalsDir.getAbsolutePath());
            }
            if (!this.segmentsDir.isDirectory()) {
                throw new RuntimeException("Not a directory: " + this.segmentsDir.getAbsolutePath());
            }
            this.dataDir = dataDir;
        }
        try {
            tmpDir = new File(properties.getProperty(Options.TMP_DIR, System.getProperty("java.io.tmpdir"))).getCanonicalFile();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.TMP_DIR + "=" + tmpDir));
        }
        if (!tmpDir.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Creating temp directory: " + tmpDir));
            }
            if (!tmpDir.mkdirs()) {
                throw new RuntimeException("Could not create directory: " + tmpDir.getAbsolutePath());
            }
        }
        if (!tmpDir.isDirectory()) {
            throw new RuntimeException("Not a directory: " + tmpDir.getAbsolutePath());
        }
        this.tmpDir = tmpDir;
        this.startupService.submit(new Startup());
    }

    public boolean isStarting() {
        return this.starting.get();
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public synchronized void shutdown() {
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        boolean wasOpen = this.open.get();
        this.open.set(false);
        this.startupService.shutdownNow();
        this.starting.set(false);
        if (!wasOpen) {
            return;
        }
        try {
            this.closeStores();
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        if (this.resourceService != null) {
            this.resourceService.shutdown();
            this.resourceService = null;
        }
    }

    @Override
    public synchronized void shutdownNow() {
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        boolean wasOpen = this.open.get();
        this.open.set(false);
        this.startupService.shutdownNow();
        this.starting.set(false);
        if (!wasOpen) {
            return;
        }
        try {
            this.closeStores();
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        if (this.resourceService != null) {
            this.resourceService.shutdownNow();
            this.resourceService = null;
        }
    }

    private void scanDataDirectory(File dir, Stats stats) throws InterruptedException {
        File[] files;
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        for (File file : files = dir.listFiles(this.newFileFilter())) {
            if (file.isDirectory()) {
                this.scanDataDirectory(file, stats);
                continue;
            }
            this.scanFile(file, stats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFile(File file, Stats stats) throws InterruptedException {
        IResourceMetadata resource;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Scanning file: " + file + ", stats=" + stats));
        }
        String name = file.getName();
        long len = file.length();
        if (len > 0L && name.endsWith(".jnl")) {
            ManagedJournal tmp;
            Properties properties = this.getProperties();
            properties.setProperty(Options.FILE, file.getAbsolutePath());
            properties.setProperty(Options.READ_ONLY, "true");
            try {
                tmp = new ManagedJournal(properties);
            }
            catch (Exception ex) {
                log.error((Object)("Problem opening journal: file=" + file.getAbsolutePath()), (Throwable)ex);
                ++stats.nfiles;
                stats.badFiles.add(file.getAbsolutePath());
                return;
            }
            try {
                resource = tmp.getResourceMetadata();
                ++stats.nfiles;
                ++stats.njournals;
                stats.nbytes += len;
            }
            finally {
                tmp.close();
            }
        }
        if (len > 0L && name.endsWith(".seg")) {
            IndexSegmentStore segStore;
            try {
                segStore = new IndexSegmentStore(file);
            }
            catch (Exception ex) {
                log.error((Object)("Problem opening segment: file=" + file.getAbsolutePath()), (Throwable)ex);
                ++stats.nfiles;
                stats.badFiles.add(file.getAbsolutePath());
                return;
            }
            try {
                resource = segStore.getResourceMetadata();
                ++stats.nfiles;
                ++stats.nsegments;
                stats.nbytes += len;
            }
            finally {
                if (segStore.isOpen()) {
                    segStore.close();
                }
            }
        }
        if (len == 0L && (name.endsWith(".jnl") || name.endsWith(".seg"))) {
            log.warn((Object)("Ignoring empty file: " + file));
        } else {
            log.warn((Object)("Ignoring file: " + file));
        }
        return;
        if (log.isInfoEnabled()) {
            log.info((Object)("Found " + resource + " in " + file));
        }
        this.addResource(resource, file);
    }

    @Override
    public File getTmpDir() {
        return this.tmpDir;
    }

    @Override
    public File getDataDir() {
        return this.dataDir;
    }

    private void closeStores() {
        Iterator itr = this.storeCache.iterator();
        while (itr.hasNext()) {
            IRawStore store = (IRawStore)itr.next().get();
            if (store == null) continue;
            try {
                store.close();
            }
            catch (Exception ex) {
                log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            itr.remove();
        }
    }

    public synchronized long getManagedJournalCount() {
        this.assertOpen();
        return this.journalIndex.getEntryCount();
    }

    public synchronized long getManagedSegmentCount() {
        this.assertOpen();
        return this.segmentIndex.getEntryCount();
    }

    protected synchronized void addResource(IResourceMetadata resourceMetadata, File file) {
        long extent;
        if (resourceMetadata == null) {
            throw new IllegalArgumentException();
        }
        if (file == null && !this.isTransient) {
            throw new IllegalArgumentException();
        }
        this.assertOpen();
        UUID uuid = resourceMetadata.getUUID();
        if (log.isInfoEnabled()) {
            log.info((Object)("file=" + file + ", uuid=" + uuid));
        }
        if (file != null) {
            file = file.getAbsoluteFile();
        }
        if (this.storeCache.get(uuid) != null) {
            throw new RuntimeException("Resource already open?: " + resourceMetadata);
        }
        if (!this.isTransient) {
            if (!file.exists()) {
                throw new RuntimeException("File not found: " + file);
            }
            File tmp = this.resourceFiles.get(uuid);
            if (tmp != null) {
                throw new RuntimeException("Resource already registered: uuid=" + uuid + " as file=" + tmp + " (given file=" + file + ")");
            }
            this.resourceFiles.put(uuid, file);
            extent = file.length();
        } else {
            extent = 0L;
        }
        if (resourceMetadata.isJournal()) {
            this.journalIndex.add((JournalMetadata)resourceMetadata);
            this.journalBytesUnderManagement.addAndGet(extent);
        } else {
            this.segmentIndex.add((SegmentMetadata)resourceMetadata);
            this.segmentBytesUnderManagement.addAndGet(extent);
        }
        this.bytesUnderManagement.addAndGet(extent);
    }

    protected ResourceFileFilter newFileFilter() {
        return new ResourceFileFilter(this);
    }

    public abstract IConcurrencyManager getConcurrencyManager();

    public abstract void setConcurrencyManager(IConcurrencyManager var1);

    @Override
    public ManagedJournal getLiveJournal() {
        this.assertRunning();
        ManagedJournal tmp = this.liveJournalRef.get();
        assert (tmp != null) : "open=" + this.isOpen() + ", starting=" + this.isStarting() + ", dataDir=" + this.dataDir;
        assert (tmp.isOpen());
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractJournal getJournal(long timestamp) {
        JournalMetadata resource;
        this.assertRunning();
        if (timestamp == 0L || timestamp == -1L) {
            return this.getLiveJournal();
        }
        JournalIndex journalIndex = this.journalIndex;
        synchronized (journalIndex) {
            resource = this.journalIndex.find(Math.abs(timestamp));
        }
        if (resource == null) {
            log.warn((Object)("No such journal: timestamp=" + timestamp));
            return null;
        }
        return (AbstractJournal)this.openStore(resource.getUUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRawStore openStore(UUID uuid) {
        this.assertRunning();
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        Lock lock = this.namedLock.acquireLock(uuid);
        try {
            IRawStore store = (IRawStore)this.storeCache.get(uuid);
            if (store != null) {
                if (!store.isOpen()) {
                    if (store instanceof IndexSegmentStore) {
                        ((IndexSegmentStore)store).reopen();
                        this.segmentStoreReopenCount.incrementAndGet();
                        IRawStore iRawStore = store;
                        return iRawStore;
                    }
                    throw new AssertionError();
                }
                IRawStore iRawStore = store;
                return iRawStore;
            }
            if (store == null) {
                UUID actualUUID;
                File file = this.resourceFiles.get(uuid);
                if (file == null) {
                    throw new NoSuchStoreException(uuid);
                }
                if (!file.exists()) {
                    throw new NoSuchStoreException("Resource file missing? uuid=" + uuid + ", file=" + file);
                }
                if (file.getName().endsWith(".jnl")) {
                    Properties properties = this.getProperties();
                    properties.setProperty(Options.FILE, file.toString());
                    properties.setProperty(Options.READ_ONLY, "true");
                    ManagedJournal journal = new ManagedJournal(properties);
                    long closeTime = journal.getRootBlockView().getCloseTime();
                    assert (closeTime != 0L) : "Journal not closed for writes?  : file=" + file + ", uuid=" + uuid + ", closeTime=" + closeTime;
                    assert (journal.isReadOnly());
                    actualUUID = journal.getRootBlockView().getUUID();
                    store = journal;
                    this.journalReopenCount.incrementAndGet();
                } else {
                    IndexSegmentStore segStore = new IndexSegmentStore(file);
                    actualUUID = segStore.getCheckpoint().segmentUUID;
                    store = segStore;
                    this.segmentStoreReopenCount.incrementAndGet();
                }
                if (!actualUUID.equals(uuid)) {
                    store.close();
                    throw new RuntimeException("Wrong UUID: file=" + file + ", expecting=" + uuid + ", actual=" + actualUUID);
                }
                assert (store != null);
                assert (store.isOpen());
                assert (store.isStable());
            }
            this.storeCache.put(uuid, store);
            IRawStore iRawStore = store;
            return iRawStore;
        }
        finally {
            lock.unlock();
        }
    }

    protected long nextTimestamp() {
        ILocalTransactionManager transactionManager = this.getConcurrencyManager().getTransactionManager();
        return transactionManager.nextTimestamp();
    }

    @Override
    public void deleteResources() {
        this.assertNotOpen();
        if (this.isTransient()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Deleting all resources: " + this.dataDir));
        }
        this.recursiveDelete(this.dataDir);
        this.bytesDeleted.addAndGet(this.bytesUnderManagement.get());
        this.bytesUnderManagement.set(0L);
        this.journalBytesUnderManagement.set(0L);
        this.segmentBytesUnderManagement.set(0L);
    }

    private void recursiveDelete(File f) {
        if (f.isDirectory()) {
            File[] children = f.listFiles(this.newFileFilter());
            if (children == null) {
                return;
            }
            for (int i = 0; i < children.length; ++i) {
                this.recursiveDelete(children[i]);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing: " + f));
        }
        if (f.exists() && !f.delete()) {
            log.warn((Object)("Could not remove: " + f));
        }
    }

    public void setReleaseTime(long releaseTime) {
        this.assertOpen();
        if (releaseTime < 0L) {
            throw new IllegalArgumentException();
        }
        this.releaseTime = releaseTime;
    }

    public long getReleaseTime() {
        return this.releaseTime;
    }

    protected abstract long getIndexRetentionTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final PurgeResult purgeOldResources() {
        IBigdataFederation<?> fed;
        long beginPurgeTime = System.currentTimeMillis();
        long lastCommitTime = this.getLiveJournal().getRootBlockView().getLastCommitTime();
        if (lastCommitTime == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Nothing committed yet.");
            }
            return null;
        }
        try {
            fed = this.getFederation();
        }
        catch (UnsupportedOperationException ex) {
            log.warn((Object)"Federation not available: Running in test harness?");
            return null;
        }
        try {
            ITransactionService txService = fed.getTransactionService();
            if (txService != null) {
                this.releaseTime = txService.getReleaseTime();
            } else {
                log.warn((Object)"Could not discover txService - Proceeding with current release time.");
            }
        }
        catch (IOException ex) {
            log.warn((Object)("Proceeding with current release time: " + ex));
        }
        if (this.releaseTime == 0L) {
            log.warn((Object)"releaseTime not set.");
            return null;
        }
        Event e = new Event(this.getFederation(), new EventResource(), (Object)EventType.PurgeResources).start();
        this.indexCacheLock.writeLock().lock();
        try {
            long commitTimeToPreserve;
            JournalMetadata resource;
            AbstractJournal j0;
            long firstCommitTime;
            long indexRetentionTime = this.getIndexRetentionTime();
            long choosenReleaseTime = indexRetentionTime == -1L ? this.releaseTime : Math.min(indexRetentionTime, this.releaseTime);
            long releaseAge = lastCommitTime - choosenReleaseTime;
            if (log.isInfoEnabled()) {
                log.info((Object)("Choosen releaseTime=" + choosenReleaseTime + ": given releaseTime=" + this.releaseTime + ", indexRetentionTime=" + indexRetentionTime + " (this is " + TimeUnit.MILLISECONDS.toSeconds(releaseAge) + " seconds before/after the lastCommitTime=" + lastCommitTime + ")"));
            }
            if (choosenReleaseTime < (firstCommitTime = (j0 = (AbstractJournal)this.openStore((resource = this.journalIndex.findNext(0L)).getUUID())).getRootBlockView().getFirstCommitTime())) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Release time is earlier than any commit time.");
                }
                PurgeResult purgeResult = null;
                return purgeResult;
            }
            if (choosenReleaseTime >= lastCommitTime) {
                commitTimeToPreserve = lastCommitTime;
                if (log.isInfoEnabled()) {
                    log.info((Object)("commitTimeToPreserve := " + commitTimeToPreserve + " (this is the lastCommitTime)"));
                }
            } else {
                commitTimeToPreserve = this.getCommitTimeStrictlyGreaterThan(choosenReleaseTime);
                if (log.isInfoEnabled()) {
                    log.info((Object)("commitTimeToPreserve := " + commitTimeToPreserve + " (this is the first commitTime GT the releaseTime=" + choosenReleaseTime + ")"));
                }
            }
            this.lastCommitTimePreserved = commitTimeToPreserve;
            long begin = System.currentTimeMillis();
            Set<UUID> resourcesInUse = this.getResourcesForTimestamp(commitTimeToPreserve);
            Set<UUID> set = this.retentionSet;
            synchronized (set) {
                resourcesInUse.addAll(this.retentionSet);
            }
            long elapsedScanCommitIndicesTime = System.currentTimeMillis() - begin;
            if (log.isInfoEnabled()) {
                for (UUID uuid : resourcesInUse) {
                    log.info((Object)("In use: file=" + this.resourceFiles.get(uuid) + ", uuid=" + uuid));
                }
            }
            long journalBeforeCount = this.getManagedJournalCount();
            long segmentBeforeCount = this.getManagedSegmentCount();
            long bytesBeforeCount = this.getBytesUnderManagement();
            long begin2 = System.currentTimeMillis();
            this.deleteUnusedResources(commitTimeToPreserve, resourcesInUse);
            long elapsedDeleteResourcesTime = System.currentTimeMillis() - begin2;
            long journalAfterCount = this.getManagedJournalCount();
            long segmentAfterCount = this.getManagedSegmentCount();
            long bytesAfterCount = this.getBytesUnderManagement();
            long elapsedPurgeResourcesTime = System.currentTimeMillis() - beginPurgeTime;
            this.purgeResourcesMillis += elapsedPurgeResourcesTime;
            PurgeResult result = new PurgeResult(firstCommitTime, lastCommitTime, this.releaseTime, indexRetentionTime, choosenReleaseTime, commitTimeToPreserve, resourcesInUse.size(), journalBeforeCount, journalAfterCount, segmentBeforeCount, segmentAfterCount, bytesBeforeCount, bytesAfterCount, elapsedScanCommitIndicesTime, elapsedDeleteResourcesTime, elapsedPurgeResourcesTime);
            e.addDetails(result.getParams());
            PurgeResult purgeResult = result;
            return purgeResult;
        }
        finally {
            this.indexCacheLock.writeLock().unlock();
            e.end();
        }
    }

    private void deleteUnusedResources(long commitTimeToPreserve, Set<UUID> resourcesInUse) {
        int njournals = 0;
        ITupleIterator itr = this.journalIndex.rangeIterator(null, null, 0, 35, null);
        while (itr.hasNext()) {
            ITuple tuple = itr.next();
            IResourceMetadata resourceMetadata = (IResourceMetadata)SerializerUtil.deserialize(tuple.getValue());
            long createTime = resourceMetadata.getCreateTime();
            if (createTime >= commitTimeToPreserve) {
                if (!log.isInfoEnabled()) break;
                log.info((Object)("Stopping at resource GTE commitTime to preserve: createTime=" + createTime + ", file=" + resourceMetadata.getFile()));
                break;
            }
            UUID uuid = resourceMetadata.getUUID();
            if (resourcesInUse.contains(uuid)) continue;
            try {
                this.deleteUnusedResource(resourceMetadata);
            }
            catch (Throwable t) {
                log.error((Object)("Could not delete journal: " + resourceMetadata.getFile()), t);
            }
            itr.remove();
            ++njournals;
        }
        int nsegments = 0;
        ITupleIterator itr2 = this.segmentIndex.rangeIterator(null, null, 0, 35, null);
        while (itr2.hasNext()) {
            ITuple tuple = itr2.next();
            IResourceMetadata resourceMetadata = (IResourceMetadata)SerializerUtil.deserialize(tuple.getValue());
            long createTime = resourceMetadata.getCreateTime();
            if (createTime >= commitTimeToPreserve) {
                if (!log.isInfoEnabled()) break;
                log.info((Object)("Stopping at resource GTE commitTime to preserve: createTime=" + createTime + ", file=" + resourceMetadata.getFile()));
                break;
            }
            UUID uuid = resourceMetadata.getUUID();
            if (resourcesInUse.contains(uuid)) continue;
            try {
                this.deleteUnusedResource(resourceMetadata);
            }
            catch (Throwable t) {
                log.error((Object)("Could not delete segment - continuing: " + resourceMetadata.getFile()), t);
            }
            itr2.remove();
            ++nsegments;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Given " + resourcesInUse.size() + " resources that are in use as of timestamp=" + commitTimeToPreserve + ", deleted " + njournals + " journals and " + nsegments + " segments"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteResource(UUID uuid, boolean isJournal) throws NoSuchStoreException {
        if (log.isInfoEnabled()) {
            log.info((Object)("deleteResource: uuid=" + uuid + ", isJournal=" + isJournal));
        }
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        if (uuid == this.liveJournalRef.get().getRootBlockView().getUUID()) {
            throw new IllegalArgumentException();
        }
        Set<UUID> set = this.retentionSet;
        synchronized (set) {
            if (this.retentionSet.contains(uuid)) {
                throw new IllegalStateException("Resource in retentionSet: " + uuid);
            }
        }
        IRawStore store = (IRawStore)this.storeCache.remove(uuid);
        if (store != null) {
            File file = store.getFile();
            if (isJournal ? !$assertionsDisabled && !(store instanceof AbstractJournal) : !$assertionsDisabled && !(store instanceof IndexSegmentStore)) {
                throw new AssertionError();
            }
            try {
                if (store.isOpen()) {
                    store.close();
                }
            }
            catch (IllegalStateException t) {
                if (isJournal) {
                    log.error((Object)file, (Throwable)t);
                }
                log.warn((Object)file, (Throwable)t);
            }
        }
        File file = this.resourceFiles.remove(uuid);
        if (log.isInfoEnabled()) {
            log.info((Object)("DELETE: file=" + file + ", uuid=" + uuid + ", isJournal=" + isJournal));
        }
        if (file == null) {
            throw new NoSuchStoreException(uuid);
        }
        if (!file.exists()) {
            throw new RuntimeException("Not found: " + file);
        }
        long length = file.length();
        if (!file.delete()) {
            throw new RuntimeException("Could not delete: " + file);
        }
        this.bytesDeleted.addAndGet(length);
        this.bytesUnderManagement.addAndGet(-length);
        if (isJournal) {
            this.journalBytesUnderManagement.addAndGet(-length);
            this.journalDeleteCount.incrementAndGet();
        } else {
            this.segmentBytesUnderManagement.addAndGet(-length);
            this.segmentStoreDeleteCount.incrementAndGet();
        }
        boolean found = false;
        if (isJournal) {
            JournalIndex journalIndex = this.journalIndex;
            synchronized (journalIndex) {
                ITupleIterator itr = this.journalIndex.rangeIterator(null, null, 0, 35, null);
                while (itr.hasNext()) {
                    IResourceMetadata md = (IResourceMetadata)itr.next().getObject();
                    if (!md.getUUID().equals(uuid)) continue;
                    itr.remove();
                    found = true;
                    break;
                }
            }
        }
        IndexSegmentIndex indexSegmentIndex = this.segmentIndex;
        synchronized (indexSegmentIndex) {
            ITupleIterator itr = this.segmentIndex.rangeIterator(null, null, 0, 35, null);
            while (itr.hasNext()) {
                IResourceMetadata md = (IResourceMetadata)itr.next().getObject();
                if (!md.getUUID().equals(uuid)) continue;
                itr.remove();
                found = true;
                break;
            }
        }
        if (!found) {
            throw new NoSuchStoreException(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUnusedResource(IResourceMetadata resourceMetadata) {
        if (log.isInfoEnabled()) {
            log.info((Object)("deleteResource: " + resourceMetadata));
        }
        if (resourceMetadata == null) {
            throw new IllegalArgumentException();
        }
        UUID uuid = resourceMetadata.getUUID();
        if (uuid == this.liveJournalRef.get().getRootBlockView().getUUID()) {
            throw new IllegalArgumentException();
        }
        Set<UUID> set = this.retentionSet;
        synchronized (set) {
            if (this.retentionSet.contains(uuid)) {
                throw new IllegalStateException("Resource in retentionSet: " + uuid);
            }
        }
        IRawStore store = (IRawStore)this.storeCache.remove(uuid);
        if (store != null) {
            File file = store.getFile();
            if (resourceMetadata.isJournal() ? !$assertionsDisabled && !(store instanceof AbstractJournal) : !$assertionsDisabled && !(store instanceof IndexSegmentStore)) {
                throw new AssertionError();
            }
            try {
                if (store.isOpen()) {
                    store.close();
                }
            }
            catch (IllegalStateException t) {
                if (resourceMetadata.isJournal()) {
                    log.error((Object)file, (Throwable)t);
                }
                log.warn((Object)file, (Throwable)t);
            }
        }
        if (LRUNexus.INSTANCE != null) {
            LRUNexus.INSTANCE.deleteCache(uuid);
        }
        File file = this.resourceFiles.remove(uuid);
        log.warn((Object)("DELETE: " + resourceMetadata + " : " + file));
        if (file == null) {
            throw new NoSuchStoreException(uuid);
        }
        if (!file.exists()) {
            throw new RuntimeException("Not found: " + file);
        }
        long length = file.length();
        if (!file.delete()) {
            throw new RuntimeException("Could not delete: " + file);
        }
        this.bytesDeleted.addAndGet(length);
        this.bytesUnderManagement.addAndGet(-length);
        if (resourceMetadata.isJournal()) {
            this.journalBytesUnderManagement.addAndGet(-length);
            this.journalDeleteCount.incrementAndGet();
        } else {
            this.segmentBytesUnderManagement.addAndGet(-length);
            this.segmentStoreDeleteCount.incrementAndGet();
        }
    }

    protected long getCommitTimeStrictlyGreaterThan(long releaseTime) {
        ManagedJournal journal = (ManagedJournal)this.getJournal(releaseTime);
        if (journal == null) {
            throw new IllegalArgumentException("No data for releaseTime=" + releaseTime);
        }
        IRootBlockView rootBlockView = journal.getRootBlockView();
        ICommitRecord commitRecord = journal.getCommitRecordStrictlyGreaterThan(releaseTime);
        if (commitRecord == null) {
            long closeTime = rootBlockView.getCloseTime();
            if (closeTime == 0L) {
                throw new IllegalArgumentException("No data for releaseTime=" + releaseTime);
            }
            log.warn((Object)("Examining prior journal (fence post): closeTime=" + closeTime + ", releaseTime=" + releaseTime));
            return this.getCommitTimeStrictlyGreaterThan(closeTime);
        }
        long commitTime = commitRecord.getTimestamp();
        log.warn((Object)("Chose commitTime=" + commitTime + " given releaseTime=" + releaseTime));
        assert (commitTime > releaseTime);
        return commitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<UUID> getResourcesForTimestamp(long commitTimeToPreserve) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("commitTimeToPreserve=" + commitTimeToPreserve + ", lastCommitTime=" + this.getLiveJournal().getRootBlockView().getLastCommitTime()));
        }
        if (commitTimeToPreserve <= 0L) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<UUID> uuids = new LinkedHashSet<UUID>(512);
        uuids.add(this.getLiveJournal().getRootBlockView().getUUID());
        JournalIndex journalIndex = this.journalIndex;
        synchronized (journalIndex) {
            ITupleIterator itr = this.journalIndex.rangeIterator();
            while (itr.hasNext()) {
                ITuple tuple = itr.next();
                JournalMetadata journalMetadata = (JournalMetadata)tuple.getObject();
                UUID uuid = journalMetadata.getUUID();
                ManagedJournal journal = (ManagedJournal)this.openStore(uuid);
                long lastCommitTime = journal.getRootBlockView().getLastCommitTime();
                if (lastCommitTime < commitTimeToPreserve) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Examining journal: file=" + journal.getFile() + ", lastCommitTime=" + lastCommitTime + ", uuid=" + journal.getRootBlockView().getUUID()));
                }
                CommitRecordIndex commitRecordIndex = journal.getCommitRecordIndex(journal.getRootBlockView().getCommitRecordIndexAddr(), true);
                HashSet<Long> addrs = new HashSet<Long>(512);
                ITupleIterator itr2 = commitRecordIndex.rangeIterator(commitTimeToPreserve, null);
                while (itr2.hasNext()) {
                    ITuple tuple2 = itr2.next();
                    CommitRecordIndex.Entry entry2 = (CommitRecordIndex.Entry)tuple2.getObject();
                    ICommitRecord commitRecord = commitRecordIndex.fetchCommitRecord(entry2);
                    Name2Addr name2addr = (Name2Addr)Name2Addr.load(journal, commitRecord.getRootAddr(0), true);
                    ITupleIterator itr3 = name2addr.rangeIterator();
                    while (itr3.hasNext()) {
                        Checkpoint checkpoint;
                        IndexMetadata indexMetadata;
                        LocalPartitionMetadata pmd;
                        ITuple tuple3 = itr3.next();
                        Name2Addr.Entry entry3 = (Name2Addr.Entry)tuple3.getObject();
                        long checkpointAddr = entry3.checkpointAddr;
                        if (!addrs.add(checkpointAddr)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("index: name=" + entry3.name));
                        }
                        if ((pmd = (indexMetadata = IndexMetadata.read(journal, (checkpoint = Checkpoint.load(journal, entry3.checkpointAddr)).getMetadataAddr())).getPartitionMetadata()) == null) continue;
                        for (IResourceMetadata t : pmd.getResources()) {
                            if (!uuids.add(t.getUUID()) || !log.isInfoEnabled()) continue;
                            log.info((Object)("Dependency: file=" + t.getFile() + ", uuid=" + t.getUUID() + ", view=" + pmd));
                        }
                    }
                }
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("commitTime=" + commitTimeToPreserve + ", #used=" + uuids.size()));
        }
        return uuids;
    }

    public static String munge(String s) {
        return s.replaceAll("[\\W]", "_");
    }

    @Override
    public File getIndexSegmentFile(IndexMetadata indexMetadata) {
        if (indexMetadata == null) {
            throw new IllegalArgumentException();
        }
        LocalPartitionMetadata pmd = indexMetadata.getPartitionMetadata();
        return this.getIndexSegmentFile(indexMetadata.getName(), indexMetadata.getIndexUUID(), pmd == null ? -1 : pmd.getPartitionId());
    }

    public File getIndexSegmentFile(String scaleOutIndexName, UUID indexUUID, int partitionId) {
        File file;
        this.assertOpen();
        if (scaleOutIndexName == null) {
            throw new IllegalArgumentException();
        }
        if (indexUUID == null) {
            throw new IllegalArgumentException();
        }
        if (partitionId < -1) {
            throw new IllegalArgumentException();
        }
        String mungedName = StoreManager.munge(scaleOutIndexName);
        File indexDir = new File(this.segmentsDir, mungedName + File.separator + indexUUID.toString());
        indexDir.mkdirs();
        String partitionStr = partitionId == -1 ? "" : "_shardId" + leadingZeros.format(partitionId);
        String prefix = mungedName + "" + partitionStr + "_";
        try {
            file = File.createTempFile(prefix, ".seg", indexDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Created file: " + file));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean purgeOldResources(long timeout, boolean truncateJournal) throws InterruptedException {
        WriteExecutorService writeService = this.getConcurrencyManager().getWriteService();
        if (writeService.tryLock(timeout, TimeUnit.MILLISECONDS)) {
            this.assertRunning();
            try {
                Event event = new Event(this.getFederation(), new EventResource(), (Object)EventType.PurgeResources).start();
                try {
                    PurgeResult purgeResult = this.purgeOldResources();
                    if (purgeResult != null) {
                        log.warn((Object)purgeResult.toString());
                        event.addDetails(purgeResult.getParams());
                    }
                    if (truncateJournal) {
                        this.assertRunning();
                        this.getLiveJournal().truncate();
                    }
                }
                finally {
                    event.end();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                writeService.unlock();
            }
        }
        log.warn((Object)("Purge resources did not run: timeout=" + timeout));
        return false;
    }

    protected void overrideJournalExtent(Properties p) {
        long bytesUnderManagement = this.bytesUnderManagement.get();
        if (this.accelerateOverflowThreshold == 0L || bytesUnderManagement >= this.accelerateOverflowThreshold) {
            return;
        }
        double d = (double)bytesUnderManagement / (double)this.accelerateOverflowThreshold;
        long initialExtent = Long.parseLong(p.getProperty(Options.INITIAL_EXTENT, "10485760"));
        long maximumExtent = Long.parseLong(p.getProperty(Options.INITIAL_EXTENT, "209715200"));
        long minimumExtent = Math.max(0x100000L, 0xA00000L);
        long adjustedExtent = Math.max(minimumExtent, (long)((double)maximumExtent * d));
        p.setProperty(Options.INITIAL_EXTENT, Long.toString(adjustedExtent));
        p.setProperty(Options.MAXIMUM_EXTENT, Long.toString(adjustedExtent));
        if (log.isInfoEnabled()) {
            log.info((Object)("discount=" + d + ", bytesUnderManagement=" + bytesUnderManagement + ", threshold=" + this.accelerateOverflowThreshold + ", minimimInitialExtent=" + minimumExtent + ", initialExtent=" + initialExtent + ", maximumExtent=" + maximumExtent + ", adjustedExtent=" + adjustedExtent));
        }
    }

    public class ManagedJournal
    extends AbstractJournal {
        protected ManagedJournal(Properties properties) {
            super(properties);
            if (this.getBufferStrategy() instanceof DiskOnlyStrategy) {
                ((DiskOnlyStrategy)this.getBufferStrategy()).setStoreCounters(StoreManager.this.getStoreCounters());
            } else if (this.getBufferStrategy() instanceof WORMStrategy) {
                ((WORMStrategy)this.getBufferStrategy()).setStoreCounters(StoreManager.this.getStoreCounters());
            }
        }

        public String toString() {
            IRootBlockView rootBlock = this.getRootBlockView();
            return this.getClass().getName() + "{file=" + this.getFile() + ", open=" + this.isOpen() + (rootBlock != null ? ", uuid=" + this.getRootBlockView().getUUID() : "") + "}";
        }

        @Override
        public long commitNow(long commitTime) {
            return super.commitNow(commitTime);
        }

        @Override
        public CommitRecordIndex getCommitRecordIndex(long addr, boolean readOnly) {
            return super.getCommitRecordIndex(addr, readOnly);
        }

        @Override
        public AbstractLocalTransactionManager getLocalTransactionManager() {
            return (AbstractLocalTransactionManager)StoreManager.this.getConcurrencyManager().getTransactionManager();
        }

        @Override
        public boolean isGroupCommit() {
            return true;
        }

        @Override
        public SparseRowStore getGlobalRowStore() {
            return StoreManager.this.getFederation().getGlobalRowStore();
        }

        @Override
        public SparseRowStore getGlobalRowStore(long timestamp) {
            return StoreManager.this.getFederation().getGlobalRowStore(timestamp);
        }

        @Override
        public BigdataFileSystem getGlobalFileSystem() {
            return StoreManager.this.getFederation().getGlobalFileSystem();
        }

        @Override
        public DefaultResourceLocator getResourceLocator() {
            return (DefaultResourceLocator)StoreManager.this.getFederation().getResourceLocator();
        }

        @Override
        public ExecutorService getExecutorService() {
            return StoreManager.this.getFederation().getExecutorService();
        }

        @Override
        public IResourceLockService getResourceLockService() {
            return StoreManager.this.getFederation().getResourceLockService();
        }

        @Override
        public TemporaryStore getTempStore() {
            return StoreManager.this.getFederation().getTempStore();
        }

        @Override
        protected void validateIndexMetadata(String name, IndexMetadata metadata) {
            super.validateIndexMetadata(name, metadata);
            LocalPartitionMetadata pmd = metadata.getPartitionMetadata();
            if (pmd == null) {
                return;
            }
            if (pmd.getResources() == null) {
                ResourceManager resourceManager = (ResourceManager)StoreManager.this;
                metadata.setPartitionMetadata(new LocalPartitionMetadata(pmd.getPartitionId(), pmd.getSourcePartitionId(), pmd.getLeftSeparatorKey(), pmd.getRightSeparatorKey(), new IResourceMetadata[]{this.getResourceMetadata()}, IndexPartitionCause.register(resourceManager)));
            } else {
                if (pmd.getResources().length == 0) {
                    throw new RuntimeException("Missing resource description: name=" + name + ", pmd=" + pmd);
                }
                if (!pmd.getResources()[0].isJournal()) {
                    throw new RuntimeException("Expecting resources[0] to be journal: name=" + name + ", pmd=" + pmd);
                }
                if (!pmd.getResources()[0].getUUID().equals(this.getRootBlockView().getUUID())) {
                    throw new RuntimeException("Expecting resources[0] to be this journal but has wrong UUID: name=" + name + ", pmd=" + pmd);
                }
            }
        }

        @Override
        public ScheduledFuture<?> addScheduledTask(Runnable task, long initialDelay, long delay, TimeUnit unit) {
            return StoreManager.this.getFederation().addScheduledTask(task, initialDelay, delay, unit);
        }

        @Override
        public boolean getCollectPlatformStatistics() {
            return StoreManager.this.getFederation().getCollectPlatformStatistics();
        }

        @Override
        public boolean getCollectQueueStatistics() {
            return StoreManager.this.getFederation().getCollectQueueStatistics();
        }

        @Override
        public int getHttpdPort() {
            return StoreManager.this.getFederation().getHttpdPort();
        }
    }

    private static class Stats {
        public int nfiles;
        public int njournals;
        public int nsegments;
        public Collection<String> badFiles = Collections.synchronizedCollection(new TreeSet());
        public long nbytes;

        private Stats() {
        }

        public String toString() {
            return "Stats{nfiles=" + this.nfiles + ", njournals=" + this.njournals + ", nsegments=" + this.nsegments + ", nbad=" + this.badFiles.size() + ", nbytes=" + this.nbytes + ", badFiles=" + this.badFiles + "}";
        }
    }

    private class Startup
    implements Runnable {
        private Startup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    this.start();
                    StoreManager.this.starting.set(false);
                    if (StoreManager.this.purgeOldResourcesDuringStartup) {
                        StoreManager.this.purgeOldResources();
                    }
                }
                catch (Throwable ex) {
                    StoreManager.this.open.set(false);
                    log.error((Object)("Problem during startup? : " + ex), ex);
                    StoreManager.this.shutdownNow();
                    throw new RuntimeException(ex);
                }
                StoreManager.this.starting.set(false);
            }
            catch (Throwable throwable) {
                StoreManager.this.starting.set(false);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Startup " + (StoreManager.this.isOpen() ? "successful" : "failed") + " : " + (StoreManager.this.isTransient ? "transient" : Options.DATA_DIR + "=" + StoreManager.this.dataDir)));
                }
                throw throwable;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Startup " + (StoreManager.this.isOpen() ? "successful" : "failed") + " : " + (StoreManager.this.isTransient ? "transient" : Options.DATA_DIR + "=" + StoreManager.this.dataDir)));
            }
        }

        private final void start() throws InterruptedException {
            if (!StoreManager.this.isStarting()) {
                throw new IllegalStateException();
            }
            int nwaits = 0;
            while (true) {
                try {
                    StoreManager.this.getConcurrencyManager();
                }
                catch (IllegalStateException ex) {
                    Thread.sleep(100L);
                    if (++nwaits % 50 != 0) continue;
                    log.warn((Object)"Waiting for concurrency manager");
                    continue;
                }
                break;
            }
            try {
                IBigdataFederation<?> fed = StoreManager.this.getFederation();
                if (fed == null) {
                    throw new UnsupportedOperationException();
                }
                while (fed.getTransactionService() == null) {
                    log.warn((Object)"Waiting for transaction service discovery");
                }
            }
            catch (UnsupportedOperationException ex) {
                log.warn((Object)"Federation not available - running in test case?");
            }
            if (!StoreManager.this.isTransient) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Starting scan of data directory: " + StoreManager.this.dataDir));
                }
                Stats stats = new Stats();
                StoreManager.this.scanDataDirectory(StoreManager.this.dataDir, stats);
                int nbad = stats.badFiles.size();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Scan results: " + stats));
                }
                if (!stats.badFiles.isEmpty()) {
                    if (StoreManager.this.ignoreBadFiles) {
                        log.warn((Object)("The following " + nbad + " file(s) had problems and are being ignored: " + stats.badFiles));
                    } else {
                        String msg = "Could not open " + nbad + " files - will not start : problem files=" + stats.badFiles;
                        log.fatal((Object)msg);
                        throw new RuntimeException(msg);
                    }
                }
                assert (StoreManager.this.journalIndex.getEntryCount() == (long)stats.njournals);
                assert (StoreManager.this.segmentIndex.getEntryCount() == (long)stats.nsegments);
                assert (StoreManager.this.resourceFiles.size() + nbad == stats.nfiles) : "#resourceFiles=" + StoreManager.access$1100(StoreManager.this).size() + ", #nbad=" + nbad + ", nfiles=" + stats.nfiles;
            }
            this.openLiveJournal();
            long lastCommitTime = StoreManager.this.liveJournalRef.get().getLastCommitTime();
            if (lastCommitTime != 0L) {
                StoreManager.this.getConcurrencyManager().getTransactionManager().notifyCommit(lastCommitTime);
            }
            try {
                StoreManager.this.resourceService = new ManagedResourceService(new InetSocketAddress(InetAddress.getByName(NicUtil.getIpAddress("default.nic", "default", false)), 0), 0){

                    @Override
                    protected File getResource(UUID uuid) throws Exception {
                        if (!StoreManager.this.isRunning()) {
                            throw new Exception("Not running.");
                        }
                        return (File)StoreManager.this.resourceFiles.get(uuid);
                    }
                };
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not start: " + StoreManager.this.resourceService, ex);
            }
        }

        private void openLiveJournal() throws InterruptedException {
            boolean newJournal;
            File file;
            if (log.isInfoEnabled()) {
                log.info((Object)("Creating/opening the live journal: dataDir=" + StoreManager.this.dataDir));
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Properties p = StoreManager.this.getProperties();
            if (StoreManager.this.journalIndex.getEntryCount() == 0L) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Creating initial journal: dataDir=" + StoreManager.this.dataDir));
                }
                if (StoreManager.this.isTransient) {
                    file = null;
                } else {
                    try {
                        file = File.createTempFile("journal", ".jnl", StoreManager.this.journalsDir).getCanonicalFile();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                p.setProperty(Options.CREATE_TIME, Long.toString(StoreManager.this.nextTimestamp()));
                StoreManager.this.overrideJournalExtent(p);
                newJournal = true;
            } else {
                JournalMetadata resource = StoreManager.this.journalIndex.find(Long.MAX_VALUE);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will open as live journal: " + resource));
                }
                assert (resource != null) : "No resource? : timestamp=9223372036854775807";
                file = (File)StoreManager.this.resourceFiles.get(resource.getUUID());
                if (file == null) {
                    throw new NoSuchStoreException(resource.getUUID());
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Opening most recent journal: " + file + ", resource=" + resource));
                }
                newJournal = false;
            }
            if (!StoreManager.this.isTransient) {
                assert (file.isAbsolute()) : "Path must be absolute: " + file;
                p.setProperty(Options.FILE, file.toString());
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Open/create of live journal: newJournal=" + newJournal + ", file=" + file));
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ManagedJournal tmp = new ManagedJournal(p);
            if (newJournal) {
                StoreManager.this.addResource(tmp.getResourceMetadata(), tmp.getFile());
            }
            StoreManager.this.storeCache.put(tmp.getRootBlockView().getUUID(), tmp);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            StoreManager.this.liveJournalRef.set(tmp);
            long extent = -tmp.getBufferStrategy().getExtent();
            StoreManager.this.bytesUnderManagement.addAndGet(extent);
            StoreManager.this.journalBytesUnderManagement.addAndGet(extent);
        }
    }

    public static interface IStoreManagerCounters {
        public static final String DataDir = "DataDir";
        public static final String TmpDir = "TmpDir";
        public static final String IsOpen = "isOpen";
        public static final String IsStarting = "isStarting";
        public static final String IsRunning = "isRunning";
        public static final String StoreCacheCapacity = "Store Cache Capacity";
        public static final String StoreCacheSize = "Store Cache Size";
        public static final String ManagedJournalCount = "Managed Journal Count";
        public static final String ManagedSegmentStoreCount = "Managed Segment Store Count";
        public static final String JournalReopenCount = "Journal (Re-)open Count";
        public static final String SegmentStoreReopenCount = "Segment Store (Re-)open Count";
        public static final String JournalDeleteCount = "Journal Delete Count";
        public static final String SegmentStoreDeleteCount = "Segment Store Delete Count";
        public static final String BytesUnderManagement = "Bytes Under Management";
        public static final String JournalBytesUnderManagement = "Journal Bytes Under Management";
        public static final String SegmentBytesUnderManagement = "Segment Bytes Under Management";
        public static final String BytesDeleted = "Bytes Deleted";
        public static final String DataDirBytesAvailable = "Data Volume Bytes Available";
        public static final String TmpDirBytesAvailable = "Temp Volume Bytes Available";
        public static final String MaximumJournalSizeAtOverflow = "Maximum Journal Size At Overflow";
        public static final String PurgeResourcesMillis = "Purge Resources Millis";
        public static final String ReleaseTime = "Release Time";
        public static final String LastOverflowTime = "Last Overflow Time";
        public static final String LastCommitTimePreserved = "Last Commit Time Preserved";
        public static final String LastCommitTime = "Last Commit Time";
    }

    public static interface Options
    extends com.bigdata.journal.Options {
        public static final String DATA_DIR = StoreManager.class.getName() + ".dataDir";
        public static final String STORE_CACHE_CAPACITY = StoreManager.class.getName() + ".storeCacheCapacity";
        public static final String DEFAULT_STORE_CACHE_CAPACITY = "20";
        public static final String STORE_CACHE_TIMEOUT = StoreManager.class.getName() + ".storeCacheTimeout";
        public static final String DEFAULT_STORE_CACHE_TIMEOUT = "60000";
        public static final String IGNORE_BAD_FILES = StoreManager.class.getName() + ".ignoreBadFiles";
        public static final String DEFAULT_IGNORE_BAD_FILES = "false";
        public static final String PURGE_OLD_RESOURCES_DURING_STARTUP = StoreManager.class.getName() + ".purgeOldResourcesDuringStartup";
        public static final String DEFAULT_PURGE_OLD_RESOURCES_DURING_STARTUP = "true";
        public static final String ACCELERATE_OVERFLOW_THRESHOLD = StoreManager.class.getName() + ".accelerateOverflowThreshold";
        public static final String DEFAULT_ACCELERATE_OVERFLOW_THRESHOLD = "1073741824";
    }
}

