/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.BTreeCounters;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.mdi.IMetadataIndex;
import com.bigdata.resources.BTreeMetadata;
import com.bigdata.resources.ResourceManager;
import com.bigdata.service.Params;
import com.bigdata.util.InnerCause;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

class ViewMetadata
extends BTreeMetadata
implements Params {
    private boolean initView = false;
    private volatile long rangeCount;
    private volatile long partitionCount;
    private volatile long adjustedNominalShardSize;
    private volatile double percentOfSplit;
    private volatile boolean tailSplit;
    private volatile SoftReference<ILocalBTreeView> ref;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILocalBTreeView getView() {
        ILocalBTreeView view;
        ILocalBTreeView iLocalBTreeView = view = this.ref == null ? null : this.ref.get();
        if (view == null) {
            ViewMetadata viewMetadata = this;
            synchronized (viewMetadata) {
                ILocalBTreeView iLocalBTreeView2 = view = this.ref == null ? null : this.ref.get();
                if (view == null) {
                    view = this.resourceManager.getIndex(this.name, this.commitTime);
                    this.ref = new SoftReference<ILocalBTreeView>(view);
                    this.initView(view);
                }
            }
        }
        assert (view != null) : this.toString();
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearRef() {
        ViewMetadata viewMetadata = this;
        synchronized (viewMetadata) {
            if (this.ref != null) {
                this.ref.clear();
            }
        }
        super.clearRef();
    }

    private synchronized void initView(ILocalBTreeView view) {
        long npartitions;
        if (view == null) {
            throw new AssertionError((Object)("View not found? " + this));
        }
        if (this.initView) {
            return;
        }
        try {
            IMetadataIndex mdi = this.resourceManager.getFederation().getMetadataIndex(this.indexMetadata.getName(), this.commitTime);
            if (mdi == null) {
                log.warn((Object)"No metadata index: running in test harness?");
                npartitions = 1L;
            } else {
                npartitions = mdi.rangeCount();
                if (npartitions == 0L) {
                    log.error((Object)("No partitions? name=" + this.indexMetadata.getName()));
                }
            }
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                throw new RuntimeException(t);
            }
            log.error((Object)("name=" + this.indexMetadata.getName()), t);
            npartitions = -1L;
        }
        this.partitionCount = npartitions;
        int accelerateSplitThreshold = this.resourceManager.accelerateSplitThreshold;
        if (accelerateSplitThreshold == 0 || this.partitionCount > (long)accelerateSplitThreshold) {
            this.adjustedNominalShardSize = this.resourceManager.nominalShardSize;
        } else {
            double d = (double)this.partitionCount / (double)accelerateSplitThreshold;
            this.adjustedNominalShardSize = (long)((double)this.resourceManager.nominalShardSize * d);
            if (log.isInfoEnabled()) {
                log.info((Object)("npartitions=" + this.partitionCount + ", discount=" + d + ", threshold=" + accelerateSplitThreshold + ", adjustedNominalShardSize=" + this.adjustedNominalShardSize + ", nominalShardSize=" + this.resourceManager.nominalShardSize));
            }
        }
        this.rangeCount = view.rangeCount();
        this.percentOfSplit = (double)this.sumSegBytes / (double)this.adjustedNominalShardSize;
        this.tailSplit = this.percentOfSplit > this.resourceManager.percentOfSplitThreshold && this.percentTailSplits > this.resourceManager.tailSplitThreshold;
        this.initView = true;
    }

    public long getRangeCount() {
        if (!this.initView) {
            this.getView();
        }
        return this.rangeCount;
    }

    public long getIndexPartitionCount() {
        if (!this.initView) {
            this.getView();
        }
        return this.partitionCount;
    }

    public long getAdjustedNominalShardSize() {
        if (!this.initView) {
            this.getView();
        }
        return this.adjustedNominalShardSize;
    }

    public double getPercentOfSplit() {
        if (!this.initView) {
            this.getView();
        }
        return this.percentOfSplit;
    }

    public boolean isTailSplit() {
        if (!this.initView) {
            this.getView();
        }
        return this.tailSplit;
    }

    public ViewMetadata(ResourceManager resourceManager, long commitTime, String name, BTreeCounters btreeCounters) {
        super(resourceManager, commitTime, name, btreeCounters);
    }

    @Override
    protected void toString(StringBuilder sb) {
        if (this.initView) {
            sb.append(", rangeCount=" + this.rangeCount);
            sb.append(", partitionCount=" + this.partitionCount);
            sb.append(", adjustedNominalShardSize=" + this.adjustedNominalShardSize);
            sb.append(", percentOfSplit=" + this.percentOfSplit);
            sb.append(", tailSplit=" + this.tailSplit);
        }
    }

    @Override
    public Map<String, Object> getParams() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("name", this.name);
        m.put("action", (Object)this.getAction());
        m.put("entryCount", this.entryCount);
        m.put("sourceCount", this.sourceCount);
        m.put("journalSourceCount", this.sourceJournalCount);
        m.put("segmentSourceCount", this.sourceSegmentCount);
        m.put("mergePriority", this.mergePriority);
        m.put("manditoryMerge", this.mandatoryMerge);
        m.put("#leafSplit", this.btreeCounters.leavesSplit);
        m.put("#headSplit", this.btreeCounters.headSplit);
        m.put("#tailSplit", this.btreeCounters.tailSplit);
        m.put("percentHeadSplits", this.percentHeadSplits);
        m.put("percentTailSplits", this.percentTailSplits);
        m.put("rangeCount", this.rangeCount);
        m.put("partitionCount", this.partitionCount);
        m.put("adjustedNominalShardSize", this.adjustedNominalShardSize);
        m.put("percentOfSplit", this.percentOfSplit);
        m.put("tailSplit", this.tailSplit);
        return m;
    }
}

