/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rwstore;

import com.bigdata.rwstore.FixedAllocator;
import com.bigdata.rwstore.RWStore;
import com.bigdata.rwstore.RWWriteCacheService;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class AllocBlock {
    private static final Logger log = Logger.getLogger(AllocBlock.class);
    final FixedAllocator m_allocator;
    int m_addr;
    private final int m_ints;
    int[] m_commit;
    int[] m_saveCommit;
    final int[] m_live;
    int[] m_transients;

    AllocBlock(int addrIsUnused, int bitSize, FixedAllocator allocator) {
        this.m_allocator = allocator;
        this.m_ints = bitSize;
        this.m_commit = new int[bitSize];
        this.m_live = new int[bitSize];
        this.m_transients = new int[bitSize];
    }

    int totalBits() {
        return this.m_ints * 32;
    }

    public boolean verify(int addr, int size) {
        if (addr < this.m_addr || addr >= this.m_addr + size * 32 * this.m_ints) {
            return false;
        }
        int bit = (addr - this.m_addr) / size;
        return RWStore.tstBit(this.m_live, bit);
    }

    public boolean addressInRange(int addr, int size) {
        return addr >= this.m_addr && addr <= this.m_addr + size * 32 * this.m_ints;
    }

    public boolean free(int addr, int size) {
        if (addr < this.m_addr || addr >= this.m_addr + size * 32 * this.m_ints) {
            return false;
        }
        this.freeBit((addr - this.m_addr) / size);
        return true;
    }

    public boolean freeBit(int bit) {
        return this.freeBit(bit, false);
    }

    public boolean freeBit(int bit, boolean sessionProtect) {
        if (!RWStore.tstBit(this.m_live, bit)) {
            throw new IllegalArgumentException("Freeing bit not set");
        }
        RWStore.clrBit(this.m_live, bit);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Freeing " + this.bitPhysicalAddress(bit) + " sessionProtect: " + sessionProtect));
        }
        if (!sessionProtect) {
            if (!RWStore.tstBit(this.m_commit, bit)) {
                RWStore.clrBit(this.m_transients, bit);
                return true;
            }
            return false;
        }
        return false;
    }

    private long bitPhysicalAddress(int bit) {
        return RWStore.convertAddr(this.m_addr) + (long)this.m_allocator.m_size * (long)bit;
    }

    public int alloc(int size) {
        if (size < 0) {
            throw new Error("Storage allocation error : negative size passed");
        }
        int bit = RWStore.fndBit(this.m_transients, this.m_ints);
        if (bit != -1) {
            RWStore.setBit(this.m_live, bit);
            RWStore.setBit(this.m_transients, bit);
            return bit;
        }
        return -1;
    }

    void setBitExternal(int bit) {
        RWStore.setBit(this.m_live, bit);
        RWStore.setBit(this.m_transients, bit);
    }

    public boolean hasFree() {
        for (int i = 0; i < this.m_ints; ++i) {
            if (this.m_live[i] == -1) continue;
            return true;
        }
        return false;
    }

    public int getAllocBits() {
        int total = this.m_ints * 32;
        int allocBits = 0;
        for (int i = 0; i < total; ++i) {
            if (!RWStore.tstBit(this.m_live, i)) continue;
            ++allocBits;
        }
        return allocBits;
    }

    public String getStats(RWStore.AllocationStats stats) {
        int total = this.m_ints * 32;
        int allocBits = this.getAllocBits();
        if (stats != null) {
            stats.m_reservedSlots += (long)total;
            stats.m_filledSlots += (long)allocBits;
            return "";
        }
        return " - start addr : " + RWStore.convertAddr(this.m_addr) + " [" + allocBits + "::" + total + "]";
    }

    public void addAddresses(ArrayList addrs, int rootAddr) {
        int total = this.m_ints * 32;
        for (int i = 0; i < total; ++i) {
            if (!RWStore.tstBit(this.m_live, i)) continue;
            addrs.add(new Integer(rootAddr - i));
        }
    }

    public void shadow() {
        this.m_saveCommit = this.m_commit;
        this.m_commit = (int[])this.m_transients.clone();
    }

    public void deshadow() {
    }

    public void abortshadow(RWWriteCacheService cache) {
        for (int i = 0; i < this.m_live.length; ++i) {
            int startBit = i * 32;
            int chkbits = this.m_live[i] & ~this.m_commit[i];
            this.clearCacheBits(cache, startBit, chkbits);
            int n = i;
            this.m_live[n] = this.m_live[n] & this.m_commit[i];
            this.m_transients[i] = this.m_commit[i];
        }
        this.m_commit = this.m_saveCommit;
        this.m_saveCommit = null;
    }

    private int clearCacheBits(RWWriteCacheService cache, int startBit, int chkbits) {
        int freebits = 0;
        if (chkbits != 0) {
            for (int b = 0; b < 32; ++b) {
                if ((chkbits & 1 << b) == 0) continue;
                long clr = RWStore.convertAddr(this.m_addr) + (long)this.m_allocator.m_size * (long)(startBit + b);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("releasing address: " + clr));
                }
                int latchedAddr = -((this.m_allocator.getIndex() << 13) + (startBit + b));
                cache.clearWrite(clr, latchedAddr);
                this.m_allocator.m_store.removeFromExternalCache(clr, this.m_allocator.m_size);
                ++freebits;
            }
        }
        return freebits;
    }

    void reset(RWWriteCacheService cache) {
        if (this.m_addr == 0) {
            return;
        }
        for (int i = 0; i < this.m_live.length; ++i) {
            int chkbits;
            int startBit = i * 32;
            if (this.m_saveCommit == null) {
                chkbits = this.m_transients[i] & ~this.m_commit[i];
                this.clearCacheBits(cache, startBit, chkbits);
                this.m_live[i] = this.m_commit[i];
                this.m_transients[i] = this.m_commit[i];
                continue;
            }
            chkbits = this.m_commit[i] & ~this.m_saveCommit[i];
            this.clearCacheBits(cache, startBit, chkbits);
            int n = i;
            this.m_live[n] = this.m_live[n] & ~chkbits;
            int n2 = i;
            this.m_transients[n2] = this.m_transients[n2] & ~chkbits;
        }
    }

    int releaseSession(RWWriteCacheService cache) {
        int freebits = 0;
        if (this.m_addr != 0) {
            for (int i = 0; i < this.m_live.length; ++i) {
                int chkbits = this.m_transients[i];
                this.m_transients[i] = this.m_live[i] | this.m_commit[i];
                int startBit = i * 32;
                freebits += this.clearCacheBits(cache, startBit, chkbits &= ~this.m_live[i]);
            }
        }
        return freebits;
    }

    int releaseCommitWrites(RWWriteCacheService cache) {
        int freebits = 0;
        if (this.m_addr != 0) {
            for (int i = 0; i < this.m_live.length; ++i) {
                int chkbits = this.m_transients[i];
                int startBit = i * 32;
                freebits += this.clearCacheBits(cache, startBit, chkbits &= ~this.m_live[i]);
            }
        }
        return freebits;
    }

    public String show() {
        StringBuilder sb = new StringBuilder();
        sb.append("AllocBlock, baseAddress: " + RWStore.convertAddr(this.m_addr) + " bits: ");
        for (int b : this.m_transients) {
            sb.append(b + " ");
        }
        return sb.toString();
    }

    int sessionBits() {
        int freebits = 0;
        if (this.m_addr != 0) {
            for (int i = 0; i < this.m_live.length; ++i) {
                int chkbits = this.m_transients[i];
                if (chkbits == 0 || (chkbits &= ~this.m_live[i]) == 0) continue;
                for (int b = 0; b < 32; ++b) {
                    if ((chkbits & 1 << b) == 0) continue;
                    ++freebits;
                }
            }
        }
        return freebits;
    }

    int freeBits() {
        int freebits = 0;
        if (this.m_addr != 0) {
            for (int i = 0; i < this.m_live.length; ++i) {
                int chkbits = ~this.m_transients[i];
                if (chkbits == 0) continue;
                if (chkbits == -1) {
                    freebits += 32;
                    continue;
                }
                for (int b = 0; b < 32; ++b) {
                    if ((chkbits & 1 << b) == 0) continue;
                    ++freebits;
                }
            }
        } else {
            freebits += this.m_live.length * 32;
        }
        return freebits;
    }

    int transientBits() {
        int freebits = 0;
        if (this.m_addr != 0) {
            for (int i = 0; i < this.m_live.length; ++i) {
                int chkbits = this.m_transients[i] & ~this.m_live[i];
                if (chkbits == 0) continue;
                if (chkbits == -1) {
                    freebits += 32;
                    continue;
                }
                for (int b = 0; b < 32; ++b) {
                    if ((chkbits & 1 << b) == 0) continue;
                    ++freebits;
                }
            }
        }
        return freebits;
    }
}

