/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rwstore;

import com.bigdata.rwstore.RWStore;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PSInputStream
extends InputStream {
    final RWStore m_store;
    final byte[] m_buffer;
    final int m_maxCursor;
    final DataInputStream m_hdrIn;
    final int m_blobBuffers;
    int m_cursor = 0;
    int m_size = 0;

    public PSInputStream(RWStore store, long addr) {
        this.m_store = store;
        this.m_size = (int)(addr & 0xFFFFFFFFFFFFFFFFL);
        if (this.m_size < store.m_maxFixedAlloc - 4) {
            this.m_buffer = new byte[this.m_size + 4];
            store.getData(addr >> 32, this.m_buffer);
            this.m_hdrIn = null;
            this.m_blobBuffers = 0;
            this.m_maxCursor = this.m_size;
        } else {
            this.m_buffer = new byte[store.m_maxFixedAlloc];
            this.m_maxCursor = store.m_maxFixedAlloc - 4;
            int alloc = this.m_maxCursor;
            int nblocks = (alloc - 1 + (this.m_size - 4)) / alloc;
            int hdrsize = 4 * (nblocks + 1) + 4;
            if (hdrsize > store.m_maxFixedAlloc) {
                throw new UnsupportedOperationException("Header is a blob not yet supported");
            }
            byte[] hdrbuf = new byte[hdrsize];
            store.getData(addr >> 32, hdrbuf);
            this.m_hdrIn = new DataInputStream(new ByteArrayInputStream(hdrbuf));
            try {
                this.m_blobBuffers = this.m_hdrIn.readInt();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to initialize blob header", e);
            }
            this.m_cursor = this.m_maxCursor;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.m_size == 0) {
            return -1;
        }
        if (this.m_cursor >= this.m_maxCursor) {
            this.loadBuffer();
        }
        --this.m_size;
        return 0xFF & this.m_buffer[this.m_cursor++];
    }

    private int loadBuffer() throws IOException {
        int nxtaddr = this.m_hdrIn.readInt();
        int rdlen = this.m_size > this.m_maxCursor ? this.m_maxCursor : this.m_size;
        this.m_store.getData(nxtaddr, this.m_buffer, 0, rdlen + 4);
        this.m_cursor = 0;
        return rdlen;
    }

    @Override
    public synchronized int read(byte[] dst, int off, int len) throws IOException {
        if (this.m_size == 0) {
            return -1;
        }
        if (this.m_cursor >= this.m_maxCursor) {
            this.loadBuffer();
        }
        int rdlen = len > this.m_size ? this.m_size : len;
        int avail = this.m_maxCursor - this.m_cursor;
        int delta = 0;
        while (avail < rdlen - delta) {
            System.arraycopy(this.m_buffer, this.m_cursor, dst, off + delta, avail);
            this.m_cursor += avail;
            delta += avail;
            this.m_size -= avail;
            avail = this.loadBuffer();
        }
        int lastRead = rdlen - delta;
        System.arraycopy(this.m_buffer, this.m_cursor, dst, off + delta, lastRead);
        this.m_size -= lastRead;
        this.m_cursor += lastRead;
        return rdlen;
    }
}

