/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rwstore;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.counters.striped.StripedCounters;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.QuorumPipeline;
import com.bigdata.ha.QuorumService;
import com.bigdata.ha.msg.HAWriteMessage;
import com.bigdata.ha.msg.IHALogRequest;
import com.bigdata.ha.msg.IHARebuildRequest;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.FileChannelUtility;
import com.bigdata.io.IBufferAccess;
import com.bigdata.io.IReopenChannel;
import com.bigdata.io.writecache.BufferedWrite;
import com.bigdata.io.writecache.IBackingReader;
import com.bigdata.io.writecache.IBufferedWriter;
import com.bigdata.io.writecache.WriteCache;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.CommitRecordIndex;
import com.bigdata.journal.CommitRecordSerializer;
import com.bigdata.journal.FileMetadata;
import com.bigdata.journal.ForceEnum;
import com.bigdata.journal.ICommitRecord;
import com.bigdata.journal.ICommitter;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.StoreState;
import com.bigdata.journal.StoreTypeEnum;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumException;
import com.bigdata.rawstore.IAllocationContext;
import com.bigdata.rawstore.IPSOutputStream;
import com.bigdata.rwstore.Allocator;
import com.bigdata.rwstore.FixedAllocator;
import com.bigdata.rwstore.FixedOutputStream;
import com.bigdata.rwstore.IRawTx;
import com.bigdata.rwstore.IStore;
import com.bigdata.rwstore.PSInputStream;
import com.bigdata.rwstore.PSOutputStream;
import com.bigdata.rwstore.PhysicalAddressResolutionException;
import com.bigdata.rwstore.RWWriteCacheService;
import com.bigdata.rwstore.StorageStats;
import com.bigdata.rwstore.StorageTerminalError;
import com.bigdata.service.AbstractTransactionService;
import com.bigdata.util.ChecksumError;
import com.bigdata.util.ChecksumUtility;
import com.bigdata.util.MergeStreamWithSnapshotData;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class RWStore
implements IStore,
IBufferedWriter,
IBackingReader {
    private static final transient Logger log = Logger.getLogger(RWStore.class);
    private static final Logger txLog = Logger.getLogger((String)"com.bigdata.txLog");
    private static final String ERR_WRITE_CACHE_CREATE = "Unable to create write cache service";
    private static final int ALLOC_BLOCK_SIZE = 1024;
    static final int OFFSET_BITS = 13;
    static final int OFFSET_BITS_MASK = 8191;
    static final int ALLOCATION_SCALEUP = 16;
    private static final int META_ALLOCATION = 8;
    private static final int cDirectBufferCapacity = 0x100000;
    private int cMaxDirectBuffers = 20;
    static final int cDirectAllocationOffset = 65536;
    private final File m_fd;
    private UUID m_storeUUID;
    private final ArrayList<FixedAllocator> m_allocs;
    private ArrayList<FixedAllocator>[] m_freeFixed;
    private final ArrayList<FixedAllocator> m_commitList;
    private final Quorum<?, ?> m_quorum;
    private final int m_writeCacheBufferCount;
    private final int m_minCleanListSize;
    private final int m_readCacheBufferCount;
    private final int m_compactionThreshold;
    private final int m_hotCacheThreshold;
    private final int m_hotCacheSize;
    private final String m_compressorKey;
    private RWWriteCacheService m_writeCacheService;
    private int[] m_allocSizes;
    final int m_maxFixedAlloc;
    final int m_minFixedAlloc;
    final int m_maxBlobAllocSize = Integer.MAX_VALUE;
    private final ReentrantReadWriteLock m_extensionLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock m_allocationLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock m_allocationWriteLock = this.m_allocationLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock m_allocationReadLock = this.m_allocationLock.readLock();
    private final long m_minReleaseAge;
    private int m_activeTxCount = 0;
    private volatile long m_lastDeferredReleaseTime = 0L;
    private final PSOutputStream m_deferredFreeOut;
    private final ReopenFileChannel m_reopener;
    private volatile BufferedWrite m_bufferedWrite;
    private StorageStats m_storageStats;
    private long m_storageStatsAddr = 0L;
    private volatile boolean m_open = true;
    private ConcurrentHashMap<Integer, Long> m_lockAddresses = null;
    private volatile long m_cacheReads = 0L;
    private volatile long m_diskReads = 0L;
    private volatile int m_allocations = 0;
    private volatile int m_frees = 0;
    private volatile long m_nativeAllocBytes = 0L;
    private volatile long m_spareAllocation = 0L;
    private final AtomicReference<CommitState> m_commitStateRef = new AtomicReference();
    private volatile int m_fileSize;
    private volatile int m_nextAllocation;
    private volatile int m_committedNextAllocation;
    private final long m_maxFileSize;
    private final int cVersion = 1024;
    private final int cVersionDemispace = 1280;
    static final int cReservedMetaBits = 20;
    private static final int cMetaHdrFields = 27;
    private final int cDefaultMetaBitsSize = 9;
    private volatile int m_metaBitsSize;
    private volatile boolean m_useMetabitsDemispace = true;
    final int cDefaultFreeBitsThreshold;
    final int cSmallSlotThreshold = 4096;
    int cSmallSlot = 1024;
    private int[] m_metaBits;
    private int[] m_metaTransientBits;
    private volatile int m_metaBitsAddr;
    private volatile boolean m_recentAlloc = false;
    private volatile boolean m_extendingFile = false;
    private volatile long m_readsAtExtend = 0L;
    private final Map<IAllocationContext, ContextAllocation> m_contexts = new ConcurrentHashMap<IAllocationContext, ContextAllocation>();
    private int m_contextRequests = 0;
    private int m_contextRemovals = 0;
    private final AtomicReference<StoreCounters> storeCounters = new AtomicReference();
    private ConcurrentWeakValueCache<Long, ICommitter> m_externalCache = null;
    private int m_cachedDatasize = 0;
    private long lastBlockSequence = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RWWriteCacheService getWriteCacheService() {
        this.m_allocationReadLock.lock();
        try {
            RWWriteCacheService rWWriteCacheService = this.m_writeCacheService;
            return rWWriteCacheService;
        }
        finally {
            this.m_allocationReadLock.unlock();
        }
    }

    public RWStore(FileMetadata fileMetadata, Quorum<?, ?> quorum) {
        if (fileMetadata == null) {
            throw new IllegalArgumentException();
        }
        this.m_minReleaseAge = Long.valueOf(fileMetadata.getProperty(AbstractTransactionService.Options.MIN_RELEASE_AGE, "1"));
        if (log.isInfoEnabled()) {
            log.info((Object)(AbstractTransactionService.Options.MIN_RELEASE_AGE + "=" + this.m_minReleaseAge));
        }
        this.m_metaBitsSize = 9;
        this.m_useMetabitsDemispace = Boolean.valueOf(fileMetadata.getProperty(Options.META_BITS_DEMI_SPACE, "false"));
        this.cDefaultFreeBitsThreshold = Integer.valueOf(fileMetadata.getProperty(Options.FREE_BITS_THRESHOLD, "300"));
        if (this.cDefaultFreeBitsThreshold < 1 || this.cDefaultFreeBitsThreshold > 5000) {
            throw new IllegalArgumentException(Options.FREE_BITS_THRESHOLD + " : Must be between 1 and 5000");
        }
        this.cSmallSlot = Integer.valueOf(fileMetadata.getProperty(Options.SMALL_SLOT_TYPE, "0"));
        if (this.cSmallSlot < 0 || this.cSmallSlot > 2048) {
            throw new IllegalArgumentException(Options.SMALL_SLOT_TYPE + " : Must be between 0 and 2048");
        }
        this.m_metaBits = new int[this.m_metaBitsSize];
        this.m_metaTransientBits = new int[this.m_metaBitsSize];
        this.m_quorum = quorum;
        this.m_fd = fileMetadata.file;
        this.storeCounters.set(new StoreCounters(10));
        IRootBlockView m_rb = fileMetadata.rootBlock;
        this.m_commitList = new ArrayList();
        this.m_allocs = new ArrayList();
        try {
            RandomAccessFile m_raf = fileMetadata.getRandomAccessFile();
            this.m_reopener = new ReopenFileChannel(this.m_fd, m_raf, "rw");
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        if (Boolean.valueOf(fileMetadata.getProperty(Options.DOUBLE_BUFFER_WRITES, "true")).booleanValue()) {
            try {
                this.m_bufferedWrite = new BufferedWrite(this);
            }
            catch (InterruptedException e1) {
                this.m_bufferedWrite = null;
            }
        } else {
            this.m_bufferedWrite = null;
        }
        this.m_writeCacheBufferCount = fileMetadata.writeCacheBufferCount;
        this.m_readCacheBufferCount = Integer.valueOf(fileMetadata.getProperty(com.bigdata.journal.Options.READ_CACHE_BUFFER_COUNT, "0"));
        if (log.isInfoEnabled()) {
            log.info((Object)(com.bigdata.journal.Options.WRITE_CACHE_BUFFER_COUNT + "=" + this.m_writeCacheBufferCount));
        }
        this.m_minCleanListSize = Integer.valueOf(fileMetadata.getProperty(com.bigdata.journal.Options.WRITE_CACHE_MIN_CLEAN_LIST_SIZE, "3"));
        if (log.isInfoEnabled()) {
            log.info((Object)(com.bigdata.journal.Options.WRITE_CACHE_MIN_CLEAN_LIST_SIZE + "=" + this.m_minCleanListSize));
        }
        this.m_compactionThreshold = Double.valueOf(fileMetadata.getProperty(com.bigdata.journal.Options.WRITE_CACHE_COMPACTION_THRESHOLD, "20")).intValue();
        if (log.isInfoEnabled()) {
            log.info((Object)(com.bigdata.journal.Options.WRITE_CACHE_COMPACTION_THRESHOLD + "=" + this.m_compactionThreshold));
        }
        this.m_hotCacheThreshold = Double.valueOf(fileMetadata.getProperty(com.bigdata.journal.Options.HOT_CACHE_THRESHOLD, "1")).intValue();
        if (log.isInfoEnabled()) {
            log.info((Object)(com.bigdata.journal.Options.HOT_CACHE_THRESHOLD + "=" + this.m_hotCacheThreshold));
        }
        this.m_hotCacheSize = Double.valueOf(fileMetadata.getProperty(com.bigdata.journal.Options.HOT_CACHE_SIZE, "10")).intValue();
        if (log.isInfoEnabled()) {
            log.info((Object)(com.bigdata.journal.Options.HOT_CACHE_SIZE + "=" + this.m_hotCacheSize));
        }
        this.m_compressorKey = fileMetadata.getProperty("HALogCompressor", "DBS");
        if (log.isInfoEnabled()) {
            log.info((Object)("HALogCompressor=" + this.m_compressorKey));
        }
        try {
            if (m_rb.getNextOffset() == 0L) {
                this.setAllocations(fileMetadata);
                this.m_storeUUID = m_rb.getUUID();
                this.defaultInit();
                this.m_maxFixedAlloc = this.m_allocSizes[this.m_allocSizes.length - 1] * 64;
                this.m_minFixedAlloc = this.m_allocSizes[0] * 64;
                this.m_storageStats = new StorageStats(this.m_allocSizes);
            } else {
                this.initfromRootBlock(m_rb);
                this.m_maxFixedAlloc = this.m_allocSizes[this.m_allocSizes.length - 1] * 64;
                this.m_minFixedAlloc = this.m_allocSizes[0] * 64;
                if (this.m_storageStatsAddr != 0L) {
                    long statsAddr = this.m_storageStatsAddr >> 16;
                    int statsLen = (int)this.m_storageStatsAddr & 0xFFFF;
                    byte[] stats = new byte[statsLen + 4];
                    this.getData(statsAddr, stats);
                    DataInputStream instr = new DataInputStream(new ByteArrayInputStream(stats));
                    this.m_storageStats = new StorageStats(instr);
                    for (FixedAllocator fa : this.m_allocs) {
                        this.m_storageStats.register(fa);
                    }
                } else {
                    this.m_storageStats = new StorageStats(this.m_allocSizes);
                }
                if (log.isTraceEnabled()) {
                    StringBuilder str = new StringBuilder();
                    this.showAllocators(str);
                    log.trace((Object)str);
                }
            }
            this.m_maxFileSize = Integer.MAX_VALUE * (long)this.m_maxFixedAlloc;
            this.m_writeCacheService = this.newWriteCacheService();
            int maxBlockLessChk = this.m_maxFixedAlloc - 4;
            assert (this.m_maxFixedAlloc > 0);
            this.m_deferredFreeOut = PSOutputStream.getNew(this, this.m_maxFixedAlloc, null);
        }
        catch (IOException e) {
            throw new StorageTerminalError("Unable to initialize store", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAddress(int latchedAddr, int size) {
        if (latchedAddr == 0) {
            return;
        }
        this.m_allocationWriteLock.lock();
        try {
            int size2;
            FixedAllocator alloc = null;
            try {
                alloc = this.getBlock(latchedAddr);
            }
            catch (PhysicalAddressResolutionException par) {
                // empty catch block
            }
            int n = size2 = size < 0 ? -size : size;
            if (alloc == null) {
                int i = this.fixedAllocatorIndex(size2);
                int block = 64 * this.m_allocSizes[i];
                ArrayList<FixedAllocator> list = this.m_freeFixed[i];
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Creating new Allocator for address: " + latchedAddr));
                }
                FixedAllocator allocator = new FixedAllocator(this, block);
                allocator.setFreeList(list);
                allocator.setIndex(this.m_allocs.size());
                this.m_allocs.add(allocator);
                assert (allocator == this.getBlock(latchedAddr));
                alloc = allocator;
            }
            assert (size2 <= alloc.getSlotSize());
            if (size > 0) {
                alloc.setAddressExternal(latchedAddr);
            }
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAddress(int latchedAddr) {
        if (latchedAddr == 0) {
            return;
        }
        this.m_allocationWriteLock.lock();
        try {
            FixedAllocator alloc = this.getBlockByAddress(latchedAddr);
            assert (alloc != null);
            int addrOffset = this.getOffset(latchedAddr);
            if (alloc == null) {
                throw new IllegalArgumentException("Invalid address provided to immediateFree: " + latchedAddr);
            }
            long pa = alloc.getPhysicalAddress(addrOffset);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Freeing allocation at " + latchedAddr + ", physical address: " + pa));
            }
            alloc.free(latchedAddr, 0, false);
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    private RWWriteCacheService newWriteCacheService() {
        try {
            boolean prefixWrites = this.m_quorum != null;
            return new RWWriteCacheService(this.m_writeCacheBufferCount, this.m_minCleanListSize, this.m_readCacheBufferCount, prefixWrites, this.m_compactionThreshold, this.m_hotCacheSize, this.m_hotCacheThreshold, RWStore.convertAddr(this.m_fileSize), (IReopenChannel)this.m_reopener, this.m_quorum, (IBackingReader)this){

                @Override
                public WriteCache newWriteCache(IBufferAccess buf, boolean useChecksum, boolean bufferHasData, IReopenChannel<? extends Channel> opener, long fileExtent) throws InterruptedException {
                    return new WriteCacheImpl(buf, useChecksum, bufferHasData, opener, fileExtent, RWStore.this.m_compressorKey);
                }
            };
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(ERR_WRITE_CACHE_CREATE, e);
        }
        catch (IOException e) {
            throw new IllegalStateException(ERR_WRITE_CACHE_CREATE, e);
        }
    }

    private void setAllocations(FileMetadata fileMetadata) throws IOException {
        String buckets = fileMetadata.getProperty(Options.ALLOCATION_SIZES, "1, 2, 3, 5, 8, 12, 16, 32, 48, 64, 128");
        String[] specs = buckets.split("\\s*,\\s*");
        this.m_allocSizes = new int[specs.length];
        int prevSize = 0;
        for (int i = 0; i < specs.length; ++i) {
            int nxtSize = Integer.parseInt(specs[i]);
            if (nxtSize <= prevSize) {
                throw new IllegalArgumentException("Invalid AllocSizes property");
            }
            this.m_allocSizes[i] = nxtSize;
            prevSize = nxtSize;
        }
    }

    private void defaultInit() throws IOException {
        int numFixed = this.m_allocSizes.length;
        this.m_freeFixed = new ArrayList[numFixed];
        for (int i = 0; i < numFixed; ++i) {
            this.m_freeFixed[i] = new ArrayList();
        }
        this.m_fileSize = this.convertFromAddr(this.m_fd.length());
        this.m_metaBits[0] = -1;
        this.m_metaTransientBits[0] = -1;
        this.m_committedNextAllocation = this.m_nextAllocation = -9;
        if (this.m_fileSize > this.m_nextAllocation) {
            this.m_fileSize = this.m_nextAllocation;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Set default file extent " + RWStore.convertAddr(this.m_fileSize)));
        }
        this.m_reopener.raf.setLength(RWStore.convertAddr(this.m_fileSize));
    }

    public boolean isOpen() {
        return this.m_open;
    }

    private void assertOpen() {
        if (!this.m_open) {
            throw new IllegalStateException("Not open");
        }
    }

    @Override
    public synchronized void close() {
        this.m_open = false;
        try {
            if (this.m_bufferedWrite != null) {
                this.m_bufferedWrite.release();
                this.m_bufferedWrite = null;
            }
            this.m_writeCacheService.close();
            this.m_reopener.raf.close();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void checkRootBlock(IRootBlockView rbv) {
        long nxtOffset = rbv.getNextOffset();
        int nxtalloc = -((int)(nxtOffset >> 32));
        int metaBitsAddr = -((int)nxtOffset);
        long metaAddr = rbv.getMetaStartAddr();
        long rawMetaBitsAddr = rbv.getMetaBitsAddr();
        if (metaAddr == 0L || rawMetaBitsAddr == 0L) {
            log.warn((Object)"No meta allocation data included in root block for RWStore");
        }
        if (this.m_quorum == null && log.isTraceEnabled()) {
            int commitRecordAddr = (int)(rbv.getCommitRecordAddr() >> 32);
            log.trace((Object)("CommitRecord " + rbv.getCommitRecordAddr() + " at physical address: " + this.physicalAddress(commitRecordAddr)));
        }
        long commitCounter = rbv.getCommitCounter();
        if (log.isTraceEnabled()) {
            log.trace((Object)("m_allocation: " + nxtalloc + ", m_metaBitsAddr: " + metaBitsAddr + ", m_commitCounter: " + commitCounter));
        }
    }

    private void initfromRootBlock(IRootBlockView rb) throws IOException {
        assert (rb != null);
        this.m_storeUUID = rb.getUUID();
        if (rb.getNextOffset() == 0L) {
            this.defaultInit();
        } else {
            long rawmbaddr;
            int metaBitsStore;
            long nxtOffset = rb.getNextOffset();
            this.m_nextAllocation = -((int)(nxtOffset >> 32));
            if (this.m_nextAllocation == 0) {
                this.m_nextAllocation = -9;
            }
            this.m_committedNextAllocation = this.m_nextAllocation;
            this.m_metaBitsAddr = -((int)nxtOffset);
            if (log.isInfoEnabled()) {
                log.info((Object)("MetaBitsAddr: " + this.m_metaBitsAddr));
            }
            long metaAddr = rb.getMetaStartAddr();
            this.m_fileSize = (int)(-(metaAddr & 0xFFFFFFFFFFFFFFFFL));
            if (log.isInfoEnabled()) {
                log.info((Object)("InitFromRootBlock m_fileSize: " + RWStore.convertAddr(this.m_fileSize)));
            }
            if ((metaBitsStore = (int)((rawmbaddr = rb.getMetaBitsAddr()) & 0xFFFFL)) > 0) {
                int i;
                byte[] buf = new byte[metaBitsStore * 4];
                FileChannelUtility.readAll(this.m_reopener, ByteBuffer.wrap(buf), rawmbaddr >>= 16);
                DataInputStream strBuf = new DataInputStream(new ByteArrayInputStream(buf));
                int storeVersion = strBuf.readInt();
                switch (storeVersion & 0xFF00) {
                    case 1024: 
                    case 1280: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Incompatible RWStore header version: storeVersion=" + storeVersion + ", cVersion=" + 1024 + ", demispace: " + this.isUsingDemiSpace());
                    }
                }
                this.m_lastDeferredReleaseTime = strBuf.readLong();
                if (strBuf.readInt() != 9) {
                    throw new IllegalStateException("Store opened with unsupported metabits size");
                }
                int allocBlocks = strBuf.readInt();
                this.m_storageStatsAddr = strBuf.readLong();
                for (i = 0; i < 20; ++i) {
                    strBuf.readInt();
                }
                this.m_allocSizes = new int[allocBlocks];
                for (i = 0; i < allocBlocks; ++i) {
                    this.m_allocSizes[i] = strBuf.readInt();
                }
                this.m_metaBitsSize = metaBitsStore - allocBlocks - 27;
                this.m_metaBits = new int[this.m_metaBitsSize];
                if (log.isInfoEnabled()) {
                    log.info((Object)("Raw MetaBitsAddr: " + rawmbaddr));
                }
                for (i = 0; i < this.m_metaBitsSize; ++i) {
                    this.m_metaBits[i] = strBuf.readInt();
                }
                this.syncMetaTransients();
                int numFixed = this.m_allocSizes.length;
                this.m_freeFixed = new ArrayList[numFixed];
                for (int i2 = 0; i2 < numFixed; ++i2) {
                    this.m_freeFixed[i2] = new ArrayList();
                }
                this.checkCoreAllocations();
                this.readAllocationBlocks();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("restored from RootBlock: " + this.m_nextAllocation + ", " + this.m_metaBitsAddr));
            }
        }
    }

    private void syncMetaTransients() {
        if (this.m_metaTransientBits == null || this.m_metaTransientBits.length != this.m_metaBits.length) {
            this.m_metaTransientBits = (int[])this.m_metaBits.clone();
        } else {
            System.arraycopy(this.m_metaBits, 0, this.m_metaTransientBits, 0, this.m_metaTransientBits.length);
        }
    }

    protected void finalize() {
        this.close();
    }

    protected void readAllocationBlocks() throws IOException {
        assert (this.m_allocs.size() == 0);
        if (log.isInfoEnabled()) {
            log.info((Object)("readAllocationBlocks, m_metaBits.length: " + this.m_metaBits.length));
        }
        for (int b = 0; b < this.m_metaBits.length; b += 9) {
            long blockStart = RWStore.convertAddr(this.m_metaBits[b]);
            int startBit = b * 32 + 32;
            int endBit = startBit + 256;
            for (int i = startBit; i < endBit; ++i) {
                if (!RWStore.tstBit(this.m_metaBits, i)) continue;
                long addr = blockStart + (long)((i - startBit) * 1024);
                FixedAllocator allocator = this.readAllocator(addr);
                allocator.setDiskAddr(i);
                this.m_allocs.add(allocator);
                if (this.m_storageStats == null) continue;
                this.m_storageStats.register(allocator);
            }
        }
        Collections.sort(this.m_allocs);
        for (int index = 0; index < this.m_allocs.size(); ++index) {
            ((Allocator)this.m_allocs.get(index)).setIndex(index);
        }
    }

    private FixedAllocator readAllocator(long addr) throws IOException {
        byte[] buf = new byte[1024];
        FileChannelUtility.readAll(this.m_reopener, ByteBuffer.wrap(buf), addr);
        ByteArrayInputStream baBuf = new ByteArrayInputStream(buf);
        DataInputStream strBuf = new DataInputStream(baBuf);
        int allocSize = strBuf.readInt();
        assert (allocSize > 0);
        int slotSizeIndex = this.slotSizeIndex(allocSize);
        if (slotSizeIndex == -1) {
            throw new IllegalStateException("Unexpected allocation size of: " + allocSize);
        }
        FixedAllocator fa = new FixedAllocator(this, allocSize);
        fa.read(strBuf);
        int chk = ChecksumUtility.getCHK().checksum(buf, buf.length - baBuf.available());
        int tstChk = strBuf.readInt();
        if (tstChk != chk) {
            throw new IllegalStateException("FixedAllocator checksum error");
        }
        if (slotSizeIndex == -1) {
            throw new IllegalStateException("Unexpected allocation size of: " + allocSize);
        }
        ArrayList<FixedAllocator> freeList = this.m_freeFixed[slotSizeIndex];
        fa.setFreeList(freeList);
        return fa;
    }

    private int slotSizeIndex(int allocSize) {
        if (allocSize % 64 != 0) {
            return -1;
        }
        int slotSize = allocSize / 64;
        int slotSizeIndex = -1;
        for (int index = 0; index < this.m_allocSizes.length; ++index) {
            if (this.m_allocSizes[index] != slotSize) continue;
            slotSizeIndex = index;
            break;
        }
        return slotSizeIndex;
    }

    private void updateFixedAllocator(int index, long addr) throws ChecksumError, InterruptedException, IOException {
        ByteBuffer buf = this.m_writeCacheService.read(addr, 1024);
        ByteArrayInputStream baBuf = new ByteArrayInputStream(buf.array());
        DataInputStream strBuf = new DataInputStream(baBuf);
        int allocSize = strBuf.readInt();
        assert (allocSize > 0);
        int slotIndex = this.slotSizeIndex(allocSize);
        if (slotIndex == -1) {
            throw new IllegalStateException("Invalid allocation size: " + allocSize);
        }
        FixedAllocator allocator = new FixedAllocator(this, allocSize);
        ArrayList<FixedAllocator> freeList = this.m_freeFixed[slotIndex];
        if (index < this.m_allocs.size()) {
            FixedAllocator old = this.m_allocs.get(index);
            freeList.remove(old);
            this.m_allocs.set(index, allocator);
            allocator.setFreeList(freeList);
        } else {
            assert (index == this.m_allocs.size());
            this.m_allocs.add(allocator);
        }
    }

    private FixedAllocator establishFreeFixedAllocator(int block) {
        ArrayList<FixedAllocator> list = this.m_freeFixed[block];
        for (int i = 0; i < list.size(); ++i) {
            FixedAllocator f = list.get(i);
            if (this.m_commitList.contains(f)) continue;
            list.remove(i);
            return f;
        }
        int allocSize = 64 * this.m_allocSizes[block];
        FixedAllocator allocator = new FixedAllocator(this, allocSize);
        allocator.setIndex(this.m_allocs.size());
        this.m_allocs.add(allocator);
        if (this.m_storageStats != null) {
            this.m_storageStats.register(allocator, true);
        }
        return allocator;
    }

    public long getMaxFileSize() {
        return this.m_maxFileSize;
    }

    public ByteBuffer getData(long rwaddr, int sze) {
        ReentrantReadWriteLock.ReadLock lock = this.m_allocationReadLock;
        lock.lock();
        try {
            if (sze > this.m_maxFixedAlloc - 4 || this.m_writeCacheService == null) {
                byte[] buf = new byte[sze + 4];
                this.getData(rwaddr, buf, 0, sze + 4);
                ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, sze);
                return byteBuffer;
            }
            long paddr = this.physicalAddress((int)rwaddr);
            if (paddr == 0L) {
                this.assertAllocators();
                throw new PhysicalAddressResolutionException(rwaddr);
            }
            assert (paddr > 0L);
            try {
                ByteBuffer byteBuffer = this.m_writeCacheService.read(paddr, sze + 4);
                return byteBuffer;
            }
            catch (Throwable e) {
                throw new RuntimeException("addr=" + rwaddr + " : cause=" + e, e);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void getData(long addr, byte[] buf) {
        this.getData(addr, buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getData(long addr, byte[] buf, int offset, int length) {
        this.assertOpen();
        if (addr == 0L) {
            return;
        }
        long begin = System.nanoTime();
        ReentrantReadWriteLock.ReadLock lock = this.m_allocationReadLock;
        lock.lock();
        this.assertOpen();
        if (length > this.m_maxFixedAlloc) {
            try {
                int alloc = this.m_maxFixedAlloc - 4;
                int nblocks = (alloc - 1 + (length - 4)) / alloc;
                if (nblocks < 0) {
                    throw new IllegalStateException("Allocation error, m_maxFixedAlloc: " + this.m_maxFixedAlloc);
                }
                byte[] hdrbuf = new byte[4 * (nblocks + 1) + 4];
                if (hdrbuf.length > this.m_maxFixedAlloc && log.isInfoEnabled()) {
                    log.info((Object)"LARGE BLOB - header is BLOB");
                }
                this.getData(addr, hdrbuf);
                DataInputStream hdrstr = new DataInputStream(new ByteArrayInputStream(hdrbuf));
                int rhdrs = hdrstr.readInt();
                if (rhdrs != nblocks) {
                    throw new IllegalStateException("Incompatible BLOB header record, expected: " + nblocks + ", got: " + rhdrs);
                }
                int[] blobHdr = new int[nblocks];
                for (int i = 0; i < nblocks; ++i) {
                    blobHdr[i] = hdrstr.readInt();
                }
                int cursor = 0;
                int rdlen = this.m_maxFixedAlloc;
                for (int i = 0; i < nblocks; ++i) {
                    if (i == nblocks - 1) {
                        rdlen = length - cursor;
                    }
                    this.getData(blobHdr[i], buf, cursor, rdlen);
                    cursor += rdlen - 4;
                }
                return;
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
                throw new IllegalStateException("Unable to restore Blob allocation", e);
            }
        }
        StoreCounters storeCounters = (StoreCounters)this.storeCounters.get().acquire();
        try {
            int nbytes = length;
            if ((long)nbytes > storeCounters.maxReadSize) {
                storeCounters.maxReadSize = nbytes;
            }
        }
        finally {
            storeCounters.release();
        }
        try {
            ByteBuffer bbuf;
            int slotSize = this.getBlock((int)addr).getBlockSize();
            if (slotSize < length) {
                throw new IllegalStateException("Bad Address: length requested greater than allocated slot");
            }
            long paddr = this.physicalAddress((int)addr);
            if (paddr == 0L) {
                this.assertAllocators();
                throw new PhysicalAddressResolutionException(addr);
            }
            assert (paddr > 0L);
            try {
                bbuf = this.m_writeCacheService != null ? this.m_writeCacheService.read(paddr, length) : null;
            }
            catch (Throwable t) {
                throw new IllegalStateException("Error reading from WriteCache addr: " + paddr + " length: " + (length - 4) + ", writeCacheDebug: " + this.m_writeCacheService.addrDebugInfo(paddr), t);
            }
            if (bbuf != null) {
                if (bbuf.limit() != length - 4) {
                    this.assertAllocators();
                    throw new IllegalStateException("Incompatible buffer size for addr: " + paddr + ", " + bbuf.limit() + " != " + (length - 4) + " writeCacheDebug: " + this.m_writeCacheService.addrDebugInfo(paddr));
                }
                byte[] in = bbuf.array();
                for (int i = 0; i < length - 4; ++i) {
                    buf[offset + i] = in[i];
                }
                ++this.m_cacheReads;
                StoreCounters c = (StoreCounters)this.storeCounters.get().acquire();
                try {
                    int nbytes = length;
                    ++c.nreads;
                    c.bytesRead += (long)nbytes;
                    c.elapsedReadNanos += System.nanoTime() - begin;
                    return;
                }
                finally {
                    c.release();
                }
            }
            ByteBuffer bb = ByteBuffer.wrap(buf, offset, length);
            this.readRaw(paddr, bb);
            int chk = ChecksumUtility.getCHK().checksum(buf, offset, length - 4);
            int tstchk = bb.getInt(offset + length - 4);
            if (chk == tstchk) return;
            this.assertAllocators();
            if (this.m_writeCacheService == null) throw new IllegalStateException("Invalid data checksum from address: " + paddr + ", size: " + (length - 4));
            String cacheDebugInfo = this.m_writeCacheService.addrDebugInfo(paddr);
            log.warn((Object)("Invalid data checksum for addr: " + paddr + ", chk: " + chk + ", tstchk: " + tstchk + ", length: " + length + ", first bytes: " + RWStore.toHexString(buf, 32) + ", successful reads: " + this.m_diskReads + ", at last extend: " + this.m_readsAtExtend + ", cacheReads: " + this.m_cacheReads + ", writeCacheDebug: " + cacheDebugInfo));
            throw new IllegalStateException("Invalid data checksum from address: " + paddr + ", size: " + (length - 4));
        }
        catch (PhysicalAddressResolutionException e) {
            throw new IllegalArgumentException("Unable to read data: " + e, e);
        }
        catch (Throwable e) {
            throw new RuntimeException("addr=" + addr + " : cause=" + e, e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAllocators() {
        ReentrantReadWriteLock.ReadLock lock = this.m_allocationReadLock;
        lock.lock();
        try {
            for (int i = 0; i < this.m_allocs.size(); ++i) {
                if (this.m_allocs.get(i).getIndex() == i) continue;
                throw new IllegalStateException("Allocator at invalid index: " + i + ", index  stored as: " + this.m_allocs.get(i).getIndex());
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static String toHexString(byte[] buf, int n) {
        return BytesUtil.toHexString(buf, n);
    }

    @Override
    public void free(long laddr, int sze) {
        this.free(laddr, sze, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(long laddr, int sze, IAllocationContext context) {
        this.assertOpen();
        int addr = (int)laddr;
        switch (addr) {
            case -2: 
            case -1: 
            case 0: {
                return;
            }
        }
        this.m_allocationWriteLock.lock();
        try {
            if (this.m_lockAddresses != null && this.m_lockAddresses.containsKey((int)laddr)) {
                throw new IllegalStateException("address locked: " + laddr);
            }
            if (sze > this.m_maxFixedAlloc - 4) {
                this.freeBlob(addr, sze, context);
            } else {
                FixedAllocator alloc = this.getBlockByAddress(addr);
                if (this.m_minReleaseAge == 0L) {
                    if (context != null) {
                        if (alloc.canImmediatelyFree(addr, sze, context)) {
                            this.immediateFree(addr, sze, true);
                        } else {
                            this.establishContextAllocation(context).deferFree(this.encodeAddr(addr, sze));
                        }
                    } else if (this.isSessionProtected()) {
                        this.immediateFree(addr, sze, false);
                    } else {
                        this.immediateFree(addr, sze);
                    }
                } else {
                    boolean alwaysDefer;
                    boolean bl = alwaysDefer = this.m_activeTxCount > 0;
                    if (!alwaysDefer) {
                        boolean bl2 = alwaysDefer = context == null && !this.m_contexts.isEmpty();
                    }
                    if (alwaysDefer && log.isDebugEnabled()) {
                        log.debug((Object)("Should defer " + addr + " real: " + this.physicalAddress(addr)));
                    }
                    if (alwaysDefer || !alloc.canImmediatelyFree(addr, sze, context)) {
                        this.deferFree(addr, sze);
                    } else {
                        this.immediateFree(addr, sze);
                    }
                }
            }
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    private long encodeAddr(long alloc, int nbytes) {
        alloc <<= 32;
        return alloc += (long)nbytes;
    }

    long getHistoryRetention() {
        return this.m_minReleaseAge;
    }

    boolean isSessionProtected() {
        if (!this.m_allocationWriteLock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.m_minReleaseAge == 0L && (this.m_activeTxCount > 0 || !this.m_contexts.isEmpty());
    }

    private void releaseSessions() {
        assert (this.m_activeTxCount == 0 && this.m_contexts.isEmpty());
        if (this.m_minReleaseAge == 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"RELEASE SESSIONS");
            }
            for (FixedAllocator fa : this.m_allocs) {
                fa.releaseSession(this.m_writeCacheService);
            }
        }
    }

    private boolean freeBlob(int hdr_addr, int sze, IAllocationContext context) {
        if (sze <= this.m_maxFixedAlloc - 4) {
            throw new IllegalArgumentException("Unexpected address size");
        }
        if (this.m_storageStats != null) {
            this.m_storageStats.deleteBlob(sze);
        }
        int alloc = this.m_maxFixedAlloc - 4;
        int blcks = (alloc - 1 + sze) / alloc;
        byte[] hdr = new byte[(blcks + 1) * 4 + 4];
        this.getData((long)hdr_addr, hdr);
        DataInputStream instr = new DataInputStream(new ByteArrayInputStream(hdr, 0, hdr.length - 4));
        try {
            int allocs = instr.readInt();
            int rem = sze;
            for (int i = 0; i < allocs; ++i) {
                int nxt = instr.readInt();
                this.free(nxt, rem < alloc ? rem : alloc);
                rem -= alloc;
            }
            this.free(hdr_addr, hdr.length);
            return true;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private boolean freeImmediateBlob(int hdr_addr, int sze) {
        if (sze <= this.m_maxFixedAlloc - 4) {
            throw new IllegalArgumentException("Unexpected address size");
        }
        if (this.m_storageStats != null) {
            this.m_storageStats.deleteBlob(sze);
        }
        int alloc = this.m_maxFixedAlloc - 4;
        int blcks = (alloc - 1 + sze) / alloc;
        byte[] hdr = new byte[(blcks + 1) * 4 + 4];
        this.getData((long)hdr_addr, hdr);
        DataInputStream instr = new DataInputStream(new ByteArrayInputStream(hdr, 0, hdr.length - 4));
        this.m_allocationWriteLock.lock();
        try {
            int allocs = instr.readInt();
            int rem = sze;
            for (int i = 0; i < allocs; ++i) {
                int nxt = instr.readInt();
                this.immediateFree(nxt, rem <= alloc ? rem : alloc);
                rem -= alloc;
            }
            this.immediateFree(hdr_addr, hdr.length);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    private void immediateFree(int addr, int sze) {
        this.immediateFree(addr, sze, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void immediateFree(int addr, int sze, boolean overrideSession) {
        switch (addr) {
            case -2: 
            case -1: 
            case 0: {
                return;
            }
        }
        if (sze > this.m_maxFixedAlloc - 4) {
            this.freeImmediateBlob(addr, sze);
            return;
        }
        this.m_allocationWriteLock.lock();
        try {
            FixedAllocator alloc = this.getBlockByAddress(addr);
            int addrOffset = this.getOffset(addr);
            if (alloc == null) {
                throw new IllegalArgumentException("Invalid address provided to immediateFree: " + addr + ", size: " + sze);
            }
            long pa = alloc.getPhysicalAddress(addrOffset);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Freeing allocation at " + addr + ", physical address: " + pa));
            }
            alloc.free(addr, sze, overrideSession);
            assert (pa != 0L);
            if (!(!overrideSession && this.isSessionProtected() || alloc.isCommitted(addrOffset))) {
                this.m_writeCacheService.clearWrite(pa, addr);
                this.removeFromExternalCache(pa, alloc.m_size);
            }
            ++this.m_frees;
            if (alloc.isAllocated(addrOffset)) {
                throw new IllegalStateException("Reallocation problem with WriteCache");
            }
            if (alloc.isUnlocked() && !this.m_commitList.contains(alloc)) {
                this.m_commitList.add(alloc);
            }
            this.m_recentAlloc = true;
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    void removeFromExternalCache(long clr, int slotSize) {
        assert (this.m_allocationWriteLock.isHeldByCurrentThread());
        if (this.m_externalCache == null) {
            return;
        }
        if (slotSize == 0 || slotSize == this.m_cachedDatasize) {
            this.m_externalCache.remove(clr);
        }
    }

    public int alloc(int size, IAllocationContext context) {
        if (size > this.m_maxFixedAlloc) {
            throw new IllegalArgumentException("Allocation size to big: " + size + " > " + this.m_maxFixedAlloc);
        }
        this.m_allocationWriteLock.lock();
        try {
            FixedAllocator allocator;
            int i = this.fixedAllocatorIndex(size);
            if (context != null) {
                allocator = this.establishContextAllocation(context).getFreeFixed(i);
            } else {
                int block = 64 * this.m_allocSizes[i];
                this.m_spareAllocation += (long)(block - size);
                ArrayList<FixedAllocator> list = this.m_freeFixed[i];
                if (list.size() == 0) {
                    allocator = new FixedAllocator(this, block);
                    allocator.setFreeList(list);
                    allocator.setIndex(this.m_allocs.size());
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("New FixedAllocator for " + block));
                    }
                    this.m_allocs.add(allocator);
                    if (this.m_storageStats != null) {
                        this.m_storageStats.register(allocator, true);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        int tsti = 0;
                        for (Allocator allocator2 : list) {
                            if (!allocator2.hasFree()) {
                                throw new IllegalStateException("Free list contains full allocator, " + tsti + " of " + list.size());
                            }
                            ++tsti;
                        }
                    }
                    allocator = list.get(0);
                }
            }
            int addr = allocator.alloc(this, size, context);
            if (addr == 0) {
                throw new IllegalStateException("Free Allocator unable to allocate address: " + allocator.getSummaryStats());
            }
            if (allocator.isUnlocked() && !this.m_commitList.contains(allocator)) {
                this.m_commitList.add(allocator);
            }
            this.m_recentAlloc = true;
            long pa = this.physicalAddress(addr);
            if (pa == 0L) {
                throw new IllegalStateException("No physical address found for " + addr);
            }
            ++this.m_allocations;
            this.m_nativeAllocBytes += (long)size;
            int n = addr;
            return n;
        }
        catch (Throwable t) {
            log.error((Object)t, t);
            throw new RuntimeException(t);
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    private int fixedAllocatorIndex(int size) {
        int i = 0;
        int cmp = this.m_minFixedAlloc;
        while (size > cmp) {
            cmp = 64 * this.m_allocSizes[++i];
        }
        return i;
    }

    public PSOutputStream realloc(long oldAddr, int size) {
        this.free(oldAddr, size);
        return PSOutputStream.getNew(this, this.m_maxFixedAlloc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long alloc(byte[] buf, int size, IAllocationContext context) {
        this.m_allocationWriteLock.lock();
        long begin = System.nanoTime();
        if (size > this.m_maxFixedAlloc - 4) {
            if (size > this.getMaxBlobSize()) {
                throw new IllegalArgumentException("Allocation request beyond maximum BLOB of " + this.getMaxBlobSize());
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("BLOB ALLOC: " + size));
            }
            if (this.m_storageStats != null) {
                this.m_storageStats.allocateBlob(size);
            }
            PSOutputStream psout = PSOutputStream.getNew(this, this.m_maxFixedAlloc, context);
            try {
                int i = 0;
                int blocks = size / 512;
                for (int b = 0; b < blocks; ++b) {
                    psout.write(buf, i, 512);
                    i += 512;
                }
                psout.write(buf, i, size - i);
                long l = psout.save();
                return l;
            }
            catch (IOException e) {
                throw new RuntimeException("Closed Store?", e);
            }
            finally {
                try {
                    psout.close();
                }
                catch (IOException ioe) {
                    log.warn((Object)"Unexpected error closing PSOutputStream", (Throwable)ioe);
                }
            }
        }
        int newAddr = this.alloc(size + 4, context);
        if (newAddr == 0) {
            throw new IllegalStateException("NULL address allocated");
        }
        int chk = ChecksumUtility.getCHK().checksum(buf, size);
        long pa = this.physicalAddress(newAddr);
        try {
            this.m_writeCacheService.write(pa, ByteBuffer.wrap(buf, 0, size), chk, true, newAddr);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Closed Store?", e);
        }
        StoreCounters c = (StoreCounters)this.storeCounters.get().acquire();
        try {
            int nwrite = size + 4;
            ++c.nwrites;
            c.bytesWritten += (long)nwrite;
            c.elapsedWriteNanos += System.nanoTime() - begin;
            if ((long)nwrite > c.maxWriteSize) {
                c.maxWriteSize = nwrite;
            }
        }
        finally {
            c.release();
        }
        long l = newAddr;
        return l;
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    public void reset() {
        if (log.isInfoEnabled()) {
            log.info((Object)"RWStore Reset");
        }
        this.m_allocationWriteLock.lock();
        try {
            this.assertOpen();
            CommitState commitState = this.m_commitStateRef.getAndSet(null);
            if (commitState != null) {
                commitState.reset();
            }
            boolean isolatedWrites = false;
            for (FixedAllocator fa : this.m_allocs) {
                isolatedWrites = isolatedWrites || fa.reset(this.m_writeCacheService, this.m_committedNextAllocation);
            }
            this.syncMetaTransients();
            if (!isolatedWrites) {
                int last;
                FixedAllocator fa;
                int origAllocs = this.m_allocs.size();
                while (this.m_allocs.size() > 0 && (fa = this.m_allocs.get(last = this.m_allocs.size() - 1)).getDiskAddr() == 0) {
                    this.m_freeFixed[this.fixedAllocatorIndex(fa.m_size)].remove(fa);
                    this.m_allocs.remove(last);
                }
                this.m_nextAllocation = this.m_committedNextAllocation;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Reset allocators, old: " + origAllocs + ", now: " + this.m_allocs.size()));
                }
                this.m_commitList.clear();
                this.m_recentAlloc = false;
            }
            if (this.m_quorum != null) {
                this.m_writeCacheService.close();
                this.m_writeCacheService = this.newWriteCacheService();
            } else if (this.m_writeCacheService != null) {
                // empty if block
            }
            this.m_deferredFreeOut.reset();
            if (this.m_storageStatsAddr != 0L) {
                this.m_storageStats.reset();
            } else {
                this.m_storageStats = new StorageStats(this.m_allocSizes);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to reset the store", e);
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    private void writeMetaBits() throws IOException {
        long addr;
        byte[] buf = this.genMetabitsData();
        long l = addr = this.m_metaBitsAddr < 0 ? this.physicalAddress(this.m_metaBitsAddr) : (long)this.m_metaBitsAddr << 16;
        if (addr == 0L) {
            throw new IllegalStateException("Invalid metabits address: " + this.m_metaBitsAddr);
        }
        assert (addr > 0L);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("writing metabits at: " + addr));
            }
            this.m_writeCacheService.write(addr, ByteBuffer.wrap(buf), 0, false, this.m_metaBitsAddr < 0 ? this.m_metaBitsAddr : 0);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] genMetabitsData() throws IOException {
        int len = 4 * (27 + this.m_allocSizes.length + this.m_metaBits.length);
        byte[] buf = new byte[len];
        try (FixedOutputStream str = new FixedOutputStream(buf);){
            int i;
            str.writeInt(this.m_metaBitsAddr > 0 ? 1280 : 1024);
            str.writeLong(this.m_lastDeferredReleaseTime);
            str.writeInt(9);
            str.writeInt(this.m_allocSizes.length);
            str.writeLong(this.m_storageStatsAddr);
            for (i = 0; i < 20; ++i) {
                str.writeInt(0);
            }
            for (i = 0; i < this.m_allocSizes.length; ++i) {
                str.writeInt(this.m_allocSizes[i]);
            }
            for (i = 0; i < this.m_metaBits.length; ++i) {
                str.writeInt(this.m_metaBits[i]);
            }
            str.flush();
        }
        return buf;
    }

    public boolean isDirty() {
        return this.requiresCommit();
    }

    void clearCommitStateRef() {
        this.m_commitStateRef.set(null);
    }

    @Override
    public void commit() {
        this.assertOpen();
        this.checkCoreAllocations();
        this.m_allocationWriteLock.lock();
        try {
            if (!this.m_commitStateRef.compareAndSet(null, new CommitState())) {
                throw new IllegalStateException("RWStore commitState found, incomplete previous commit must be rolled back/aborted");
            }
            if (this.m_storageStatsAddr != 0L) {
                int len = (int)(this.m_storageStatsAddr & 0xFFFFL);
                int addr = (int)(this.m_storageStatsAddr >> 16);
                this.immediateFree(addr, len);
            }
            if (this.m_storageStats != null) {
                byte[] buf = this.m_storageStats.getData();
                long addr = this.alloc(buf, buf.length, null);
                this.m_storageStatsAddr = (addr << 16) + (long)buf.length;
            }
            if (this.m_metaBitsAddr > 0) {
                this.m_writeCacheService.removeWriteToAddr(RWStore.convertAddr(-this.m_metaBitsAddr), 0);
            } else {
                int reqmbc = this.getRequiredMetaBitsStorage();
                int nmbaddr = 0;
                if (!this.m_useMetabitsDemispace && reqmbc < this.m_maxFixedAlloc) {
                    nmbaddr = this.alloc(reqmbc, null);
                }
                if (this.m_metaBitsAddr < 0) {
                    int oldMetaBitsSize = (this.m_metaBits.length + this.m_allocSizes.length + 1) * 4;
                    this.immediateFree(this.m_metaBitsAddr, oldMetaBitsSize);
                }
                this.m_metaBitsAddr = nmbaddr;
            }
            if (this.m_metaBitsAddr == 0) {
                while (this.m_nextAllocation % 2 != 0) {
                    --this.m_nextAllocation;
                }
                this.m_metaBitsAddr = -this.m_nextAllocation;
                this.m_nextAllocation -= 2;
                while (this.m_nextAllocation <= this.m_fileSize) {
                    this.extendFile();
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)"Using Demi-space metabits");
                }
            }
            if (this.m_metaBitsAddr > 0) {
                this.m_metaBitsAddr ^= 1;
            }
            if (log.isDebugEnabled()) {
                long mbaddr = this.m_metaBitsAddr < 0 ? this.physicalAddress(this.m_metaBitsAddr) : RWStore.convertAddr(-this.m_metaBitsAddr);
                log.debug((Object)("Writing metabits at " + mbaddr));
            }
            for (FixedAllocator allocator : this.m_commitList) {
                int old = allocator.getDiskAddr();
                this.metaFree(old);
                int naddr = this.metaAlloc();
                allocator.setDiskAddr(naddr);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Update allocator " + allocator.getIndex() + ", old addr: " + old + ", new addr: " + naddr));
                }
                try {
                    this.m_writeCacheService.write(this.metaBit2Addr(naddr), ByteBuffer.wrap(allocator.write()), 0, false, 0);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.writeMetaBits();
            try {
                this.m_writeCacheService.flush(true);
                this.lastBlockSequence = this.m_writeCacheService.resetSequence();
            }
            catch (InterruptedException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
            this.syncMetaTransients();
        }
        catch (IOException e) {
            throw new StorageTerminalError("Unable to commit transaction", e);
        }
        finally {
            this.m_recentAlloc = false;
            this.m_allocationWriteLock.unlock();
        }
        this.checkCoreAllocations();
        if (log.isTraceEnabled()) {
            log.trace((Object)("commitChanges for: " + this.m_nextAllocation + ", " + this.m_metaBitsAddr + ", active contexts: " + this.m_contexts.size()));
        }
        if (log.isDebugEnabled() && this.m_quorum != null && this.m_quorum.isHighlyAvailable()) {
            log.debug((Object)this.showAllocatorList());
        }
    }

    @Override
    public Lock getCommitLock() {
        return this.m_allocationWriteLock;
    }

    @Override
    public void postCommit() {
        if (!this.m_allocationWriteLock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        CommitState commitState = this.m_commitStateRef.getAndSet(null);
        if (commitState == null) {
            throw new IllegalStateException("No current CommitState found on postCommit");
        }
        commitState.postCommit();
        for (FixedAllocator fa : this.m_commitList) {
            fa.postCommit();
        }
        if (this.m_storageStats != null) {
            this.m_storageStats.commit();
        }
        this.m_commitList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkDeferredFrees(AbstractJournal journal) {
        if (journal == null) {
            return 0;
        }
        this.m_allocationWriteLock.lock();
        try {
            if (this.isSessionProtected()) {
                int n = 0;
                return n;
            }
            AbstractTransactionService transactionService = (AbstractTransactionService)journal.getLocalTransactionManager().getTransactionService();
            long lastCommitTime = journal.getLastCommitTime();
            if (lastCommitTime == 0L) {
                int n = 0;
                return n;
            }
            long latestReleasableTime = transactionService.getReleaseTime();
            if (lastCommitTime <= latestReleasableTime) {
                throw new AssertionError((Object)("lastCommitTime=" + lastCommitTime + ", latestReleasableTime=" + latestReleasableTime + ", lastDeferredReleaseTime=" + this.m_lastDeferredReleaseTime + ", activeTxCount=" + this.m_activeTxCount));
            }
            if (txLog.isInfoEnabled()) {
                txLog.info((Object)("RECYCLER: lastCommitTime=" + lastCommitTime + ", latestReleasableTime=" + latestReleasableTime + ", lastDeferredReleaseTime=" + this.m_lastDeferredReleaseTime + ", activeTxCount=" + this.m_activeTxCount));
            }
            if (this.m_lastDeferredReleaseTime >= latestReleasableTime) {
                int n = 0;
                return n;
            }
            int n = this.freeDeferrals(journal, this.m_lastDeferredReleaseTime + 1L, latestReleasableTime);
            return n;
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    private int getRequiredMetaBitsStorage() {
        int ints = 27;
        ints += this.m_allocSizes.length + this.m_metaBits.length;
        int commitInts = (32 + this.m_commitList.size()) / 32;
        int allocBlocks = (8 + commitInts) / 8;
        return (ints += 9 * allocBlocks) * 4;
    }

    protected int allocBlock(int size) {
        if (size <= 0) {
            throw new Error("allocBlock called with zero size request");
        }
        int allocAddr = this.m_nextAllocation;
        this.m_nextAllocation -= size;
        while (RWStore.convertAddr(this.m_nextAllocation) >= RWStore.convertAddr(this.m_fileSize)) {
            this.extendFile();
        }
        this.checkCoreAllocations();
        if (log.isTraceEnabled()) {
            log.trace((Object)("allocation created at " + RWStore.convertAddr(allocAddr) + " for " + RWStore.convertAddr(-size)));
        }
        return allocAddr;
    }

    private void checkCoreAllocations() {
        long lfileSize = RWStore.convertAddr(this.m_fileSize);
        long lnextAlloc = RWStore.convertAddr(this.m_nextAllocation);
        if (lnextAlloc >= lfileSize) {
            throw new IllegalStateException("Core Allocation Error - file size: " + lfileSize + ", nextAlloc: " + lnextAlloc);
        }
    }

    int metaAlloc() {
        int bit = this.fndMetabit();
        if (bit < 0) {
            int nsize = this.m_metaBits.length + 9;
            int[] nbits = new int[nsize];
            int[] ntransients = new int[nsize];
            for (int i = 0; i < this.m_metaBits.length; ++i) {
                nbits[i] = this.m_metaBits[i];
                ntransients[i] = this.m_metaTransientBits[i];
            }
            this.m_metaBits = nbits;
            this.m_metaTransientBits = ntransients;
            this.m_metaBits[this.m_metaBitsSize] = this.m_nextAllocation;
            this.m_nextAllocation -= 8;
            this.m_metaBitsSize = nsize;
            bit = this.fndMetabit();
            assert (bit >= 0);
        }
        RWStore.setBit(this.m_metaTransientBits, bit);
        RWStore.setBit(this.m_metaBits, bit);
        if (this.m_nextAllocation <= this.m_fileSize) {
            if (log.isInfoEnabled()) {
                log.info((Object)"ExtendFile called from metaAlloc");
            }
            this.extendFile();
        }
        this.checkCoreAllocations();
        return bit;
    }

    private int fndMetabit() {
        int blocks = this.m_metaBits.length / 9;
        for (int b = 0; b < blocks; ++b) {
            int ret = RWStore.fndBit(this.m_metaTransientBits, b * 9 + 1, 8);
            if (ret == -1) continue;
            assert (!RWStore.tstBit(this.m_metaBits, ret));
            return ret;
        }
        return -1;
    }

    void metaFree(int bit) {
        if (!this.m_allocationWriteLock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (bit <= 0) {
            return;
        }
        if (RWStore.tstBit(this.m_metaBits, bit)) {
            RWStore.clrBit(this.m_metaBits, bit);
        } else {
            RWStore.clrBit(this.m_metaTransientBits, bit);
        }
        this.m_writeCacheService.clearWrite(this.metaBit2Addr(bit), 0);
    }

    long metaBit2Addr(int bit) {
        int intIndex = bit / 32;
        assert (intIndex % 9 != 0);
        int addrIndex = intIndex / 9 * 9;
        long addr = RWStore.convertAddr(this.m_metaBits[addrIndex]);
        int intOffset = bit - (addrIndex + 1) * 32;
        long ret = addr + (long)(1024 * intOffset);
        return ret;
    }

    public static long convertAddr(int addr) {
        long laddr = addr;
        if (laddr < 0L) {
            long ret = -laddr << 16;
            return ret;
        }
        return laddr & 0xFFFFFFFFFFFFFFF0L;
    }

    public int convertFromAddr(long addr) {
        return (int)(-(addr >> 16));
    }

    private void extendFile() {
        int adjust = -1200 + this.m_fileSize / 10;
        this.extendFile(adjust);
    }

    private void extendFile(int adjust) {
        if (this.m_extendingFile) {
            throw new IllegalStateException("File concurrently extended");
        }
        ReentrantReadWriteLock.WriteLock lock = this.m_extensionLock.writeLock();
        lock.lock();
        try {
            this.m_extendingFile = true;
            this.m_fileSize += adjust;
            long toAddr = RWStore.convertAddr(this.m_fileSize);
            if (this.getMaxFileSize() < toAddr) {
                throw new Error("System greater than maximum size");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Extending file to: " + toAddr));
            }
            this.m_reopener.reopenChannel();
            this.m_reopener.raf.setLength(toAddr);
            ++this.storeCounters.get().ntruncate;
            this.m_writeCacheService.setExtent(toAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)"Extend file done");
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Force Reopen", t);
        }
        finally {
            this.m_extendingFile = false;
            this.m_readsAtExtend = this.m_diskReads;
            lock.unlock();
        }
    }

    static void setBit(int[] bits, int bitnum) {
        int index = bitnum / 32;
        int bit = bitnum % 32;
        int n = index;
        bits[n] = bits[n] | 1 << bit;
    }

    static boolean tstBit(int[] bits, int bitnum) {
        int index = bitnum / 32;
        int bit = bitnum % 32;
        if (index >= bits.length) {
            throw new IllegalArgumentException("Accessing bit index: " + index + " of array length: " + bits.length);
        }
        return (bits[index] & 1 << bit) != 0;
    }

    static void clrBit(int[] bits, int bitnum) {
        int index = bitnum / 32;
        int bit = bitnum % 32;
        int val = bits[index];
        bits[index] = val &= ~(1 << bit);
    }

    static int fndBit(int[] bits, int size) {
        return RWStore.fndBit(bits, 0, size);
    }

    static int fndBit(int[] bits, int offset, int size) {
        int eob = size + offset;
        for (int i = offset; i < eob; ++i) {
            int b = RWStore.fndBit(bits[i]);
            if (b == -1) continue;
            return i * 32 + b;
        }
        return -1;
    }

    static int fndBit(int bits) {
        if (bits != -1) {
            for (int k = 0; k < 32; ++k) {
                if ((bits & 1 << k) != 0) continue;
                return k;
            }
        }
        return -1;
    }

    public void showAllocators(StringBuilder str) {
        this.m_storageStats.showStats(str);
    }

    public boolean verify(long laddr) {
        int addr = (int)laddr;
        if (addr == 0) {
            return false;
        }
        return this.getBlockByAddress(addr) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long physicalAddress(int addr, boolean nocheck) {
        ReentrantReadWriteLock.ReadLock lock = this.m_allocationReadLock;
        lock.lock();
        try {
            long laddr;
            if (addr >= 0) {
                long l = addr & 0xFFFFFFE0;
                return l;
            }
            FixedAllocator allocator = this.getBlock(addr);
            int offset = this.getOffset(addr);
            long l = laddr = allocator.getPhysicalAddress(offset, nocheck);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long physicalAddress(int addr) {
        return this.physicalAddress(addr, false);
    }

    FixedAllocator getBlockByAddress(int addr) {
        if (addr < 0) {
            return this.getBlock(addr);
        }
        Iterator<FixedAllocator> allocs = this.m_allocs.iterator();
        FixedAllocator alloc = null;
        while (allocs.hasNext() && !(alloc = allocs.next()).addressInRange(addr)) {
            alloc = null;
        }
        return alloc;
    }

    private FixedAllocator getBlock(int addr) {
        int index = -addr >>> 13;
        if (index >= this.m_allocs.size()) {
            throw new PhysicalAddressResolutionException(addr);
        }
        return this.m_allocs.get(index);
    }

    private int getOffset(int addr) {
        return -addr & 0x1FFF;
    }

    public boolean isNativeAddress(long addr) {
        return addr <= 0L;
    }

    @Override
    public File getStoreFile() {
        return this.m_fd;
    }

    public boolean requiresCommit() {
        return this.m_recentAlloc;
    }

    public long getMetaBitsAddr() {
        long ret = 0L;
        ret = this.m_metaBitsAddr < 0 ? this.physicalAddress(this.m_metaBitsAddr) : RWStore.convertAddr(-this.m_metaBitsAddr);
        ret <<= 16;
        int metaBitsSize = 27 + this.m_metaBits.length + this.m_allocSizes.length;
        ret += (long)metaBitsSize;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Returning metabitsAddr: " + ret + ", for " + this.m_metaBitsAddr + " - " + this.m_metaBits.length + ", " + metaBitsSize));
        }
        return ret;
    }

    public long getMetaBitsStoreAddress() {
        if (this.m_metaBitsAddr < 0) {
            return this.physicalAddress(this.m_metaBitsAddr);
        }
        return RWStore.convertAddr(-this.m_metaBitsAddr);
    }

    public long getMetaStartAddr() {
        return -this.m_fileSize;
    }

    public long getNextOffset() {
        long ret = -this.m_nextAllocation;
        if (this.m_metaBitsAddr > 0) {
            ++ret;
        }
        ret <<= 32;
        ret += (long)(-this.m_metaBitsAddr);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Returning nextOffset: " + ret + ", for " + this.m_metaBitsAddr));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushWrites(boolean metadata) throws IOException {
        this.assertOpen();
        try {
            this.m_writeCacheService.flush(metadata);
            this.m_reopener.reopenChannel().force(metadata);
            StoreCounters c = (StoreCounters)this.storeCounters.get().acquire();
            try {
                ++c.nforce;
            }
            finally {
                c.release();
            }
        }
        catch (InterruptedException e) {
            throw new ClosedByInterruptException();
        }
    }

    public long getTotalAllocations() {
        return this.m_allocations;
    }

    public long getTotalFrees() {
        return this.m_frees;
    }

    public long getTotalAllocationsSize() {
        return this.m_nativeAllocBytes;
    }

    void addToCommit(FixedAllocator allocator) {
        if (!this.m_commitList.contains(allocator)) {
            this.m_commitList.add(allocator);
        }
    }

    void removeFromCommit(Allocator allocator) {
        this.m_commitList.remove(allocator);
    }

    public Allocator getAllocator(int i) {
        return this.m_allocs.get(i);
    }

    public void establishExtent(long extent) {
        this.assertOpen();
        long currentExtent = RWStore.convertAddr(this.m_fileSize);
        if (extent > currentExtent) {
            this.extendFile(this.convertFromAddr(extent - currentExtent));
        } else if (extent < currentExtent) {
            throw new IllegalArgumentException("Cannot shrink RWStore extent: currentExtent=" + currentExtent + ", fileSize=" + this.m_fileSize + ", newValue=" + extent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFixedAllocatorCount() {
        ReentrantReadWriteLock.ReadLock lock = this.m_allocationReadLock;
        lock.lock();
        try {
            int fixed = 0;
            Iterator<FixedAllocator> allocs = this.m_allocs.iterator();
            while (allocs.hasNext()) {
                if (!(allocs.next() instanceof FixedAllocator)) continue;
                ++fixed;
            }
            int n = fixed;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAllocatedBlocks() {
        ReentrantReadWriteLock.ReadLock lock = this.m_allocationReadLock;
        lock.lock();
        try {
            int allocated = 0;
            for (Allocator allocator : this.m_allocs) {
                if (!(allocator instanceof FixedAllocator)) continue;
                allocated += ((FixedAllocator)allocator).getAllocatedBlocks();
            }
            int n = allocated;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileStorage() {
        ReentrantReadWriteLock.ReadLock lock = this.m_allocationReadLock;
        lock.lock();
        try {
            long allocated = 0L;
            for (FixedAllocator alloc : this.m_allocs) {
                allocated += alloc.getFileStorage();
            }
            long l = allocated;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAllocatedSlots() {
        ReentrantReadWriteLock.ReadLock lock = this.m_allocationReadLock;
        lock.lock();
        try {
            long allocated = 0L;
            for (Allocator allocator : this.m_allocs) {
                if (!(allocator instanceof FixedAllocator)) continue;
                allocated += ((FixedAllocator)allocator).getAllocatedSlots();
            }
            long l = allocated;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public void deferFree(int rwaddr, int sze) {
        this.m_allocationWriteLock.lock();
        try {
            if (sze > this.m_maxFixedAlloc - 4) {
                this.m_deferredFreeOut.writeInt(-rwaddr);
                this.m_deferredFreeOut.writeInt(sze);
            } else {
                this.m_deferredFreeOut.writeInt(rwaddr);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not free: rwaddr=" + rwaddr + ", size=" + sze, e);
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    @Override
    public long saveDeferrals() {
        this.m_allocationWriteLock.lock();
        try {
            if (this.m_deferredFreeOut.getBytesWritten() == 0) {
                long l = 0L;
                return l;
            }
            this.m_deferredFreeOut.writeInt(0);
            int outlen = this.m_deferredFreeOut.getBytesWritten();
            long addr = this.m_deferredFreeOut.save();
            addr <<= 32;
            this.m_deferredFreeOut.reset();
            long l = addr += (long)outlen;
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write to deferred free", e);
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    private int freeDeferrals(long blockAddr, long lastReleaseTime) {
        int addr = (int)(blockAddr >> 32);
        int sze = (int)blockAddr & 0xFFFFFF;
        if (log.isTraceEnabled()) {
            log.trace((Object)("freeDeferrals at " + this.physicalAddress(addr) + ", size: " + sze + " releaseTime: " + lastReleaseTime));
        }
        byte[] buf = new byte[sze + 4];
        this.getData((long)addr, buf);
        DataInputStream strBuf = new DataInputStream(new ByteArrayInputStream(buf));
        this.m_allocationWriteLock.lock();
        int totalFreed = 0;
        try {
            int nxtAddr = strBuf.readInt();
            boolean cnt = false;
            while (nxtAddr != 0) {
                if (nxtAddr > 0) {
                    int bloblen = strBuf.readInt();
                    assert (bloblen > 0);
                    this.immediateFree(-nxtAddr, bloblen);
                } else {
                    this.immediateFree(nxtAddr, 1);
                }
                ++totalFreed;
                nxtAddr = strBuf.readInt();
            }
            this.immediateFree(addr, sze);
            this.m_lastDeferredReleaseTime = lastReleaseTime;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Updated m_lastDeferredReleaseTime=" + this.m_lastDeferredReleaseTime));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Problem freeing deferrals", e);
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
        return totalFreed;
    }

    private int freeDeferrals(AbstractJournal journal, long fromTime, long toTime) {
        CommitRecordIndex commitRecordIndex = journal.getReadOnlyCommitRecordIndex();
        if (commitRecordIndex == null) {
            return 0;
        }
        IndexMetadata metadata = commitRecordIndex.getIndexMetadata();
        byte[] fromKey = metadata.getTupleSerializer().serializeKey(fromTime);
        byte[] toKey = metadata.getTupleSerializer().serializeKey(toTime);
        ITupleIterator commitRecords = commitRecordIndex.rangeIterator(fromKey, toKey);
        int totalFreed = 0;
        int commitPointsRecycled = 0;
        while (commitRecords.hasNext()) {
            ITuple tuple = commitRecords.next();
            CommitRecordIndex.Entry entry = (CommitRecordIndex.Entry)tuple.getObject();
            try {
                ICommitRecord record = CommitRecordSerializer.INSTANCE.deserialize(journal.read(entry.addr));
                long blockAddr = record.getRootAddr(2);
                if (blockAddr != 0L) {
                    totalFreed += this.freeDeferrals(blockAddr, record.getTimestamp());
                }
                ++commitPointsRecycled;
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Problem with entry at " + entry.addr, re);
            }
        }
        int commitPointsRemoved = journal.removeCommitRecordEntries(fromKey, toKey);
        if (txLog.isInfoEnabled()) {
            txLog.info((Object)("RECYCLED: fromTime=" + fromTime + ", toTime=" + toTime + ", totalFreed=" + totalFreed + ", commitPointsRecycled=" + commitPointsRecycled + ", commitPointsRemoved=" + commitPointsRemoved));
        }
        if (commitPointsRecycled != commitPointsRemoved) {
            throw new AssertionError((Object)("commitPointsRecycled=" + commitPointsRecycled + " != commitPointsRemoved=" + commitPointsRemoved));
        }
        return totalFreed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerContext(IAllocationContext context) {
        this.m_allocationWriteLock.lock();
        try {
            this.establishContextAllocation(context);
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachContext(IAllocationContext context) {
        this.assertOpen();
        this.m_allocationWriteLock.lock();
        try {
            ContextAllocation alloc = this.m_contexts.remove(context);
            if (alloc != null) {
                ++this.m_contextRemovals;
            } else {
                throw new IllegalStateException("Multiple call to detachContext");
            }
            alloc.release();
            if (this.m_contexts.isEmpty() && this.m_activeTxCount == 0) {
                this.releaseSessions();
            }
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortContext(IAllocationContext context) {
        this.assertOpen();
        this.m_allocationWriteLock.lock();
        try {
            ContextAllocation alloc = this.m_contexts.remove(context);
            if (alloc != null) {
                ++this.m_contextRemovals;
                alloc.abort();
            }
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    private ContextAllocation establishContextAllocation(IAllocationContext context) {
        assert (this.m_allocationWriteLock.isHeldByCurrentThread());
        ContextAllocation ret = this.m_contexts.get(context);
        if (ret == null) {
            ret = new ContextAllocation(this, this.m_freeFixed.length, null, context);
            if (this.m_contexts.put(context, ret) != null) {
                throw new AssertionError();
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Establish ContextAllocation: " + ret + ", total: " + this.m_contexts.size() + ", requests: " + ++this.m_contextRequests + ", removals: " + this.m_contextRemovals + ", allocators: " + this.m_allocs.size()));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Context: ncontexts=" + this.m_contexts.size() + ", context=" + context));
            }
        }
        return ret;
    }

    @Override
    public int getSlotSize(int data_len) {
        int i = 0;
        int ret = this.m_minFixedAlloc;
        while (data_len > ret) {
            if (++i == this.m_allocSizes.length) {
                return data_len;
            }
            ret = 64 * this.m_allocSizes[i];
        }
        return ret;
    }

    public int getMaxAllocSize() {
        return this.m_maxFixedAlloc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRootBlock(IRootBlockView rootBlock, ForceEnum forceOnCommit) {
        if (rootBlock == null) {
            throw new IllegalArgumentException();
        }
        this.checkRootBlock(rootBlock);
        this.assertOpen();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Writing new rootblock with commitCounter: " + rootBlock.getCommitCounter() + ", commitRecordAddr: " + rootBlock.getCommitRecordAddr() + ", commitRecordIndexAddr: " + rootBlock.getCommitRecordIndexAddr()));
        }
        try {
            ByteBuffer data = rootBlock.asReadOnlyBuffer();
            long pos = rootBlock.isRootBlock0() ? 8L : 348L;
            ReentrantReadWriteLock.ReadLock lock = this.m_extensionLock.readLock();
            lock.lock();
            try {
                FileChannelUtility.writeAll(this.m_reopener, data, pos);
                this.m_reopener.reopenChannel().force(forceOnCommit == ForceEnum.ForceMetadata);
                StoreCounters c = (StoreCounters)this.storeCounters.get().acquire();
                try {
                    ++c.nwriteRootBlock;
                }
                finally {
                    c.release();
                }
                if (this.m_committedNextAllocation != this.m_nextAllocation) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Updating committedNextAllocation from writeRootBlock");
                    }
                    this.m_committedNextAllocation = this.m_nextAllocation;
                }
            }
            finally {
                lock.unlock();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("wrote root block: " + rootBlock));
        }
    }

    public ByteBuffer readRootBlock(boolean rootBlock0) {
        this.assertOpen();
        ByteBuffer tmp = ByteBuffer.allocate(340);
        ReentrantReadWriteLock.ReadLock lock = this.m_extensionLock.readLock();
        lock.lock();
        try {
            FileChannelUtility.readAll(this.m_reopener, tmp, rootBlock0 ? 8L : 348L);
            tmp.position(0);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            lock.unlock();
        }
        return tmp;
    }

    @Override
    public StoreCounters<?> getStoreCounters() {
        return this.storeCounters.get();
    }

    public void setStoreCounters(StoreCounters<?> storeCounters) {
        if (storeCounters == null) {
            throw new IllegalArgumentException();
        }
        this.storeCounters.set(storeCounters);
    }

    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        root.addCounter("extent", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(RWStore.this.getStoreFile().length());
            }
        });
        root.attach(this.storeCounters.get().getCounters());
        if (this.m_writeCacheService != null) {
            CounterSet tmp = root.makePath("writeCache");
            tmp.attach(this.m_writeCacheService.getCounters());
        }
        return root;
    }

    public void writeRawBuffer(IHAWriteMessage msg, IBufferAccess b) throws IOException, InterruptedException {
        final ByteBuffer xb = msg.expand(b.buffer());
        if (log.isTraceEnabled()) {
            log.trace((Object)("expanded buffer, position: " + xb.position() + ", limit: " + xb.limit()));
        }
        IBufferAccess ba = new IBufferAccess(){

            @Override
            public ByteBuffer buffer() {
                return xb;
            }

            @Override
            public void release() throws InterruptedException {
            }

            @Override
            public void release(long timeout, TimeUnit unit) throws InterruptedException {
            }
        };
        WriteCache writeCache = this.m_writeCacheService.newWriteCache(ba, true, true, this.m_reopener, msg.getFileExtent());
        writeCache.closeForWrites();
        ByteBuffer bb = ba.buffer();
        int limit = bb.limit();
        bb.position(limit);
        writeCache.flush(false);
        this.m_writeCacheService.installReads(writeCache);
    }

    public Future<Void> sendHALogBuffer(IHALogRequest req, IHAWriteMessage msg, IBufferAccess buf) throws IOException, InterruptedException {
        ByteBuffer b = buf.buffer();
        assert (b.remaining() > 0) : "Empty buffer: " + b;
        QuorumPipeline quorumMember = (QuorumPipeline)((Object)this.m_quorum.getMember());
        Future<Void> remoteWriteFuture = quorumMember.replicate(req, msg, b);
        return remoteWriteFuture;
    }

    public Future<Void> sendRawBuffer(IHARebuildRequest req, long sequence, long quorumToken, long fileExtent, long offset, int nbytes, ByteBuffer b) throws IOException, InterruptedException {
        ByteBuffer clientBuffer = b;
        clientBuffer.position(0);
        clientBuffer.limit(nbytes);
        this.readRaw(offset, clientBuffer);
        assert (clientBuffer.remaining() > 0) : "Empty buffer: " + clientBuffer;
        QuorumPipeline quorumMember = (QuorumPipeline)((Object)this.m_quorum.getMember());
        int chk = ChecksumUtility.threadChk.get().checksum(b);
        HAWriteMessage msg = new HAWriteMessage(this.m_storeUUID, -1L, -1L, sequence, nbytes, chk, StoreTypeEnum.RW, quorumToken, fileExtent, offset);
        Future<Void> remoteWriteFuture = quorumMember.replicate(req, msg, clientBuffer);
        return remoteWriteFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOnStream(OutputStream os, AbstractJournal.ISnapshotData snapshotData, Quorum<HAGlue, QuorumService<HAGlue>> quorum, long token) throws IOException, QuorumException, InterruptedException {
        try (FileChannelUtility.ReopenerInputStream filein = new FileChannelUtility.ReopenerInputStream(this.m_reopener);){
            MergeStreamWithSnapshotData.process(filein, snapshotData, os);
        }
        if (!quorum.getClient().isJoinedMember(token)) {
            throw new QuorumException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOnStream2(OutputStream os, Set<Map.Entry<Long, byte[]>> snapshotData, Quorum<HAGlue, QuorumService<HAGlue>> quorum, long token) throws IOException, QuorumException {
        IBufferAccess buf = null;
        try {
            long totalBytes;
            try {
                buf = DirectBufferPool.INSTANCE.acquire();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            ByteBuffer b = buf.buffer();
            int bufferCapacity = b.capacity();
            byte[] a = new byte[bufferCapacity];
            int headerSize = 688;
            long fileExtent = this.getStoreFile().length();
            long remaining = totalBytes = fileExtent - 688L;
            long offset = 688L;
            long sequence = 0L;
            if (log.isInfoEnabled()) {
                log.info((Object)("Writing on stream: nbytes=" + totalBytes));
            }
            while (remaining > 0L) {
                int nbytes = (int)Math.min((long)bufferCapacity, remaining);
                if (sequence == 0L && nbytes == bufferCapacity && remaining > (long)bufferCapacity) {
                    nbytes -= 688;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Writing block: sequence=" + sequence + ", offset=" + offset + ", nbytes=" + nbytes));
                }
                ByteBuffer clientBuffer = b;
                clientBuffer.position(0);
                clientBuffer.limit(nbytes);
                this.readRaw(offset, clientBuffer);
                assert (clientBuffer.remaining() > 0) : "Empty buffer: " + clientBuffer;
                if (BytesUtil.toArray(clientBuffer, false, a) != a) {
                    throw new AssertionError();
                }
                os.write(a, 0, nbytes);
                remaining -= (long)nbytes;
                offset += (long)nbytes;
                ++sequence;
                if (quorum.getClient().isJoinedMember(token)) continue;
                throw new QuorumException();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Wrote on stream: #blocks=" + sequence + ", #bytes=" + (fileExtent - 688L)));
            }
        }
        finally {
            if (buf != null) {
                try {
                    buf.release();
                }
                catch (InterruptedException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer readRaw(long offset, ByteBuffer dst) {
        ReentrantReadWriteLock.ReadLock lock = this.m_extensionLock.readLock();
        lock.lock();
        try {
            int position = dst.position();
            try {
                long beginDisk = System.nanoTime();
                long pos = offset;
                int length = dst.limit();
                int ndiskRead = FileChannelUtility.readAll(this.m_reopener, dst, pos);
                this.m_diskReads += (long)ndiskRead;
                long now = System.nanoTime();
                StoreCounters c = (StoreCounters)this.storeCounters.get().acquire();
                try {
                    c.ndiskRead += (long)ndiskRead;
                    int nbytes = length;
                    ++c.nreads;
                    c.bytesRead += (long)nbytes;
                    c.bytesReadFromDisk += (long)nbytes;
                    c.elapsedReadNanos += now - beginDisk;
                    c.elapsedDiskReadNanos += now - beginDisk;
                }
                finally {
                    c.release();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            dst.position(position);
            ByteBuffer byteBuffer = dst;
            return byteBuffer;
        }
        finally {
            lock.unlock();
        }
    }

    public int getMaxBlobSize() {
        return 0x7FFFFFFB;
    }

    public StorageStats getStorageStats() {
        return this.m_storageStats;
    }

    @Override
    public IRawTx newTx() {
        return new RawTx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateTx() {
        this.m_allocationWriteLock.lock();
        try {
            ++this.m_activeTxCount;
            if (log.isInfoEnabled()) {
                log.info((Object)("#activeTx=" + this.m_activeTxCount));
            }
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateTx() {
        this.m_allocationWriteLock.lock();
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Deactivating TX " + this.m_activeTxCount));
            }
            if (this.m_activeTxCount == 0) {
                throw new IllegalStateException("Tx count must be positive!");
            }
            --this.m_activeTxCount;
            if (log.isInfoEnabled()) {
                log.info((Object)("#activeTx=" + this.m_activeTxCount));
            }
            if (this.m_activeTxCount == 0 && this.m_contexts.isEmpty()) {
                this.releaseSessions();
            }
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveTxCount() {
        this.m_allocationWriteLock.lock();
        try {
            int n = this.m_activeTxCount;
            return n;
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    @Override
    public int getAssociatedSlotSize(int addr) {
        return this.getBlock(addr).getBlockSize();
    }

    public void lockAddress(int addr) {
        if (this.m_lockAddresses.putIfAbsent(addr, System.currentTimeMillis()) != null) {
            throw new IllegalStateException("address already locked, logical: " + addr + ", physical: " + this.physicalAddress(addr, true));
        }
    }

    public void showWriteCacheDebug(long paddr) {
        log.warn((Object)("WriteCacheDebug: " + paddr + " - " + this.m_writeCacheService.addrDebugInfo(paddr)));
    }

    public CounterSet getWriteCacheCounters() {
        return this.m_writeCacheService.getCounters();
    }

    @Override
    public long getLastReleaseTime() {
        return this.m_lastDeferredReleaseTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerExternalCache(ConcurrentWeakValueCache<Long, ICommitter> externalCache, int dataSize) {
        this.m_allocationWriteLock.lock();
        try {
            this.m_externalCache = externalCache;
            this.m_cachedDatasize = this.getSlotSize(dataSize);
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCommitted(int rwaddr) {
        ReentrantReadWriteLock.WriteLock lock = this.m_allocationWriteLock;
        lock.lock();
        try {
            FixedAllocator alloc = this.getBlockByAddress(rwaddr);
            int offset = this.getOffset(rwaddr);
            boolean bl = alloc.isCommitted(offset);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean inWriteCache(int rwaddr) {
        return this.m_writeCacheService.isPresent(this.physicalAddress(rwaddr, true));
    }

    @Override
    public InputStream getInputStream(long addr) {
        return new PSInputStream(this, addr);
    }

    @Override
    public IPSOutputStream getOutputStream() {
        return this.getOutputStream(null);
    }

    public IPSOutputStream getOutputStream(IAllocationContext context) {
        return PSOutputStream.getNew(this, this.m_maxFixedAlloc, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFromHARootBlock(IRootBlockView rootBlock) {
        ReentrantReadWriteLock.WriteLock outerLock = this.m_allocationWriteLock;
        outerLock.lock();
        try {
            ReentrantReadWriteLock.WriteLock innerLock = this.m_extensionLock.writeLock();
            innerLock.lock();
            try {
                this.m_allocs.clear();
                assert (this.m_nextAllocation != 0);
                this.m_nextAllocation = 0;
                this.initfromRootBlock(rootBlock);
                this.m_externalCache.clear();
                assert (this.m_nextAllocation != 0);
            }
            finally {
                innerLock.unlock();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            outerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postHACommit(IRootBlockView rbv) {
        ReentrantReadWriteLock.WriteLock outerLock = this.m_allocationWriteLock;
        outerLock.lock();
        try {
            ReentrantReadWriteLock.WriteLock innerLock = this.m_extensionLock.writeLock();
            innerLock.lock();
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"POSTHACOMMIT START");
                    for (int index = 0; index < this.m_allocs.size(); ++index) {
                        FixedAllocator xfa = this.m_allocs.get(index);
                        log.trace((Object)("Allocator " + index + ", size: " + xfa.m_size + ", startAddress: " + xfa.getStartAddr() + ", allocated: " + xfa.getAllocatedSlots() / (long)xfa.m_size));
                    }
                }
                long nxtOffset = rbv.getNextOffset();
                this.m_nextAllocation = -((int)(nxtOffset >> 32));
                if (this.m_nextAllocation == 0) {
                    throw new IllegalStateException("Invalid state for non-empty store");
                }
                this.m_committedNextAllocation = this.m_nextAllocation;
                this.m_metaBitsAddr = -((int)nxtOffset);
                ArrayList<FixedAllocator> nallocs = new ArrayList<FixedAllocator>();
                int[] oldmetabits = this.m_metaBits;
                RootBlockInfo rbi = new RootBlockInfo(rbv, this.m_reopener);
                this.m_metaBits = rbi.m_metabits;
                this.m_lastDeferredReleaseTime = rbi.m_lastDeferredReleaseTime;
                this.m_storageStatsAddr = rbi.m_storageStatsAddr;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Metabits length: " + this.m_metaBits.length));
                }
                if (oldmetabits.length % 9 != 0) {
                    throw new AssertionError();
                }
                if (this.m_metaBits.length % 9 != 0) {
                    throw new AssertionError((Object)("New metabits: " + this.m_metaBits.length + ", old: " + oldmetabits.length));
                }
                if (this.m_metaBits.length < oldmetabits.length) {
                    throw new AssertionError();
                }
                int[] moddedBits = (int[])this.m_metaBits.clone();
                for (int b = 0; b < oldmetabits.length; b += 9) {
                    for (int i = 1; i < 9; ++i) {
                        int n = b + i;
                        moddedBits[n] = moddedBits[n] & ~oldmetabits[b + i];
                    }
                }
                if (log.isTraceEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    Iterator<Map.Entry<Long, WeakReference<ICommitter>>> entries = this.m_externalCache.entryIterator();
                    while (entries.hasNext()) {
                        sb.append(entries.next().getKey() + "|");
                    }
                    log.trace((Object)("External Cache Start Size: " + this.m_externalCache.size() + ", entries: " + sb.toString()));
                }
                int modCount = 0;
                int totalFreed = 0;
                for (int i = 0; i < moddedBits.length; i += 9) {
                    long startAddr = RWStore.convertAddr(this.m_metaBits[i]);
                    for (int j = 1; j < 9; ++j) {
                        int chkbits = moddedBits[i + j];
                        for (int b = 0; b < 32; ++b) {
                            if ((chkbits & 1 << b) == 0) continue;
                            ++modCount;
                            int bit = b + 32 * (j - 1);
                            long paddr = startAddr + (long)(bit * 1024);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Allocator at: " + paddr));
                            }
                            int metaBit = (i + j) * 32 + b;
                            FixedAllocator nalloc = this.readAllocator(paddr);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Allocator read of size: " + nalloc.m_size + ", metaBit: " + metaBit));
                            }
                            nalloc.setDiskAddr(metaBit);
                            boolean found = false;
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Checking allocator at " + nalloc.getStartAddr()));
                            }
                            for (int index = 0; !found && index < this.m_allocs.size(); ++index) {
                                FixedAllocator xfa = this.m_allocs.get(index);
                                if (xfa.getStartAddr() != nalloc.getStartAddr()) continue;
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("Found updated allocator at " + index + ", size: " + xfa.m_size + " vs " + nalloc.m_size + ", allocated slots: " + xfa.getAllocatedSlots() / (long)xfa.m_size + " vs " + nalloc.getAllocatedSlots() / (long)xfa.m_size));
                                }
                                found = true;
                                this.m_allocs.set(index, nalloc);
                                nalloc.setIndex(index);
                                xfa.removeFromFreeList();
                                totalFreed += nalloc.removeFreedWrites(xfa, this.m_externalCache);
                            }
                            if (found) continue;
                            nallocs.add(nalloc);
                        }
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Released: " + totalFreed + " addresses from " + modCount + " modified Allocators"));
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("OLD BITS: " + BytesUtil.toHexString(oldmetabits)));
                    log.trace((Object)("NEW BITS: " + BytesUtil.toHexString(this.m_metaBits)));
                    log.trace((Object)("MODDED BITS: " + BytesUtil.toHexString(moddedBits)));
                    log.trace((Object)("MODDED COUNT: " + modCount + " from " + this.m_allocs.size() + " Allocators"));
                }
                if (nallocs.size() > 0) {
                    Collections.sort(nallocs);
                    int sindex = this.m_allocs.size();
                    for (int index = 0; index < nallocs.size(); ++index) {
                        ((Allocator)nallocs.get(index)).setIndex(sindex + index);
                        if (!log.isTraceEnabled()) continue;
                        log.trace((Object)("New Allocator, index: " + (sindex + index)));
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Adding new allocators: " + sindex));
                    }
                    this.m_allocs.addAll(nallocs);
                }
                long nxtOffset2 = rbv.getNextOffset();
                this.m_nextAllocation = -((int)(nxtOffset2 >> 32));
                if (this.m_nextAllocation == 0) {
                    this.m_nextAllocation = -9;
                }
                this.m_committedNextAllocation = this.m_nextAllocation;
                if (log.isTraceEnabled()) {
                    log.trace((Object)"POSTHACOMMIT END");
                    for (int index = 0; index < this.m_allocs.size(); ++index) {
                        FixedAllocator xfa = this.m_allocs.get(index);
                        log.trace((Object)("Allocator " + index + ", startAddress: " + xfa.getStartAddr() + ", allocated: " + xfa.getAllocatedSlots()));
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("External Cache Pre Clear Size: " + this.m_externalCache.size()));
                }
                assert (this.m_nextAllocation != 0);
            }
            finally {
                innerLock.unlock();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            outerLock.unlock();
        }
    }

    public DeleteBlockStats checkDeleteBlocks(AbstractJournal journal) {
        DeleteBlockStats stats = new DeleteBlockStats();
        CommitRecordIndex commitRecordIndex = journal.getReadOnlyCommitRecordIndex();
        if (commitRecordIndex == null) {
            return stats;
        }
        ITupleIterator commitRecords = commitRecordIndex.rangeIterator();
        while (commitRecords.hasNext()) {
            ITuple tuple = commitRecords.next();
            CommitRecordIndex.Entry entry = (CommitRecordIndex.Entry)tuple.getObject();
            try {
                ICommitRecord record = CommitRecordSerializer.INSTANCE.deserialize(journal.read(entry.addr));
                long blockAddr = record.getRootAddr(2);
                if (blockAddr != 0L) {
                    this.checkDeferrals(blockAddr, record.getTimestamp(), stats);
                }
                stats.m_commitRecords++;
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Problem with entry at " + entry.addr, re);
            }
        }
        return stats;
    }

    private void checkDeferrals(long blockAddr, long commitTime, DeleteBlockStats stats) {
        boolean writeAll = false;
        int addr = (int)(blockAddr >> 32);
        int sze = (int)blockAddr & 0xFFFFFF;
        if (log.isTraceEnabled()) {
            log.trace((Object)("freeDeferrals at " + this.physicalAddress(addr) + ", size: " + sze + " releaseTime: " + commitTime));
        }
        byte[] buf = new byte[sze + 4];
        this.getData((long)addr, buf);
        DataInputStream strBuf = new DataInputStream(new ByteArrayInputStream(buf));
        this.m_allocationWriteLock.lock();
        try {
            int nxtAddr = strBuf.readInt();
            while (nxtAddr != 0) {
                stats.m_addresses++;
                if (nxtAddr > 0) {
                    stats.m_blobs++;
                    int bloblen = strBuf.readInt();
                    assert (bloblen > 0);
                    nxtAddr = -nxtAddr;
                }
                if (!this.isCommitted(nxtAddr)) {
                    stats.m_badAddresses++;
                }
                if (stats.m_freed.containsKey(nxtAddr)) {
                    stats.m_duplicates.add(nxtAddr);
                } else {
                    stats.m_freed.put(nxtAddr, nxtAddr);
                }
                nxtAddr = strBuf.readInt();
            }
            assert (this.isCommitted(addr));
        }
        catch (IOException e) {
            throw new RuntimeException("Problem checking deferrals: " + e, e);
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] readFromLatchedAddress(int nxtAddr) throws IOException {
        ReentrantReadWriteLock.ReadLock outerLock = this.m_allocationReadLock;
        try {
            FixedAllocator alloc = this.getBlockByAddress(nxtAddr);
            byte[] data = new byte[alloc.m_size];
            ByteBuffer bb = ByteBuffer.wrap(data);
            int offset = this.getOffset(nxtAddr);
            long paddr = alloc.getPhysicalAddress(offset);
            ReentrantReadWriteLock.ReadLock innerLock = this.m_extensionLock.readLock();
            try {
                FileChannelUtility.readAll(this.m_reopener, bb, paddr);
            }
            finally {
                innerLock.unlock();
            }
            byte[] byArray = data;
            return byArray;
        }
        finally {
            outerLock.unlock();
        }
    }

    public long getBlockSequence() {
        return this.lastBlockSequence;
    }

    public long getCurrentBlockSequence() {
        RWWriteCacheService tmp = this.m_writeCacheService;
        if (tmp == null) {
            return 0L;
        }
        return tmp.getSequence();
    }

    public void computeDigest(Object snapshot, MessageDigest digest) throws DigestException, IOException {
        this.computeDigestOld(snapshot, digest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeDigestOld(Object snapshot, MessageDigest digest) throws DigestException, IOException {
        if (snapshot != null) {
            throw new UnsupportedOperationException();
        }
        IBufferAccess buf = null;
        try {
            long fileExtent;
            long totalBytes;
            try {
                buf = DirectBufferPool.INSTANCE.acquire();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            ByteBuffer b = buf.buffer();
            int bufferCapacity = b.capacity();
            long remaining = totalBytes = (fileExtent = this.getStoreFile().length());
            long offset = 0L;
            long sequence = 0L;
            if (log.isInfoEnabled()) {
                log.info((Object)("Computing digest: nbytes=" + totalBytes));
            }
            while (remaining > 0L) {
                int nbytes = (int)Math.min((long)bufferCapacity, remaining);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Computing digest: sequence=" + sequence + ", offset=" + offset + ", nbytes=" + nbytes));
                }
                b.position(0);
                b.limit(nbytes);
                this.readRaw(offset, b);
                digest.update(b);
                remaining -= (long)nbytes;
                offset += (long)nbytes;
                ++sequence;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Computed digest: #blocks=" + sequence + ", #bytes=" + totalBytes));
            }
            return;
        }
        finally {
            if (buf != null) {
                try {
                    buf.release();
                }
                catch (InterruptedException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeDigestAlt(Object snapshot, MessageDigest digest) throws DigestException, IOException {
        if (snapshot != null) {
            throw new UnsupportedOperationException();
        }
        this.m_allocationWriteLock.lock();
        try {
            for (FixedAllocator fa : this.m_allocs) {
                fa.computeDigest(snapshot, digest);
            }
        }
        finally {
            this.m_allocationWriteLock.unlock();
        }
        byte[] data = digest.digest();
        StringBuffer sb = new StringBuffer();
        for (byte b : data) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(b);
        }
        log.warn((Object)("STORE DIGEST: " + sb.toString()));
        log.warn((Object)("Free Deferrals: " + this.m_deferredFreeOut.getBytesWritten()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRaw(long offset, ByteBuffer transfer) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeRaw: " + offset));
        }
        ReentrantReadWriteLock.ReadLock lock = this.m_extensionLock.readLock();
        lock.lock();
        try {
            FileChannelUtility.writeAll(this.m_reopener, transfer, offset);
        }
        finally {
            lock.unlock();
        }
    }

    private String showAllocatorList() {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < this.m_allocs.size(); ++index) {
            FixedAllocator xfa = this.m_allocs.get(index);
            sb.append("Allocator " + index + ", size: " + xfa.m_size + ", startAddress: " + xfa.getStartAddr() + ", allocated: " + xfa.getAllocatedSlots() + "\n");
        }
        return sb.toString();
    }

    public boolean verifyAllocatedAddress(long addr) {
        for (int index = 0; index < this.m_allocs.size(); ++index) {
            FixedAllocator xfa = this.m_allocs.get(index);
            if (!xfa.verifyAllocatedAddress(addr)) continue;
            return true;
        }
        return false;
    }

    public StoreState getStoreState() {
        RWStoreState ret = new RWStoreState(this);
        return ret;
    }

    public boolean ensureMetabitsDemispace(boolean useDemispace) {
        boolean isDemispace;
        boolean bl = isDemispace = this.m_metaBitsAddr > 0;
        if (isDemispace != useDemispace || this.m_useMetabitsDemispace != useDemispace) {
            this.m_useMetabitsDemispace = useDemispace;
            this.m_metaBitsAddr = 0;
            this.m_recentAlloc = true;
            return true;
        }
        return false;
    }

    public boolean isUsingDemiSpace() {
        return this.m_metaBitsAddr > 0;
    }

    public void snapshotMetabits(AbstractJournal.ISnapshotData tm) throws IOException {
        long mba = this.m_metaBitsAddr < 0 ? this.physicalAddress(this.m_metaBitsAddr) : RWStore.convertAddr(-this.m_metaBitsAddr);
        tm.put(mba, this.genMetabitsData());
    }

    public void snapshotAllocators(AbstractJournal.ISnapshotData tm) {
        for (FixedAllocator alloc : this.m_allocs) {
            alloc.snapshot(tm);
        }
    }

    public static class RWStoreState
    implements StoreState {
        private static final long serialVersionUID = 4315400143557397323L;
        private final int m_fileSize;
        private final int m_nextAllocation;
        private final int m_committedNextAllocation;
        private final long m_minReleaseAge;
        private final long m_lastDeferredReleaseTime;
        private final long m_storageStatsAddr;
        private final int m_allocsSize;
        private final int m_metaBitsAddr;
        private final int m_metaBitsSize;

        private RWStoreState(RWStore store) {
            this.m_fileSize = store.m_fileSize;
            this.m_nextAllocation = store.m_nextAllocation;
            this.m_committedNextAllocation = store.m_committedNextAllocation;
            this.m_minReleaseAge = store.m_minReleaseAge;
            this.m_lastDeferredReleaseTime = store.m_lastDeferredReleaseTime;
            this.m_storageStatsAddr = store.m_storageStatsAddr;
            this.m_allocsSize = store.m_allocs.size();
            this.m_metaBitsAddr = store.m_metaBitsAddr;
            this.m_metaBitsSize = store.m_metaBits.length;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof RWStoreState)) {
                return false;
            }
            RWStoreState other = (RWStoreState)obj;
            return this.m_fileSize == other.m_fileSize && this.m_nextAllocation == other.m_nextAllocation && this.m_committedNextAllocation == other.m_committedNextAllocation && this.m_minReleaseAge == other.m_minReleaseAge && this.m_lastDeferredReleaseTime == other.m_lastDeferredReleaseTime && this.m_storageStatsAddr == other.m_storageStatsAddr && this.m_allocsSize == other.m_allocsSize && this.m_metaBitsAddr == other.m_metaBitsAddr && this.m_metaBitsSize == other.m_metaBitsSize;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("RWStoreState\n");
            sb.append("fileSize: " + this.m_fileSize + "\n");
            sb.append("nextAllocation: " + this.m_nextAllocation + "\n");
            sb.append("committedNextAllocation: " + this.m_committedNextAllocation + "\n");
            sb.append("minReleaseAge: " + this.m_minReleaseAge + "\n");
            sb.append("lastDeferredReleaseTime: " + this.m_lastDeferredReleaseTime + "\n");
            sb.append("storageStatsAddr: " + this.m_storageStatsAddr + "\n");
            sb.append("allocsSize: " + this.m_allocsSize + "\n");
            sb.append("metaBitsAddr: " + this.m_metaBitsAddr + "\n");
            sb.append("metaBitsSize: " + this.m_metaBitsSize + "\n");
            return sb.toString();
        }
    }

    public static class DeleteBlockStats {
        private int m_commitRecords = 0;
        private int m_addresses = 0;
        private int m_blobs = 0;
        private int m_badAddresses = 0;
        private final HashMap<Integer, Integer> m_freed = new HashMap();
        private final Set<Integer> m_duplicates = new LinkedHashSet<Integer>();

        public int getCommitRecords() {
            return this.m_commitRecords;
        }

        public int getAddresses() {
            return this.m_addresses;
        }

        public int getBadAddresses() {
            return this.m_badAddresses;
        }

        public Set<Integer> getDuplicateAddresses() {
            return this.m_duplicates;
        }

        public String toString(RWStore store) {
            StringBuilder sb = new StringBuilder();
            sb.append("CommitRecords: " + this.m_commitRecords + ", Addresses: " + this.m_addresses + ", Blobs: " + this.m_blobs + ", bad: " + this.m_badAddresses);
            if (!this.m_duplicates.isEmpty()) {
                for (int latchedAddr : this.m_duplicates) {
                    sb.append("\nDuplicate: latchedAddr=" + latchedAddr + "\n");
                }
            }
            return sb.toString();
        }
    }

    private final class RawTx
    implements IRawTx {
        private final AtomicBoolean m_open = new AtomicBoolean(true);

        RawTx() {
            RWStore.this.activateTx();
        }

        @Override
        public void close() {
            if (this.m_open.compareAndSet(true, false)) {
                RWStore.this.deactivateTx();
            }
        }
    }

    public static class StoreCounters<T extends StoreCounters<T>>
    extends StripedCounters<T> {
        public volatile long nreads;
        public volatile long ndiskRead;
        public volatile long bytesRead;
        public volatile long bytesReadFromDisk;
        public volatile long elapsedReadNanos;
        public volatile long elapsedDiskReadNanos;
        public volatile long checksumErrorCount;
        public volatile long nwrites;
        public volatile long maxReadSize;
        public volatile long maxWriteSize;
        public volatile long bytesWritten;
        public volatile long elapsedWriteNanos;
        public volatile long nforce;
        public volatile long ntruncate;
        public volatile long nreopen;
        public volatile long nwriteRootBlock;
        public volatile long bufferDataBytes;
        public volatile long bufferDataWrites;
        public volatile long bufferFileWrites;

        public StoreCounters() {
        }

        public StoreCounters(int batchSize) {
            super(batchSize);
        }

        public StoreCounters(int nstripes, int batchSize) {
            super(nstripes, batchSize);
        }

        @Override
        public void add(T o) {
            super.add(o);
            this.nreads += ((StoreCounters)o).nreads;
            this.ndiskRead += ((StoreCounters)o).ndiskRead;
            this.bytesRead += ((StoreCounters)o).bytesRead;
            this.bytesReadFromDisk += ((StoreCounters)o).bytesReadFromDisk;
            this.maxReadSize = Math.max(this.maxReadSize, ((StoreCounters)o).maxReadSize);
            this.elapsedReadNanos += ((StoreCounters)o).elapsedReadNanos;
            this.elapsedDiskReadNanos += ((StoreCounters)o).elapsedDiskReadNanos;
            this.checksumErrorCount += ((StoreCounters)o).checksumErrorCount;
            this.nwrites += ((StoreCounters)o).nwrites;
            this.maxWriteSize = Math.max(this.maxWriteSize, ((StoreCounters)o).maxWriteSize);
            this.bytesWritten += ((StoreCounters)o).bytesWritten;
            this.elapsedWriteNanos += ((StoreCounters)o).elapsedWriteNanos;
            this.nforce += ((StoreCounters)o).nforce;
            this.ntruncate += ((StoreCounters)o).ntruncate;
            this.nreopen += ((StoreCounters)o).nreopen;
            this.nwriteRootBlock += ((StoreCounters)o).nwriteRootBlock;
        }

        @Override
        public T subtract(T o) {
            StoreCounters t = (StoreCounters)super.subtract(o);
            t.nreads -= ((StoreCounters)o).nreads;
            t.ndiskRead -= ((StoreCounters)o).ndiskRead;
            t.bytesRead -= ((StoreCounters)o).bytesRead;
            t.bytesReadFromDisk -= ((StoreCounters)o).bytesReadFromDisk;
            t.maxReadSize -= ((StoreCounters)o).maxReadSize;
            t.elapsedReadNanos -= ((StoreCounters)o).elapsedReadNanos;
            t.elapsedDiskReadNanos -= ((StoreCounters)o).elapsedDiskReadNanos;
            t.checksumErrorCount -= ((StoreCounters)o).checksumErrorCount;
            t.nwrites -= ((StoreCounters)o).nwrites;
            t.maxWriteSize -= ((StoreCounters)o).maxWriteSize;
            t.bytesWritten -= ((StoreCounters)o).bytesWritten;
            t.elapsedWriteNanos -= ((StoreCounters)o).elapsedWriteNanos;
            t.nforce -= ((StoreCounters)o).nforce;
            t.ntruncate -= ((StoreCounters)o).ntruncate;
            t.nreopen -= ((StoreCounters)o).nreopen;
            t.nwriteRootBlock -= ((StoreCounters)o).nwriteRootBlock;
            return (T)t;
        }

        @Override
        public void clear() {
            this.nreads = 0L;
            this.ndiskRead = 0L;
            this.bytesRead = 0L;
            this.bytesReadFromDisk = 0L;
            this.maxReadSize = 0L;
            this.elapsedReadNanos = 0L;
            this.elapsedDiskReadNanos = 0L;
            this.checksumErrorCount = 0L;
            this.nwrites = 0L;
            this.maxWriteSize = 0L;
            this.bytesWritten = 0L;
            this.elapsedWriteNanos = 0L;
            this.nforce = 0L;
            this.ntruncate = 0L;
            this.nreopen = 0L;
            this.nwriteRootBlock = 0L;
        }

        @Override
        public CounterSet getCounters() {
            CounterSet root = super.getCounters();
            root.addCounter("nreads", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.nreads);
                }
            });
            root.addCounter("bytesRead", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.bytesRead);
                }
            });
            root.addCounter("readSecs", new Instrument<Double>(){

                @Override
                public void sample() {
                    double elapsedReadSecs = (double)StoreCounters.this.elapsedReadNanos / 1.0E9;
                    this.setValue(elapsedReadSecs);
                }
            });
            root.addCounter("bytesReadPerSec", new Instrument<Double>(){

                @Override
                public void sample() {
                    double readSecs = (double)StoreCounters.this.elapsedReadNanos / 1.0E9;
                    double bytesReadPerSec = readSecs == 0.0 ? 0.0 : (double)StoreCounters.this.bytesRead / readSecs;
                    this.setValue(bytesReadPerSec);
                }
            });
            root.addCounter("maxReadSize", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.maxReadSize);
                }
            });
            root.addCounter("checksumErrorCount", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.checksumErrorCount);
                }
            });
            root.addCounter("nwrites", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.nwrites);
                }
            });
            root.addCounter("bytesWritten", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.bytesWritten);
                }
            });
            root.addCounter("writeSecs", new Instrument<Double>(){

                @Override
                public void sample() {
                    double writeSecs = (double)StoreCounters.this.elapsedWriteNanos / 1.0E9;
                    this.setValue(writeSecs);
                }
            });
            root.addCounter("bytesWrittenPerSec", new Instrument<Double>(){

                @Override
                public void sample() {
                    double writeSecs = (double)StoreCounters.this.elapsedWriteNanos / 1.0E9;
                    double bytesWrittenPerSec = writeSecs == 0.0 ? 0.0 : (double)StoreCounters.this.bytesWritten / writeSecs;
                    this.setValue(bytesWrittenPerSec);
                }
            });
            root.addCounter("maxWriteSize", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.maxWriteSize);
                }
            });
            CounterSet bc = root.makePath("buffer");
            bc.addCounter("ndataWrites", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.bufferDataWrites);
                }
            });
            bc.addCounter("nfileWrites", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.bufferFileWrites);
                }
            });
            CounterSet disk = root.makePath("disk");
            disk.addCounter("nreads", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.ndiskRead);
                }
            });
            disk.addCounter("bytesRead", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.bytesReadFromDisk);
                }
            });
            disk.addCounter("bytesPerRead", new Instrument<Double>(){

                @Override
                public void sample() {
                    double bytesPerDiskRead = StoreCounters.this.ndiskRead == 0L ? 0.0 : (double)StoreCounters.this.bytesReadFromDisk / (double)StoreCounters.this.ndiskRead;
                    this.setValue(bytesPerDiskRead);
                }
            });
            disk.addCounter("readSecs", new Instrument<Double>(){

                @Override
                public void sample() {
                    double diskReadSecs = (double)StoreCounters.this.elapsedDiskReadNanos / 1.0E9;
                    this.setValue(diskReadSecs);
                }
            });
            disk.addCounter("bytesReadPerSec", new Instrument<Double>(){

                @Override
                public void sample() {
                    double diskReadSecs = (double)StoreCounters.this.elapsedDiskReadNanos / 1.0E9;
                    double bytesReadPerSec = diskReadSecs == 0.0 ? 0.0 : (double)StoreCounters.this.bytesReadFromDisk / diskReadSecs;
                    this.setValue(bytesReadPerSec);
                }
            });
            disk.addCounter("secsPerRead", new Instrument<Double>(){

                @Override
                public void sample() {
                    double diskReadSecs = (double)StoreCounters.this.elapsedDiskReadNanos / 1.0E9;
                    double readLatency = diskReadSecs == 0.0 ? 0.0 : diskReadSecs / (double)StoreCounters.this.ndiskRead;
                    this.setValue(readLatency);
                }
            });
            disk.addCounter("nforce", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.nforce);
                }
            });
            disk.addCounter("nextend", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.ntruncate);
                }
            });
            disk.addCounter("nreopen", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.nreopen);
                }
            });
            disk.addCounter("rootBlockWrites", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(StoreCounters.this.nwriteRootBlock);
                }
            });
            return root;
        }
    }

    static class ContextAllocation {
        private final RWStore m_store;
        private final ArrayList<FixedAllocator>[] m_freeFixed;
        private final ArrayList<FixedAllocator> m_allFixed;
        private final ArrayList<Long> m_deferredFrees;
        private final ContextAllocation m_parent;
        private final IAllocationContext m_context;

        ContextAllocation(RWStore store, int fixedBlocks, ContextAllocation parent, IAllocationContext acontext) {
            this.m_store = store;
            this.m_parent = parent;
            this.m_context = acontext;
            this.m_freeFixed = new ArrayList[fixedBlocks];
            for (int i = 0; i < this.m_freeFixed.length; ++i) {
                this.m_freeFixed[i] = new ArrayList();
            }
            this.m_allFixed = new ArrayList();
            this.m_deferredFrees = new ArrayList();
        }

        public void deferFree(long encodeAddr) {
            this.m_deferredFrees.add(encodeAddr);
        }

        void release() {
            ArrayList<FixedAllocator>[] freeFixed = this.m_parent != null ? this.m_parent.m_freeFixed : this.m_store.m_freeFixed;
            IAllocationContext pcontext = this.m_parent == null ? null : this.m_parent.m_context;
            for (FixedAllocator f : this.m_allFixed) {
                f.setAllocationContext(pcontext);
                f.setFreeList(freeFixed[this.m_store.fixedAllocatorIndex(f.m_size)]);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Releasing " + this.m_deferredFrees.size() + " deferred frees"));
            }
            for (Long l : this.m_deferredFrees) {
                this.m_store.immediateFree((int)(l >> 32), l.intValue());
            }
            this.m_deferredFrees.clear();
        }

        void abort() {
            ArrayList<FixedAllocator>[] freeFixed = this.m_parent != null ? this.m_parent.m_freeFixed : this.m_store.m_freeFixed;
            IAllocationContext pcontext = this.m_parent == null ? null : this.m_parent.m_context;
            for (FixedAllocator f : this.m_allFixed) {
                f.abortAllocationContext(pcontext, this.m_store.m_writeCacheService);
                f.setFreeList(freeFixed[this.m_store.fixedAllocatorIndex(f.m_size)]);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Aborting " + this.m_deferredFrees.size() + " deferred frees"));
            }
            this.m_deferredFrees.clear();
        }

        FixedAllocator getFreeFixed(int i) {
            ArrayList<FixedAllocator> free = this.m_freeFixed[i];
            if (free.size() == 0) {
                FixedAllocator falloc = this.establishFixedAllocator(i);
                falloc.setAllocationContext(this.m_context);
                falloc.setFreeList(free);
                this.m_allFixed.add(falloc);
            }
            return free.get(0);
        }

        FixedAllocator establishFixedAllocator(int i) {
            if (this.m_parent == null) {
                return this.m_store.establishFreeFixedAllocator(i);
            }
            return this.m_parent.establishFixedAllocator(i);
        }
    }

    private class ReopenFileChannel
    implements IReopenChannel<FileChannel> {
        private final File file;
        private final String mode;
        private volatile RandomAccessFile raf;

        public ReopenFileChannel(File file, RandomAccessFile raf, String mode) throws IOException {
            this.file = file;
            this.mode = mode;
            this.raf = raf;
            this.reopenChannel();
        }

        @Override
        public String toString() {
            return this.file.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileChannel reopenChannel() throws IOException {
            FileChannel channel;
            RandomAccessFile tmp = this.raf;
            if (tmp != null && (channel = tmp.getChannel()).isOpen()) {
                return channel;
            }
            ReopenFileChannel reopenFileChannel = this;
            synchronized (reopenFileChannel) {
                if (this.raf != null && (channel = this.raf.getChannel()).isOpen()) {
                    return channel;
                }
                this.raf = new RandomAccessFile(this.file, this.mode);
                StoreCounters c = (StoreCounters)((StoreCounters)RWStore.this.storeCounters.get()).acquire();
                try {
                    ++c.nreopen;
                }
                finally {
                    c.release();
                }
                return this.raf.getChannel();
            }
        }
    }

    public static class AllocationStats {
        long m_blockSize;
        long m_reservedSlots;
        long m_filledSlots;

        public AllocationStats(int i) {
            this.m_blockSize = i;
        }
    }

    private class CommitState {
        private final int m_lastCommittedNextAllocation;
        private final long m_storageStatsAddr;
        private final int m_metaBitsAddr;

        CommitState() {
            if (!RWStore.this.m_allocationWriteLock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            this.m_lastCommittedNextAllocation = RWStore.this.m_committedNextAllocation;
            this.m_storageStatsAddr = RWStore.this.m_storageStatsAddr;
            this.m_metaBitsAddr = RWStore.this.m_metaBitsAddr;
        }

        void postCommit() {
        }

        void reset() {
            if (!RWStore.this.m_allocationWriteLock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            RWStore.this.m_storageStatsAddr = this.m_storageStatsAddr;
            RWStore.this.m_committedNextAllocation = this.m_lastCommittedNextAllocation;
            RWStore.this.m_metaBitsAddr = this.m_metaBitsAddr;
        }
    }

    private static class RootBlockInfo {
        private final ReopenFileChannel m_reopener;
        private final int[] m_metabits;
        private final long m_storageStatsAddr;
        private final long m_lastDeferredReleaseTime;

        RootBlockInfo(IRootBlockView rb, ReopenFileChannel reopener) throws IOException {
            int i;
            this.m_reopener = reopener;
            long rawmbaddr = rb.getMetaBitsAddr();
            int metaBitsStore = (int)(rawmbaddr & 0xFFFFL);
            long pmaddr = rawmbaddr >> 16;
            byte[] buf = new byte[metaBitsStore * 4];
            FileChannelUtility.readAll(this.m_reopener, ByteBuffer.wrap(buf), pmaddr);
            DataInputStream strBuf = new DataInputStream(new ByteArrayInputStream(buf));
            strBuf.readInt();
            this.m_lastDeferredReleaseTime = strBuf.readLong();
            strBuf.readInt();
            int allocBlocks = strBuf.readInt();
            this.m_storageStatsAddr = strBuf.readLong();
            for (i = 0; i < 20; ++i) {
                strBuf.readInt();
            }
            for (i = 0; i < allocBlocks; ++i) {
                strBuf.readInt();
            }
            int metaBitsSize = metaBitsStore - allocBlocks - 27;
            assert (metaBitsSize % 9 == 0);
            int[] ret = new int[metaBitsSize];
            for (int i2 = 0; i2 < metaBitsSize; ++i2) {
                ret[i2] = strBuf.readInt();
            }
            this.m_metabits = ret;
        }
    }

    class WriteCacheImpl
    extends WriteCache.FileChannelScatteredWriteCache {
        private final String compressorKey;

        public WriteCacheImpl(IBufferAccess buf, boolean useChecksum, boolean bufferHasData, IReopenChannel<FileChannel> opener, long fileExtent, String compressorKey) throws InterruptedException {
            super(buf, useChecksum, RWStore.this.m_quorum != null, bufferHasData, opener, fileExtent, RWStore.this.m_bufferedWrite);
            this.compressorKey = compressorKey;
        }

        @Override
        public String getCompressorKey() {
            return this.compressorKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean writeOnChannel(ByteBuffer data, long firstOffsetignored, Map<Long, WriteCache.RecordMetadata> recordMap, long nanos) throws InterruptedException, IOException {
            ReentrantReadWriteLock.ReadLock readLock = RWStore.this.m_extensionLock.readLock();
            readLock.lock();
            try {
                boolean ret;
                boolean bl = ret = super.writeOnChannel(data, firstOffsetignored, recordMap, nanos);
                return bl;
            }
            finally {
                readLock.unlock();
            }
        }

        @Override
        protected void registerWriteStatus(long offset, int length, char action) {
            RWStore.this.m_writeCacheService.debugAddrs(offset, length, action);
        }

        @Override
        protected void addAddress(int latchedAddr, int size) {
        }

        @Override
        protected void removeAddress(int latchedAddr) {
        }
    }

    public static interface Options {
        public static final String ALLOCATION_SIZES = RWStore.class.getName() + ".allocationSizes";
        public static final String DEFAULT_ALLOCATION_SIZES = "1, 2, 3, 5, 8, 12, 16, 32, 48, 64, 128";
        @Deprecated
        public static final String META_BITS_SIZE = RWStore.class.getName() + ".metaBitsSize";
        @Deprecated
        public static final String DEFAULT_META_BITS_SIZE = "9";
        public static final String META_BITS_DEMI_SPACE = RWStore.class.getName() + ".metabitsDemispace";
        public static final String DEFAULT_META_BITS_DEMI_SPACE = "false";
        public static final String FREE_BITS_THRESHOLD = RWStore.class.getName() + ".freeBitsThreshold";
        public static final String DEFAULT_FREE_BITS_THRESHOLD = "300";
        public static final String SMALL_SLOT_TYPE = RWStore.class.getName() + ".smallSlotType";
        public static final String DEFAULT_SMALL_SLOT_TYPE = "0";
        public static final String DOUBLE_BUFFER_WRITES = RWStore.class.getName() + ".doubleBuffer";
        public static final String DEFAULT_DOUBLE_BUFFER_WRITES = "true";
    }
}

