/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rwstore.sector;

import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.IBufferAccess;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.CommitRecordIndex;
import com.bigdata.journal.CommitRecordSerializer;
import com.bigdata.journal.ICommitRecord;
import com.bigdata.journal.ICommitter;
import com.bigdata.rawstore.IAllocationContext;
import com.bigdata.rawstore.IPSOutputStream;
import com.bigdata.rwstore.IRawTx;
import com.bigdata.rwstore.PSOutputStream;
import com.bigdata.rwstore.sector.AllocationContext;
import com.bigdata.rwstore.sector.IMemoryManager;
import com.bigdata.rwstore.sector.ISectorManager;
import com.bigdata.rwstore.sector.MemoryManagerOutOfMemory;
import com.bigdata.rwstore.sector.PSInputStream;
import com.bigdata.rwstore.sector.SectorAllocator;
import com.bigdata.service.AbstractTransactionService;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class MemoryManager
implements IMemoryManager,
ISectorManager {
    private static final Logger log = Logger.getLogger(MemoryManager.class);
    private static final Logger txLog = Logger.getLogger((String)"com.bigdata.txLog");
    private int[] m_debugAddrs = null;
    private int m_debugCurs = 0;
    private final DirectBufferPool m_pool;
    private final ArrayList<IBufferAccess> m_resources;
    final ReentrantLock m_allocationLock = new ReentrantLock();
    private final Condition m_sectorFree = this.m_allocationLock.newCondition();
    private final int m_sectorSize;
    private final int m_maxSectors;
    private final boolean m_blocks;
    private final ArrayList<SectorAllocator> m_sectors = new ArrayList();
    private final ArrayList<SectorAllocator> m_free = new ArrayList();
    private final AtomicLong m_extent = new AtomicLong();
    private final AtomicLong m_allocCount = new AtomicLong();
    private final AtomicLong m_userBytes = new AtomicLong();
    private final AtomicLong m_slotBytes = new AtomicLong();
    private int m_activeTxCount = 0;
    private final PSOutputStream m_deferredFreeOut;
    private ConcurrentWeakValueCache<Long, ICommitter> m_externalCache = null;
    private int m_cachedDatasize = 0;
    private long m_lastDeferredReleaseTime = 0L;
    private final Map<IAllocationContext, AllocationContext> m_contexts = new ConcurrentHashMap<IAllocationContext, AllocationContext>();
    private int m_contextRequests = 0;
    private int m_contextRemovals = 0;
    private long m_retention = 0L;

    public MemoryManager(DirectBufferPool pool) {
        this(pool, Integer.MAX_VALUE);
    }

    public MemoryManager(DirectBufferPool pool, int sectors) {
        this(pool, sectors, true, null);
    }

    public MemoryManager(DirectBufferPool pool, int sectors, boolean blocks, Properties properties) {
        if (pool == null) {
            throw new IllegalArgumentException();
        }
        if (sectors <= 0) {
            throw new IllegalArgumentException();
        }
        this.m_pool = pool;
        this.m_maxSectors = sectors;
        this.m_blocks = blocks;
        this.m_resources = new ArrayList();
        this.m_sectorSize = pool.getBufferCapacity();
        this.m_deferredFreeOut = PSOutputStream.getNew(this, 4100, null);
        if (properties != null) {
            this.m_retention = Long.parseLong(properties.getProperty(AbstractTransactionService.Options.MIN_RELEASE_AGE, "1"));
        }
    }

    protected void finalize() throws Throwable {
        this.releaseDirectBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDirectBuffers() {
        for (int i = 0; i < this.m_resources.size(); ++i) {
            IBufferAccess buf = this.m_resources.get(i);
            if (buf == null) continue;
            try {
                buf.release();
                continue;
            }
            catch (InterruptedException e) {
                log.error((Object)"Unable to release direct buffers", (Throwable)e);
                continue;
            }
            finally {
                this.m_resources.set(i, null);
            }
        }
        this.m_resources.clear();
    }

    @Override
    public int getMaxSectors() {
        return this.m_maxSectors;
    }

    public boolean isBlocking() {
        return this.m_blocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSectorCount() {
        this.m_allocationLock.lock();
        try {
            int n = this.m_sectors.size();
            return n;
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    @Override
    public int getSectorSize() {
        return this.m_sectorSize;
    }

    public long getMaxMemoryCapacity() {
        return (long)this.m_sectorSize * (long)this.m_resources.size();
    }

    @Override
    public long allocate(ByteBuffer data) {
        return this.allocate(data, this.m_blocks);
    }

    @Override
    public long allocate(ByteBuffer data, boolean blocks) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        int nbytes = data.remaining();
        if (nbytes == 0) {
            throw new IllegalArgumentException();
        }
        long retaddr = this.allocate(nbytes, blocks);
        ByteBuffer[] bufs = this.get(retaddr);
        MemoryManager.copyData(data, bufs);
        return retaddr;
    }

    static void copyData(ByteBuffer src, ByteBuffer[] dst) {
        int pos = 0;
        for (int i = 0; i < dst.length; ++i) {
            int tsize = dst[i].remaining();
            src.limit(pos + tsize);
            src.position(pos);
            dst[i].put(src);
            pos += tsize;
        }
    }

    @Override
    public long allocate(int nbytes) {
        return this.allocate(nbytes, this.m_blocks);
    }

    private SectorAllocator scanForSectorWithFreeSpace(int nbytes) {
        byte tag = SectorAllocator.getTag(nbytes);
        for (SectorAllocator s : this.m_sectors) {
            if (s.m_free[tag] <= 0) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Can allocate from sector: " + s));
            }
            return s;
        }
        return null;
    }

    private SectorAllocator getSectorFromFreeList(boolean blocks, int nbytes) {
        while (this.m_free.isEmpty()) {
            SectorAllocator sector;
            if (this.m_sectors.size() < this.m_maxSectors) {
                IBufferAccess nbuf;
                sector = this.scanForSectorWithFreeSpace(nbytes);
                if (sector != null) {
                    return sector;
                }
                try {
                    nbuf = blocks ? this.m_pool.acquire() : this.m_pool.acquire(1L, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                catch (TimeoutException ex) {
                    throw new RuntimeException(ex);
                }
                this.m_resources.add(nbuf);
                sector = new SectorAllocator(this, null);
                sector.setSectorAddress(this.m_extent.get(), this.m_sectorSize);
                sector.setIndex(this.m_sectors.size());
                if (this.m_activeTxCount > 0 || !this.m_contexts.isEmpty()) {
                    sector.preserveSessionData();
                }
                this.m_sectors.add(sector);
                this.m_extent.addAndGet(this.m_sectorSize);
                continue;
            }
            if (blocks) {
                sector = this.scanForSectorWithFreeSpace(nbytes);
                if (sector != null) {
                    return sector;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Blocking...");
                }
                try {
                    this.m_sectorFree.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Resuming...");
                continue;
            }
            throw new MemoryManagerOutOfMemory();
        }
        return this.m_free.get(0);
    }

    @Override
    public long allocate(int nbytes, boolean blocks) {
        if (nbytes <= 0) {
            throw new IllegalArgumentException();
        }
        this.m_allocationLock.lock();
        try {
            if (nbytes <= 4096) {
                SectorAllocator sector = this.getSectorFromFreeList(blocks, nbytes);
                int rwaddr = sector.alloc(nbytes);
                if (SectorAllocator.getSectorIndex(rwaddr) >= this.m_sectors.size()) {
                    throw new IllegalStateException("Address: " + rwaddr + " yields index: " + SectorAllocator.getSectorIndex(rwaddr));
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("allocating bit: " + SectorAllocator.getSectorOffset(rwaddr)));
                }
                this.m_allocCount.incrementAndGet();
                this.m_userBytes.addAndGet(nbytes);
                this.m_slotBytes.addAndGet(sector.getPhysicalSize(SectorAllocator.getSectorOffset(rwaddr)));
                if (this.m_debugAddrs != null) {
                    this.m_debugAddrs[this.m_debugCurs++] = rwaddr;
                    if (this.m_debugCurs == this.m_debugAddrs.length) {
                        this.m_debugCurs = 0;
                    }
                }
                long l = this.makeAddr(rwaddr, nbytes);
                return l;
            }
            int nblocks = 0;
            ByteBuffer hdrbuf = null;
            int[] addrs = null;
            try {
                nblocks = SectorAllocator.getBlobBlockCount(nbytes);
                hdrbuf = ByteBuffer.allocate(nblocks * 4 + 4);
                hdrbuf.putInt(nblocks);
                addrs = new int[nblocks];
                for (int i = 0; i < nblocks; ++i) {
                    int pos = 4096 * i;
                    int bsize = i < nblocks - 1 ? 4096 : nbytes - pos;
                    long bpaddr = this.allocate(bsize, blocks);
                    int bprwaddr = MemoryManager.getAllocationAddress(bpaddr);
                    hdrbuf.putInt(bprwaddr);
                    addrs[i] = bprwaddr;
                }
                hdrbuf.flip();
                int retaddr = MemoryManager.getAllocationAddress(this.allocate(hdrbuf, blocks));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Allocation BLOB at: " + retaddr));
                }
                long pos = this.makeAddr(retaddr, nbytes);
                return pos;
            }
            catch (MemoryManagerOutOfMemory oom) {
                try {
                    int addr;
                    hdrbuf.position(0);
                    hdrbuf.limit(nblocks * 4 + 4);
                    int rblocks = hdrbuf.getInt();
                    assert (nblocks == rblocks);
                    for (int i = 0; i < nblocks && (addr = hdrbuf.getInt()) != 0; ++i) {
                        long laddr = this.makeAddr(addr, 4096);
                        this.free(laddr);
                    }
                }
                catch (Throwable t) {
                    log.warn((Object)"Problem trying to release partial allocations after MemoryManagerOutOfMemory", t);
                }
                throw oom;
            }
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    @Override
    public ByteBuffer[] get(long addr) {
        if (addr == 0L) {
            throw new IllegalArgumentException();
        }
        int rwaddr = MemoryManager.getAllocationAddress(addr);
        int size = MemoryManager.getAllocationSize(addr);
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        if (size <= 4096) {
            return new ByteBuffer[]{this.getBuffer(rwaddr, size)};
        }
        ByteBuffer hdrbuf = this.getBlobHdr(addr);
        int nblocks = hdrbuf.getInt();
        ByteBuffer[] blobbufs = new ByteBuffer[nblocks];
        int remaining = size;
        for (int i = 0; i < nblocks; ++i) {
            int blockSize = remaining <= 4096 ? remaining : 4096;
            blobbufs[i] = this.getBuffer(hdrbuf.getInt(), blockSize);
            remaining -= blockSize;
        }
        return blobbufs;
    }

    @Override
    public byte[] read(long addr) {
        return MemoryManager.read(this, addr);
    }

    static byte[] read(IMemoryManager mmgr, long addr) {
        ByteBuffer[] bufs;
        int nbytes = MemoryManager.getAllocationSize(addr);
        byte[] a = new byte[nbytes];
        ByteBuffer mybb = ByteBuffer.wrap(a);
        for (ByteBuffer b : bufs = mmgr.get(addr)) {
            mybb.put(b);
        }
        return a;
    }

    private ByteBuffer getBlobHdr(long addr) {
        int size = MemoryManager.getAllocationSize(addr);
        int nblocks = SectorAllocator.getBlobBlockCount(size);
        int hdrsize = 4 * nblocks + 4;
        long hdraddr = addr & 0xFFFFFFFF00000000L | (long)hdrsize;
        return this.get(hdraddr)[0];
    }

    String debugInfo(int rwaddr) {
        StringBuilder out = new StringBuilder("Debug: " + rwaddr);
        for (int i = 0; i < this.m_debugCurs; ++i) {
            if (this.m_debugAddrs[i] == rwaddr) {
                out.append("A");
                continue;
            }
            if (this.m_debugAddrs[i] != -rwaddr) continue;
            out.append("X");
        }
        return out.toString();
    }

    ByteBuffer getBuffer(int rwaddr, int size) {
        int offset;
        SectorAllocator sector = this.getSector(rwaddr);
        if (!sector.isGettable(offset = SectorAllocator.getSectorOffset(rwaddr))) {
            throw new IllegalArgumentException("Address not gettable: " + rwaddr);
        }
        long paddr = sector.getPhysicalAddress(offset);
        IBufferAccess ba = this.m_resources.get(sector.m_index);
        if (ba == null) {
            throw new IllegalArgumentException();
        }
        int bufferAddr = (int)(paddr - sector.m_sectorAddress);
        int nlimit = bufferAddr + size;
        ByteBuffer ret = ba.buffer().duplicate();
        if (nlimit > ret.capacity() || nlimit < 0) {
            throw new IllegalStateException("Buffer Limit Error - Capacity: " + ret.capacity() + ", new limit: " + nlimit);
        }
        ret.limit(nlimit);
        ret.position(bufferAddr);
        return ret.slice();
    }

    SectorAllocator getSector(int rwaddr) {
        int index = SectorAllocator.getSectorIndex(rwaddr);
        if (index >= this.m_sectors.size()) {
            throw new IllegalStateException("Address: " + rwaddr + " yields index: " + index + " >= sector:size(): " + this.m_sectors.size());
        }
        return this.m_sectors.get(index);
    }

    static int getAllocationAddress(long addr) {
        return (int)(addr >> 32);
    }

    static int getAllocationSize(long addr) {
        return (int)(addr & 0xFFFFFFFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(long addr) {
        if (addr == 0L) {
            throw new IllegalArgumentException();
        }
        int rwaddr = MemoryManager.getAllocationAddress(addr);
        int size = MemoryManager.getAllocationSize(addr);
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Releasing allocation at: " + rwaddr + "[" + size + "]"));
        }
        this.m_allocationLock.lock();
        try {
            if (this.m_retention > 0L) {
                this.deferFree(rwaddr, size);
            } else {
                this.immediateFree(addr);
            }
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void immediateFree(long addr) {
        if (addr == 0L) {
            throw new IllegalArgumentException();
        }
        int rwaddr = MemoryManager.getAllocationAddress(addr);
        int size = MemoryManager.getAllocationSize(addr);
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Releasing allocation at: " + rwaddr + "[" + size + "]"));
        }
        this.m_allocationLock.lock();
        try {
            if (size <= 4096) {
                int offset = SectorAllocator.getSectorOffset(rwaddr);
                SectorAllocator sector = this.getSector(rwaddr);
                sector.free(offset);
                this.m_allocCount.decrementAndGet();
                this.m_userBytes.addAndGet(-size);
                this.m_slotBytes.addAndGet(-sector.getPhysicalSize(offset));
                if (this.m_debugAddrs != null) {
                    this.m_debugAddrs[this.m_debugCurs++] = -rwaddr;
                    if (this.m_debugCurs == this.m_debugAddrs.length) {
                        this.m_debugCurs = 0;
                    }
                }
                this.removeFromExternalCache(this.getPhysicalAddress(addr), sector.getPhysicalSize(offset));
            } else {
                ByteBuffer hdrbuf = this.getBlobHdr(addr);
                int spos = hdrbuf.position();
                int hdrsize = hdrbuf.limit() - spos;
                int nblocks = hdrbuf.getInt();
                int remaining = size;
                for (int i = 0; i < nblocks; ++i) {
                    int blockSize = remaining <= 4096 ? remaining : 4096;
                    long mkaddr = this.makeAddr(hdrbuf.getInt(), blockSize);
                    this.immediateFree(mkaddr);
                }
                this.immediateFree(this.makeAddr(rwaddr, hdrsize));
            }
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    @Override
    public long getPhysicalAddress(long addr) {
        int rwaddr = MemoryManager.getAllocationAddress(addr);
        int sector = SectorAllocator.getSectorIndex(rwaddr);
        int soffset = SectorAllocator.getSectorOffset(rwaddr);
        long paddr = this.getSectorSize();
        return paddr * (long)sector + (long)soffset;
    }

    private long makeAddr(int rwaddr, int size) {
        long addr = rwaddr;
        addr <<= 32;
        assert (rwaddr == MemoryManager.getAllocationAddress(addr += (long)size));
        assert (size == MemoryManager.getAllocationSize(addr));
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.m_allocationLock.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"");
            }
            this.m_sectors.clear();
            this.m_free.clear();
            this.m_extent.set(0L);
            this.m_allocCount.set(0L);
            this.m_userBytes.set(0L);
            this.m_slotBytes.set(0L);
            this.releaseDirectBuffers();
            this.m_sectorFree.signalAll();
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToFreeList(SectorAllocator sector) {
        this.m_allocationLock.lock();
        try {
            this.m_free.add(sector);
            this.m_sectorFree.signalAll();
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromFreeList(SectorAllocator sector) {
        this.m_allocationLock.lock();
        try {
            assert (this.m_free.get(0) == sector);
            this.m_free.remove(sector);
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    @Override
    public void trimSector(long trim, SectorAllocator sector) {
    }

    @Override
    public IMemoryManager createAllocationContext() {
        return new AllocationContext(this);
    }

    @Override
    public int allocationSize(long addr) {
        return MemoryManager.getAllocationSize(addr);
    }

    public long getCapacity() {
        return (long)this.m_pool.getBufferCapacity() * (long)this.m_resources.size();
    }

    public long getExtent() {
        return this.m_extent.get();
    }

    @Override
    public long getAllocationCount() {
        return this.m_allocCount.get();
    }

    @Override
    public long getSlotBytes() {
        return this.m_slotBytes.get();
    }

    @Override
    public long getUserBytes() {
        return this.m_userBytes.get();
    }

    @Override
    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        root.addCounter("bufferCapacity", new OneShotInstrument<Integer>(this.m_maxSectors));
        root.addCounter("bufferCount", new OneShotInstrument<Integer>(this.getSectorCount()));
        root.addCounter("extent", new OneShotInstrument<Long>(this.m_extent.get()));
        root.addCounter("allocationCount", new OneShotInstrument<Long>(this.getAllocationCount()));
        root.addCounter("slotBytes", new OneShotInstrument<Long>(this.getUserBytes()));
        root.addCounter("userBytes", new OneShotInstrument<Long>(this.getUserBytes()));
        root.addCounter("blocking", new OneShotInstrument<Boolean>(this.isBlocking()));
        return root;
    }

    public String toString() {
        return this.getClass().getName() + "{counters=" + this.getCounters() + "}";
    }

    @Override
    public long alloc(byte[] buf, int size, IAllocationContext context) {
        if (context != null) {
            throw new IllegalArgumentException("The MemoryManager does not support AllocationContexts");
        }
        return MemoryManager.getAllocationAddress(this.allocate(ByteBuffer.wrap(buf, 0, size)));
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void free(long addr, int size) {
        this.free((addr << 32) + (long)size);
    }

    @Override
    public int getAssociatedSlotSize(int addr) {
        SectorAllocator sector = this.getSector(addr);
        int offset = SectorAllocator.getSectorOffset(addr);
        return sector.getPhysicalSize(offset);
    }

    @Override
    public void getData(long l, byte[] buf) {
        ByteBuffer rbuf = this.getBuffer((int)l, buf.length);
        rbuf.get(buf);
    }

    @Override
    public File getStoreFile() {
        throw new UnsupportedOperationException("The MemoryManager does not provdie a StoreFile");
    }

    @Override
    public IPSOutputStream getOutputStream() {
        return this.getOutputStream(null);
    }

    @Override
    public IPSOutputStream getOutputStream(IAllocationContext context) {
        return PSOutputStream.getNew(this, 4100, context);
    }

    @Override
    public InputStream getInputStream(long addr) {
        return new PSInputStream(this, addr);
    }

    @Override
    public void commit() {
    }

    @Override
    public Lock getCommitLock() {
        return this.m_allocationLock;
    }

    @Override
    public void postCommit() {
        if (!this.m_allocationLock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        Iterator<SectorAllocator> sectors = this.m_sectors.iterator();
        while (sectors.hasNext()) {
            sectors.next().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerExternalCache(ConcurrentWeakValueCache<Long, ICommitter> externalCache, int dataSize) {
        this.m_allocationLock.lock();
        try {
            this.m_externalCache = externalCache;
            this.m_cachedDatasize = this.getSlotSize(dataSize);
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    void removeFromExternalCache(long clr, int slotSize) {
        ICommitter rem;
        assert (this.m_allocationLock.isLocked());
        if (this.m_externalCache == null) {
            return;
        }
        if ((slotSize == 0 || slotSize == this.m_cachedDatasize) && (rem = this.m_externalCache.remove(clr)) != null && log.isTraceEnabled()) {
            log.trace((Object)("ExternalCache, removed: " + rem.getClass().getName() + " with addr: " + clr));
        }
    }

    private int getSlotSize(int size) {
        return SectorAllocator.getBlockForSize(size);
    }

    @Override
    public long saveDeferrals() {
        this.m_allocationLock.lock();
        try {
            if (this.m_deferredFreeOut.getBytesWritten() == 0) {
                long l = 0L;
                return l;
            }
            this.m_deferredFreeOut.writeInt(0);
            int outlen = this.m_deferredFreeOut.getBytesWritten();
            long addr = this.m_deferredFreeOut.save();
            addr <<= 32;
            this.m_deferredFreeOut.reset();
            long l = addr += (long)outlen;
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write to deferred free", e);
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    public void deferFree(int rwaddr, int sze) {
        assert (rwaddr != 0);
        this.m_allocationLock.lock();
        try {
            if (sze > 4096) {
                this.m_deferredFreeOut.writeInt(-rwaddr);
                this.m_deferredFreeOut.writeInt(sze);
            } else {
                this.m_deferredFreeOut.writeInt(rwaddr);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not free: rwaddr=" + rwaddr + ", size=" + sze, e);
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    @Override
    public int checkDeferredFrees(AbstractJournal journal) {
        AbstractTransactionService transactionService = (AbstractTransactionService)journal.getLocalTransactionManager().getTransactionService();
        long lastCommitTime = journal.getLastCommitTime();
        if (lastCommitTime == 0L) {
            return 0;
        }
        long latestReleasableTime = transactionService.getReleaseTime();
        return this.freeDeferrals(journal, this.m_lastDeferredReleaseTime + 1L, latestReleasableTime);
    }

    private int freeDeferrals(long blockAddr, long lastReleaseTime) {
        this.m_allocationLock.lock();
        int totalFreed = 0;
        DataInputStream strBuf = null;
        try {
            strBuf = new DataInputStream(this.getInputStream(blockAddr));
            int nxtAddr = strBuf.readInt();
            while (nxtAddr != 0) {
                if (nxtAddr > 0) {
                    int bloblen = strBuf.readInt();
                    assert (bloblen > 0);
                    this.immediateFree(this.makeAddr(-nxtAddr, bloblen));
                } else {
                    this.immediateFree(this.makeAddr(nxtAddr, 1));
                }
                ++totalFreed;
                nxtAddr = strBuf.readInt();
            }
            this.immediateFree(blockAddr);
            this.m_lastDeferredReleaseTime = lastReleaseTime;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Updated m_lastDeferredReleaseTime=" + this.m_lastDeferredReleaseTime));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Problem freeing deferrals", e);
        }
        finally {
            this.m_allocationLock.unlock();
            if (strBuf != null) {
                try {
                    strBuf.close();
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        return totalFreed;
    }

    private int freeDeferrals(AbstractJournal journal, long fromTime, long toTime) {
        CommitRecordIndex commitRecordIndex = journal.getReadOnlyCommitRecordIndex();
        if (commitRecordIndex == null) {
            return 0;
        }
        IndexMetadata metadata = commitRecordIndex.getIndexMetadata();
        byte[] fromKey = metadata.getTupleSerializer().serializeKey(fromTime);
        byte[] toKey = metadata.getTupleSerializer().serializeKey(toTime);
        ITupleIterator commitRecords = commitRecordIndex.rangeIterator(fromKey, toKey);
        int totalFreed = 0;
        int commitPointsRecycled = 0;
        while (commitRecords.hasNext()) {
            ITuple tuple = commitRecords.next();
            CommitRecordIndex.Entry entry = (CommitRecordIndex.Entry)tuple.getObject();
            try {
                ICommitRecord record = CommitRecordSerializer.INSTANCE.deserialize(journal.read(entry.addr));
                long blockAddr = record.getRootAddr(2);
                if (blockAddr != 0L) {
                    totalFreed += this.freeDeferrals(blockAddr, record.getTimestamp());
                }
                ++commitPointsRecycled;
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Problem with entry at " + entry.addr, re);
            }
        }
        int commitPointsRemoved = journal.removeCommitRecordEntries(fromKey, toKey);
        if (txLog.isInfoEnabled()) {
            txLog.info((Object)("fromTime=" + fromTime + ", toTime=" + toTime + ", totalFreed=" + totalFreed + ", commitPointsRecycled=" + commitPointsRecycled + ", commitPointsRemoved=" + commitPointsRemoved));
        }
        if (commitPointsRecycled != commitPointsRemoved) {
            throw new AssertionError((Object)("commitPointsRecycled=" + commitPointsRecycled + " != commitPointsRemoved=" + commitPointsRemoved));
        }
        return totalFreed;
    }

    @Override
    public IRawTx newTx() {
        this.activateTx();
        return new IRawTx(){
            private final AtomicBoolean m_open = new AtomicBoolean(true);

            @Override
            public void close() {
                if (this.m_open.compareAndSet(true, false)) {
                    MemoryManager.this.deactivateTx();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateTx() {
        this.m_allocationLock.lock();
        try {
            ++this.m_activeTxCount;
            if (log.isInfoEnabled()) {
                log.info((Object)("#activeTx=" + this.m_activeTxCount));
            }
            if (this.m_activeTxCount == 1 && this.m_contexts.isEmpty()) {
                this.acquireSessions();
            }
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateTx() {
        this.m_allocationLock.lock();
        try {
            if (this.m_activeTxCount == 0) {
                throw new IllegalStateException("Tx count must be positive!");
            }
            --this.m_activeTxCount;
            if (log.isInfoEnabled()) {
                log.info((Object)("#activeTx=" + this.m_activeTxCount));
            }
            if (this.m_activeTxCount == 0) {
                this.releaseSessions();
            }
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    private void releaseSessions() {
        for (SectorAllocator sector : this.m_sectors) {
            sector.releaseSession(null);
        }
    }

    private void acquireSessions() {
        for (SectorAllocator sector : this.m_sectors) {
            sector.preserveSessionData();
        }
    }

    @Override
    public long getLastReleaseTime() {
        return this.m_lastDeferredReleaseTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortContext(IAllocationContext context) {
        this.m_allocationLock.lock();
        try {
            AllocationContext alloc = this.m_contexts.remove(context);
            if (alloc != null) {
                ++this.m_contextRemovals;
                alloc.clear();
                if (this.m_activeTxCount == 0 && this.m_contexts.isEmpty()) {
                    this.releaseSessions();
                }
            }
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachContext(IAllocationContext context) {
        this.m_allocationLock.lock();
        try {
            AllocationContext alloc = this.m_contexts.remove(context);
            if (alloc != null) {
                ++this.m_contextRemovals;
            } else {
                throw new IllegalStateException("Multiple call to detachContext");
            }
            alloc.commit();
            if (this.m_contexts.isEmpty() && this.m_activeTxCount == 0) {
                this.releaseSessions();
            }
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerContext(IAllocationContext context) {
        this.m_allocationLock.lock();
        try {
            this.establishContextAllocation(context);
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    private AllocationContext establishContextAllocation(IAllocationContext context) {
        assert (this.m_allocationLock.isHeldByCurrentThread());
        AllocationContext ret = this.m_contexts.get(context);
        if (ret == null) {
            ret = new AllocationContext(this);
            if (this.m_contexts.put(context, ret) != null) {
                throw new AssertionError();
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Establish ContextAllocation: " + ret + ", total: " + this.m_contexts.size() + ", requests: " + ++this.m_contextRequests + ", removals: " + this.m_contextRemovals));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Context: ncontexts=" + this.m_contexts.size() + ", context=" + context));
            }
            if (this.m_activeTxCount == 0 && this.m_contexts.size() == 1) {
                this.acquireSessions();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCommitted(long addr) {
        this.m_allocationLock.lock();
        try {
            int rwaddr = MemoryManager.getAllocationAddress(addr);
            int offset = SectorAllocator.getSectorOffset(rwaddr);
            SectorAllocator sector = this.getSector(rwaddr);
            boolean bl = sector.isCommitted(offset);
            return bl;
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long allocate(ByteBuffer data, IAllocationContext context) {
        this.m_allocationLock.lock();
        try {
            long l = this.establishContextAllocation(context).allocate(data);
            return l;
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    @Override
    public long write(ByteBuffer data, IAllocationContext context) {
        return this.allocate(data, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(long addr, IAllocationContext context) {
        this.m_allocationLock.lock();
        try {
            this.establishContextAllocation(context).free(addr);
        }
        finally {
            this.m_allocationLock.unlock();
        }
    }

    @Override
    public void delete(long addr, IAllocationContext context) {
        this.free(addr, context);
    }
}

