/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.search.AbstractIndexTask;
import com.bigdata.search.FullTextIndex;
import com.bigdata.search.Hit;
import com.bigdata.search.IHitCollector;
import com.bigdata.search.ITermDocRecord;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class ReadIndexTask<V extends Comparable<V>>
extends AbstractIndexTask<V>
implements Callable<Object> {
    private static final Logger log = Logger.getLogger(ReadIndexTask.class);
    private final IHitCollector<V> hits;
    private final ITupleIterator<?> itr;
    private Hit<V> tmp;

    public ReadIndexTask(String termText, int termNdx, int numTerms, boolean prefixMatch, double queryTermWeight, FullTextIndex<V> searchEngine, IHitCollector<V> hits) {
        super(termText, termNdx, numTerms, prefixMatch, queryTermWeight, searchEngine);
        if (hits == null) {
            throw new IllegalArgumentException();
        }
        this.hits = hits;
        if (log.isDebugEnabled()) {
            log.debug((Object)("termText=[" + termText + "], prefixMatch=" + prefixMatch + ", queryTermWeight=" + queryTermWeight + "\nfromKey=" + BytesUtil.toString(this.fromKey) + "\n  toKey=" + BytesUtil.toString(this.toKey)));
        }
        this.itr = searchEngine.getIndex().rangeIterator(this.fromKey, this.toKey, 0, 3, null);
        this.tmp = new Hit(numTerms);
    }

    @Override
    public Long call() throws Exception {
        try {
            long nhits = this.run();
            return nhits;
        }
        catch (Throwable t) {
            throw this.launderThrowable(t);
        }
    }

    private long run() {
        long nhits = 0L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("queryTerm=" + this.queryTerm + ", termWeight=" + this.queryTermWeight));
        }
        while (this.itr.hasNext()) {
            Hit hit;
            if (nhits % 1000L == 0L && Thread.interrupted()) {
                log.warn((Object)("Interrupted: queryTerm=" + this.queryTerm + ", nhits=" + nhits));
                return nhits;
            }
            ITuple<?> tuple = this.itr.next();
            ITermDocRecord rec = (ITermDocRecord)tuple.getObject();
            Object docId = rec.getDocId();
            double termWeight = rec.getLocalTermWeight();
            Hit oldValue = this.hits.putIfAbsent(docId, this.tmp);
            if (oldValue == null) {
                hit = this.tmp;
                hit.setDocId(docId);
                this.tmp = new Hit(this.numQueryTerms);
            } else {
                hit = oldValue;
            }
            hit.add(this.queryTermNdx, this.queryTermWeight * termWeight);
            ++nhits;
        }
        return nhits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuntimeException launderThrowable(Throwable t) throws Exception {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        throw new RuntimeException(t);
    }
}

