/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IParallelizableIndexProcedure;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.relation.IMutableRelationIndexWriteProcedure;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.log4j.Logger;

public class TextIndexWriteProc
extends AbstractKeyArrayIndexProcedure<Long>
implements IParallelizableIndexProcedure<Long>,
IMutableRelationIndexWriteProcedure<Long> {
    private static final long serialVersionUID = 9013449121306914750L;
    private static final transient Logger log = Logger.getLogger(TextIndexWriteProc.class);
    private boolean overwrite;

    public TextIndexWriteProc() {
    }

    protected TextIndexWriteProc(IRabaCoder keySer, IRabaCoder valSer, int fromIndex, int toIndex, byte[][] keys, byte[][] vals, boolean overwrite) {
        super(keySer, valSer, fromIndex, toIndex, keys, vals);
        assert (vals != null);
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    @Override
    public Long apply(IIndex ndx) {
        long updateCount = 0L;
        int n = this.getKeyCount();
        for (int i = 0; i < n; ++i) {
            boolean write;
            byte[] key = this.getKey(i);
            assert (key != null);
            assert (key.length > 0);
            byte[] val = this.getValue(i);
            boolean bl = write = this.overwrite || !ndx.contains(key);
            if (!write || ndx.insert(key, val) == null) continue;
            ++updateCount;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("wrote " + n + " tuples of which " + updateCount + " were updated rows"));
        }
        return updateCount;
    }

    @Override
    protected void readMetadata(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readMetadata(in);
        this.overwrite = in.readBoolean();
    }

    @Override
    protected void writeMetadata(ObjectOutput out) throws IOException {
        super.writeMetadata(out);
        out.writeBoolean(this.overwrite);
    }

    public static class IndexWriteProcConstructor
    extends AbstractKeyArrayIndexProcedureConstructor<TextIndexWriteProc> {
        public static IndexWriteProcConstructor OVERWRITE = new IndexWriteProcConstructor(true);
        public static IndexWriteProcConstructor NO_OVERWRITE = new IndexWriteProcConstructor(false);
        private final boolean overwrite;

        @Override
        public final boolean sendValues() {
            return true;
        }

        private IndexWriteProcConstructor(boolean overwrite) {
            this.overwrite = overwrite;
        }

        @Override
        public TextIndexWriteProc newInstance(IRabaCoder keySer, IRabaCoder valSer, int fromIndex, int toIndex, byte[][] keys, byte[][] vals) {
            return new TextIndexWriteProc(keySer, valSer, fromIndex, toIndex, keys, vals, this.overwrite);
        }
    }
}

