/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.service.IServiceLoadHelper;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public abstract class AbstractRoundRobinServiceLoadHelper
implements IServiceLoadHelper {
    protected static final Logger log = Logger.getLogger(AbstractRoundRobinServiceLoadHelper.class);
    protected static final boolean INFO = log.isInfoEnabled();
    private final AtomicInteger roundRobinIndex = new AtomicInteger();

    protected AbstractRoundRobinServiceLoadHelper() {
    }

    protected abstract UUID[] awaitServices(int var1, long var2) throws InterruptedException, TimeoutException;

    @Override
    public UUID[] getUnderUtilizedDataServices(int minCount, int maxCount, UUID exclude) throws InterruptedException, TimeoutException {
        Object[] c;
        if (INFO) {
            log.info((Object)("minCount=" + minCount + ", maxCount=" + maxCount + ", exclude=" + exclude));
        }
        long timeout = 10000L;
        Object[] a = this.awaitServices(1, 10000L);
        if (a.length == 1 && exclude != null && exclude.equals(a[0])) {
            a = this.awaitServices(2, 10000L);
        }
        Arrays.sort(a);
        int n = minCount == 0 && maxCount == 0 ? a.length : (a.length > minCount ? Math.min(a.length, Math.max(minCount, maxCount)) : minCount);
        if (INFO) {
            log.info((Object)("Have " + a.length + " data services and will make " + n + " assignments."));
        }
        Object[] b = new UUID[n];
        int i = 0;
        int nexcluded = 0;
        while (i + nexcluded < b.length) {
            Object uuid = a[this.roundRobinIndex.getAndIncrement() % a.length];
            assert (uuid != null);
            if (exclude != null && ((UUID)uuid).equals(exclude)) {
                nexcluded = 1;
                continue;
            }
            b[i++] = uuid;
        }
        if (nexcluded == 0) {
            c = b;
        } else {
            c = new UUID[n - 1];
            System.arraycopy(b, 0, c, 0, n - 1);
        }
        if (INFO) {
            log.info((Object)("Assigned UUIDs: " + Arrays.toString(c)));
        }
        return c;
    }
}

