/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

public class HostScore
implements Comparable<HostScore> {
    public final String hostname;
    public final double rawScore;
    public double score;
    public int rank = -1;
    public double drank = -1.0;

    public HostScore(String hostname) {
        this(hostname, 0.0);
    }

    public HostScore(String hostname, double rawScore) {
        assert (hostname != null);
        assert (hostname.length() > 0);
        this.hostname = hostname;
        this.rawScore = rawScore;
    }

    public String toString() {
        return "HostScore{hostname=" + this.hostname + ", rawScore=" + this.rawScore + ", score=" + this.score + ", rank=" + this.rank + ", drank=" + this.drank + "}";
    }

    @Override
    public int compareTo(HostScore arg0) {
        if (this.rawScore < arg0.rawScore) {
            return -1;
        }
        if (this.rawScore > arg0.rawScore) {
            return 1;
        }
        return this.hostname.compareTo(arg0.hostname);
    }

    public static double normalize(double rawScore, double totalRawScore) {
        if (totalRawScore == 0.0) {
            return 0.0;
        }
        return rawScore / totalRawScore;
    }
}

