/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini;

import com.bigdata.service.jini.JiniClient;
import java.util.Arrays;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import org.apache.log4j.Logger;

public class JiniClientConfig {
    protected static final Logger log = Logger.getLogger(JiniClientConfig.class);
    public final Entry[] entries;
    public final String[] groups;
    public final LookupLocator[] locators;

    public String toString() {
        return this.getClass().getSimpleName() + "{ " + "groups" + "=" + Arrays.toString(this.groups) + ", " + "locators" + "=" + Arrays.toString(this.locators) + ", " + "entries" + "=" + Arrays.toString(this.entries) + "}";
    }

    public JiniClientConfig(String classNameIsIgnored, Configuration config) throws ConfigurationException {
        this.entries = (Entry[])config.getEntry(Options.NAMESPACE, "entries", Entry[].class, (Object)new Entry[0]);
        this.groups = (String[])config.getEntry(Options.NAMESPACE, "groups", String[].class);
        this.locators = (LookupLocator[])config.getEntry(Options.NAMESPACE, "locators", LookupLocator[].class);
        if (log.isInfoEnabled()) {
            log.info((Object)this.toString());
        }
    }

    public static interface Options {
        public static final String NAMESPACE = JiniClient.class.getName();
        public static final String ENTRIES = "entries";
        public static final String GROUPS = "groups";
        public static final String LOCATORS = "locators";
        public static final String PROPERTIES = "properties";
    }
}

