/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini;

import com.bigdata.io.IStreamSerializer;
import com.bigdata.jini.start.config.ZookeeperClientConfig;
import com.bigdata.jini.util.JiniUtil;
import com.bigdata.journal.IDistributedTransactionService;
import com.bigdata.journal.IResourceLockService;
import com.bigdata.journal.ITransactionService;
import com.bigdata.relation.accesspath.IAsynchronousIterator;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.accesspath.IRunnableBuffer;
import com.bigdata.service.AbstractDistributedFederation;
import com.bigdata.service.IDataService;
import com.bigdata.service.ILoadBalancerService;
import com.bigdata.service.IMetadataService;
import com.bigdata.service.IService;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.JiniClientConfig;
import com.bigdata.service.jini.lookup.ClientServicesClient;
import com.bigdata.service.jini.lookup.DataServiceFilter;
import com.bigdata.service.jini.lookup.DataServicesClient;
import com.bigdata.service.jini.lookup.LoadBalancerClient;
import com.bigdata.service.jini.lookup.MetadataServiceFilter;
import com.bigdata.service.jini.lookup.ServicesManagerClient;
import com.bigdata.service.jini.lookup.TransactionServiceClient;
import com.bigdata.service.proxy.ClientAsynchronousIterator;
import com.bigdata.service.proxy.ClientBuffer;
import com.bigdata.service.proxy.ClientFuture;
import com.bigdata.service.proxy.ClientRunnableBuffer;
import com.bigdata.service.proxy.RemoteAsynchronousIterator;
import com.bigdata.service.proxy.RemoteAsynchronousIteratorImpl;
import com.bigdata.service.proxy.RemoteBuffer;
import com.bigdata.service.proxy.RemoteBufferImpl;
import com.bigdata.service.proxy.RemoteFuture;
import com.bigdata.service.proxy.RemoteFutureImpl;
import com.bigdata.service.proxy.RemoteRunnableBuffer;
import com.bigdata.service.proxy.RemoteRunnableBufferImpl;
import com.bigdata.zookeeper.ZooHelper;
import com.bigdata.zookeeper.ZooKeeperAccessor;
import com.bigdata.zookeeper.ZooResourceLockService;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceDiscoveryManager;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;

public class JiniFederation<T>
extends AbstractDistributedFederation<T>
implements DiscoveryListener,
ServiceDiscoveryListener {
    private LookupDiscoveryManager lookupDiscoveryManager;
    private ServiceDiscoveryManager serviceDiscoveryManager;
    private DataServicesClient dataServicesClient;
    private LoadBalancerClient loadBalancerClient;
    private TransactionServiceClient transactionServiceClient;
    private ServicesManagerClient servicesManagerClient;
    private ClientServicesClient clientServicesClient;
    private final ZooResourceLockService resourceLockService = new ZooResourceLockService(this);
    private final ZooKeeperAccessor zooKeeperAccessor;
    private final ZookeeperClientConfig zooConfig;
    private boolean open = true;
    private long lastKnownCommitTime;
    private final InvocationLayerFactory invocationLayerFactory = new BasicILFactory();
    protected final ReentrantLock discoveryEventLock = new ReentrantLock();
    protected final Condition discoveryEvent = this.discoveryEventLock.newCondition();
    private final ConcurrentLinkedQueue<TaskFuture> futures = new ConcurrentLinkedQueue();

    public ZookeeperClientConfig getZooConfig() {
        return this.zooConfig;
    }

    public ZooKeeperAccessor getZookeeperAccessor() {
        return this.zooKeeperAccessor;
    }

    public ZooKeeper getZookeeper() {
        try {
            return this.zooKeeperAccessor.getZookeeper();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void createKeyZNodes(ZooKeeper zookeeper) throws KeeperException, InterruptedException {
        String[] a;
        String zroot = this.zooConfig.zroot;
        List<ACL> acl = this.zooConfig.acl;
        for (String zpath : a = new String[]{zroot, zroot + "/" + "config", zroot + "/" + "locks", zroot + "/" + "locks/createPhysicalService", zroot + "/" + "locks/serviceConfigMonitor", zroot + "/" + "locks/resources"}) {
            try {
                zookeeper.create(zpath, new byte[0], acl, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("exists: " + zpath));
                }
                return;
            }
        }
    }

    public LookupDiscoveryManager getDiscoveryManagement() {
        return this.lookupDiscoveryManager;
    }

    public ServiceDiscoveryManager getServiceDiscoveryManager() {
        return this.serviceDiscoveryManager;
    }

    public DataServicesClient getDataServicesClient() {
        return this.dataServicesClient;
    }

    public ServicesManagerClient getServicesManagerClient() {
        return this.servicesManagerClient;
    }

    public ClientServicesClient getClientServicesClient() {
        return this.clientServicesClient;
    }

    public JiniFederation(JiniClient<T> client, JiniClientConfig jiniConfig, ZookeeperClientConfig zooConfig) {
        super(client);
        this.addScheduledTask(new MonitorFuturesTask(this.futures), 1L, 5L, TimeUnit.SECONDS);
        if (log.isInfoEnabled()) {
            log.info((Object)jiniConfig.toString());
        }
        String[] groups = jiniConfig.groups;
        LookupLocator[] lookupLocators = jiniConfig.locators;
        try {
            this.zooConfig = zooConfig;
            this.zooKeeperAccessor = new ZooKeeperAccessor(zooConfig.servers, zooConfig.sessionTimeout);
            this.lookupDiscoveryManager = new LookupDiscoveryManager(groups, lookupLocators, (DiscoveryListener)this, client.getConfiguration());
            try {
                this.serviceDiscoveryManager = new ServiceDiscoveryManager((DiscoveryManagement)this.lookupDiscoveryManager, new LeaseRenewalManager(), client.getConfiguration());
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not initiate service discovery manager", ex);
            }
            long cacheMissTimeout = Long.valueOf(client.getProperties().getProperty("cacheMissTimeout", "2000"));
            this.dataServicesClient = new DataServicesClient(this, cacheMissTimeout);
            this.transactionServiceClient = new TransactionServiceClient(this, cacheMissTimeout);
            this.loadBalancerClient = new LoadBalancerClient(this, cacheMissTimeout);
            this.servicesManagerClient = new ServicesManagerClient(this, cacheMissTimeout);
            this.clientServicesClient = new ClientServicesClient(this, cacheMissTimeout);
        }
        catch (Exception ex) {
            log.fatal((Object)("Problem initiating service discovery: " + ex.getMessage()), (Throwable)ex);
            try {
                this.shutdownNow();
            }
            catch (Throwable t) {
                log.error((Object)t.getMessage(), t);
            }
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitJiniRegistrars(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos;
        long begin = System.nanoTime();
        long remaining = nanos = unit.toNanos(timeout);
        ServiceRegistrar[] registrars = null;
        while ((registrars = this.lookupDiscoveryManager.getRegistrars()).length == 0 && (remaining = nanos - (System.nanoTime() - begin)) > 0L) {
            this.discoveryEventLock.lockInterruptibly();
            try {
                this.discoveryEvent.awaitNanos(remaining);
            }
            finally {
                this.discoveryEventLock.unlock();
            }
            remaining = nanos - (System.nanoTime() - begin);
        }
        if (registrars.length == 0) {
            long elapsed = System.nanoTime() - begin;
            log.warn((Object)("jini: no registrars: elapsed=" + TimeUnit.NANOSECONDS.toMillis(elapsed)));
            return false;
        }
        return true;
    }

    @Override
    public JiniClient<T> getClient() {
        return (JiniClient)super.getClient();
    }

    @Override
    public ILoadBalancerService getLoadBalancerService() {
        if (this.loadBalancerClient == null) {
            return null;
        }
        return this.loadBalancerClient.getLoadBalancerService();
    }

    @Override
    public ITransactionService getTransactionService() {
        if (this.transactionServiceClient == null) {
            return null;
        }
        IDistributedTransactionService proxy = (IDistributedTransactionService)this.transactionServiceClient.getTransactionService();
        if (proxy == null) {
            return proxy;
        }
        return proxy;
    }

    @Override
    public IResourceLockService getResourceLockService() {
        return this.resourceLockService;
    }

    @Override
    public IMetadataService getMetadataService() {
        if (this.dataServicesClient == null) {
            return null;
        }
        return this.dataServicesClient.getMetadataService();
    }

    @Override
    public UUID[] getDataServiceUUIDs(int maxCount) {
        this.assertOpen();
        return this.dataServicesClient.getDataServiceUUIDs(maxCount);
    }

    @Override
    public IDataService getDataService(UUID serviceUUID) {
        if (this.dataServicesClient == null) {
            log.error((Object)"No data service client?");
            return null;
        }
        return this.dataServicesClient.getDataService(serviceUUID);
    }

    @Override
    public IDataService getAnyDataService() {
        this.assertOpen();
        return this.dataServicesClient.getDataService();
    }

    @Override
    public IDataService getDataServiceByName(String name) {
        if (this.dataServicesClient == null) {
            return null;
        }
        return this.dataServicesClient.getDataServiceByName(name);
    }

    @Override
    public synchronized void shutdown() {
        if (!this.open) {
            return;
        }
        this.open = false;
        long begin = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)"begin");
        }
        super.shutdown();
        this.terminateDiscoveryProcesses();
        long elapsed = System.currentTimeMillis() - begin;
        if (log.isInfoEnabled()) {
            log.info((Object)("Done: elapsed=" + elapsed + "ms"));
        }
    }

    @Override
    public synchronized void shutdownNow() {
        if (!this.open) {
            return;
        }
        this.open = false;
        long begin = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)"begin");
        }
        super.shutdownNow();
        this.terminateDiscoveryProcesses();
        long elapsed = System.currentTimeMillis() - begin;
        if (log.isInfoEnabled()) {
            log.info((Object)("Done: elapsed=" + elapsed + "ms"));
        }
    }

    private void terminateDiscoveryProcesses() {
        if (this.transactionServiceClient != null) {
            this.transactionServiceClient.terminate();
            this.transactionServiceClient = null;
        }
        if (this.loadBalancerClient != null) {
            this.loadBalancerClient.terminate();
            this.loadBalancerClient = null;
        }
        if (this.dataServicesClient != null) {
            this.dataServicesClient.terminate();
            this.dataServicesClient = null;
        }
        if (this.servicesManagerClient != null) {
            this.servicesManagerClient.terminate();
            this.servicesManagerClient = null;
        }
        if (this.clientServicesClient != null) {
            this.clientServicesClient.terminate();
            this.clientServicesClient = null;
        }
        if (this.serviceDiscoveryManager != null) {
            this.serviceDiscoveryManager.terminate();
            this.serviceDiscoveryManager = null;
        }
        if (this.lookupDiscoveryManager != null) {
            this.lookupDiscoveryManager.terminate();
            this.lookupDiscoveryManager = null;
        }
        try {
            this.zooKeeperAccessor.close();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void distributedFederationShutdown(boolean immediateShutdown) throws InterruptedException {
        this.assertOpen();
        this.servicesManagerClient.shutdownDiscoveredServices(this.getExecutorService(), null, immediateShutdown);
        this.clientServicesClient.shutdownDiscoveredServices(this.getExecutorService(), null, immediateShutdown);
        this.dataServicesClient.shutdownDiscoveredServices(this.getExecutorService(), DataServiceFilter.INSTANCE, immediateShutdown);
        this.dataServicesClient.shutdownDiscoveredServices(this.getExecutorService(), MetadataServiceFilter.INSTANCE, immediateShutdown);
        this.loadBalancerClient.shutdownDiscoveredServices(this.getExecutorService(), null, immediateShutdown);
        this.transactionServiceClient.shutdownDiscoveredServices(this.getExecutorService(), null, immediateShutdown);
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            this.servicesManagerClient.destroyDiscoveredServices(this.getExecutorService(), null);
            this.clientServicesClient.destroyDiscoveredServices(this.getExecutorService(), null);
            this.dataServicesClient.destroyDiscoveredServices(this.getExecutorService(), DataServiceFilter.INSTANCE);
            this.dataServicesClient.destroyDiscoveredServices(this.getExecutorService(), MetadataServiceFilter.INSTANCE);
            this.loadBalancerClient.destroyDiscoveredServices(this.getExecutorService(), null);
            this.transactionServiceClient.destroyDiscoveredServices(this.getExecutorService(), null);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        try {
            ZooKeeper zookeeper = this.getZookeeperAccessor().getZookeeper();
            if (zookeeper.exists(this.zooConfig.zroot, false) != null) {
                ZooHelper.destroyZNodes(zookeeper, this.zooConfig.zroot, 0);
            }
        }
        catch (InterruptedException ex) {
            log.warn((Object)ex);
        }
        catch (KeeperException.SessionExpiredException ex) {
            log.warn((Object)ex);
        }
        catch (KeeperException.ConnectionLossException ex) {
            log.warn((Object)ex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getLastCommitTime() {
        ITransactionService transactionService = this.getTransactionService();
        if (transactionService != null) {
            try {
                this.lastKnownCommitTime = transactionService.getLastCommitTime();
            }
            catch (IOException e) {
                log.error((Object)"Can not reach the timestampService?", (Throwable)e);
            }
        }
        return this.lastKnownCommitTime;
    }

    protected Exporter getExporter(boolean enableDGC) {
        return new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), this.invocationLayerFactory, enableDGC, false);
    }

    @Override
    public <E> IAsynchronousIterator<E> getProxy(IAsynchronousIterator<E> sourceIterator, IStreamSerializer<E> serializer, int capacity) {
        RemoteAsynchronousIterator proxy;
        if (sourceIterator == null) {
            throw new IllegalArgumentException();
        }
        if (serializer == null) {
            throw new IllegalArgumentException();
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        Exporter exporter = this.getExporter(true);
        RemoteAsynchronousIteratorImpl<E> impl = new RemoteAsynchronousIteratorImpl<E>(sourceIterator, serializer);
        try {
            proxy = (RemoteAsynchronousIterator)exporter.export(impl);
        }
        catch (ExportException ex) {
            throw new RuntimeException("Export error: " + ex, ex);
        }
        return new ClientAsynchronousIterator(proxy, capacity);
    }

    @Override
    public <E> Future<E> getProxy(Future<E> future) {
        RemoteFuture proxy;
        Exporter exporter = this.getExporter(true);
        RemoteFutureImpl<E> impl = new RemoteFutureImpl<E>(future);
        try {
            proxy = (RemoteFuture)exporter.export(impl);
            if (log.isInfoEnabled()) {
                log.info((Object)("Exported proxy: proxy=" + proxy + "(" + proxy.getClass() + ")"));
            }
        }
        catch (ExportException ex) {
            throw new RuntimeException("Export error: " + ex, ex);
        }
        return new ClientFuture(proxy);
    }

    @Override
    public <E> IBuffer<E> getProxy(IBuffer<E> buffer) {
        RemoteBuffer proxy;
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        Exporter exporter = this.getExporter(true);
        RemoteBufferImpl<E> impl = new RemoteBufferImpl<E>(buffer);
        try {
            proxy = (RemoteBuffer)exporter.export(impl);
            if (log.isInfoEnabled()) {
                log.info((Object)("Exported proxy: proxy=" + proxy + "(" + proxy.getClass() + ")"));
            }
        }
        catch (ExportException ex) {
            throw new RuntimeException("Export error: " + ex, ex);
        }
        return new ClientBuffer(proxy);
    }

    @Override
    public <E, V> IRunnableBuffer<E> getProxy(IRunnableBuffer<E> buffer) {
        RemoteRunnableBuffer proxy;
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        Exporter exporter = this.getExporter(true);
        RemoteRunnableBufferImpl<E, E> impl = new RemoteRunnableBufferImpl<E, E>(buffer, this.getProxy(buffer.getFuture()));
        try {
            proxy = (RemoteRunnableBuffer)exporter.export(impl);
            if (log.isInfoEnabled()) {
                log.info((Object)("Exported proxy: proxy=" + proxy + "(" + proxy.getClass() + ")"));
            }
        }
        catch (ExportException ex) {
            throw new RuntimeException("Export error: " + ex, ex);
        }
        return new ClientRunnableBuffer(proxy);
    }

    @Override
    public <E> E getProxy(E obj, boolean enableDGC) {
        try {
            return (E)this.getExporter(enableDGC).export((Remote)obj);
        }
        catch (ExportException e) {
            throw new RuntimeException(e);
        }
    }

    public void serviceAdded(ServiceDiscoveryEvent e) {
        ServiceItem serviceItem = e.getPostEventServiceItem();
        if (serviceItem.service instanceof IService) {
            UUID serviceUUID = JiniUtil.serviceID2UUID(serviceItem.serviceID);
            this.serviceJoin((IService)serviceItem.service, serviceUUID);
        } else {
            log.warn((Object)("Not an " + IService.class));
        }
    }

    public void serviceChanged(ServiceDiscoveryEvent e) {
    }

    public void serviceRemoved(ServiceDiscoveryEvent e) {
        ServiceItem serviceItem = e.getPreEventServiceItem();
        UUID serviceUUID = JiniUtil.serviceID2UUID(serviceItem.serviceID);
        this.serviceLeave(serviceUUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discarded(DiscoveryEvent e) {
        try {
            this.discoveryEventLock.lockInterruptibly();
            try {
                this.discoveryEvent.signalAll();
            }
            finally {
                this.discoveryEventLock.unlock();
            }
        }
        catch (InterruptedException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discovered(DiscoveryEvent e) {
        try {
            this.discoveryEventLock.lockInterruptibly();
            try {
                this.discoveryEvent.signalAll();
            }
            finally {
                this.discoveryEventLock.unlock();
            }
        }
        catch (InterruptedException ex) {
            return;
        }
    }

    public <T1> Future<T1> submitMonitoredTask(Callable<T1> task) {
        if (task == null) {
            throw new IllegalArgumentException();
        }
        this.assertOpen();
        Future<T1> f = this.getExecutorService().submit(task);
        this.futures.add(new TaskFuture<T1>(task, f));
        return f;
    }

    public void cancelMonitoredTasks(boolean mayInterruptIfRunning) {
        for (TaskFuture tmp : this.futures) {
            if (tmp.future.isDone()) continue;
            tmp.future.cancel(mayInterruptIfRunning);
        }
    }

    private static class MonitorFuturesTask
    implements Runnable {
        protected static final Logger log = Logger.getLogger(MonitorFuturesTask.class);
        private final ConcurrentLinkedQueue<TaskFuture> futures;

        public MonitorFuturesTask(ConcurrentLinkedQueue<TaskFuture> futures) {
            if (futures == null) {
                throw new IllegalArgumentException();
            }
            this.futures = futures;
        }

        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("#tasks=" + this.futures.size()));
            }
            for (TaskFuture f : this.futures) {
                if (!f.future.isDone()) continue;
                this.futures.remove(f);
                try {
                    f.future.get();
                }
                catch (InterruptedException e) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Interrupted: " + f.task), (Throwable)e);
                        continue;
                    }
                    log.warn((Object)("Interrupted: task=" + f.task.getClass().getName()));
                }
                catch (ExecutionException e) {
                    log.error((Object)f.task.toString(), (Throwable)e);
                }
            }
        }
    }

    private static class TaskFuture<T> {
        final Callable<T> task;
        final Future<T> future;

        public TaskFuture(Callable<T> task, Future<T> future) {
            this.task = task;
            this.future = future;
        }
    }
}

