/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini;

import com.bigdata.bop.engine.IQueryPeer;
import com.bigdata.btree.proc.IIndexProcedure;
import com.bigdata.service.DataService;
import com.bigdata.service.MetadataService;
import com.bigdata.service.jini.DataServer;
import com.bigdata.service.jini.FakeLifeCycle;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.RemoteAdministrable;
import com.bigdata.service.jini.RemoteDestroyAdmin;
import com.sun.jini.start.LifeCycle;
import java.net.InetAddress;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.jini.export.ServerContext;
import net.jini.io.context.ClientHost;
import org.apache.log4j.MDC;

public class MetadataServer
extends DataServer {
    public MetadataServer(String[] args, LifeCycle lifeCycle) {
        super(args, lifeCycle);
    }

    public static void main(String[] args) {
        new MetadataServer(args, new FakeLifeCycle()).run();
        System.exit(0);
    }

    @Override
    protected MetadataService newService(Properties properties) {
        properties = new Properties(properties);
        properties.setProperty(MetadataService.Options.OVERFLOW_ENABLED, "false");
        AdministrableMetadataService service = new AdministrableMetadataService(this, properties);
        this.getClient().setDelegate(new DataService.DataServiceFederationDelegate(service));
        return service;
    }

    public static class AdministrableMetadataService
    extends MetadataService
    implements Remote,
    RemoteAdministrable,
    RemoteDestroyAdmin {
        protected final MetadataServer server;
        private IQueryPeer queryPeerProxy = null;

        public AdministrableMetadataService(MetadataServer server, Properties properties) {
            super(properties);
            this.server = server;
        }

        public Object getAdmin() throws RemoteException {
            if (log.isInfoEnabled()) {
                log.info((Object)("" + this.getServiceUUID()));
            }
            return this.server.proxy;
        }

        @Override
        protected void setupLoggingContext() {
            super.setupLoggingContext();
            try {
                InetAddress clientAddr = ((ClientHost)ServerContext.getServerContextElement(ClientHost.class)).getClientHost();
                MDC.put((String)"clientname", (Object)clientAddr.getHostName());
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
        }

        @Override
        protected void clearLoggingContext() {
            MDC.remove((String)"clientname");
            super.clearLoggingContext();
        }

        @Override
        public JiniFederation<?> getFederation() {
            return this.server.getClient().getFederation();
        }

        @Override
        public synchronized void destroy() {
            if (!this.server.isShuttingDown()) {
                this.server.runDestroy();
            } else if (this.isOpen()) {
                super.destroy();
            }
        }

        @Override
        public synchronized void shutdown() {
            super.shutdown();
            this.server.shutdownNow(false);
        }

        @Override
        public synchronized void shutdownNow() {
            super.shutdownNow();
            this.server.shutdownNow(false);
        }

        @Override
        public Future<? extends Object> submit(Callable<? extends Object> task) {
            return ((JiniFederation)this.getFederation()).getProxy(super.submit(task));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IQueryPeer getQueryEngine() {
            AdministrableMetadataService administrableMetadataService = this;
            synchronized (administrableMetadataService) {
                if (this.queryPeerProxy == null) {
                    this.queryPeerProxy = ((JiniFederation)this.getFederation()).getProxy(super.getQueryEngine(), false);
                }
                return this.queryPeerProxy;
            }
        }

        public Future submit(long tx, String name, IIndexProcedure proc) {
            return ((JiniFederation)this.getFederation()).getProxy(super.submit(tx, name, proc));
        }

        @Override
        public String getServiceName() {
            String s = this.server.getServiceName();
            if (s == null) {
                s = super.getServiceName();
            }
            return s;
        }
    }

    public static interface Options
    extends MetadataService.Options {
    }
}

