/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.benchmark;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.KVO;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.proc.BatchInsert;
import com.bigdata.btree.proc.BatchRemove;
import com.bigdata.relation.accesspath.IRunnableBuffer;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.master.AbstractClientTask;
import com.bigdata.service.jini.master.TaskMaster;
import com.bigdata.service.ndx.ClientIndexView;
import com.bigdata.service.ndx.IScaleOutClientIndex;
import com.bigdata.service.ndx.pipeline.IDuplicateRemover;
import java.io.Serializable;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import org.apache.zookeeper.KeeperException;

public class ThroughputMaster
extends TaskMaster<JobState, ClientTask, Void> {
    protected ThroughputMaster(JiniFederation fed) throws ConfigurationException {
        super(fed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ConfigurationException, ExecutionException, InterruptedException, KeeperException {
        IBigdataFederation fed = new JiniClient(args).connect();
        try {
            ThroughputMaster task = new ThroughputMaster((JiniFederation)fed);
            task.execute();
        }
        finally {
            ((JiniFederation)fed).shutdown();
        }
    }

    @Override
    protected void beginJob(JobState jobState) throws Exception {
        super.beginJob(jobState);
        String name = jobState.namespace;
        if (this.fed.getIndex(name, 0L) == null) {
            int npartitions;
            if (log.isInfoEnabled()) {
                log.info((Object)("Registering index: " + name));
            }
            if ((npartitions = ((JobState)this.getJobState()).npartitions) > 0) {
                KeyBuilder keyBuilder = new KeyBuilder(8);
                byte[][] separatorKeys = new byte[npartitions][];
                separatorKeys[0] = new byte[0];
                long key = 0L;
                for (int i = 1; i < npartitions; ++i) {
                    separatorKeys[i] = keyBuilder.reset().append(key).getKey();
                    key += Long.MAX_VALUE / (long)npartitions;
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("separatorKey=" + BytesUtil.toString(separatorKeys[i])));
                }
                UUID[] dataServiceUUIDs = null;
                this.fed.registerIndex(new IndexMetadata(name, UUID.randomUUID()), separatorKeys, dataServiceUUIDs);
            } else {
                this.fed.registerIndex(new IndexMetadata(name, UUID.randomUUID()));
            }
        }
    }

    @Override
    protected JobState newJobState(String component, Configuration config) throws ConfigurationException {
        return new JobState(component, config);
    }

    @Override
    protected ClientTask newClientTask(int clientNum) {
        return new ClientTask((JobState)this.getJobState(), clientNum);
    }

    static class ClientState
    implements Serializable {
        private static final long serialVersionUID = -6780200715236939550L;
        public final long nops;

        public ClientState(long nops) {
            this.nops = nops;
        }
    }

    public static class Task
    implements Callable<Void> {
        private final IIndex ndx;
        private final IRunnableBuffer<KVO<Void>[]> insert;
        private final IRunnableBuffer<KVO<Void>[]> remove;
        private final int nops;
        private final double insertRate;
        private final int incRange;
        private final Random r;
        private final KeyBuilder keyBuilder = new KeyBuilder(8);
        private long lastKey;

        private final byte[] nextKey() {
            long key = this.lastKey + (long)this.r.nextInt(this.incRange - 1) + 1L;
            byte[] data = this.keyBuilder.reset().append(key).getKey();
            this.lastKey = key;
            return data;
        }

        public Task(IScaleOutClientIndex ndx, IRunnableBuffer<KVO<Void>[]> insert, IRunnableBuffer<KVO<Void>[]> remove, Random r, int nops, long firstKey, int incRange, double insertRate) {
            this.ndx = ndx;
            this.insert = insert;
            this.remove = remove;
            this.r = r;
            if (insertRate < 0.0 || insertRate > 1.0) {
                throw new IllegalArgumentException();
            }
            this.lastKey = firstKey;
            this.incRange = incRange;
            this.insertRate = insertRate;
            this.nops = nops;
        }

        @Override
        public Void call() throws Exception {
            if (this.r.nextDouble() <= this.insertRate) {
                KVO[] a = new KVO[this.nops];
                for (int i = 0; i < this.nops; ++i) {
                    byte[] key = this.nextKey();
                    byte[] val = new byte[5];
                    this.r.nextBytes(val);
                    a[i] = new KVO(key, val);
                }
                if (this.insert == null) {
                    this.ndx.submit(0, this.nops, KVO.getKeys(a), KVO.getVals(a), BatchInsert.BatchInsertConstructor.RETURN_NO_VALUES, null);
                } else {
                    this.insert.add(a);
                }
            } else {
                KVO[] a = new KVO[this.nops];
                for (int i = 0; i < this.nops; ++i) {
                    a[i] = new KVO(this.nextKey(), null);
                }
                if (this.remove == null) {
                    this.ndx.submit(0, this.nops, KVO.getKeys(a), KVO.getVals(a), BatchRemove.BatchRemoveConstructor.RETURN_MUTATION_COUNT, null);
                } else {
                    this.remove.add(a);
                }
            }
            return null;
        }
    }

    static class ClientTask
    extends AbstractClientTask<JobState, Void, ClientState> {
        private static final long serialVersionUID = 5950450307665619854L;
        private transient long nops = 0L;
        private transient long lastNops = 0L;
        private transient Random r = null;

        protected ClientTask(JobState jobState, int clientNum) {
            super(jobState, clientNum);
        }

        @Override
        protected ClientState newClientState() {
            return new ClientState(this.nops);
        }

        @Override
        protected Void runWithZLock(ClientState clientState) throws Exception, KeeperException, InterruptedException {
            IRunnableBuffer<KVO<Void>[]> removeBuffer;
            IRunnableBuffer<KVO<Void>[]> insertBuffer;
            IDuplicateRemover duplicateRemover;
            if (this.r == null) {
                this.r = ((JobState)this.jobState).seed == 0L ? new Random() : new Random(((JobState)this.jobState).seed);
            }
            ClientIndexView ndx = this.getFederation().getIndex(((JobState)this.jobState).namespace, 0L);
            if (((JobState)this.jobState).asynchronous) {
                duplicateRemover = null;
                insertBuffer = ndx.newWriteBuffer(null, duplicateRemover, BatchInsert.BatchInsertConstructor.RETURN_NO_VALUES);
                removeBuffer = ndx.newWriteBuffer(null, duplicateRemover, BatchRemove.BatchRemoveConstructor.RETURN_MUTATION_COUNT);
            } else {
                duplicateRemover = null;
                removeBuffer = null;
                insertBuffer = null;
            }
            while (this.nops < ((JobState)this.jobState).operationCount) {
                long firstKey;
                int nkeys = this.r.nextInt(((JobState)this.jobState).maxKeysPerOp) + 1;
                if (((JobState)this.jobState).startKeyPartitions) {
                    firstKey = Math.abs(this.r.nextLong());
                } else {
                    long keyRange = Long.MAX_VALUE / (long)((JobState)this.jobState).nclients;
                    long base = (long)this.clientNum * keyRange;
                    long offset = (long)this.r.nextDouble() * keyRange;
                    firstKey = base + offset;
                }
                double insertRate = 1.0;
                new Task(ndx, insertBuffer, removeBuffer, this.r, nkeys, firstKey, ((JobState)this.jobState).incRange, 1.0).call();
                this.nops += (long)nkeys;
                if (((JobState)this.jobState).zookeeperUpdateInterval == 0L || this.nops - this.lastNops < ((JobState)this.jobState).zookeeperUpdateInterval) continue;
                this.writeClientState(new ClientState(this.nops));
                this.lastNops = this.nops;
            }
            if (((JobState)this.jobState).asynchronous) {
                insertBuffer.close();
                removeBuffer.close();
                insertBuffer.getFuture().get();
                removeBuffer.getFuture().get();
            }
            System.err.println(this.getFederation().getIndexCounters(ndx.getName()));
            return null;
        }
    }

    public static class JobState
    extends TaskMaster.JobState {
        private static final long serialVersionUID = 7663471973121918154L;
        public final long operationCount;
        public final long seed;
        public final String namespace;
        public final boolean asynchronous;
        public final int npartitions;
        public final boolean startKeyPartitions;
        public final int maxKeysPerOp;
        public final int incRange;
        public final long zookeeperUpdateInterval;

        @Override
        protected void toString(StringBuilder sb) {
            sb.append(", operationCount=" + this.operationCount);
            sb.append(", seed=" + this.seed);
            sb.append(", namespace=" + this.namespace);
            sb.append(", asynchronous=" + this.asynchronous);
            sb.append(", npartitions=" + this.npartitions);
            sb.append(", startKeyPartitions=" + this.startKeyPartitions);
            sb.append(", maxKeysPerOp=" + this.maxKeysPerOp);
            sb.append(", incRange=" + this.incRange);
            sb.append(", zookeeperUpdateInterval=" + this.zookeeperUpdateInterval);
        }

        public JobState(String component, Configuration config) throws ConfigurationException {
            super(component, config);
            this.operationCount = (Long)config.getEntry(component, "operationCount", Long.TYPE);
            this.seed = (Long)config.getEntry(component, "seed", Long.TYPE, (Object)0L);
            this.namespace = (String)config.getEntry(component, "namespace", String.class);
            this.asynchronous = (Boolean)config.getEntry(component, "asynchronous", Boolean.TYPE);
            this.npartitions = (Integer)config.getEntry(component, "npartitions", Integer.TYPE);
            this.startKeyPartitions = (Boolean)config.getEntry(component, "startKeyPartitions", Boolean.TYPE);
            this.maxKeysPerOp = (Integer)config.getEntry(component, "maxKeysPerOp", Integer.TYPE);
            this.incRange = (Integer)config.getEntry(component, "incRange", Integer.TYPE);
            this.zookeeperUpdateInterval = (Long)config.getEntry(component, "zookeeperUpdateInterval", Long.TYPE, (Object)0L);
        }
    }

    public static interface ConfigurationOptions
    extends TaskMaster.ConfigurationOptions {
        public static final String OPERATION_COUNT = "operationCount";
        public static final String SEED = "seed";
        public static final String NAMESPACE = "namespace";
        public static final String ASYNCHRONOUS = "asynchronous";
        public static final String NPARTITIONS = "npartitions";
        public static final String START_KEY_PARTITIONS = "startKeyPartitions";
        public static final String MAX_KEYS_PER_OP = "maxKeysPerOp";
        public static final String INC_RANGE = "incRange";
        public static final String ZOOKEEPER_UPDATE_INTERVAL = "zookeeperUpdateInterval";
    }
}

