/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.lookup;

import com.bigdata.jini.lookup.entry.ServiceItemFilterChain;
import com.bigdata.jini.util.JiniUtil;
import com.bigdata.service.jini.RemoteDestroyAdmin;
import com.bigdata.service.jini.lookup.ServiceCache;
import com.bigdata.util.InnerCause;
import com.sun.jini.admin.DestroyAdmin;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.ConnectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceDiscoveryManager;
import net.jini.lookup.ServiceItemFilter;
import org.apache.log4j.Logger;

public abstract class AbstractCachingServiceClient<S extends Remote> {
    protected static final transient Logger log = Logger.getLogger(AbstractCachingServiceClient.class);
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final LookupCache lookupCache;
    private final ServiceTemplate template;
    private final ServiceItemFilter filter;
    private final long cacheMissTimeout;
    private final ServiceCache serviceCache;
    private final Class<?> serviceIface;

    protected ServiceDiscoveryManager getServiceDiscoveryManager() {
        return this.serviceDiscoveryManager;
    }

    public final ServiceCache getServiceCache() {
        return this.serviceCache;
    }

    public final LookupCache getLookupCache() {
        return this.lookupCache;
    }

    public AbstractCachingServiceClient(ServiceDiscoveryManager serviceDiscoveryManager, ServiceDiscoveryListener serviceDiscoveryListener, Class<?> serviceIface, ServiceTemplate template, ServiceItemFilter filter, long cacheMissTimeout) throws RemoteException {
        if (serviceDiscoveryManager == null) {
            throw new IllegalArgumentException();
        }
        if (serviceIface == null) {
            throw new IllegalArgumentException();
        }
        if (template == null) {
            throw new IllegalArgumentException();
        }
        if (cacheMissTimeout < 0L) {
            throw new IllegalArgumentException();
        }
        this.serviceDiscoveryManager = serviceDiscoveryManager;
        this.serviceIface = serviceIface;
        this.template = template;
        this.filter = filter;
        this.cacheMissTimeout = cacheMissTimeout;
        this.serviceCache = new ServiceCache(serviceDiscoveryListener);
        this.lookupCache = this.getServiceDiscoveryManager().createLookupCache(template, filter, (ServiceDiscoveryListener)this.serviceCache);
    }

    public final void terminate() {
        this.lookupCache.terminate();
    }

    public final S getService() {
        return this.getService(this.filter);
    }

    public final S getService(ServiceItemFilter filter) {
        ServiceItem item = this.getServiceItem(filter);
        if (item == null) {
            return null;
        }
        Remote service = (Remote)item.service;
        return (S)service;
    }

    public final ServiceItem getServiceItem(ServiceItemFilter filter) {
        if (filter != null && this.filter != null) {
            filter = new ServiceItemFilterChain(new ServiceItemFilter[]{filter, this.filter});
        } else if (this.filter != null) {
            filter = this.filter;
        }
        ServiceItem item = this.lookupCache.lookup(filter);
        if (item == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Cache miss.");
            }
            if ((item = this.handleCacheMiss(filter)) == null) {
                log.warn((Object)"No matching service.");
                return null;
            }
        }
        return item;
    }

    private final ServiceItem handleCacheMiss(ServiceItemFilter filter) {
        ServiceItem item = null;
        try {
            item = this.serviceDiscoveryManager.lookup(this.template, filter, this.cacheMissTimeout);
        }
        catch (RemoteException ex) {
            log.error((Object)ex);
            return null;
        }
        catch (InterruptedException ex) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Interrupted - no match.");
            }
            Thread.currentThread().interrupt();
            return null;
        }
        if (item == null) {
            log.warn((Object)("Could not discover matching service: template=" + this.template + ", filter=" + filter + ", timeout=" + this.cacheMissTimeout));
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Found: " + item));
        }
        return item;
    }

    public final ServiceItem getServiceItem(UUID serviceUUID) {
        if (serviceUUID == null) {
            throw new IllegalArgumentException();
        }
        ServiceID serviceId = JiniUtil.uuid2ServiceID(serviceUUID);
        ServiceItem serviceItem = this.serviceCache.getServiceItemByID(serviceId);
        if (serviceItem == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Cache miss.");
            }
            if ((serviceItem = this.handleCacheMiss(serviceId)) == null) {
                log.warn((Object)"No matching service.");
                return null;
            }
        }
        return serviceItem;
    }

    private final ServiceItem handleCacheMiss(ServiceID serviceId) {
        ServiceItem item = null;
        try {
            ServiceTemplate template = new ServiceTemplate(serviceId, null, null);
            item = this.serviceDiscoveryManager.lookup(template, this.filter, this.cacheMissTimeout);
        }
        catch (RemoteException ex) {
            log.error((Object)ex);
            return null;
        }
        catch (InterruptedException ex) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Interrupted - no match.");
            }
            Thread.currentThread().interrupt();
            return null;
        }
        if (item == null) {
            log.warn((Object)("Could not discover matching service: serviceID=" + serviceId + ", template=" + this.template + ", filter=" + this.filter + ", timeout=" + this.cacheMissTimeout));
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Found: " + item));
        }
        return item;
    }

    public ServiceItem[] getServiceItems(int maxCount, ServiceItemFilter filter) {
        if (filter != null && this.filter != null) {
            filter = new ServiceItemFilterChain(new ServiceItemFilter[]{filter, this.filter});
        } else if (this.filter != null) {
            filter = this.filter;
        }
        ServiceItem[] items = this.serviceCache.getServiceItems(maxCount, filter);
        if (log.isInfoEnabled()) {
            log.info((Object)("There are at least " + items.length + " services : maxCount=" + maxCount));
        }
        return items;
    }

    public UUID[] getServiceUUIDs(int maxCount, ServiceItemFilter filter) {
        ServiceItem[] items = this.getServiceItems(maxCount, filter);
        UUID[] uuids = new UUID[items.length];
        for (int i = 0; i < items.length; ++i) {
            uuids[i] = JiniUtil.serviceID2UUID(items[i].serviceID);
        }
        return uuids;
    }

    public void destroyDiscoveredServices(ExecutorService executorService, ServiceItemFilter filter) throws InterruptedException {
        if (executorService == null) {
            throw new IllegalArgumentException();
        }
        ServiceItem[] items = this.serviceCache.getServiceItems(0, filter);
        log.warn((Object)("Will destroy " + items.length + " " + this.serviceIface.getName() + " services" + (filter == null ? "" : " matching " + filter)));
        ArrayList<1> tasks = new ArrayList<1>(items.length);
        ServiceItem[] arr$ = items;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ServiceItem serviceItem;
            final ServiceItem item = serviceItem = arr$[i$];
            tasks.add(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try {
                        AbstractCachingServiceClient.this.destroyService(item);
                        return true;
                    }
                    catch (InvocationTargetException ex) {
                        ConnectException t = (ConnectException)InnerCause.getInnerCause(ex, ConnectException.class);
                        if (t != null) {
                            log.warn((Object)(t + ":" + item));
                            return false;
                        }
                        throw ex;
                    }
                }
            });
        }
        List futures = executorService.invokeAll(tasks);
        for (int i = 0; i < items.length; ++i) {
            Future f = futures.get(i);
            try {
                f.get();
                continue;
            }
            catch (Throwable t) {
                log.error((Object)items[i], t);
            }
        }
    }

    public void shutdownDiscoveredServices(ExecutorService executorService, ServiceItemFilter filter, final boolean immediateShutdown) throws InterruptedException {
        if (executorService == null) {
            throw new IllegalArgumentException();
        }
        ServiceItem[] items = this.serviceCache.getServiceItems(0, filter);
        log.warn((Object)("Will shutdown " + items.length + " " + this.serviceIface.getName() + " services"));
        ArrayList<2> tasks = new ArrayList<2>(items.length);
        ServiceItem[] arr$ = items;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ServiceItem serviceItem;
            final ServiceItem item = serviceItem = arr$[i$];
            tasks.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    AbstractCachingServiceClient.this.shutdownService(item, immediateShutdown);
                    return null;
                }
            });
        }
        List futures = executorService.invokeAll(tasks);
        for (int i = 0; i < items.length; ++i) {
            Future f = futures.get(i);
            try {
                f.get();
                continue;
            }
            catch (Throwable t) {
                log.error((Object)items[i], t);
            }
        }
    }

    protected boolean destroyService(ServiceItem serviceItem) throws Exception {
        if (serviceItem == null) {
            throw new IllegalArgumentException();
        }
        Remote proxy = (Remote)serviceItem.service;
        Method getAdmin = proxy.getClass().getMethod("getAdmin", new Class[0]);
        Object admin = getAdmin.invoke((Object)proxy, new Object[0]);
        if (admin instanceof DestroyAdmin) {
            log.warn((Object)("will destroy() service: " + serviceItem));
            ((DestroyAdmin)admin).destroy();
            return true;
        }
        log.warn((Object)("Service does not implement " + DestroyAdmin.class + " : " + serviceItem));
        return false;
    }

    protected boolean shutdownService(ServiceItem serviceItem, boolean immediateShutdown) throws Exception {
        Remote proxy = (Remote)serviceItem.service;
        Method getAdmin = proxy.getClass().getMethod("getAdmin", new Class[0]);
        Object admin = getAdmin.invoke((Object)proxy, new Object[0]);
        if (admin instanceof RemoteDestroyAdmin) {
            block7: {
                if (immediateShutdown) {
                    log.warn((Object)("will shutdownNow() service: " + serviceItem));
                    try {
                        ((RemoteDestroyAdmin)admin).shutdownNow();
                    }
                    catch (IOException ex) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Exception during RMI requesting shutdown: " + ex));
                        }
                        break block7;
                    }
                }
                log.warn((Object)("will shutdown() service: " + serviceItem));
                try {
                    ((RemoteDestroyAdmin)admin).shutdown();
                }
                catch (IOException ex) {
                    if (!log.isInfoEnabled()) break block7;
                    log.info((Object)("Exception during RMI requesting shutdown: " + ex));
                }
            }
            return true;
        }
        log.warn((Object)("Service does not implement " + RemoteDestroyAdmin.class + " : " + serviceItem));
        return false;
    }
}

