/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.master;

import com.bigdata.io.SerializerUtil;
import com.bigdata.service.DataServiceCallable;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.master.TaskMaster;
import com.bigdata.zookeeper.ZLockImpl;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public abstract class AbstractClientTask<S extends TaskMaster.JobState, U, V extends Serializable>
extends DataServiceCallable<U>
implements Callable<U> {
    protected static final Logger log = Logger.getLogger(AbstractClientTask.class);
    protected final S jobState;
    protected final int clientNum;
    private transient String clientZPath;
    private transient List<ACL> acl;
    protected transient ZLockImpl zlock;

    public S getJobState() {
        return this.jobState;
    }

    public int getClientNum() {
        return this.clientNum;
    }

    @Override
    public void setFederation(IBigdataFederation fed) {
        super.setFederation(fed);
        this.clientZPath = ((TaskMaster.JobState)this.jobState).getClientZPath(this.getFederation(), this.clientNum);
        this.acl = this.getFederation().getZooConfig().acl;
    }

    public JiniFederation getFederation() {
        return (JiniFederation)super.getFederation();
    }

    public String toString() {
        return this.getClass().getName() + "{clientNum=" + this.clientNum + "}";
    }

    protected AbstractClientTask(S jobState, int clientNum) {
        this.jobState = jobState;
        this.clientNum = clientNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public U call() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Running: client#=" + this.clientNum + ", " + this.jobState));
        }
        V clientState = this.setupClientState();
        while (true) {
            this.zlock = ZLockImpl.getLock(this.getFederation().getZookeeper(), ((TaskMaster.JobState)this.jobState).getLockNodeZPath(this.getFederation(), this.clientNum), this.acl);
            this.zlock.lock();
            try {
                U ret = this.runWithZLock(clientState);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Finished: client#=" + this.clientNum + ", " + this.jobState));
                }
                U u = ret;
                return u;
            }
            catch (KeeperException.SessionExpiredException ex) {
                log.warn((Object)(this + " : will seek zlock again"), (Throwable)ex);
                continue;
            }
            finally {
                this.zlock.unlock();
                continue;
            }
            break;
        }
    }

    protected abstract U runWithZLock(V var1) throws Exception, KeeperException, InterruptedException;

    protected V setupClientState() throws InterruptedException, KeeperException {
        Object clientState;
        block3: {
            ZooKeeper zookeeper = this.getFederation().getZookeeperAccessor().getZookeeper();
            String clientZPath = ((TaskMaster.JobState)this.jobState).getClientZPath(this.getFederation(), this.clientNum);
            try {
                clientState = this.newClientState();
                zookeeper.create(clientZPath, SerializerUtil.serialize(clientState), this.getFederation().getZooConfig().acl, CreateMode.PERSISTENT);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Created: clientZPath=" + clientZPath + ", state=" + clientState));
                }
            }
            catch (KeeperException.NodeExistsException ex) {
                clientState = (Serializable)SerializerUtil.deserialize(zookeeper.getData(clientZPath, false, new Stat()));
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)("Existing: clientZPath=" + clientZPath + ", state=" + clientState));
            }
        }
        return clientState;
    }

    protected void writeClientState(V clientState) throws KeeperException, InterruptedException {
        if (clientState == null) {
            throw new IllegalArgumentException();
        }
        if (!this.zlock.isLockHeld()) {
            throw new InterruptedException("Lost ZLock");
        }
        ZooKeeper zookeeper = this.zlock.getZooKeeper();
        try {
            zookeeper.setData(this.clientZPath, SerializerUtil.serialize(clientState), -1);
        }
        catch (KeeperException.ConnectionLossException ex) {
            log.warn((Object)ex);
        }
    }

    protected abstract V newClientState();
}

