/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.master;

import com.bigdata.relation.accesspath.BlockingBuffer;
import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class AbstractResourceScanner<V>
implements Callable<Long> {
    protected static final Logger log = Logger.getLogger(AbstractResourceScanner.class);
    private final BlockingBuffer<V[]> buffer;
    private final ArrayBlockingQueue<V> queue;
    private final ReentrantLock queueLock = new ReentrantLock();
    private final AtomicLong acceptCount = new AtomicLong();
    private final AtomicLong chunkCount = new AtomicLong();

    public final long getAcceptCount() {
        return this.acceptCount.get();
    }

    protected AbstractResourceScanner(BlockingBuffer<V[]> buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        this.buffer = buffer;
        this.queue = new ArrayBlockingQueue(2 * buffer.getMinimumChunkSize());
    }

    @Override
    public final Long call() throws Exception {
        this.runScanner();
        this.flushQueue();
        return this.acceptCount.get();
    }

    protected abstract void runScanner() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(V resource) throws InterruptedException {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("accept: " + resource));
        }
        this.acceptCount.incrementAndGet();
        this.queue.add(resource);
        this.queueLock.lockInterruptibly();
        try {
            if (this.queue.size() >= this.buffer.getMinimumChunkSize()) {
                this.transferChunk();
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    private void transferChunk() {
        LinkedList c = new LinkedList();
        this.queue.drainTo(c, this.buffer.getMinimumChunkSize());
        int chunkSize = c.size();
        if (chunkSize == 0) {
            return;
        }
        Object[] a = (Object[])Array.newInstance(c.getFirst().getClass(), chunkSize);
        int i = 0;
        for (Object v : c) {
            assert (v != null) : "null @ index=" + i;
            a[i++] = v;
        }
        assert (i == chunkSize) : "i=" + i + ", chunkSize=" + chunkSize;
        if (log.isInfoEnabled()) {
            log.info((Object)("chunkSize=" + chunkSize + ", naccepted=" + this.acceptCount + ", chunkCount=" + this.chunkCount));
        }
        this.buffer.add(a);
        this.chunkCount.incrementAndGet();
    }

    private void flushQueue() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Flushing queue to buffer.");
        }
        while (!this.queue.isEmpty()) {
            this.transferChunk();
        }
    }
}

