/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.master;

import com.bigdata.btree.AsynchronousIndexWriteConfiguration;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.master.AbstractAsynchronousClientTask;
import com.bigdata.service.jini.master.AbstractResourceScanner;
import com.bigdata.service.jini.master.ClientLocator;
import com.bigdata.service.jini.master.DefaultHashFunction;
import com.bigdata.service.jini.master.IHashFunction;
import com.bigdata.service.jini.master.INotifyOutcome;
import com.bigdata.service.jini.master.IResourceScannerFactory;
import com.bigdata.service.jini.master.ResourceBufferStatistics;
import com.bigdata.service.jini.master.ResourceBufferSubtaskStatistics;
import com.bigdata.service.jini.master.ResourceBufferTask;
import com.bigdata.service.jini.master.TaskMaster;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;

public abstract class MappedTaskMaster<S extends JobState, T extends AbstractAsynchronousClientTask<U, V, L>, L extends ClientLocator, U, V extends Serializable>
extends TaskMaster<S, T, U> {
    public MappedTaskMaster(JiniFederation<?> fed) throws ConfigurationException {
        super(fed);
    }

    @Override
    protected void runJob() throws Exception {
        BlockingBuffer<V[]> resourceBuffer = this.newResourceBuffer();
        try {
            AbstractResourceScanner<?> scanner = ((JobState)this.getJobState()).scannerFactory.newScanner(resourceBuffer);
            Future<Long> scannerFuture = this.fed.getExecutorService().submit(scanner);
            System.out.println("Master running : " + scanner);
            Long acceptCount = scannerFuture.get();
            System.out.println("Master accepted " + acceptCount + " resources for processing.");
            resourceBuffer.close();
            resourceBuffer.getFuture().get();
        }
        catch (Throwable t) {
            resourceBuffer.abort(t);
            throw new RuntimeException(t);
        }
    }

    public BlockingBuffer<V[]> newResourceBuffer() {
        AsynchronousIndexWriteConfiguration conf = ((JobState)this.getJobState()).conf;
        ResourceBufferStatistics stats = new ResourceBufferStatistics(this.getFederation());
        BlockingBuffer resourceBuffer = new BlockingBuffer(new LinkedBlockingDeque(conf.getMasterQueueCapacity()), conf.getMasterChunkSize(), conf.getMasterChunkTimeoutNanos(), TimeUnit.NANOSECONDS, false);
        ResourceBufferTask.M task = new ResourceBufferTask.M<V>(this, conf.getSinkIdleTimeoutNanos(), conf.getSinkPollTimeoutNanos(), conf.getSinkQueueCapacity(), conf.getSinkChunkSize(), conf.getSinkChunkTimeoutNanos(), stats, resourceBuffer){

            @Override
            public void didSucceed(V resource) {
                File file;
                super.didSucceed(resource);
                if (((JobState)MappedTaskMaster.this.getJobState()).deleteAfter && resource instanceof File && !(file = (File)resource).delete() && file.exists()) {
                    log.warn((Object)("Could not delete file: " + resource));
                }
            }

            @Override
            public void didFail(V resource, Throwable t) {
                log.error(resource, t);
            }
        };
        FutureTask<ResourceBufferStatistics<ClientLocator, ResourceBufferSubtaskStatistics>> ft = new FutureTask<ResourceBufferStatistics<ClientLocator, ResourceBufferSubtaskStatistics>>(task);
        resourceBuffer.setFuture(ft);
        this.getFederation().getExecutorService().submit(ft);
        this.attachPerformanceCounters(stats.getCounters());
        return task.getBuffer();
    }

    @Override
    protected T newClientTask(int clientNum) {
        throw new UnsupportedOperationException();
    }

    protected abstract T newClientTask(INotifyOutcome<V, L> var1, L var2);

    public static class JobState
    extends TaskMaster.JobState {
        private static final long serialVersionUID = 1395850823170993889L;
        protected final AsynchronousIndexWriteConfiguration conf;
        protected final IResourceScannerFactory<?> scannerFactory;
        public final int pendingSetMasterInitialCapacity;
        public final int pendingSetSubtaskInitialCapacity;
        public final IHashFunction clientHashFunction;
        public final boolean deleteAfter;

        @Override
        protected void toString(StringBuilder sb) {
            super.toString(sb);
            sb.append(", resourceBufferConfig=" + this.conf);
            sb.append(", resourceScannerFactory=" + this.scannerFactory);
            sb.append(", pendingSetMasterInitialCapacity=" + this.pendingSetMasterInitialCapacity);
            sb.append(", pendingSetSubtaskInitialCapacity=" + this.pendingSetSubtaskInitialCapacity);
            sb.append(", deleteAfter=" + this.deleteAfter);
        }

        public JobState(String component, Configuration config) throws ConfigurationException {
            super(component, config);
            int masterChunkSize = 100;
            int sinkChunkSize = 1000;
            this.conf = (AsynchronousIndexWriteConfiguration)config.getEntry(component, "resourceBufferConfig", AsynchronousIndexWriteConfiguration.class, (Object)new AsynchronousIndexWriteConfiguration(100, 100, TimeUnit.SECONDS.toNanos(5L), Long.valueOf("9223372036854775807"), Long.valueOf(IndexMetadata.Options.DEFAULT_SINK_POLL_TIMEOUT_NANOS), 100, 1000, TimeUnit.SECONDS.toNanos(20L)));
            this.scannerFactory = (IResourceScannerFactory)config.getEntry(component, "resourceScannerFactory", IResourceScannerFactory.class);
            this.pendingSetMasterInitialCapacity = (Integer)config.getEntry(component, "pendingSetMasterInitialCapacity", Integer.TYPE, (Object)16);
            this.pendingSetSubtaskInitialCapacity = (Integer)config.getEntry(component, "pendingSetSubtaskInitialCapacity", Integer.TYPE, (Object)16);
            this.clientHashFunction = (IHashFunction)config.getEntry(component, "clientHashFunction", IHashFunction.class, new DefaultHashFunction());
            this.deleteAfter = (Boolean)config.getEntry(component, "deleteAfter", Boolean.TYPE);
        }
    }

    public static interface ConfigurationOptions
    extends TaskMaster.ConfigurationOptions {
        public static final String RESOURCE_BUFFER_CONFIG = "resourceBufferConfig";
        public static final String RESOURCE_SCANNER_FACTORY = "resourceScannerFactory";
        public static final String PENDING_SET_MASTER_INITIAL_CAPACITY = "pendingSetMasterInitialCapacity";
        public static final int DEFAULT_PENDING_SET_MASTER_INITIAL_CAPACITY = 16;
        public static final String PENDING_SET_SUBTASK_INITIAL_CAPACITY = "pendingSetSubtaskInitialCapacity";
        public static final int DEFAULT_PENDING_SET_SUBTASK_INITIAL_CAPACITY = 16;
        public static final String CLIENT_HASH_FUNCTION = "clientHashFunction";
        public static final String DELETE_AFTER = "deleteAfter";
    }
}

