/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.master;

import com.bigdata.jini.util.JiniUtil;
import com.bigdata.service.IRemoteExecutor;
import com.bigdata.service.jini.JiniFederation;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.UUID;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;

public class ServiceMap
implements Serializable {
    private static final long serialVersionUID = 5704885443752980274L;
    public final int ntasks;
    private transient ServiceItem[] serviceItems;
    public final UUID[] serviceUUIDs;

    public ServiceMap(int ntasks) {
        if (ntasks < 0) {
            throw new IllegalArgumentException();
        }
        this.ntasks = ntasks;
        this.serviceItems = new ServiceItem[ntasks];
        this.serviceUUIDs = new UUID[ntasks];
    }

    public void resolveServiceUUIDs(JiniFederation fed) throws RemoteException, InterruptedException {
        for (int i = 0; i < this.ntasks; ++i) {
            UUID serviceUUID = this.serviceUUIDs[i];
            ServiceID serviceID = JiniUtil.uuid2ServiceID(serviceUUID);
            ServiceItem serviceItem = null;
            serviceItem = fed.getClientServicesClient().getServiceCache().getServiceItemByID(serviceID);
            if (serviceItem == null && (serviceItem = fed.getDataServicesClient().getServiceCache().getServiceItemByID(serviceID)) == null && (serviceItem = fed.getServiceDiscoveryManager().lookup(new ServiceTemplate(serviceID, new Class[]{IRemoteExecutor.class}, null), null, 1000L)) == null) {
                throw new RuntimeException("Could not discover service: " + serviceUUID);
            }
            if (this.serviceItems == null) {
                this.serviceItems = new ServiceItem[this.ntasks];
            }
            this.serviceItems[i] = serviceItem;
        }
    }

    public void assignClientsToServices(ServiceItem[] serviceItems) throws Exception {
        if (serviceItems == null) {
            throw new IllegalArgumentException();
        }
        for (int clientNum = 0; clientNum < this.ntasks; ++clientNum) {
            int i = clientNum % serviceItems.length;
            ServiceItem serviceItem = serviceItems[i];
            assert (serviceItem != null) : "No service item @ index=" + i;
            this.serviceItems[clientNum] = serviceItem;
            this.serviceUUIDs[clientNum] = JiniUtil.serviceID2UUID(serviceItem.serviceID);
        }
    }

    public UUID getServiceUUID(int clientNum) {
        return this.serviceUUIDs[clientNum];
    }

    public ServiceItem getServiceItem(int clientNum) {
        return this.serviceItems[clientNum];
    }
}

