/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.util;

import com.bigdata.service.AbstractFederation;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.IService;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.JiniFederation;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.jini.config.ConfigurationException;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import org.apache.log4j.Logger;

public class ListServices {
    private static final Logger log = Logger.getLogger(ListServices.class);
    protected static final String COMPONENT = ListServices.class.getName();

    public static void main(String[] args) throws InterruptedException, ConfigurationException, IOException, ExecutionException {
        IBigdataFederation fed = JiniClient.newInstance(args).connect();
        int repeatCount = (Integer)((JiniClient)((JiniFederation)fed).getClient()).getConfiguration().getEntry(COMPONENT, "repeatCount", Integer.TYPE, (Object)1);
        Runtime.getRuntime().addShutdownHook(new Thread((JiniFederation)fed){
            final /* synthetic */ JiniFederation val$fed;
            {
                this.val$fed = jiniFederation;
            }

            @Override
            public void run() {
                this.val$fed.shutdownNow();
            }
        });
        if (repeatCount == 0) {
            while (true) {
                Future<String> f = ((AbstractFederation)fed).getExecutorService().submit(new DiscoverAndListTask((JiniFederation<?>)fed));
                System.out.println(f.get());
            }
        }
        for (int i = 0; i < repeatCount; ++i) {
            Future<String> f = ((AbstractFederation)fed).getExecutorService().submit(new DiscoverAndListTask((JiniFederation<?>)fed));
            System.out.println(f.get());
        }
        ((JiniFederation)fed).shutdown();
        System.exit(0);
    }

    static class DiscoverAndListTask
    implements Callable<String> {
        final JiniFederation<?> fed;
        final long discoveryDelay;
        final boolean showServiceItems;

        public DiscoverAndListTask(JiniFederation<?> fed) throws ConfigurationException {
            this.fed = fed;
            this.discoveryDelay = (Long)((JiniClient)fed.getClient()).getConfiguration().getEntry(COMPONENT, "discoveryDelay", Long.TYPE, (Object)5000L);
            this.showServiceItems = (Boolean)((JiniClient)fed.getClient()).getConfiguration().getEntry(COMPONENT, "showServiceItems", Boolean.TYPE, (Object)false);
        }

        @Override
        public String call() throws Exception {
            System.out.println("Waiting " + this.discoveryDelay + "ms for service discovery.");
            ServiceItem[] a = this.fed.getServiceDiscoveryManager().lookup(new ServiceTemplate(null, new Class[0], new Entry[0]), Integer.MAX_VALUE, Integer.MAX_VALUE, null, this.discoveryDelay);
            StringBuilder sb = new StringBuilder();
            LinkedList<ServiceItem> otherServices = new LinkedList<ServiceItem>();
            HashMap<Class, LinkedList<ServiceItem>> bigdataServicesByIface = new HashMap<Class, LinkedList<ServiceItem>>(a.length);
            HashMap bigdataServicesByHost = new HashMap(a.length);
            HashMap<ServiceID, String> hostnames = new HashMap<ServiceID, String>();
            HashMap<ServiceID, Class> serviceId2serviceIface = new HashMap<ServiceID, Class>(a.length);
            LinkedList<ServiceItem> staleServices = new LinkedList<ServiceItem>();
            int bigdataServiceCount = 0;
            for (ServiceItem serviceItem : a) {
                String hostname;
                Class serviceIface;
                if (!(serviceItem.service instanceof IService)) {
                    otherServices.add(serviceItem);
                    continue;
                }
                try {
                    serviceIface = ((IService)serviceItem.service).getServiceIface();
                    hostname = ((IService)serviceItem.service).getHostname();
                    hostnames.put(serviceItem.serviceID, hostname);
                }
                catch (IOException ex) {
                    log.warn((Object)("RMI error: " + ex + " for " + serviceItem));
                    staleServices.add(serviceItem);
                    continue;
                }
                List<ServiceItem> list = (LinkedList<ServiceItem>)bigdataServicesByIface.get(serviceIface);
                if (list == null) {
                    list = new LinkedList<ServiceItem>();
                    bigdataServicesByIface.put(serviceIface, (LinkedList<ServiceItem>)list);
                }
                list.add(serviceItem);
                list = (List)bigdataServicesByHost.get(hostname);
                if (list == null) {
                    list = new LinkedList();
                    bigdataServicesByHost.put(hostname, list);
                }
                list.add(serviceItem);
                serviceId2serviceIface.put(serviceItem.serviceID, serviceIface);
                ++bigdataServiceCount;
            }
            boolean foundZooKeeper = this.fed.getZookeeperAccessor().awaitZookeeperConnected(10L, TimeUnit.MILLISECONDS);
            ServiceRegistrar[] registrars = this.fed.getDiscoveryManagement().getRegistrars();
            sb.append("Zookeeper is " + (foundZooKeeper ? "" : "not ") + "running.\n");
            sb.append("Discovered " + registrars.length + " jini service registrars.\n");
            for (ServiceRegistrar r : registrars) {
                sb.append("   " + r.getLocator().getHost() + "\n");
            }
            sb.append("Discovered " + a.length + " services\n");
            sb.append("Discovered " + staleServices.size() + " stale bigdata services.\n");
            sb.append("Discovered " + bigdataServiceCount + " live bigdata services.\n");
            sb.append("Discovered " + otherServices.size() + " other services.\n");
            sb.append("Bigdata services by serviceIface:\n");
            TreeMap<String, Class> sortedMap = new TreeMap<String, Class>();
            for (Class serviceIface : bigdataServicesByIface.keySet()) {
                sortedMap.put(serviceIface.getName(), serviceIface);
            }
            for (Class serviceIface : sortedMap.values()) {
                List list = (List)bigdataServicesByIface.get(serviceIface);
                HashSet<String> hosts = new HashSet<String>();
                for (ServiceItem serviceItem : list) {
                    String hostname = (String)hostnames.get(serviceItem.serviceID);
                    hosts.add(hostname);
                }
                sb.append("  There are " + list.size() + " instances of " + serviceIface.getName() + " on " + hosts.size() + " hosts\n");
                if (!this.showServiceItems) continue;
                for (ServiceItem t : list) {
                    sb.append(t.toString());
                    sb.append("\n");
                }
            }
            sb.append("Bigdata services by hostname:\n");
            Object[] keys = bigdataServicesByHost.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object hostname : keys) {
                List servicesOnHostList = (List)bigdataServicesByHost.get(hostname);
                sb.append("  There are " + servicesOnHostList.size() + " live bigdata services on " + (String)hostname + "\n");
                TreeMap<String, LinkedList<ServiceItem>> serviceType2 = new TreeMap<String, LinkedList<ServiceItem>>();
                for (ServiceItem serviceItemOnHost : servicesOnHostList) {
                    Class serviceIface = (Class)serviceId2serviceIface.get(serviceItemOnHost.serviceID);
                    LinkedList<ServiceItem> servicesByTypeOnHostList = (LinkedList<ServiceItem>)serviceType2.get(serviceIface.getName());
                    if (servicesByTypeOnHostList == null) {
                        servicesByTypeOnHostList = new LinkedList<ServiceItem>();
                        serviceType2.put(serviceIface.getName(), servicesByTypeOnHostList);
                    }
                    servicesByTypeOnHostList.add(serviceItemOnHost);
                }
                for (String serviceIfaceName : serviceType2.keySet()) {
                    sb.append("    There are ");
                    sb.append(((List)serviceType2.get(serviceIfaceName)).size());
                    sb.append(" ");
                    sb.append(serviceIfaceName);
                    sb.append(" services");
                    sb.append("\n");
                }
            }
            if (this.showServiceItems) {
                for (ServiceItem t : otherServices) {
                    sb.append(t.toString());
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
    }
}

