/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.jini.util;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.ScaleOutTripleStore;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.locator.DefaultResourceLocator;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.JiniFederation;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import net.jini.config.ConfigurationException;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class ShowKB {
    protected static final String COMPONENT = ShowKB.class.getName();
    private final JiniFederation<?> fed;

    private ShowKB(JiniFederation<?> fed) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, ConfigurationException, IOException, ExecutionException {
        System.err.println("Start");
        IBigdataFederation fed = JiniClient.newInstance(args).connect();
        System.err.println("Connected");
        Runtime.getRuntime().addShutdownHook(new Thread((JiniFederation)fed){
            final /* synthetic */ JiniFederation val$fed;
            {
                this.val$fed = jiniFederation;
            }

            @Override
            public void run() {
                this.val$fed.shutdownNow();
            }
        });
        try {
            String namespace = (String)((JiniClient)((JiniFederation)fed).getClient()).getConfiguration().getEntry(COMPONENT, "namespace", String.class);
            System.out.println("KB namespace=" + namespace);
            long ts = ((JiniFederation)fed).getLastCommitTime();
            ScaleOutTripleStore tripleStore = (ScaleOutTripleStore)((DefaultResourceLocator)((AbstractFederation)fed).getResourceLocator()).locate(namespace, ts);
            if (tripleStore == null) {
                System.err.println("Does not exist: " + namespace);
                System.exit(1);
            }
            System.out.println("axiomCount=" + tripleStore.getStatementCount());
            KeyBuilder keyBuilder = new KeyBuilder();
            Iterator<? extends Value> itr = tripleStore.getVocabulary().values();
            while (itr.hasNext()) {
                BigdataValue v = (BigdataValue)itr.next();
                IV iv = v.getIV();
                String key = iv == null ? "N/A" : BytesUtil.toString(IVUtility.encode(keyBuilder.reset(), iv).getKey());
                System.out.println(v + "\t" + iv + "\t" + key);
            }
            IAccessPath<ISPO> ap = tripleStore.getAccessPath(null, RDF.TYPE, null);
            System.out.println("have ap: " + ap);
            long rangeCount = ap.rangeCount(false);
            System.out.println("rangeCount=" + rangeCount);
        }
        finally {
            ((JiniFederation)fed).shutdown();
        }
    }

    public static interface ConfigurationOptions {
        public static final String NAMESPACE = "namespace";
    }
}

