/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.proxy;

import com.bigdata.io.IStreamSerializer;
import com.bigdata.service.proxy.IRemoteChunk;
import com.bigdata.striterator.IKeyOrder;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RemoteChunk<E>
implements IRemoteChunk<E>,
Externalizable {
    private static final long serialVersionUID = -8022644024286873191L;
    private boolean exhausted;
    private IStreamSerializer<E[]> serializer;
    private IKeyOrder<E> keyOrder;
    private E[] a;
    private static final transient byte VERSION0 = 0;
    private static final transient byte VERSION = 0;

    public RemoteChunk() {
    }

    public RemoteChunk(boolean exhausted, IStreamSerializer<E[]> serializer, IKeyOrder<E> keyOrder, E[] a) {
        if (serializer == null) {
            throw new IllegalArgumentException();
        }
        this.exhausted = exhausted;
        this.serializer = serializer;
        this.keyOrder = keyOrder;
        this.a = a;
    }

    @Override
    public E[] getChunk() {
        return this.a;
    }

    @Override
    public IKeyOrder<E> getKeyOrder() {
        return this.keyOrder;
    }

    @Override
    public boolean isExhausted() {
        return this.exhausted;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown version: " + version);
            }
        }
        this.exhausted = in.readBoolean();
        boolean haveChunk = in.readBoolean();
        this.keyOrder = (IKeyOrder)in.readObject();
        if (haveChunk) {
            this.serializer = (IStreamSerializer)in.readObject();
            this.a = this.serializer.deserialize(in);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeBoolean(this.exhausted);
        boolean haveChunk = this.a != null;
        out.writeBoolean(haveChunk);
        out.writeObject(this.keyOrder);
        if (haveChunk) {
            out.writeObject(this.serializer);
            this.serializer.serialize(out, this.a);
        }
    }
}

