/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import com.bigdata.striterator.IChunkedIterator;
import com.bigdata.striterator.IFilter;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Appender<I extends Iterator<E>, E>
implements IFilter<I, E, E> {
    private static final long serialVersionUID = 1307691066685808103L;
    private final int chunkSize;
    private final I src2;

    public Appender(I src2) {
        this(100, src2);
    }

    public Appender(int chunkSize, I src2) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (src2 == null) {
            throw new IllegalArgumentException();
        }
        this.chunkSize = chunkSize;
        this.src2 = src2;
    }

    public I filter(I src) {
        return (I)new AppendingIterator(this.chunkSize, src, this.src2);
    }

    private static class AppendingIterator<I extends Iterator<E>, E>
    implements IChunkedIterator<E> {
        private final int chunkSize;
        private final I src1;
        private final I src2;
        private I src;
        private boolean firstSource = true;

        public AppendingIterator(int chunkSize, I src, I src2) {
            this.chunkSize = chunkSize;
            this.src = src;
            this.src1 = src;
            this.src2 = src2;
        }

        @Override
        public boolean hasNext() {
            if (this.src == null) {
                return false;
            }
            if (this.src.hasNext()) {
                return true;
            }
            if (this.firstSource) {
                this.src = this.src2;
                this.firstSource = false;
            } else {
                this.src = null;
            }
            return this.hasNext();
        }

        @Override
        public E next() {
            if (this.src == null) {
                throw new NoSuchElementException();
            }
            return this.src.next();
        }

        @Override
        public void remove() {
            if (this.src == null) {
                throw new IllegalStateException();
            }
            this.src.remove();
        }

        @Override
        public void close() {
            this.src = null;
            if (this.src1 instanceof ICloseableIterator) {
                ((ICloseableIterator)this.src1).close();
            }
            if (this.src2 instanceof ICloseableIterator) {
                ((ICloseableIterator)this.src2).close();
            }
        }

        @Override
        public E[] nextChunk() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = 0;
            Object[] chunk = null;
            while (this.hasNext() && n < this.chunkSize) {
                E t = this.next();
                if (chunk == null) {
                    chunk = (Object[])Array.newInstance(t.getClass(), this.chunkSize);
                }
                chunk[n++] = t;
            }
            if (n != this.chunkSize) {
                Object[] tmp = (Object[])Array.newInstance(chunk.getClass().getComponentType(), n);
                System.arraycopy(chunk, 0, tmp, 0, n);
                chunk = tmp;
            }
            return chunk;
        }
    }
}

