/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.lang.reflect.Array;
import java.util.Arrays;

public abstract class ChunkedResolvingIterator<E, S>
implements IChunkedOrderedIterator<E> {
    private final IChunkedOrderedIterator<S> src;
    private final IKeyOrder<E> keyOrder;

    public ChunkedResolvingIterator(IChunkedOrderedIterator<S> src) {
        this(src, null);
    }

    public ChunkedResolvingIterator(IChunkedOrderedIterator<S> src, IKeyOrder<E> keyOrder) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.src = src;
        this.keyOrder = keyOrder;
    }

    @Override
    public IKeyOrder<E> getKeyOrder() {
        return this.keyOrder;
    }

    @Override
    public boolean hasNext() {
        return this.src.hasNext();
    }

    @Override
    public E next() {
        return this.resolve(this.src.next());
    }

    @Override
    public E[] nextChunk() {
        E[] a = this.src.nextChunk();
        Object[] b = null;
        for (int i = 0; i < a.length; ++i) {
            E e = this.resolve(a[i]);
            if (b == null) {
                b = (Object[])Array.newInstance(e.getClass(), a.length);
            }
            b[i] = e;
        }
        return b;
    }

    @Override
    public E[] nextChunk(IKeyOrder<E> keyOrder) {
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        E[] chunk = this.nextChunk();
        if (!keyOrder.equals(this.getKeyOrder())) {
            Arrays.sort(chunk, 0, chunk.length, keyOrder.getComparator());
        }
        return chunk;
    }

    @Override
    public void remove() {
        this.src.remove();
    }

    @Override
    public void close() {
        this.src.close();
    }

    protected abstract E resolve(S var1);
}

