/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import com.bigdata.striterator.IChunkedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IFilter;
import com.bigdata.striterator.IKeyOrder;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Filter<I extends Iterator<E>, E>
implements IFilter<I, E, E> {
    private static final long serialVersionUID = 1L;
    private final int chunkSize;
    protected Object state;

    public Filter() {
        this(null);
    }

    public Filter(Object state) {
        this(100, state);
    }

    public Filter(int chunkSize, Object state) {
        this.chunkSize = chunkSize;
        this.state = state;
    }

    @Override
    public IChunkedIterator<E> filter(I src) {
        return new FilteredIterator(this.chunkSize, src, this);
    }

    protected abstract boolean isValid(E var1);

    private static class FilteredIterator<I extends Iterator<E>, E>
    implements IChunkedIterator<E> {
        private final I src;
        private final Filter<I, E> filter;
        private E next;
        private final int chunkSize;
        private final IKeyOrder<E> keyOrder;

        public FilteredIterator(int chunkSize, I src, Filter<I, E> filter) {
            this.chunkSize = chunkSize;
            this.src = src;
            this.filter = filter;
            this.keyOrder = src instanceof IChunkedOrderedIterator ? ((IChunkedOrderedIterator)src).getKeyOrder() : null;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.src.hasNext()) {
                Object e = this.src.next();
                if (!this.filter.isValid(e)) continue;
                this.next = e;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            E tmp = this.next;
            this.next = null;
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E[] nextChunk() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = 0;
            Object[] chunk = null;
            while (this.hasNext() && n < this.chunkSize) {
                E t = this.next();
                if (chunk == null) {
                    chunk = (Object[])Array.newInstance(t.getClass(), this.chunkSize);
                }
                chunk[n++] = t;
            }
            if (n != this.chunkSize) {
                Object[] tmp = (Object[])Array.newInstance(chunk.getClass().getComponentType(), n);
                System.arraycopy(chunk, 0, tmp, 0, n);
                chunk = tmp;
            }
            return chunk;
        }

        public IKeyOrder<E> getKeyOrder() {
            return this.keyOrder;
        }

        public E[] nextChunk(IKeyOrder<E> keyOrder) {
            if (keyOrder == null) {
                throw new IllegalArgumentException();
            }
            E[] chunk = this.nextChunk();
            if (!keyOrder.equals(this.getKeyOrder())) {
                Arrays.sort(chunk, 0, chunk.length, keyOrder.getComparator());
            }
            return chunk;
        }

        @Override
        public void close() {
            if (this.src instanceof ICloseableIterator) {
                ((ICloseableIterator)this.src).close();
            }
        }
    }
}

