/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import com.bigdata.striterator.IChunkedIterator;
import com.bigdata.striterator.IFilter;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MergeFilter<I extends Iterator<E>, E extends Comparable<E>>
implements IFilter<I, E, E> {
    private static final long serialVersionUID = -3593674406822688011L;
    private final int chunkSize;
    private final I src2;

    public MergeFilter(I src2) {
        this(100, src2);
    }

    public MergeFilter(int chunkSize, I src2) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (src2 == null) {
            throw new IllegalArgumentException();
        }
        this.chunkSize = chunkSize;
        this.src2 = src2;
    }

    public I filter(I src) {
        return (I)new MergedIterator(this.chunkSize, src, this.src2);
    }

    private static class MergedIterator<I extends Iterator<E>, E extends Comparable<E>>
    implements IChunkedIterator<E> {
        private final int chunkSize;
        private final I src1;
        private final I src2;
        private E tmp1;
        private E tmp2;

        public MergedIterator(int chunkSize, I src1, I src2) {
            this.chunkSize = chunkSize;
            this.src1 = src1;
            this.src2 = src2;
        }

        @Override
        public void close() {
            if (this.src1 instanceof ICloseableIterator) {
                ((ICloseableIterator)this.src1).close();
            }
            if (this.src2 instanceof ICloseableIterator) {
                ((ICloseableIterator)this.src2).close();
            }
        }

        @Override
        public boolean hasNext() {
            return this.tmp1 != null || this.tmp2 != null || this.src1.hasNext() || this.src2.hasNext();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.tmp1 == null && this.src1.hasNext()) {
                this.tmp1 = (Comparable)this.src1.next();
            }
            if (this.tmp2 == null && this.src2.hasNext()) {
                this.tmp2 = (Comparable)this.src2.next();
            }
            if (this.tmp1 == null) {
                E tmp = this.tmp2;
                this.tmp2 = null;
                return tmp;
            }
            if (this.tmp2 == null) {
                E tmp = this.tmp1;
                this.tmp1 = null;
                return tmp;
            }
            int cmp = this.tmp1.compareTo(this.tmp2);
            if (cmp == 0) {
                E tmp = this.tmp1;
                this.tmp2 = null;
                this.tmp1 = null;
                return tmp;
            }
            if (cmp < 0) {
                E tmp = this.tmp1;
                this.tmp1 = null;
                return tmp;
            }
            E tmp = this.tmp2;
            this.tmp2 = null;
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E[] nextChunk() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = 0;
            Comparable[] chunk = null;
            while (this.hasNext() && n < this.chunkSize) {
                Object t = this.next();
                if (chunk == null) {
                    chunk = (Comparable[])Array.newInstance(t.getClass(), this.chunkSize);
                }
                chunk[n++] = t;
            }
            if (n != this.chunkSize) {
                Comparable[] tmp = (Comparable[])Array.newInstance(chunk.getClass().getComponentType(), n);
                System.arraycopy(chunk, 0, tmp, 0, n);
                chunk = tmp;
            }
            return chunk;
        }
    }
}

