/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util;

import com.bigdata.journal.AbstractJournal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class MergeStreamWithSnapshotData {
    private static final transient Logger log = Logger.getLogger(MergeStreamWithSnapshotData.class);

    public static void process(InputStream in, AbstractJournal.ISnapshotData snapshotData, OutputStream out) throws IOException {
        byte[] bb = new byte[4096];
        Iterator<AbstractJournal.ISnapshotEntry> bbs = snapshotData.entries();
        long curs = 0L;
        while (bbs.hasNext()) {
            AbstractJournal.ISnapshotEntry e = bbs.next();
            long pos = e.getAddress();
            byte[] buf = e.getData();
            long blen = buf.length;
            if (curs < pos) {
                MergeStreamWithSnapshotData.transfer(in, pos - curs, bb, out);
                curs = pos;
            }
            out.write(buf);
            if (log.isInfoEnabled()) {
                log.info((Object)("Write ByteBuffer at " + pos + ", length: " + blen));
            }
            curs += blen;
            in.skip(blen);
        }
        MergeStreamWithSnapshotData.transfer(in, Long.MAX_VALUE, bb, out);
    }

    private static void transfer(InputStream in, long len, byte[] buf, OutputStream out) throws IOException {
        long rem;
        int rdlen;
        for (rem = len; rem > (long)buf.length; rem -= (long)rdlen) {
            rdlen = in.read(buf);
            if (rdlen == -1) {
                return;
            }
            out.write(buf, 0, rdlen);
        }
        rdlen = in.read(buf, 0, (int)rem);
        if (rdlen == -1) {
            return;
        }
        out.write(buf, 0, rdlen);
    }
}

